/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.api;

import com.google.gson.reflect.TypeToken;
import com.zuora.ApiCallback;
import com.zuora.ApiClient;
import com.zuora.ApiException;
import com.zuora.ApiResponse;
import com.zuora.Configuration;
import com.zuora.Pair;
import com.zuora.model.ExpandedAuthentication;
import com.zuora.model.ExpandedMapping;
import com.zuora.model.ExpandedOAuth;
import com.zuora.model.ExpandedReportGetRecent;
import com.zuora.model.ExpandedReportList;
import com.zuora.model.ExpandedSignedUrl;
import com.zuora.model.ExpandedStageError;
import com.zuora.model.ExpandedUploadCsv;
import com.zuora.model.ExpandedUploadCsvStatus;
import com.zuora.model.ExpandedUploadFile;
import com.zuora.model.ExpandedUploadFileStatus;
import java.io.File;
import java.lang.reflect.Type;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class RevenueIntegrationApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public RevenueIntegrationApi() {
        this(Configuration.getDefaultApiClient());
    }

    public RevenueIntegrationApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call downloadReportCall(String token, String filename, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/integration/v1/reports/download/{filename}".replace("{filename}", this.localVarApiClient.escapeString(filename.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (token != null) {
            localVarHeaderParams.put("token", this.localVarApiClient.parameterToString(token));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call downloadReportValidateBeforeCall(String token, String filename, ApiCallback _callback) throws ApiException {
        if (token == null) {
            throw new ApiException("Missing the required parameter 'token' when calling downloadReport(Async)");
        }
        if (filename == null) {
            throw new ApiException("Missing the required parameter 'filename' when calling downloadReport(Async)");
        }
        return this.downloadReportCall(token, filename, _callback);
    }

    protected void downloadReport(String token, String filename) throws ApiException {
        this.downloadReportWithHttpInfo(token, filename);
    }

    private ApiResponse<Void> downloadReportWithHttpInfo(String token, String filename) throws ApiException {
        Call localVarCall = this.downloadReportValidateBeforeCall(token, filename, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call downloadReportAsync(String token, String filename, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.downloadReportValidateBeforeCall(token, filename, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public DownloadReportApi downloadReportApi(String token, String filename) {
        return new DownloadReportApi(token, filename);
    }

    private Call generateJWTTokenCall(String role, String clientname, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/integration/v1/authenticate";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (role != null) {
            localVarHeaderParams.put("role", this.localVarApiClient.parameterToString(role));
        }
        if (clientname != null) {
            localVarHeaderParams.put("clientname", this.localVarApiClient.parameterToString(clientname));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call generateJWTTokenValidateBeforeCall(String role, String clientname, ApiCallback _callback) throws ApiException {
        if (role == null) {
            throw new ApiException("Missing the required parameter 'role' when calling generateJWTToken(Async)");
        }
        if (clientname == null) {
            throw new ApiException("Missing the required parameter 'clientname' when calling generateJWTToken(Async)");
        }
        return this.generateJWTTokenCall(role, clientname, _callback);
    }

    protected ExpandedAuthentication generateJWTToken(String role, String clientname) throws ApiException {
        ApiResponse<ExpandedAuthentication> localVarResp = this.generateJWTTokenWithHttpInfo(role, clientname);
        return localVarResp.getData();
    }

    private ApiResponse<ExpandedAuthentication> generateJWTTokenWithHttpInfo(String role, String clientname) throws ApiException {
        Call localVarCall = this.generateJWTTokenValidateBeforeCall(role, clientname, null);
        Type localVarReturnType = new TypeToken<ExpandedAuthentication>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call generateJWTTokenAsync(String role, String clientname, ApiCallback<ExpandedAuthentication> _callback) throws ApiException {
        Call localVarCall = this.generateJWTTokenValidateBeforeCall(role, clientname, _callback);
        Type localVarReturnType = new TypeToken<ExpandedAuthentication>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GenerateJWTTokenApi generateJWTTokenApi(String role, String clientname) {
        return new GenerateJWTTokenApi(role, clientname);
    }

    private Call generateOAuthTokenCall(String clientId, String clientSecret, String grantType, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/oauth2/token";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (clientId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("client_id", clientId));
        }
        if (clientSecret != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("client_secret", clientSecret));
        }
        if (grantType != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("grant_type", grantType));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call generateOAuthTokenValidateBeforeCall(String clientId, String clientSecret, String grantType, ApiCallback _callback) throws ApiException {
        if (clientId == null) {
            throw new ApiException("Missing the required parameter 'clientId' when calling generateOAuthToken(Async)");
        }
        if (clientSecret == null) {
            throw new ApiException("Missing the required parameter 'clientSecret' when calling generateOAuthToken(Async)");
        }
        if (grantType == null) {
            throw new ApiException("Missing the required parameter 'grantType' when calling generateOAuthToken(Async)");
        }
        return this.generateOAuthTokenCall(clientId, clientSecret, grantType, _callback);
    }

    protected ExpandedOAuth generateOAuthToken(String clientId, String clientSecret, String grantType) throws ApiException {
        ApiResponse<ExpandedOAuth> localVarResp = this.generateOAuthTokenWithHttpInfo(clientId, clientSecret, grantType);
        return localVarResp.getData();
    }

    private ApiResponse<ExpandedOAuth> generateOAuthTokenWithHttpInfo(String clientId, String clientSecret, String grantType) throws ApiException {
        Call localVarCall = this.generateOAuthTokenValidateBeforeCall(clientId, clientSecret, grantType, null);
        Type localVarReturnType = new TypeToken<ExpandedOAuth>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call generateOAuthTokenAsync(String clientId, String clientSecret, String grantType, ApiCallback<ExpandedOAuth> _callback) throws ApiException {
        Call localVarCall = this.generateOAuthTokenValidateBeforeCall(clientId, clientSecret, grantType, _callback);
        Type localVarReturnType = new TypeToken<ExpandedOAuth>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GenerateOAuthTokenApi generateOAuthTokenApi(String clientId, String clientSecret, String grantType) {
        return new GenerateOAuthTokenApi(clientId, clientSecret, grantType);
    }

    private Call getCsvUploadStatusCall(Integer id, String token, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/integration/v1/csv/upload/status";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (id != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("id", id));
        }
        if (token != null) {
            localVarHeaderParams.put("token", this.localVarApiClient.parameterToString(token));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCsvUploadStatusValidateBeforeCall(Integer id, String token, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getCsvUploadStatus(Async)");
        }
        if (token == null) {
            throw new ApiException("Missing the required parameter 'token' when calling getCsvUploadStatus(Async)");
        }
        return this.getCsvUploadStatusCall(id, token, _callback);
    }

    protected ExpandedUploadCsvStatus getCsvUploadStatus(Integer id, String token) throws ApiException {
        ApiResponse<ExpandedUploadCsvStatus> localVarResp = this.getCsvUploadStatusWithHttpInfo(id, token);
        return localVarResp.getData();
    }

    private ApiResponse<ExpandedUploadCsvStatus> getCsvUploadStatusWithHttpInfo(Integer id, String token) throws ApiException {
        Call localVarCall = this.getCsvUploadStatusValidateBeforeCall(id, token, null);
        Type localVarReturnType = new TypeToken<ExpandedUploadCsvStatus>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getCsvUploadStatusAsync(Integer id, String token, ApiCallback<ExpandedUploadCsvStatus> _callback) throws ApiException {
        Call localVarCall = this.getCsvUploadStatusValidateBeforeCall(id, token, _callback);
        Type localVarReturnType = new TypeToken<ExpandedUploadCsvStatus>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetCsvUploadStatusApi getCsvUploadStatusApi(Integer id, String token) {
        return new GetCsvUploadStatusApi(id, token);
    }

    private Call getFileUploadLogStatusCall(String token, Integer fileRequestId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/integration/v1/upload/file/log/{file_name}".replace("{file_request_id}", this.localVarApiClient.escapeString(fileRequestId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (token != null) {
            localVarHeaderParams.put("token", this.localVarApiClient.parameterToString(token));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getFileUploadLogStatusValidateBeforeCall(String token, Integer fileRequestId, ApiCallback _callback) throws ApiException {
        if (token == null) {
            throw new ApiException("Missing the required parameter 'token' when calling getFileUploadLogStatus(Async)");
        }
        if (fileRequestId == null) {
            throw new ApiException("Missing the required parameter 'fileRequestId' when calling getFileUploadLogStatus(Async)");
        }
        return this.getFileUploadLogStatusCall(token, fileRequestId, _callback);
    }

    protected ExpandedUploadFileStatus getFileUploadLogStatus(String token, Integer fileRequestId) throws ApiException {
        ApiResponse<ExpandedUploadFileStatus> localVarResp = this.getFileUploadLogStatusWithHttpInfo(token, fileRequestId);
        return localVarResp.getData();
    }

    private ApiResponse<ExpandedUploadFileStatus> getFileUploadLogStatusWithHttpInfo(String token, Integer fileRequestId) throws ApiException {
        Call localVarCall = this.getFileUploadLogStatusValidateBeforeCall(token, fileRequestId, null);
        Type localVarReturnType = new TypeToken<ExpandedUploadFileStatus>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getFileUploadLogStatusAsync(String token, Integer fileRequestId, ApiCallback<ExpandedUploadFileStatus> _callback) throws ApiException {
        Call localVarCall = this.getFileUploadLogStatusValidateBeforeCall(token, fileRequestId, _callback);
        Type localVarReturnType = new TypeToken<ExpandedUploadFileStatus>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetFileUploadLogStatusApi getFileUploadLogStatusApi(String token, Integer fileRequestId) {
        return new GetFileUploadLogStatusApi(token, fileRequestId);
    }

    private Call getFileUploadStatusByRequestIdCall(String token, Integer fileRequestId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/integration/v1/fileupload/status/{file_request_id}".replace("{file_request_id}", this.localVarApiClient.escapeString(fileRequestId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (token != null) {
            localVarHeaderParams.put("token", this.localVarApiClient.parameterToString(token));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getFileUploadStatusByRequestIdValidateBeforeCall(String token, Integer fileRequestId, ApiCallback _callback) throws ApiException {
        if (token == null) {
            throw new ApiException("Missing the required parameter 'token' when calling getFileUploadStatusByRequestId(Async)");
        }
        if (fileRequestId == null) {
            throw new ApiException("Missing the required parameter 'fileRequestId' when calling getFileUploadStatusByRequestId(Async)");
        }
        return this.getFileUploadStatusByRequestIdCall(token, fileRequestId, _callback);
    }

    protected ExpandedUploadFileStatus getFileUploadStatusByRequestId(String token, Integer fileRequestId) throws ApiException {
        ApiResponse<ExpandedUploadFileStatus> localVarResp = this.getFileUploadStatusByRequestIdWithHttpInfo(token, fileRequestId);
        return localVarResp.getData();
    }

    private ApiResponse<ExpandedUploadFileStatus> getFileUploadStatusByRequestIdWithHttpInfo(String token, Integer fileRequestId) throws ApiException {
        Call localVarCall = this.getFileUploadStatusByRequestIdValidateBeforeCall(token, fileRequestId, null);
        Type localVarReturnType = new TypeToken<ExpandedUploadFileStatus>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getFileUploadStatusByRequestIdAsync(String token, Integer fileRequestId, ApiCallback<ExpandedUploadFileStatus> _callback) throws ApiException {
        Call localVarCall = this.getFileUploadStatusByRequestIdValidateBeforeCall(token, fileRequestId, _callback);
        Type localVarReturnType = new TypeToken<ExpandedUploadFileStatus>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetFileUploadStatusByRequestIdApi getFileUploadStatusByRequestIdApi(String token, Integer fileRequestId) {
        return new GetFileUploadStatusByRequestIdApi(token, fileRequestId);
    }

    private Call getReportsCall(String token, Integer numberOfRecords, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/integration/v1/reports/recent-n/{number_of_records}".replace("{number_of_records}", this.localVarApiClient.escapeString(numberOfRecords.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (token != null) {
            localVarHeaderParams.put("token", this.localVarApiClient.parameterToString(token));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getReportsValidateBeforeCall(String token, Integer numberOfRecords, ApiCallback _callback) throws ApiException {
        if (token == null) {
            throw new ApiException("Missing the required parameter 'token' when calling getReports(Async)");
        }
        if (numberOfRecords == null) {
            throw new ApiException("Missing the required parameter 'numberOfRecords' when calling getReports(Async)");
        }
        return this.getReportsCall(token, numberOfRecords, _callback);
    }

    protected ExpandedReportGetRecent getReports(String token, Integer numberOfRecords) throws ApiException {
        ApiResponse<ExpandedReportGetRecent> localVarResp = this.getReportsWithHttpInfo(token, numberOfRecords);
        return localVarResp.getData();
    }

    private ApiResponse<ExpandedReportGetRecent> getReportsWithHttpInfo(String token, Integer numberOfRecords) throws ApiException {
        Call localVarCall = this.getReportsValidateBeforeCall(token, numberOfRecords, null);
        Type localVarReturnType = new TypeToken<ExpandedReportGetRecent>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getReportsAsync(String token, Integer numberOfRecords, ApiCallback<ExpandedReportGetRecent> _callback) throws ApiException {
        Call localVarCall = this.getReportsValidateBeforeCall(token, numberOfRecords, _callback);
        Type localVarReturnType = new TypeToken<ExpandedReportGetRecent>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetReportsApi getReportsApi(String token, Integer numberOfRecords) {
        return new GetReportsApi(token, numberOfRecords);
    }

    private Call getReportsByIdCall(String token, LocalDate createddate, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/integration/v1/reports/<int:report_id>";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (createddate != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("createddate", createddate));
        }
        if (token != null) {
            localVarHeaderParams.put("token", this.localVarApiClient.parameterToString(token));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getReportsByIdValidateBeforeCall(String token, LocalDate createddate, ApiCallback _callback) throws ApiException {
        if (token == null) {
            throw new ApiException("Missing the required parameter 'token' when calling getReportsById(Async)");
        }
        if (createddate == null) {
            throw new ApiException("Missing the required parameter 'createddate' when calling getReportsById(Async)");
        }
        return this.getReportsByIdCall(token, createddate, _callback);
    }

    protected ExpandedReportList getReportsById(String token, LocalDate createddate) throws ApiException {
        ApiResponse<ExpandedReportList> localVarResp = this.getReportsByIdWithHttpInfo(token, createddate);
        return localVarResp.getData();
    }

    private ApiResponse<ExpandedReportList> getReportsByIdWithHttpInfo(String token, LocalDate createddate) throws ApiException {
        Call localVarCall = this.getReportsByIdValidateBeforeCall(token, createddate, null);
        Type localVarReturnType = new TypeToken<ExpandedReportList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getReportsByIdAsync(String token, LocalDate createddate, ApiCallback<ExpandedReportList> _callback) throws ApiException {
        Call localVarCall = this.getReportsByIdValidateBeforeCall(token, createddate, _callback);
        Type localVarReturnType = new TypeToken<ExpandedReportList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetReportsByIdApi getReportsByIdApi(String token, LocalDate createddate) {
        return new GetReportsByIdApi(token, createddate);
    }

    private Call getSignedUrlCall(String token, String submissionId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/integration/v2/reports/signedurl/{submission_id}".replace("{submission_id}", this.localVarApiClient.escapeString(submissionId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (token != null) {
            localVarHeaderParams.put("token", this.localVarApiClient.parameterToString(token));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getSignedUrlValidateBeforeCall(String token, String submissionId, ApiCallback _callback) throws ApiException {
        if (token == null) {
            throw new ApiException("Missing the required parameter 'token' when calling getSignedUrl(Async)");
        }
        if (submissionId == null) {
            throw new ApiException("Missing the required parameter 'submissionId' when calling getSignedUrl(Async)");
        }
        return this.getSignedUrlCall(token, submissionId, _callback);
    }

    protected ExpandedSignedUrl getSignedUrl(String token, String submissionId) throws ApiException {
        ApiResponse<ExpandedSignedUrl> localVarResp = this.getSignedUrlWithHttpInfo(token, submissionId);
        return localVarResp.getData();
    }

    private ApiResponse<ExpandedSignedUrl> getSignedUrlWithHttpInfo(String token, String submissionId) throws ApiException {
        Call localVarCall = this.getSignedUrlValidateBeforeCall(token, submissionId, null);
        Type localVarReturnType = new TypeToken<ExpandedSignedUrl>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getSignedUrlAsync(String token, String submissionId, ApiCallback<ExpandedSignedUrl> _callback) throws ApiException {
        Call localVarCall = this.getSignedUrlValidateBeforeCall(token, submissionId, _callback);
        Type localVarReturnType = new TypeToken<ExpandedSignedUrl>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetSignedUrlApi getSignedUrlApi(String token, String submissionId) {
        return new GetSignedUrlApi(token, submissionId);
    }

    private Call getStageErrorCall(String token, String errortype, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/integration/v1/stage/error/{errortype}".replace("{errortype}", this.localVarApiClient.escapeString(errortype.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (token != null) {
            localVarHeaderParams.put("token", this.localVarApiClient.parameterToString(token));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getStageErrorValidateBeforeCall(String token, String errortype, ApiCallback _callback) throws ApiException {
        if (token == null) {
            throw new ApiException("Missing the required parameter 'token' when calling getStageError(Async)");
        }
        if (errortype == null) {
            throw new ApiException("Missing the required parameter 'errortype' when calling getStageError(Async)");
        }
        return this.getStageErrorCall(token, errortype, _callback);
    }

    protected ExpandedStageError getStageError(String token, String errortype) throws ApiException {
        ApiResponse<ExpandedStageError> localVarResp = this.getStageErrorWithHttpInfo(token, errortype);
        return localVarResp.getData();
    }

    private ApiResponse<ExpandedStageError> getStageErrorWithHttpInfo(String token, String errortype) throws ApiException {
        Call localVarCall = this.getStageErrorValidateBeforeCall(token, errortype, null);
        Type localVarReturnType = new TypeToken<ExpandedStageError>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getStageErrorAsync(String token, String errortype, ApiCallback<ExpandedStageError> _callback) throws ApiException {
        Call localVarCall = this.getStageErrorValidateBeforeCall(token, errortype, _callback);
        Type localVarReturnType = new TypeToken<ExpandedStageError>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetStageErrorApi getStageErrorApi(String token, String errortype) {
        return new GetStageErrorApi(token, errortype);
    }

    private Call listReportsCall(String token, LocalDate createddate, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/integration/v1/reports/list";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (createddate != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("createddate", createddate));
        }
        if (token != null) {
            localVarHeaderParams.put("token", this.localVarApiClient.parameterToString(token));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listReportsValidateBeforeCall(String token, LocalDate createddate, ApiCallback _callback) throws ApiException {
        if (token == null) {
            throw new ApiException("Missing the required parameter 'token' when calling listReports(Async)");
        }
        if (createddate == null) {
            throw new ApiException("Missing the required parameter 'createddate' when calling listReports(Async)");
        }
        return this.listReportsCall(token, createddate, _callback);
    }

    protected ExpandedReportList listReports(String token, LocalDate createddate) throws ApiException {
        ApiResponse<ExpandedReportList> localVarResp = this.listReportsWithHttpInfo(token, createddate);
        return localVarResp.getData();
    }

    private ApiResponse<ExpandedReportList> listReportsWithHttpInfo(String token, LocalDate createddate) throws ApiException {
        Call localVarCall = this.listReportsValidateBeforeCall(token, createddate, null);
        Type localVarReturnType = new TypeToken<ExpandedReportList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listReportsAsync(String token, LocalDate createddate, ApiCallback<ExpandedReportList> _callback) throws ApiException {
        Call localVarCall = this.listReportsValidateBeforeCall(token, createddate, _callback);
        Type localVarReturnType = new TypeToken<ExpandedReportList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public ListReportsApi listReportsApi(String token, LocalDate createddate) {
        return new ListReportsApi(token, createddate);
    }

    private Call uploadCsvCall(String token, String templatename, String data, String filename, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/integration/v1/csv/upload";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (data != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("data", data));
        }
        if (token != null) {
            localVarHeaderParams.put("token", this.localVarApiClient.parameterToString(token));
        }
        if (templatename != null) {
            localVarHeaderParams.put("templatename", this.localVarApiClient.parameterToString(templatename));
        }
        if (filename != null) {
            localVarHeaderParams.put("filename", this.localVarApiClient.parameterToString(filename));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call uploadCsvValidateBeforeCall(String token, String templatename, String data, String filename, ApiCallback _callback) throws ApiException {
        if (token == null) {
            throw new ApiException("Missing the required parameter 'token' when calling uploadCsv(Async)");
        }
        if (templatename == null) {
            throw new ApiException("Missing the required parameter 'templatename' when calling uploadCsv(Async)");
        }
        if (data == null) {
            throw new ApiException("Missing the required parameter 'data' when calling uploadCsv(Async)");
        }
        if (filename == null) {
            throw new ApiException("Missing the required parameter 'filename' when calling uploadCsv(Async)");
        }
        return this.uploadCsvCall(token, templatename, data, filename, _callback);
    }

    protected ExpandedUploadCsv uploadCsv(String token, String templatename, String data, String filename) throws ApiException {
        ApiResponse<ExpandedUploadCsv> localVarResp = this.uploadCsvWithHttpInfo(token, templatename, data, filename);
        return localVarResp.getData();
    }

    private ApiResponse<ExpandedUploadCsv> uploadCsvWithHttpInfo(String token, String templatename, String data, String filename) throws ApiException {
        Call localVarCall = this.uploadCsvValidateBeforeCall(token, templatename, data, filename, null);
        Type localVarReturnType = new TypeToken<ExpandedUploadCsv>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call uploadCsvAsync(String token, String templatename, String data, String filename, ApiCallback<ExpandedUploadCsv> _callback) throws ApiException {
        Call localVarCall = this.uploadCsvValidateBeforeCall(token, templatename, data, filename, _callback);
        Type localVarReturnType = new TypeToken<ExpandedUploadCsv>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public UploadCsvApi uploadCsvApi(String token, String templatename, String data, String filename) {
        return new UploadCsvApi(token, templatename, data, filename);
    }

    private Call uploadFileCall(String token, File _file, String templatename, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/integration/v1/upload/file";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_file != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("file", _file));
        }
        if (token != null) {
            localVarHeaderParams.put("token", this.localVarApiClient.parameterToString(token));
        }
        if (templatename != null) {
            localVarHeaderParams.put("templatename", this.localVarApiClient.parameterToString(templatename));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call uploadFileValidateBeforeCall(String token, File _file, String templatename, ApiCallback _callback) throws ApiException {
        if (token == null) {
            throw new ApiException("Missing the required parameter 'token' when calling uploadFile(Async)");
        }
        if (_file == null) {
            throw new ApiException("Missing the required parameter '_file' when calling uploadFile(Async)");
        }
        if (templatename == null) {
            throw new ApiException("Missing the required parameter 'templatename' when calling uploadFile(Async)");
        }
        return this.uploadFileCall(token, _file, templatename, _callback);
    }

    protected ExpandedUploadFile uploadFile(String token, File _file, String templatename) throws ApiException {
        ApiResponse<ExpandedUploadFile> localVarResp = this.uploadFileWithHttpInfo(token, _file, templatename);
        return localVarResp.getData();
    }

    private ApiResponse<ExpandedUploadFile> uploadFileWithHttpInfo(String token, File _file, String templatename) throws ApiException {
        Call localVarCall = this.uploadFileValidateBeforeCall(token, _file, templatename, null);
        Type localVarReturnType = new TypeToken<ExpandedUploadFile>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call uploadFileAsync(String token, File _file, String templatename, ApiCallback<ExpandedUploadFile> _callback) throws ApiException {
        Call localVarCall = this.uploadFileValidateBeforeCall(token, _file, templatename, _callback);
        Type localVarReturnType = new TypeToken<ExpandedUploadFile>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public UploadFileApi uploadFileApi(String token, File _file, String templatename) {
        return new UploadFileApi(token, _file, templatename);
    }

    private Call uploadMappingCall(String token, String templatename, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/integration/v1/upload/mapping";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (templatename != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("templatename", templatename));
        }
        if (token != null) {
            localVarHeaderParams.put("token", this.localVarApiClient.parameterToString(token));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call uploadMappingValidateBeforeCall(String token, String templatename, ApiCallback _callback) throws ApiException {
        if (token == null) {
            throw new ApiException("Missing the required parameter 'token' when calling uploadMapping(Async)");
        }
        if (templatename == null) {
            throw new ApiException("Missing the required parameter 'templatename' when calling uploadMapping(Async)");
        }
        return this.uploadMappingCall(token, templatename, _callback);
    }

    protected ExpandedMapping uploadMapping(String token, String templatename) throws ApiException {
        ApiResponse<ExpandedMapping> localVarResp = this.uploadMappingWithHttpInfo(token, templatename);
        return localVarResp.getData();
    }

    private ApiResponse<ExpandedMapping> uploadMappingWithHttpInfo(String token, String templatename) throws ApiException {
        Call localVarCall = this.uploadMappingValidateBeforeCall(token, templatename, null);
        Type localVarReturnType = new TypeToken<ExpandedMapping>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call uploadMappingAsync(String token, String templatename, ApiCallback<ExpandedMapping> _callback) throws ApiException {
        Call localVarCall = this.uploadMappingValidateBeforeCall(token, templatename, _callback);
        Type localVarReturnType = new TypeToken<ExpandedMapping>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public UploadMappingApi uploadMappingApi(String token, String templatename) {
        return new UploadMappingApi(token, templatename);
    }

    public class UploadMappingApi {
        private final String token;
        private final String templatename;

        private UploadMappingApi(String token, String templatename) {
            this.token = token;
            this.templatename = templatename;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return RevenueIntegrationApi.this.uploadMappingCall(this.token, this.templatename, _callback);
        }

        public ExpandedMapping execute() throws ApiException {
            ApiResponse localVarResp = RevenueIntegrationApi.this.uploadMappingWithHttpInfo(this.token, this.templatename);
            return (ExpandedMapping)localVarResp.getData();
        }

        private ApiResponse<ExpandedMapping> executeWithHttpInfo() throws ApiException {
            return RevenueIntegrationApi.this.uploadMappingWithHttpInfo(this.token, this.templatename);
        }

        public Call executeAsync(ApiCallback<ExpandedMapping> _callback) throws ApiException {
            return RevenueIntegrationApi.this.uploadMappingAsync(this.token, this.templatename, _callback);
        }
    }

    public class UploadFileApi {
        private final String token;
        private final File _file;
        private final String templatename;

        private UploadFileApi(String token, File _file, String templatename) {
            this.token = token;
            this._file = _file;
            this.templatename = templatename;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return RevenueIntegrationApi.this.uploadFileCall(this.token, this._file, this.templatename, _callback);
        }

        public ExpandedUploadFile execute() throws ApiException {
            ApiResponse localVarResp = RevenueIntegrationApi.this.uploadFileWithHttpInfo(this.token, this._file, this.templatename);
            return (ExpandedUploadFile)localVarResp.getData();
        }

        private ApiResponse<ExpandedUploadFile> executeWithHttpInfo() throws ApiException {
            return RevenueIntegrationApi.this.uploadFileWithHttpInfo(this.token, this._file, this.templatename);
        }

        public Call executeAsync(ApiCallback<ExpandedUploadFile> _callback) throws ApiException {
            return RevenueIntegrationApi.this.uploadFileAsync(this.token, this._file, this.templatename, _callback);
        }
    }

    public class UploadCsvApi {
        private final String token;
        private final String templatename;
        private final String data;
        private final String filename;

        private UploadCsvApi(String token, String templatename, String data, String filename) {
            this.token = token;
            this.templatename = templatename;
            this.data = data;
            this.filename = filename;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return RevenueIntegrationApi.this.uploadCsvCall(this.token, this.templatename, this.data, this.filename, _callback);
        }

        public ExpandedUploadCsv execute() throws ApiException {
            ApiResponse localVarResp = RevenueIntegrationApi.this.uploadCsvWithHttpInfo(this.token, this.templatename, this.data, this.filename);
            return (ExpandedUploadCsv)localVarResp.getData();
        }

        private ApiResponse<ExpandedUploadCsv> executeWithHttpInfo() throws ApiException {
            return RevenueIntegrationApi.this.uploadCsvWithHttpInfo(this.token, this.templatename, this.data, this.filename);
        }

        public Call executeAsync(ApiCallback<ExpandedUploadCsv> _callback) throws ApiException {
            return RevenueIntegrationApi.this.uploadCsvAsync(this.token, this.templatename, this.data, this.filename, _callback);
        }
    }

    public class ListReportsApi {
        private final String token;
        private final LocalDate createddate;

        private ListReportsApi(String token, LocalDate createddate) {
            this.token = token;
            this.createddate = createddate;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return RevenueIntegrationApi.this.listReportsCall(this.token, this.createddate, _callback);
        }

        public ExpandedReportList execute() throws ApiException {
            ApiResponse localVarResp = RevenueIntegrationApi.this.listReportsWithHttpInfo(this.token, this.createddate);
            return (ExpandedReportList)localVarResp.getData();
        }

        private ApiResponse<ExpandedReportList> executeWithHttpInfo() throws ApiException {
            return RevenueIntegrationApi.this.listReportsWithHttpInfo(this.token, this.createddate);
        }

        public Call executeAsync(ApiCallback<ExpandedReportList> _callback) throws ApiException {
            return RevenueIntegrationApi.this.listReportsAsync(this.token, this.createddate, _callback);
        }
    }

    public class GetStageErrorApi {
        private final String token;
        private final String errortype;

        private GetStageErrorApi(String token, String errortype) {
            this.token = token;
            this.errortype = errortype;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return RevenueIntegrationApi.this.getStageErrorCall(this.token, this.errortype, _callback);
        }

        public ExpandedStageError execute() throws ApiException {
            ApiResponse localVarResp = RevenueIntegrationApi.this.getStageErrorWithHttpInfo(this.token, this.errortype);
            return (ExpandedStageError)localVarResp.getData();
        }

        private ApiResponse<ExpandedStageError> executeWithHttpInfo() throws ApiException {
            return RevenueIntegrationApi.this.getStageErrorWithHttpInfo(this.token, this.errortype);
        }

        public Call executeAsync(ApiCallback<ExpandedStageError> _callback) throws ApiException {
            return RevenueIntegrationApi.this.getStageErrorAsync(this.token, this.errortype, _callback);
        }
    }

    public class GetSignedUrlApi {
        private final String token;
        private final String submissionId;

        private GetSignedUrlApi(String token, String submissionId) {
            this.token = token;
            this.submissionId = submissionId;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return RevenueIntegrationApi.this.getSignedUrlCall(this.token, this.submissionId, _callback);
        }

        public ExpandedSignedUrl execute() throws ApiException {
            ApiResponse localVarResp = RevenueIntegrationApi.this.getSignedUrlWithHttpInfo(this.token, this.submissionId);
            return (ExpandedSignedUrl)localVarResp.getData();
        }

        private ApiResponse<ExpandedSignedUrl> executeWithHttpInfo() throws ApiException {
            return RevenueIntegrationApi.this.getSignedUrlWithHttpInfo(this.token, this.submissionId);
        }

        public Call executeAsync(ApiCallback<ExpandedSignedUrl> _callback) throws ApiException {
            return RevenueIntegrationApi.this.getSignedUrlAsync(this.token, this.submissionId, _callback);
        }
    }

    public class GetReportsByIdApi {
        private final String token;
        private final LocalDate createddate;

        private GetReportsByIdApi(String token, LocalDate createddate) {
            this.token = token;
            this.createddate = createddate;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return RevenueIntegrationApi.this.getReportsByIdCall(this.token, this.createddate, _callback);
        }

        public ExpandedReportList execute() throws ApiException {
            ApiResponse localVarResp = RevenueIntegrationApi.this.getReportsByIdWithHttpInfo(this.token, this.createddate);
            return (ExpandedReportList)localVarResp.getData();
        }

        private ApiResponse<ExpandedReportList> executeWithHttpInfo() throws ApiException {
            return RevenueIntegrationApi.this.getReportsByIdWithHttpInfo(this.token, this.createddate);
        }

        public Call executeAsync(ApiCallback<ExpandedReportList> _callback) throws ApiException {
            return RevenueIntegrationApi.this.getReportsByIdAsync(this.token, this.createddate, _callback);
        }
    }

    public class GetReportsApi {
        private final String token;
        private final Integer numberOfRecords;

        private GetReportsApi(String token, Integer numberOfRecords) {
            this.token = token;
            this.numberOfRecords = numberOfRecords;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return RevenueIntegrationApi.this.getReportsCall(this.token, this.numberOfRecords, _callback);
        }

        public ExpandedReportGetRecent execute() throws ApiException {
            ApiResponse localVarResp = RevenueIntegrationApi.this.getReportsWithHttpInfo(this.token, this.numberOfRecords);
            return (ExpandedReportGetRecent)localVarResp.getData();
        }

        private ApiResponse<ExpandedReportGetRecent> executeWithHttpInfo() throws ApiException {
            return RevenueIntegrationApi.this.getReportsWithHttpInfo(this.token, this.numberOfRecords);
        }

        public Call executeAsync(ApiCallback<ExpandedReportGetRecent> _callback) throws ApiException {
            return RevenueIntegrationApi.this.getReportsAsync(this.token, this.numberOfRecords, _callback);
        }
    }

    public class GetFileUploadStatusByRequestIdApi {
        private final String token;
        private final Integer fileRequestId;

        private GetFileUploadStatusByRequestIdApi(String token, Integer fileRequestId) {
            this.token = token;
            this.fileRequestId = fileRequestId;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return RevenueIntegrationApi.this.getFileUploadStatusByRequestIdCall(this.token, this.fileRequestId, _callback);
        }

        public ExpandedUploadFileStatus execute() throws ApiException {
            ApiResponse localVarResp = RevenueIntegrationApi.this.getFileUploadStatusByRequestIdWithHttpInfo(this.token, this.fileRequestId);
            return (ExpandedUploadFileStatus)localVarResp.getData();
        }

        private ApiResponse<ExpandedUploadFileStatus> executeWithHttpInfo() throws ApiException {
            return RevenueIntegrationApi.this.getFileUploadStatusByRequestIdWithHttpInfo(this.token, this.fileRequestId);
        }

        public Call executeAsync(ApiCallback<ExpandedUploadFileStatus> _callback) throws ApiException {
            return RevenueIntegrationApi.this.getFileUploadStatusByRequestIdAsync(this.token, this.fileRequestId, _callback);
        }
    }

    public class GetFileUploadLogStatusApi {
        private final String token;
        private final Integer fileRequestId;

        private GetFileUploadLogStatusApi(String token, Integer fileRequestId) {
            this.token = token;
            this.fileRequestId = fileRequestId;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return RevenueIntegrationApi.this.getFileUploadLogStatusCall(this.token, this.fileRequestId, _callback);
        }

        public ExpandedUploadFileStatus execute() throws ApiException {
            ApiResponse localVarResp = RevenueIntegrationApi.this.getFileUploadLogStatusWithHttpInfo(this.token, this.fileRequestId);
            return (ExpandedUploadFileStatus)localVarResp.getData();
        }

        private ApiResponse<ExpandedUploadFileStatus> executeWithHttpInfo() throws ApiException {
            return RevenueIntegrationApi.this.getFileUploadLogStatusWithHttpInfo(this.token, this.fileRequestId);
        }

        public Call executeAsync(ApiCallback<ExpandedUploadFileStatus> _callback) throws ApiException {
            return RevenueIntegrationApi.this.getFileUploadLogStatusAsync(this.token, this.fileRequestId, _callback);
        }
    }

    public class GetCsvUploadStatusApi {
        private final Integer id;
        private final String token;

        private GetCsvUploadStatusApi(Integer id, String token) {
            this.id = id;
            this.token = token;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return RevenueIntegrationApi.this.getCsvUploadStatusCall(this.id, this.token, _callback);
        }

        public ExpandedUploadCsvStatus execute() throws ApiException {
            ApiResponse localVarResp = RevenueIntegrationApi.this.getCsvUploadStatusWithHttpInfo(this.id, this.token);
            return (ExpandedUploadCsvStatus)localVarResp.getData();
        }

        private ApiResponse<ExpandedUploadCsvStatus> executeWithHttpInfo() throws ApiException {
            return RevenueIntegrationApi.this.getCsvUploadStatusWithHttpInfo(this.id, this.token);
        }

        public Call executeAsync(ApiCallback<ExpandedUploadCsvStatus> _callback) throws ApiException {
            return RevenueIntegrationApi.this.getCsvUploadStatusAsync(this.id, this.token, _callback);
        }
    }

    public class GenerateOAuthTokenApi {
        private final String clientId;
        private final String clientSecret;
        private final String grantType;

        private GenerateOAuthTokenApi(String clientId, String clientSecret, String grantType) {
            this.clientId = clientId;
            this.clientSecret = clientSecret;
            this.grantType = grantType;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return RevenueIntegrationApi.this.generateOAuthTokenCall(this.clientId, this.clientSecret, this.grantType, _callback);
        }

        public ExpandedOAuth execute() throws ApiException {
            ApiResponse localVarResp = RevenueIntegrationApi.this.generateOAuthTokenWithHttpInfo(this.clientId, this.clientSecret, this.grantType);
            return (ExpandedOAuth)localVarResp.getData();
        }

        private ApiResponse<ExpandedOAuth> executeWithHttpInfo() throws ApiException {
            return RevenueIntegrationApi.this.generateOAuthTokenWithHttpInfo(this.clientId, this.clientSecret, this.grantType);
        }

        public Call executeAsync(ApiCallback<ExpandedOAuth> _callback) throws ApiException {
            return RevenueIntegrationApi.this.generateOAuthTokenAsync(this.clientId, this.clientSecret, this.grantType, _callback);
        }
    }

    public class GenerateJWTTokenApi {
        private final String role;
        private final String clientname;

        private GenerateJWTTokenApi(String role, String clientname) {
            this.role = role;
            this.clientname = clientname;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return RevenueIntegrationApi.this.generateJWTTokenCall(this.role, this.clientname, _callback);
        }

        public ExpandedAuthentication execute() throws ApiException {
            ApiResponse localVarResp = RevenueIntegrationApi.this.generateJWTTokenWithHttpInfo(this.role, this.clientname);
            return (ExpandedAuthentication)localVarResp.getData();
        }

        private ApiResponse<ExpandedAuthentication> executeWithHttpInfo() throws ApiException {
            return RevenueIntegrationApi.this.generateJWTTokenWithHttpInfo(this.role, this.clientname);
        }

        public Call executeAsync(ApiCallback<ExpandedAuthentication> _callback) throws ApiException {
            return RevenueIntegrationApi.this.generateJWTTokenAsync(this.role, this.clientname, _callback);
        }
    }

    public class DownloadReportApi {
        private final String token;
        private final String filename;

        private DownloadReportApi(String token, String filename) {
            this.token = token;
            this.filename = filename;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return RevenueIntegrationApi.this.downloadReportCall(this.token, this.filename, _callback);
        }

        public void execute() throws ApiException {
            RevenueIntegrationApi.this.downloadReportWithHttpInfo(this.token, this.filename);
        }

        private ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return RevenueIntegrationApi.this.downloadReportWithHttpInfo(this.token, this.filename);
        }

        public Call executeAsync(ApiCallback<Void> _callback) throws ApiException {
            return RevenueIntegrationApi.this.downloadReportAsync(this.token, this.filename, _callback);
        }
    }
}

