/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.client.JSON;
import org.openapitools.client.model.PaymentScheduleBillingDocumentRequest;
import org.openapitools.client.model.PaymentScheduleItemRequest;
import org.openapitools.client.model.PaymentSchedulePaymentOptionRequest;
import org.openapitools.jackson.nullable.JsonNullable;
import org.threeten.bp.LocalDate;

public class PaymentScheduleCreateRequest {
    public static final String SERIALIZED_NAME_ACCOUNT_ID = "account_id";
    @SerializedName(value="account_id")
    private String accountId;
    public static final String SERIALIZED_NAME_ACCOUNT_NUMBER = "account_number";
    @SerializedName(value="account_number")
    private String accountNumber;
    public static final String SERIALIZED_NAME_BILLING_DOCUMENT = "billing_document";
    @SerializedName(value="billing_document")
    private PaymentScheduleBillingDocumentRequest billingDocument;
    public static final String SERIALIZED_NAME_CURRENCY = "currency";
    @SerializedName(value="currency")
    private String currency;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_ITEMS = "items";
    @SerializedName(value="items")
    private List<PaymentScheduleItemRequest> items = null;
    public static final String SERIALIZED_NAME_PAYMENT_GATEWAY_ID = "payment_gateway_id";
    @SerializedName(value="payment_gateway_id")
    private String paymentGatewayId;
    public static final String SERIALIZED_NAME_PAYMENT_GATEWAY_NUMBER = "payment_gateway_number";
    @SerializedName(value="payment_gateway_number")
    private String paymentGatewayNumber;
    public static final String SERIALIZED_NAME_PAYMENT_METHOD_NUMBER = "payment_method_number";
    @SerializedName(value="payment_method_number")
    private String paymentMethodNumber;
    public static final String SERIALIZED_NAME_PAYMENT_METHOD_ID = "payment_method_id";
    @SerializedName(value="payment_method_id")
    private String paymentMethodId;
    public static final String SERIALIZED_NAME_PAYMENT_SCHEDULE_NUMBER = "payment_schedule_number";
    @SerializedName(value="payment_schedule_number")
    private String paymentScheduleNumber;
    public static final String SERIALIZED_NAME_PAYMENT_OPTIONS = "payment_options";
    @SerializedName(value="payment_options")
    private List<PaymentSchedulePaymentOptionRequest> paymentOptions = null;
    public static final String SERIALIZED_NAME_STANDALONE = "standalone";
    @SerializedName(value="standalone")
    private Boolean standalone;
    public static final String SERIALIZED_NAME_START_DATE = "start_date";
    @SerializedName(value="start_date")
    private LocalDate startDate;
    public static final String SERIALIZED_NAME_PREPAYMENT = "prepayment";
    @SerializedName(value="prepayment")
    private Boolean prepayment;
    public static final String SERIALIZED_NAME_PERIOD = "period";
    @SerializedName(value="period")
    private PeriodEnum period;
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private BigDecimal amount;
    public static final String SERIALIZED_NAME_TOTAL_AMOUNT = "total_amount";
    @SerializedName(value="total_amount")
    private BigDecimal totalAmount;
    public static final String SERIALIZED_NAME_NUMBER_OF_PAYMENTS = "number_of_payments";
    @SerializedName(value="number_of_payments")
    private Integer numberOfPayments;
    public static final String SERIALIZED_NAME_CUSTOM_FIELDS = "custom_fields";
    @SerializedName(value="custom_fields")
    @JsonAdapter(value=JSON.CustomFieldAdapter.class)
    private Map<String, Object> customFields = null;

    public PaymentScheduleCreateRequest accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Unique identifier of the customer account the payment schedule belongs to.")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public PaymentScheduleCreateRequest accountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Account number of the customer account the payment schedule belongs to.")
    public String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public PaymentScheduleCreateRequest billingDocument(PaymentScheduleBillingDocumentRequest billingDocument) {
        this.billingDocument = billingDocument;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The billing document with which the payment schedule is associated. Note: This field is optional. If you have the Standalone Payment feature enabled, you can leave this field blank and set standalone to true to create standalone payments. You can also choose to create unapplied payments by leaving this object blank and setting standalone to false. If Standalone Payment is not enabled, leaving this object unspecified will create unapplied payments.")
    public PaymentScheduleBillingDocumentRequest getBillingDocument() {
        return this.billingDocument;
    }

    public void setBillingDocument(PaymentScheduleBillingDocumentRequest billingDocument) {
        this.billingDocument = billingDocument;
    }

    public PaymentScheduleCreateRequest currency(String currency) {
        this.currency = currency;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="USD", value="Currency of the payment schedule. Note: This field is optional. The default value is the account's default currency. This field will be ignored when items is specified.")
    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public PaymentScheduleCreateRequest description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="description of test account", value="An arbitrary string attached to the object. Often useful for displaying to users.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public PaymentScheduleCreateRequest items(List<PaymentScheduleItemRequest> items) {
        this.items = items;
        return this;
    }

    public PaymentScheduleCreateRequest addItemsItem(PaymentScheduleItemRequest itemsItem) {
        if (this.items == null) {
            this.items = new ArrayList<PaymentScheduleItemRequest>();
        }
        this.items.add(itemsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Container for payment schedule items.")
    public List<PaymentScheduleItemRequest> getItems() {
        return this.items;
    }

    public void setItems(List<PaymentScheduleItemRequest> items) {
        this.items = items;
    }

    public PaymentScheduleCreateRequest paymentGatewayId(String paymentGatewayId) {
        this.paymentGatewayId = paymentGatewayId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="8ad093f27d6eee80017d6effd7a66759", value="ID of the payment gateway used to collect payments. Note: This field is optional. The default value is the account's default payment gateway ID. If no payment gateway ID is found on the customer account level, the default value will be the tenant's default payment gateway ID. This field will be ignored when items is specified.")
    public String getPaymentGatewayId() {
        return this.paymentGatewayId;
    }

    public void setPaymentGatewayId(String paymentGatewayId) {
        this.paymentGatewayId = paymentGatewayId;
    }

    public PaymentScheduleCreateRequest paymentGatewayNumber(String paymentGatewayNumber) {
        this.paymentGatewayNumber = paymentGatewayNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The payment gateway number of the payment gateway used to collect scheduled payments.")
    public String getPaymentGatewayNumber() {
        return this.paymentGatewayNumber;
    }

    public void setPaymentGatewayNumber(String paymentGatewayNumber) {
        this.paymentGatewayNumber = paymentGatewayNumber;
    }

    public PaymentScheduleCreateRequest paymentMethodNumber(String paymentMethodNumber) {
        this.paymentMethodNumber = paymentMethodNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The payment method number of the payment method to be used to collect payments.")
    public String getPaymentMethodNumber() {
        return this.paymentMethodNumber;
    }

    public void setPaymentMethodNumber(String paymentMethodNumber) {
        this.paymentMethodNumber = paymentMethodNumber;
    }

    public PaymentScheduleCreateRequest paymentMethodId(String paymentMethodId) {
        this.paymentMethodId = paymentMethodId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="8a95b1946b6aeac8718c32aab8c395f", value="ID of the payment method. Note: This field is optional. The default value is the account's default payment method ID. This field will be ignored when items is specified.")
    public String getPaymentMethodId() {
        return this.paymentMethodId;
    }

    public void setPaymentMethodId(String paymentMethodId) {
        this.paymentMethodId = paymentMethodId;
    }

    public PaymentScheduleCreateRequest paymentScheduleNumber(String paymentScheduleNumber) {
        this.paymentScheduleNumber = paymentScheduleNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Number of the payment schedule.")
    public String getPaymentScheduleNumber() {
        return this.paymentScheduleNumber;
    }

    public void setPaymentScheduleNumber(String paymentScheduleNumber) {
        this.paymentScheduleNumber = paymentScheduleNumber;
    }

    public PaymentScheduleCreateRequest paymentOptions(List<PaymentSchedulePaymentOptionRequest> paymentOptions) {
        this.paymentOptions = paymentOptions;
        return this;
    }

    public PaymentScheduleCreateRequest addPaymentOptionsItem(PaymentSchedulePaymentOptionRequest paymentOptionsItem) {
        if (this.paymentOptions == null) {
            this.paymentOptions = new ArrayList<PaymentSchedulePaymentOptionRequest>();
        }
        this.paymentOptions.add(paymentOptionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Container for the payment options, which describe the transactional level rules for processing payments. Currently, only the gateway_options type is supported. Payment schedule payment_options take precedence over payment schedule item payment_options.")
    public List<PaymentSchedulePaymentOptionRequest> getPaymentOptions() {
        return this.paymentOptions;
    }

    public void setPaymentOptions(List<PaymentSchedulePaymentOptionRequest> paymentOptions) {
        this.paymentOptions = paymentOptions;
    }

    public PaymentScheduleCreateRequest standalone(Boolean standalone) {
        this.standalone = standalone;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates whether the payments created by the payment schedule are standalone payments or not.              When setting to `true`, standalone payments will be created.       When setting to `false`, you can either specify a billing document, or not specifying any billing documents.       In the latter case, unapplied payments will be created.       If set to `null`, standalone payments will be created.              **Note**: This parameter is only available if standalone payments are enabled in your tenant. The default value is `true` if standalone payments are enabled in your tenant.")
    public Boolean getStandalone() {
        return this.standalone;
    }

    public void setStandalone(Boolean standalone) {
        this.standalone = standalone;
    }

    public PaymentScheduleCreateRequest startDate(LocalDate startDate) {
        this.startDate = startDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Sun Jan 01 00:00:00 GMT 2023", value="The date of the first scheduled payment collection. Note: This parameter is required when `items` is not specified. This parameter will be ignored when `items` is specified.")
    public LocalDate getStartDate() {
        return this.startDate;
    }

    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public PaymentScheduleCreateRequest prepayment(Boolean prepayment) {
        this.prepayment = prepayment;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates whether the payments created by the payment schedule will be used as reserved payments. This field will only be available if the prepaid cash drawdown permission is enabled. See <a href=\"https://knowledgecenter.zuora.com/Zuora_Billing/Bill_your_customers/Bill_for_usage_or_prepaid_products/Advanced_Consumption_Billing/Prepaid_with_Drawdown\" target=\"_blank\">Prepaid Cash with Drawdown for more information.</a>")
    public Boolean getPrepayment() {
        return this.prepayment;
    }

    public void setPrepayment(Boolean prepayment) {
        this.prepayment = prepayment;
    }

    public PaymentScheduleCreateRequest period(PeriodEnum period) {
        this.period = period;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Unit in which term duration is defined. One of week or month.")
    public PeriodEnum getPeriod() {
        return this.period;
    }

    public void setPeriod(PeriodEnum period) {
        this.period = period;
    }

    public PaymentScheduleCreateRequest amount(BigDecimal amount) {
        this.amount = amount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The amount of each payment schedule item in the payment schedule.")
    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public PaymentScheduleCreateRequest totalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The total amount to be collected by the payment schedule.")
    public BigDecimal getTotalAmount() {
        return this.totalAmount;
    }

    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    public PaymentScheduleCreateRequest numberOfPayments(Integer numberOfPayments) {
        this.numberOfPayments = numberOfPayments;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of payment schedule items to be created for this payment schedule.")
    public Integer getNumberOfPayments() {
        return this.numberOfPayments;
    }

    public void setNumberOfPayments(Integer numberOfPayments) {
        this.numberOfPayments = numberOfPayments;
    }

    public PaymentScheduleCreateRequest customFields(Map<String, Object> customFields) {
        this.customFields = customFields;
        return this;
    }

    public PaymentScheduleCreateRequest putCustomFieldsItem(String key, Object customFieldsItem) {
        if (this.customFields == null) {
            this.customFields = new HashMap<String, Object>();
        }
        this.customFields.put(key, customFieldsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Set of user-defined fields associated with this object. Useful for storing additional information about the object in a structured format.")
    public Map<String, Object> getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(Map<String, Object> customFields) {
        this.customFields = customFields;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentScheduleCreateRequest paymentScheduleCreateRequest = (PaymentScheduleCreateRequest)o;
        return Objects.equals(this.accountId, paymentScheduleCreateRequest.accountId) && Objects.equals(this.accountNumber, paymentScheduleCreateRequest.accountNumber) && Objects.equals(this.billingDocument, paymentScheduleCreateRequest.billingDocument) && Objects.equals(this.currency, paymentScheduleCreateRequest.currency) && Objects.equals(this.description, paymentScheduleCreateRequest.description) && Objects.equals(this.items, paymentScheduleCreateRequest.items) && Objects.equals(this.paymentGatewayId, paymentScheduleCreateRequest.paymentGatewayId) && Objects.equals(this.paymentGatewayNumber, paymentScheduleCreateRequest.paymentGatewayNumber) && Objects.equals(this.paymentMethodNumber, paymentScheduleCreateRequest.paymentMethodNumber) && Objects.equals(this.paymentMethodId, paymentScheduleCreateRequest.paymentMethodId) && Objects.equals(this.paymentScheduleNumber, paymentScheduleCreateRequest.paymentScheduleNumber) && Objects.equals(this.paymentOptions, paymentScheduleCreateRequest.paymentOptions) && Objects.equals(this.standalone, paymentScheduleCreateRequest.standalone) && Objects.equals(this.startDate, paymentScheduleCreateRequest.startDate) && Objects.equals(this.prepayment, paymentScheduleCreateRequest.prepayment) && Objects.equals((Object)this.period, (Object)paymentScheduleCreateRequest.period) && Objects.equals(this.amount, paymentScheduleCreateRequest.amount) && Objects.equals(this.totalAmount, paymentScheduleCreateRequest.totalAmount) && Objects.equals(this.numberOfPayments, paymentScheduleCreateRequest.numberOfPayments) && Objects.equals(this.customFields, paymentScheduleCreateRequest.customFields);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountId, this.accountNumber, this.billingDocument, this.currency, this.description, this.items, this.paymentGatewayId, this.paymentGatewayNumber, this.paymentMethodNumber, this.paymentMethodId, this.paymentScheduleNumber, this.paymentOptions, this.standalone, this.startDate, this.prepayment, this.period, this.amount, this.totalAmount, this.numberOfPayments, this.customFields});
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentScheduleCreateRequest {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    accountNumber: ").append(this.toIndentedString(this.accountNumber)).append("\n");
        sb.append("    billingDocument: ").append(this.toIndentedString(this.billingDocument)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("    paymentGatewayId: ").append(this.toIndentedString(this.paymentGatewayId)).append("\n");
        sb.append("    paymentGatewayNumber: ").append(this.toIndentedString(this.paymentGatewayNumber)).append("\n");
        sb.append("    paymentMethodNumber: ").append(this.toIndentedString(this.paymentMethodNumber)).append("\n");
        sb.append("    paymentMethodId: ").append(this.toIndentedString(this.paymentMethodId)).append("\n");
        sb.append("    paymentScheduleNumber: ").append(this.toIndentedString(this.paymentScheduleNumber)).append("\n");
        sb.append("    paymentOptions: ").append(this.toIndentedString(this.paymentOptions)).append("\n");
        sb.append("    standalone: ").append(this.toIndentedString(this.standalone)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    prepayment: ").append(this.toIndentedString(this.prepayment)).append("\n");
        sb.append("    period: ").append(this.toIndentedString((Object)this.period)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    totalAmount: ").append(this.toIndentedString(this.totalAmount)).append("\n");
        sb.append("    numberOfPayments: ").append(this.toIndentedString(this.numberOfPayments)).append("\n");
        sb.append("    customFields: ").append(this.toIndentedString(this.customFields)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum PeriodEnum {
        WEEK("week"),
        MONTH("month"),
        BIWEEKLY("biweekly"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private PeriodEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static PeriodEnum fromValue(String value) {
            for (PeriodEnum b : PeriodEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<PeriodEnum> {
            public void write(JsonWriter jsonWriter, PeriodEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public PeriodEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return PeriodEnum.fromValue(value);
            }
        }
    }
}

