/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.client.JSON;
import org.openapitools.client.model.Invoice;
import org.openapitools.client.model.LineItem;
import org.openapitools.client.model.Subscription;
import org.openapitools.client.model.SubscriptionItem;
import org.openapitools.client.model.TaxationItemListResponse;
import org.openapitools.jackson.nullable.JsonNullable;
import org.threeten.bp.OffsetDateTime;

public class InvoiceItem {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_UPDATED_BY_ID = "updated_by_id";
    @SerializedName(value="updated_by_id")
    private String updatedById;
    public static final String SERIALIZED_NAME_UPDATED_TIME = "updated_time";
    @SerializedName(value="updated_time")
    private OffsetDateTime updatedTime;
    public static final String SERIALIZED_NAME_CREATED_BY_ID = "created_by_id";
    @SerializedName(value="created_by_id")
    private String createdById;
    public static final String SERIALIZED_NAME_CREATED_TIME = "created_time";
    @SerializedName(value="created_time")
    private OffsetDateTime createdTime;
    public static final String SERIALIZED_NAME_CUSTOM_FIELDS = "custom_fields";
    @SerializedName(value="custom_fields")
    @JsonAdapter(value=JSON.CustomFieldAdapter.class)
    private Map<String, Object> customFields = null;
    public static final String SERIALIZED_NAME_CUSTOM_OBJECTS = "custom_objects";
    @SerializedName(value="custom_objects")
    private Map<String, Object> customObjects = null;
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private BigDecimal amount;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_DEFERRED_REVENUE_ACCOUNT = "deferred_revenue_account";
    @SerializedName(value="deferred_revenue_account")
    private String deferredRevenueAccount;
    public static final String SERIALIZED_NAME_RECOGNIZED_REVENUE_ACCOUNT = "recognized_revenue_account";
    @SerializedName(value="recognized_revenue_account")
    private String recognizedRevenueAccount;
    public static final String SERIALIZED_NAME_REVENUE_RECOGNITION_RULE_NAME = "revenue_recognition_rule_name";
    @SerializedName(value="revenue_recognition_rule_name")
    private String revenueRecognitionRuleName;
    public static final String SERIALIZED_NAME_QUANTITY = "quantity";
    @SerializedName(value="quantity")
    private BigDecimal quantity;
    public static final String SERIALIZED_NAME_SERVICE_END = "service_end";
    @SerializedName(value="service_end")
    private String serviceEnd;
    public static final String SERIALIZED_NAME_ACCOUNTS_RECEIVABLE_ACCOUNT = "accounts_receivable_account";
    @SerializedName(value="accounts_receivable_account")
    private String accountsReceivableAccount;
    public static final String SERIALIZED_NAME_DISCOUNT_ITEM = "discount_item";
    @SerializedName(value="discount_item")
    private Boolean discountItem;
    public static final String SERIALIZED_NAME_APPLIED_TO_ITEM_ID = "applied_to_item_id";
    @SerializedName(value="applied_to_item_id")
    private String appliedToItemId;
    public static final String SERIALIZED_NAME_SERVICE_START = "service_start";
    @SerializedName(value="service_start")
    private String serviceStart;
    public static final String SERIALIZED_NAME_ACCOUNTING_CODE = "accounting_code";
    @SerializedName(value="accounting_code")
    private String accountingCode;
    public static final String SERIALIZED_NAME_INVOICE_ID = "invoice_id";
    @SerializedName(value="invoice_id")
    private String invoiceId;
    public static final String SERIALIZED_NAME_SKU = "sku";
    @SerializedName(value="sku")
    private String sku;
    public static final String SERIALIZED_NAME_SUBSCRIPTION_ID = "subscription_id";
    @SerializedName(value="subscription_id")
    private String subscriptionId;
    public static final String SERIALIZED_NAME_TAX_INCLUSIVE = "tax_inclusive";
    @SerializedName(value="tax_inclusive")
    private Boolean taxInclusive;
    public static final String SERIALIZED_NAME_REMAINING_BALANCE = "remaining_balance";
    @SerializedName(value="remaining_balance")
    private BigDecimal remainingBalance;
    public static final String SERIALIZED_NAME_UNIT_OF_MEASURE = "unit_of_measure";
    @SerializedName(value="unit_of_measure")
    private String unitOfMeasure;
    public static final String SERIALIZED_NAME_UNIT_AMOUNT = "unit_amount";
    @SerializedName(value="unit_amount")
    private BigDecimal unitAmount;
    public static final String SERIALIZED_NAME_BOOKING_REFERENCE = "booking_reference";
    @SerializedName(value="booking_reference")
    private String bookingReference;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_DOCUMENT_ITEM_DATE = "document_item_date";
    @SerializedName(value="document_item_date")
    private OffsetDateTime documentItemDate;
    public static final String SERIALIZED_NAME_PRICE_ID = "price_id";
    @SerializedName(value="price_id")
    private String priceId;
    public static final String SERIALIZED_NAME_PURCHASE_ORDER_NUMBER = "purchase_order_number";
    @SerializedName(value="purchase_order_number")
    private String purchaseOrderNumber;
    public static final String SERIALIZED_NAME_TAX = "tax";
    @SerializedName(value="tax")
    private BigDecimal tax;
    public static final String SERIALIZED_NAME_TAX_CODE = "tax_code";
    @SerializedName(value="tax_code")
    private String taxCode;
    public static final String SERIALIZED_NAME_SUBSCRIPTION_ITEM_ID = "subscription_item_id";
    @SerializedName(value="subscription_item_id")
    private String subscriptionItemId;
    public static final String SERIALIZED_NAME_TAXATION_ITEMS = "taxation_items";
    @SerializedName(value="taxation_items")
    private TaxationItemListResponse taxationItems;
    public static final String SERIALIZED_NAME_INVOICE = "invoice";
    @SerializedName(value="invoice")
    private Invoice invoice;
    public static final String SERIALIZED_NAME_LINE_ITEM = "line_item";
    @SerializedName(value="line_item")
    private LineItem lineItem;
    public static final String SERIALIZED_NAME_SUBSCRIPTION = "subscription";
    @SerializedName(value="subscription")
    private Subscription subscription;
    public static final String SERIALIZED_NAME_SUBSCRIPTION_ITEM = "subscription_item";
    @SerializedName(value="subscription_item")
    private SubscriptionItem subscriptionItem;

    public InvoiceItem() {
    }

    public InvoiceItem(String id, String updatedById, OffsetDateTime updatedTime, String createdById, OffsetDateTime createdTime, Map<String, Object> customObjects, OffsetDateTime documentItemDate, Subscription subscription) {
        this();
        this.id = id;
        this.updatedById = updatedById;
        this.updatedTime = updatedTime;
        this.createdById = createdById;
        this.createdTime = createdTime;
        this.customObjects = customObjects;
        this.documentItemDate = documentItemDate;
        this.subscription = subscription;
    }

    @Nullable
    @ApiModelProperty(value="Unique identifier for the object.")
    public String getId() {
        return this.id;
    }

    @Nullable
    @ApiModelProperty(value="Unique identifier of the Zuora user who last updated the object")
    public String getUpdatedById() {
        return this.updatedById;
    }

    @Nullable
    @ApiModelProperty(value="The date and time when the object was last updated in ISO 8601 UTC format.")
    public OffsetDateTime getUpdatedTime() {
        return this.updatedTime;
    }

    @Nullable
    @ApiModelProperty(value="Unique identifier of the Zuora user who created the object")
    public String getCreatedById() {
        return this.createdById;
    }

    @Nullable
    @ApiModelProperty(value="The date and time when the object was created in ISO 8601 UTC format.")
    public OffsetDateTime getCreatedTime() {
        return this.createdTime;
    }

    public InvoiceItem customFields(Map<String, Object> customFields) {
        this.customFields = customFields;
        return this;
    }

    public InvoiceItem putCustomFieldsItem(String key, Object customFieldsItem) {
        if (this.customFields == null) {
            this.customFields = new HashMap<String, Object>();
        }
        this.customFields.put(key, customFieldsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Set of user-defined fields associated with this object. Useful for storing additional information about the object in a structured format.")
    public Map<String, Object> getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(Map<String, Object> customFields) {
        this.customFields = customFields;
    }

    @Nullable
    @ApiModelProperty(value="The custom objects associated with a Zuora standard object.")
    public Map<String, Object> getCustomObjects() {
        return this.customObjects;
    }

    public InvoiceItem amount(BigDecimal amount) {
        this.amount = amount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The total amount of this invoice item.")
    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public InvoiceItem description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An arbitrary string associated with the object. Often useful for displaying to users.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public InvoiceItem deferredRevenueAccount(String deferredRevenueAccount) {
        this.deferredRevenueAccount = deferredRevenueAccount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The accounting code for the deferred revenue, such as Monthly Recurring Liability.")
    public String getDeferredRevenueAccount() {
        return this.deferredRevenueAccount;
    }

    public void setDeferredRevenueAccount(String deferredRevenueAccount) {
        this.deferredRevenueAccount = deferredRevenueAccount;
    }

    public InvoiceItem recognizedRevenueAccount(String recognizedRevenueAccount) {
        this.recognizedRevenueAccount = recognizedRevenueAccount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The accounting code for the recognized revenue, such as Monthly Recurring Charges or Overage Charges.")
    public String getRecognizedRevenueAccount() {
        return this.recognizedRevenueAccount;
    }

    public void setRecognizedRevenueAccount(String recognizedRevenueAccount) {
        this.recognizedRevenueAccount = recognizedRevenueAccount;
    }

    public InvoiceItem revenueRecognitionRuleName(String revenueRecognitionRuleName) {
        this.revenueRecognitionRuleName = revenueRecognitionRuleName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of the revenue recognition rule governing the revenue schedule.")
    public String getRevenueRecognitionRuleName() {
        return this.revenueRecognitionRuleName;
    }

    public void setRevenueRecognitionRuleName(String revenueRecognitionRuleName) {
        this.revenueRecognitionRuleName = revenueRecognitionRuleName;
    }

    public InvoiceItem quantity(BigDecimal quantity) {
        this.quantity = quantity;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of units of this item.")
    public BigDecimal getQuantity() {
        return this.quantity;
    }

    public void setQuantity(BigDecimal quantity) {
        this.quantity = quantity;
    }

    public InvoiceItem serviceEnd(String serviceEnd) {
        this.serviceEnd = serviceEnd;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The end date of the service period associated with this invoice item. If the associated charge is a one-time fee, then this date is the date of that charge.")
    public String getServiceEnd() {
        return this.serviceEnd;
    }

    public void setServiceEnd(String serviceEnd) {
        this.serviceEnd = serviceEnd;
    }

    public InvoiceItem accountsReceivableAccount(String accountsReceivableAccount) {
        this.accountsReceivableAccount = accountsReceivableAccount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An active account in your Zuora Chart of Accounts.")
    public String getAccountsReceivableAccount() {
        return this.accountsReceivableAccount;
    }

    public void setAccountsReceivableAccount(String accountsReceivableAccount) {
        this.accountsReceivableAccount = accountsReceivableAccount;
    }

    public InvoiceItem discountItem(Boolean discountItem) {
        this.discountItem = discountItem;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If true, indicates that the item is a discount item.")
    public Boolean getDiscountItem() {
        return this.discountItem;
    }

    public void setDiscountItem(Boolean discountItem) {
        this.discountItem = discountItem;
    }

    public InvoiceItem appliedToItemId(String appliedToItemId) {
        this.appliedToItemId = appliedToItemId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Identifier of an invoice item or a debit memo item that this discount item or credit memo item is applied to.")
    public String getAppliedToItemId() {
        return this.appliedToItemId;
    }

    public void setAppliedToItemId(String appliedToItemId) {
        this.appliedToItemId = appliedToItemId;
    }

    public InvoiceItem serviceStart(String serviceStart) {
        this.serviceStart = serviceStart;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The start date of the service period associated with this invoice item. If the associated charge is a one-time fee, then this date is the date of that charge.")
    public String getServiceStart() {
        return this.serviceStart;
    }

    public void setServiceStart(String serviceStart) {
        this.serviceStart = serviceStart;
    }

    public InvoiceItem accountingCode(String accountingCode) {
        this.accountingCode = accountingCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getAccountingCode() {
        return this.accountingCode;
    }

    public void setAccountingCode(String accountingCode) {
        this.accountingCode = accountingCode;
    }

    public InvoiceItem invoiceId(String invoiceId) {
        this.invoiceId = invoiceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The identifier of the invoice associated with this invoice item.")
    public String getInvoiceId() {
        return this.invoiceId;
    }

    public void setInvoiceId(String invoiceId) {
        this.invoiceId = invoiceId;
    }

    public InvoiceItem sku(String sku) {
        this.sku = sku;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The unique SKU (stock keeping unit) of the product associated with this item.")
    public String getSku() {
        return this.sku;
    }

    public void setSku(String sku) {
        this.sku = sku;
    }

    public InvoiceItem subscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The identifier of the subscription associated with the invoice item.")
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public void setSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
    }

    public InvoiceItem taxInclusive(Boolean taxInclusive) {
        this.taxInclusive = taxInclusive;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="This specifies if the invoice item amount is inclusive or exclusive of tax.")
    public Boolean getTaxInclusive() {
        return this.taxInclusive;
    }

    public void setTaxInclusive(Boolean taxInclusive) {
        this.taxInclusive = taxInclusive;
    }

    public InvoiceItem remainingBalance(BigDecimal remainingBalance) {
        this.remainingBalance = remainingBalance;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The remaining balance of this invoice item.")
    public BigDecimal getRemainingBalance() {
        return this.remainingBalance;
    }

    public void setRemainingBalance(BigDecimal remainingBalance) {
        this.remainingBalance = remainingBalance;
    }

    public InvoiceItem unitOfMeasure(String unitOfMeasure) {
        this.unitOfMeasure = unitOfMeasure;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specifies the units used to measure usage.")
    public String getUnitOfMeasure() {
        return this.unitOfMeasure;
    }

    public void setUnitOfMeasure(String unitOfMeasure) {
        this.unitOfMeasure = unitOfMeasure;
    }

    public InvoiceItem unitAmount(BigDecimal unitAmount) {
        this.unitAmount = unitAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Unit amount (in the currency specified) of the invoice item.")
    public BigDecimal getUnitAmount() {
        return this.unitAmount;
    }

    public void setUnitAmount(BigDecimal unitAmount) {
        this.unitAmount = unitAmount;
    }

    public InvoiceItem bookingReference(String bookingReference) {
        this.bookingReference = bookingReference;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The booking reference for this invoice item.")
    public String getBookingReference() {
        return this.bookingReference;
    }

    public void setBookingReference(String bookingReference) {
        this.bookingReference = bookingReference;
    }

    public InvoiceItem name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Name of the invoice item displayed to customers on billing documents.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Nullable
    @ApiModelProperty(value="The date and time when the invoice item was created in ISO 8601 UTC format.")
    public OffsetDateTime getDocumentItemDate() {
        return this.documentItemDate;
    }

    public InvoiceItem priceId(String priceId) {
        this.priceId = priceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The identifier of the price this invoice item is associated with.")
    public String getPriceId() {
        return this.priceId;
    }

    public void setPriceId(String priceId) {
        this.priceId = priceId;
    }

    public InvoiceItem purchaseOrderNumber(String purchaseOrderNumber) {
        this.purchaseOrderNumber = purchaseOrderNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The purchase order number associated with this invoice item.")
    public String getPurchaseOrderNumber() {
        return this.purchaseOrderNumber;
    }

    public void setPurchaseOrderNumber(String purchaseOrderNumber) {
        this.purchaseOrderNumber = purchaseOrderNumber;
    }

    public InvoiceItem tax(BigDecimal tax) {
        this.tax = tax;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The amount of tax applied to the invoice item.")
    public BigDecimal getTax() {
        return this.tax;
    }

    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }

    public InvoiceItem taxCode(String taxCode) {
        this.taxCode = taxCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The designated tax code.")
    public String getTaxCode() {
        return this.taxCode;
    }

    public void setTaxCode(String taxCode) {
        this.taxCode = taxCode;
    }

    public InvoiceItem subscriptionItemId(String subscriptionItemId) {
        this.subscriptionItemId = subscriptionItemId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The identifier the subscription item associated with this invoice item.")
    public String getSubscriptionItemId() {
        return this.subscriptionItemId;
    }

    public void setSubscriptionItemId(String subscriptionItemId) {
        this.subscriptionItemId = subscriptionItemId;
    }

    public InvoiceItem taxationItems(TaxationItemListResponse taxationItems) {
        this.taxationItems = taxationItems;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public TaxationItemListResponse getTaxationItems() {
        return this.taxationItems;
    }

    public void setTaxationItems(TaxationItemListResponse taxationItems) {
        this.taxationItems = taxationItems;
    }

    public InvoiceItem invoice(Invoice invoice) {
        this.invoice = invoice;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The invoice the item belongs to. EXPANDABLE")
    public Invoice getInvoice() {
        return this.invoice;
    }

    public void setInvoice(Invoice invoice) {
        this.invoice = invoice;
    }

    public InvoiceItem lineItem(LineItem lineItem) {
        this.lineItem = lineItem;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The order line item associated with this invoice item. EXPANDABLE")
    public LineItem getLineItem() {
        return this.lineItem;
    }

    public void setLineItem(LineItem lineItem) {
        this.lineItem = lineItem;
    }

    @Nullable
    @ApiModelProperty(value="List of customer subscriptions.")
    public Subscription getSubscription() {
        return this.subscription;
    }

    public InvoiceItem subscriptionItem(SubscriptionItem subscriptionItem) {
        this.subscriptionItem = subscriptionItem;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The expandable subscription item associated with this billing document item.")
    public SubscriptionItem getSubscriptionItem() {
        return this.subscriptionItem;
    }

    public void setSubscriptionItem(SubscriptionItem subscriptionItem) {
        this.subscriptionItem = subscriptionItem;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InvoiceItem invoiceItem = (InvoiceItem)o;
        return Objects.equals(this.id, invoiceItem.id) && Objects.equals(this.updatedById, invoiceItem.updatedById) && Objects.equals(this.updatedTime, invoiceItem.updatedTime) && Objects.equals(this.createdById, invoiceItem.createdById) && Objects.equals(this.createdTime, invoiceItem.createdTime) && Objects.equals(this.customFields, invoiceItem.customFields) && Objects.equals(this.customObjects, invoiceItem.customObjects) && Objects.equals(this.amount, invoiceItem.amount) && Objects.equals(this.description, invoiceItem.description) && Objects.equals(this.deferredRevenueAccount, invoiceItem.deferredRevenueAccount) && Objects.equals(this.recognizedRevenueAccount, invoiceItem.recognizedRevenueAccount) && Objects.equals(this.revenueRecognitionRuleName, invoiceItem.revenueRecognitionRuleName) && Objects.equals(this.quantity, invoiceItem.quantity) && Objects.equals(this.serviceEnd, invoiceItem.serviceEnd) && Objects.equals(this.accountsReceivableAccount, invoiceItem.accountsReceivableAccount) && Objects.equals(this.discountItem, invoiceItem.discountItem) && Objects.equals(this.appliedToItemId, invoiceItem.appliedToItemId) && Objects.equals(this.serviceStart, invoiceItem.serviceStart) && Objects.equals(this.accountingCode, invoiceItem.accountingCode) && Objects.equals(this.invoiceId, invoiceItem.invoiceId) && Objects.equals(this.sku, invoiceItem.sku) && Objects.equals(this.subscriptionId, invoiceItem.subscriptionId) && Objects.equals(this.taxInclusive, invoiceItem.taxInclusive) && Objects.equals(this.remainingBalance, invoiceItem.remainingBalance) && Objects.equals(this.unitOfMeasure, invoiceItem.unitOfMeasure) && Objects.equals(this.unitAmount, invoiceItem.unitAmount) && Objects.equals(this.bookingReference, invoiceItem.bookingReference) && Objects.equals(this.name, invoiceItem.name) && Objects.equals(this.documentItemDate, invoiceItem.documentItemDate) && Objects.equals(this.priceId, invoiceItem.priceId) && Objects.equals(this.purchaseOrderNumber, invoiceItem.purchaseOrderNumber) && Objects.equals(this.tax, invoiceItem.tax) && Objects.equals(this.taxCode, invoiceItem.taxCode) && Objects.equals(this.subscriptionItemId, invoiceItem.subscriptionItemId) && Objects.equals(this.taxationItems, invoiceItem.taxationItems) && Objects.equals(this.invoice, invoiceItem.invoice) && Objects.equals(this.lineItem, invoiceItem.lineItem) && Objects.equals(this.subscription, invoiceItem.subscription) && Objects.equals(this.subscriptionItem, invoiceItem.subscriptionItem);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(this.id, this.updatedById, this.updatedTime, this.createdById, this.createdTime, this.customFields, this.customObjects, this.amount, this.description, this.deferredRevenueAccount, this.recognizedRevenueAccount, this.revenueRecognitionRuleName, this.quantity, this.serviceEnd, this.accountsReceivableAccount, this.discountItem, this.appliedToItemId, this.serviceStart, this.accountingCode, this.invoiceId, this.sku, this.subscriptionId, this.taxInclusive, this.remainingBalance, this.unitOfMeasure, this.unitAmount, this.bookingReference, this.name, this.documentItemDate, this.priceId, this.purchaseOrderNumber, this.tax, this.taxCode, this.subscriptionItemId, this.taxationItems, this.invoice, this.lineItem, this.subscription, this.subscriptionItem);
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InvoiceItem {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    updatedById: ").append(this.toIndentedString(this.updatedById)).append("\n");
        sb.append("    updatedTime: ").append(this.toIndentedString(this.updatedTime)).append("\n");
        sb.append("    createdById: ").append(this.toIndentedString(this.createdById)).append("\n");
        sb.append("    createdTime: ").append(this.toIndentedString(this.createdTime)).append("\n");
        sb.append("    customFields: ").append(this.toIndentedString(this.customFields)).append("\n");
        sb.append("    customObjects: ").append(this.toIndentedString(this.customObjects)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    deferredRevenueAccount: ").append(this.toIndentedString(this.deferredRevenueAccount)).append("\n");
        sb.append("    recognizedRevenueAccount: ").append(this.toIndentedString(this.recognizedRevenueAccount)).append("\n");
        sb.append("    revenueRecognitionRuleName: ").append(this.toIndentedString(this.revenueRecognitionRuleName)).append("\n");
        sb.append("    quantity: ").append(this.toIndentedString(this.quantity)).append("\n");
        sb.append("    serviceEnd: ").append(this.toIndentedString(this.serviceEnd)).append("\n");
        sb.append("    accountsReceivableAccount: ").append(this.toIndentedString(this.accountsReceivableAccount)).append("\n");
        sb.append("    discountItem: ").append(this.toIndentedString(this.discountItem)).append("\n");
        sb.append("    appliedToItemId: ").append(this.toIndentedString(this.appliedToItemId)).append("\n");
        sb.append("    serviceStart: ").append(this.toIndentedString(this.serviceStart)).append("\n");
        sb.append("    accountingCode: ").append(this.toIndentedString(this.accountingCode)).append("\n");
        sb.append("    invoiceId: ").append(this.toIndentedString(this.invoiceId)).append("\n");
        sb.append("    sku: ").append(this.toIndentedString(this.sku)).append("\n");
        sb.append("    subscriptionId: ").append(this.toIndentedString(this.subscriptionId)).append("\n");
        sb.append("    taxInclusive: ").append(this.toIndentedString(this.taxInclusive)).append("\n");
        sb.append("    remainingBalance: ").append(this.toIndentedString(this.remainingBalance)).append("\n");
        sb.append("    unitOfMeasure: ").append(this.toIndentedString(this.unitOfMeasure)).append("\n");
        sb.append("    unitAmount: ").append(this.toIndentedString(this.unitAmount)).append("\n");
        sb.append("    bookingReference: ").append(this.toIndentedString(this.bookingReference)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    documentItemDate: ").append(this.toIndentedString(this.documentItemDate)).append("\n");
        sb.append("    priceId: ").append(this.toIndentedString(this.priceId)).append("\n");
        sb.append("    purchaseOrderNumber: ").append(this.toIndentedString(this.purchaseOrderNumber)).append("\n");
        sb.append("    tax: ").append(this.toIndentedString(this.tax)).append("\n");
        sb.append("    taxCode: ").append(this.toIndentedString(this.taxCode)).append("\n");
        sb.append("    subscriptionItemId: ").append(this.toIndentedString(this.subscriptionItemId)).append("\n");
        sb.append("    taxationItems: ").append(this.toIndentedString(this.taxationItems)).append("\n");
        sb.append("    invoice: ").append(this.toIndentedString(this.invoice)).append("\n");
        sb.append("    lineItem: ").append(this.toIndentedString(this.lineItem)).append("\n");
        sb.append("    subscription: ").append(this.toIndentedString(this.subscription)).append("\n");
        sb.append("    subscriptionItem: ").append(this.toIndentedString(this.subscriptionItem)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

