/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.client.JSON;
import org.threeten.bp.LocalDate;

public class CreditMemoPatchRequest {
    public static final String SERIALIZED_NAME_APPLY = "apply";
    @SerializedName(value="apply")
    private Boolean apply;
    public static final String SERIALIZED_NAME_DOCUMENT_DATE = "document_date";
    @SerializedName(value="document_date")
    private LocalDate documentDate;
    public static final String SERIALIZED_NAME_REASON_CODE = "reason_code";
    @SerializedName(value="reason_code")
    private String reasonCode;
    public static final String SERIALIZED_NAME_TRANSFER_TO_ACCOUNTING = "transfer_to_accounting";
    @SerializedName(value="transfer_to_accounting")
    private Boolean transferToAccounting;
    public static final String SERIALIZED_NAME_EXCLUDE_FROM_AUTO_APPLY_RULES = "exclude_from_auto_apply_rules";
    @SerializedName(value="exclude_from_auto_apply_rules")
    private Boolean excludeFromAutoApplyRules;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_CUSTOM_FIELDS = "custom_fields";
    @SerializedName(value="custom_fields")
    @JsonAdapter(value=JSON.CustomFieldAdapter.class)
    private Map<String, Object> customFields = null;

    public CreditMemoPatchRequest apply(Boolean apply) {
        this.apply = apply;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether to automatically apply the billing document upon posting.")
    public Boolean getApply() {
        return this.apply;
    }

    public void setApply(Boolean apply) {
        this.apply = apply;
    }

    public CreditMemoPatchRequest documentDate(LocalDate documentDate) {
        this.documentDate = documentDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Sun Jan 01 00:00:00 GMT 2023", value="The date when the credit memo is applied")
    public LocalDate getDocumentDate() {
        return this.documentDate;
    }

    public void setDocumentDate(LocalDate documentDate) {
        this.documentDate = documentDate;
    }

    public CreditMemoPatchRequest reasonCode(String reasonCode) {
        this.reasonCode = reasonCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Reason for issuing this credit memo")
    public String getReasonCode() {
        return this.reasonCode;
    }

    public void setReasonCode(String reasonCode) {
        this.reasonCode = reasonCode;
    }

    public CreditMemoPatchRequest transferToAccounting(Boolean transferToAccounting) {
        this.transferToAccounting = transferToAccounting;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether to transfer to an external accounting system.")
    public Boolean getTransferToAccounting() {
        return this.transferToAccounting;
    }

    public void setTransferToAccounting(Boolean transferToAccounting) {
        this.transferToAccounting = transferToAccounting;
    }

    public CreditMemoPatchRequest excludeFromAutoApplyRules(Boolean excludeFromAutoApplyRules) {
        this.excludeFromAutoApplyRules = excludeFromAutoApplyRules;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates whether to exclude this credit memo from the rule of automatically applying it to invoices.")
    public Boolean getExcludeFromAutoApplyRules() {
        return this.excludeFromAutoApplyRules;
    }

    public void setExcludeFromAutoApplyRules(Boolean excludeFromAutoApplyRules) {
        this.excludeFromAutoApplyRules = excludeFromAutoApplyRules;
    }

    public CreditMemoPatchRequest description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An arbitrary string associated with the object. Often useful for displaying to users.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public CreditMemoPatchRequest customFields(Map<String, Object> customFields) {
        this.customFields = customFields;
        return this;
    }

    public CreditMemoPatchRequest putCustomFieldsItem(String key, Object customFieldsItem) {
        if (this.customFields == null) {
            this.customFields = new HashMap<String, Object>();
        }
        this.customFields.put(key, customFieldsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Set of user-defined fields associated with this object. Useful for storing additional information about the object in a structured format.")
    public Map<String, Object> getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(Map<String, Object> customFields) {
        this.customFields = customFields;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreditMemoPatchRequest creditMemoPatchRequest = (CreditMemoPatchRequest)o;
        return Objects.equals(this.apply, creditMemoPatchRequest.apply) && Objects.equals(this.documentDate, creditMemoPatchRequest.documentDate) && Objects.equals(this.reasonCode, creditMemoPatchRequest.reasonCode) && Objects.equals(this.transferToAccounting, creditMemoPatchRequest.transferToAccounting) && Objects.equals(this.excludeFromAutoApplyRules, creditMemoPatchRequest.excludeFromAutoApplyRules) && Objects.equals(this.description, creditMemoPatchRequest.description) && Objects.equals(this.customFields, creditMemoPatchRequest.customFields);
    }

    public int hashCode() {
        return Objects.hash(this.apply, this.documentDate, this.reasonCode, this.transferToAccounting, this.excludeFromAutoApplyRules, this.description, this.customFields);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreditMemoPatchRequest {\n");
        sb.append("    apply: ").append(this.toIndentedString(this.apply)).append("\n");
        sb.append("    documentDate: ").append(this.toIndentedString(this.documentDate)).append("\n");
        sb.append("    reasonCode: ").append(this.toIndentedString(this.reasonCode)).append("\n");
        sb.append("    transferToAccounting: ").append(this.toIndentedString(this.transferToAccounting)).append("\n");
        sb.append("    excludeFromAutoApplyRules: ").append(this.toIndentedString(this.excludeFromAutoApplyRules)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    customFields: ").append(this.toIndentedString(this.customFields)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

