/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.client.JSON;
import org.openapitools.client.model.Account;
import org.openapitools.client.model.Contact;
import org.openapitools.client.model.CreditMemoAppliedToResponse;
import org.openapitools.client.model.CreditMemoItemListResponse;
import org.openapitools.client.model.FlexibleBillingDocumentSettings;
import org.openapitools.jackson.nullable.JsonNullable;
import org.threeten.bp.LocalDate;
import org.threeten.bp.OffsetDateTime;

public class CreditMemo {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_UPDATED_BY_ID = "updated_by_id";
    @SerializedName(value="updated_by_id")
    private String updatedById;
    public static final String SERIALIZED_NAME_UPDATED_TIME = "updated_time";
    @SerializedName(value="updated_time")
    private OffsetDateTime updatedTime;
    public static final String SERIALIZED_NAME_CREATED_BY_ID = "created_by_id";
    @SerializedName(value="created_by_id")
    private String createdById;
    public static final String SERIALIZED_NAME_CREATED_TIME = "created_time";
    @SerializedName(value="created_time")
    private OffsetDateTime createdTime;
    public static final String SERIALIZED_NAME_CUSTOM_FIELDS = "custom_fields";
    @SerializedName(value="custom_fields")
    @JsonAdapter(value=JSON.CustomFieldAdapter.class)
    private Map<String, Object> customFields = null;
    public static final String SERIALIZED_NAME_CUSTOM_OBJECTS = "custom_objects";
    @SerializedName(value="custom_objects")
    private Map<String, Object> customObjects = null;
    public static final String SERIALIZED_NAME_ACCOUNT_ID = "account_id";
    @SerializedName(value="account_id")
    private String accountId;
    public static final String SERIALIZED_NAME_ACCOUNT_NUMBER = "account_number";
    @SerializedName(value="account_number")
    private String accountNumber;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_DOCUMENT_DATE = "document_date";
    @SerializedName(value="document_date")
    private LocalDate documentDate;
    public static final String SERIALIZED_NAME_REASON_CODE = "reason_code";
    @SerializedName(value="reason_code")
    private String reasonCode;
    public static final String SERIALIZED_NAME_INVOICE_ID = "invoice_id";
    @SerializedName(value="invoice_id")
    private String invoiceId;
    public static final String SERIALIZED_NAME_TRANSFER_TO_ACCOUNTING = "transfer_to_accounting";
    @SerializedName(value="transfer_to_accounting")
    private Boolean transferToAccounting;
    public static final String SERIALIZED_NAME_EXCLUDE_FROM_AUTO_APPLY_RULES = "exclude_from_auto_apply_rules";
    @SerializedName(value="exclude_from_auto_apply_rules")
    private Boolean excludeFromAutoApplyRules;
    public static final String SERIALIZED_NAME_CURRENCY = "currency";
    @SerializedName(value="currency")
    private String currency;
    public static final String SERIALIZED_NAME_CREDIT_MEMO_NUMBER = "credit_memo_number";
    @SerializedName(value="credit_memo_number")
    private String creditMemoNumber;
    public static final String SERIALIZED_NAME_AMOUNT_REFUNDED = "amount_refunded";
    @SerializedName(value="amount_refunded")
    private BigDecimal amountRefunded;
    public static final String SERIALIZED_NAME_STATE_TRANSITIONS = "state_transitions";
    @SerializedName(value="state_transitions")
    private Object stateTransitions;
    public static final String SERIALIZED_NAME_POSTED_BY_ID = "posted_by_id";
    @SerializedName(value="posted_by_id")
    private String postedById;
    public static final String SERIALIZED_NAME_STATE = "state";
    @SerializedName(value="state")
    private StateEnum state;
    public static final String SERIALIZED_NAME_ACCOUNT = "account";
    @SerializedName(value="account")
    private Account account;
    public static final String SERIALIZED_NAME_ITEMS = "items";
    @SerializedName(value="items")
    private CreditMemoItemListResponse items;
    public static final String SERIALIZED_NAME_TOTAL = "total";
    @SerializedName(value="total")
    private BigDecimal total;
    public static final String SERIALIZED_NAME_SUBTOTAL = "subtotal";
    @SerializedName(value="subtotal")
    private BigDecimal subtotal;
    public static final String SERIALIZED_NAME_TAX = "tax";
    @SerializedName(value="tax")
    private BigDecimal tax;
    public static final String SERIALIZED_NAME_BALANCE = "balance";
    @SerializedName(value="balance")
    private BigDecimal balance;
    public static final String SERIALIZED_NAME_REMAINING_BALANCE = "remaining_balance";
    @SerializedName(value="remaining_balance")
    private BigDecimal remainingBalance;
    public static final String SERIALIZED_NAME_APPLIED_TO = "applied_to";
    @SerializedName(value="applied_to")
    private List<CreditMemoAppliedToResponse> appliedTo = null;
    public static final String SERIALIZED_NAME_BILL_TO_ID = "bill_to_id";
    @SerializedName(value="bill_to_id")
    @JsonAdapter(value=JSON.NullableFieldAdapter.class)
    private String billToId;
    public static final String SERIALIZED_NAME_BILL_TO = "bill_to";
    @SerializedName(value="bill_to")
    private Contact billTo;
    public static final String SERIALIZED_NAME_BILLING_DOCUMENT_SETTINGS = "billing_document_settings";
    @SerializedName(value="billing_document_settings")
    private FlexibleBillingDocumentSettings billingDocumentSettings;

    public CreditMemo() {
    }

    public CreditMemo(String id, String updatedById, OffsetDateTime updatedTime, String createdById, OffsetDateTime createdTime, Map<String, Object> customObjects, String creditMemoNumber, String postedById, CreditMemoItemListResponse items, BigDecimal total, BigDecimal subtotal, BigDecimal tax, BigDecimal balance, BigDecimal remainingBalance, List<CreditMemoAppliedToResponse> appliedTo, Contact billTo) {
        this();
        this.id = id;
        this.updatedById = updatedById;
        this.updatedTime = updatedTime;
        this.createdById = createdById;
        this.createdTime = createdTime;
        this.customObjects = customObjects;
        this.creditMemoNumber = creditMemoNumber;
        this.postedById = postedById;
        this.items = items;
        this.total = total;
        this.subtotal = subtotal;
        this.tax = tax;
        this.balance = balance;
        this.remainingBalance = remainingBalance;
        this.appliedTo = appliedTo;
        this.billTo = billTo;
    }

    @Nullable
    @ApiModelProperty(value="Unique identifier for the object.")
    public String getId() {
        return this.id;
    }

    @Nullable
    @ApiModelProperty(value="Unique identifier of the Zuora user who last updated the object")
    public String getUpdatedById() {
        return this.updatedById;
    }

    @Nullable
    @ApiModelProperty(value="The date and time when the object was last updated in ISO 8601 UTC format.")
    public OffsetDateTime getUpdatedTime() {
        return this.updatedTime;
    }

    @Nullable
    @ApiModelProperty(value="Unique identifier of the Zuora user who created the object")
    public String getCreatedById() {
        return this.createdById;
    }

    @Nullable
    @ApiModelProperty(value="The date and time when the object was created in ISO 8601 UTC format.")
    public OffsetDateTime getCreatedTime() {
        return this.createdTime;
    }

    public CreditMemo customFields(Map<String, Object> customFields) {
        this.customFields = customFields;
        return this;
    }

    public CreditMemo putCustomFieldsItem(String key, Object customFieldsItem) {
        if (this.customFields == null) {
            this.customFields = new HashMap<String, Object>();
        }
        this.customFields.put(key, customFieldsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Set of user-defined fields associated with this object. Useful for storing additional information about the object in a structured format.")
    public Map<String, Object> getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(Map<String, Object> customFields) {
        this.customFields = customFields;
    }

    @Nullable
    @ApiModelProperty(value="The custom objects associated with a Zuora standard object.")
    public Map<String, Object> getCustomObjects() {
        return this.customObjects;
    }

    public CreditMemo accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Identifier of the account that owns the credit memo.     **Either this field or `account_number` is required when creating credit memos from a price(charge in the v1 API).**")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public CreditMemo accountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="RC-00020831", value="Human-readable identifier of the account that owns the credit memo.    **Either this field or `account_id` is required when creating credit memos from a price(charge in the v1 API).**")
    public String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public CreditMemo description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An arbitrary string associated with the object. Often useful for displaying to users.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public CreditMemo documentDate(LocalDate documentDate) {
        this.documentDate = documentDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Sun Jan 01 00:00:00 GMT 2023", value="The date when the credit memo takes effect.")
    public LocalDate getDocumentDate() {
        return this.documentDate;
    }

    public void setDocumentDate(LocalDate documentDate) {
        this.documentDate = documentDate;
    }

    public CreditMemo reasonCode(String reasonCode) {
        this.reasonCode = reasonCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Reason for issuing this credit memo")
    public String getReasonCode() {
        return this.reasonCode;
    }

    public void setReasonCode(String reasonCode) {
        this.reasonCode = reasonCode;
    }

    public CreditMemo invoiceId(String invoiceId) {
        this.invoiceId = invoiceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The identifier of the invoice billing document from which this credit memo is created.      **Required when creating credit memos from an invoice.**")
    public String getInvoiceId() {
        return this.invoiceId;
    }

    public void setInvoiceId(String invoiceId) {
        this.invoiceId = invoiceId;
    }

    public CreditMemo transferToAccounting(Boolean transferToAccounting) {
        this.transferToAccounting = transferToAccounting;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether to transfer to an external accounting system.")
    public Boolean getTransferToAccounting() {
        return this.transferToAccounting;
    }

    public void setTransferToAccounting(Boolean transferToAccounting) {
        this.transferToAccounting = transferToAccounting;
    }

    public CreditMemo excludeFromAutoApplyRules(Boolean excludeFromAutoApplyRules) {
        this.excludeFromAutoApplyRules = excludeFromAutoApplyRules;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates whether to exclude this credit memo from the rule of automatically applying it to invoices.")
    public Boolean getExcludeFromAutoApplyRules() {
        return this.excludeFromAutoApplyRules;
    }

    public void setExcludeFromAutoApplyRules(Boolean excludeFromAutoApplyRules) {
        this.excludeFromAutoApplyRules = excludeFromAutoApplyRules;
    }

    public CreditMemo currency(String currency) {
        this.currency = currency;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="3-letter ISO 4217 currency code. This field is available only if you have the [Multiple Currencies](https://knowledgecenter.zuora.com/Zuora_Billing/Bill_your_customers/Flexible_Billing/Multiple_Currencies) feature enabled and are creating a credit memo from a charge.")
    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @Nullable
    @ApiModelProperty(value="A human-readable identifier for the billing document; may be user-supplied.")
    public String getCreditMemoNumber() {
        return this.creditMemoNumber;
    }

    public CreditMemo amountRefunded(BigDecimal amountRefunded) {
        this.amountRefunded = amountRefunded;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The amount this billing document refunded.")
    public BigDecimal getAmountRefunded() {
        return this.amountRefunded;
    }

    public void setAmountRefunded(BigDecimal amountRefunded) {
        this.amountRefunded = amountRefunded;
    }

    public CreditMemo stateTransitions(Object stateTransitions) {
        this.stateTransitions = stateTransitions;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Object getStateTransitions() {
        return this.stateTransitions;
    }

    public void setStateTransitions(Object stateTransitions) {
        this.stateTransitions = stateTransitions;
    }

    @Nullable
    @ApiModelProperty(value="Identifier of the Zuora user who posted the billing document.")
    public String getPostedById() {
        return this.postedById;
    }

    public CreditMemo state(StateEnum state) {
        this.state = state;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The status of the billing document.")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public CreditMemo account(Account account) {
        this.account = account;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The account that owns the billing document. EXPANDABLE")
    public Account getAccount() {
        return this.account;
    }

    public void setAccount(Account account) {
        this.account = account;
    }

    @Nullable
    @ApiModelProperty(value="List of billing document items. EXPANDABLE")
    public CreditMemoItemListResponse getItems() {
        return this.items;
    }

    @Nullable
    @ApiModelProperty(value="The total amount.")
    public BigDecimal getTotal() {
        return this.total;
    }

    @Nullable
    @ApiModelProperty(value="The total amount exclusive of tax.")
    public BigDecimal getSubtotal() {
        return this.subtotal;
    }

    @Nullable
    @ApiModelProperty(value="The total tax amount.")
    public BigDecimal getTax() {
        return this.tax;
    }

    @Deprecated
    @Nullable
    @ApiModelProperty(value="The total balance remaining.  This field is deprecated. Use `remaining_balance` field.")
    public BigDecimal getBalance() {
        return this.balance;
    }

    @Nullable
    @ApiModelProperty(value="The total balance remaining.")
    public BigDecimal getRemainingBalance() {
        return this.remainingBalance;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<CreditMemoAppliedToResponse> getAppliedTo() {
        return this.appliedTo;
    }

    public CreditMemo billToId(String billToId) {
        this.billToId = billToId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2c92c0f86a8dd422016a9e7a70116b0d", value="ID of the bill-to contact.")
    public String getBillToId() {
        return this.billToId;
    }

    public void setBillToId(String billToId) {
        this.billToId = billToId;
    }

    @Nullable
    @ApiModelProperty(value="The billing address for the customer.")
    public Contact getBillTo() {
        return this.billTo;
    }

    public CreditMemo billingDocumentSettings(FlexibleBillingDocumentSettings billingDocumentSettings) {
        this.billingDocumentSettings = billingDocumentSettings;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The billing document settings for the customer.")
    public FlexibleBillingDocumentSettings getBillingDocumentSettings() {
        return this.billingDocumentSettings;
    }

    public void setBillingDocumentSettings(FlexibleBillingDocumentSettings billingDocumentSettings) {
        this.billingDocumentSettings = billingDocumentSettings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreditMemo creditMemo = (CreditMemo)o;
        return Objects.equals(this.id, creditMemo.id) && Objects.equals(this.updatedById, creditMemo.updatedById) && Objects.equals(this.updatedTime, creditMemo.updatedTime) && Objects.equals(this.createdById, creditMemo.createdById) && Objects.equals(this.createdTime, creditMemo.createdTime) && Objects.equals(this.customFields, creditMemo.customFields) && Objects.equals(this.customObjects, creditMemo.customObjects) && Objects.equals(this.accountId, creditMemo.accountId) && Objects.equals(this.accountNumber, creditMemo.accountNumber) && Objects.equals(this.description, creditMemo.description) && Objects.equals(this.documentDate, creditMemo.documentDate) && Objects.equals(this.reasonCode, creditMemo.reasonCode) && Objects.equals(this.invoiceId, creditMemo.invoiceId) && Objects.equals(this.transferToAccounting, creditMemo.transferToAccounting) && Objects.equals(this.excludeFromAutoApplyRules, creditMemo.excludeFromAutoApplyRules) && Objects.equals(this.currency, creditMemo.currency) && Objects.equals(this.creditMemoNumber, creditMemo.creditMemoNumber) && Objects.equals(this.amountRefunded, creditMemo.amountRefunded) && Objects.equals(this.stateTransitions, creditMemo.stateTransitions) && Objects.equals(this.postedById, creditMemo.postedById) && Objects.equals((Object)this.state, (Object)creditMemo.state) && Objects.equals(this.account, creditMemo.account) && Objects.equals(this.items, creditMemo.items) && Objects.equals(this.total, creditMemo.total) && Objects.equals(this.subtotal, creditMemo.subtotal) && Objects.equals(this.tax, creditMemo.tax) && Objects.equals(this.balance, creditMemo.balance) && Objects.equals(this.remainingBalance, creditMemo.remainingBalance) && Objects.equals(this.appliedTo, creditMemo.appliedTo) && Objects.equals(this.billToId, creditMemo.billToId) && Objects.equals(this.billTo, creditMemo.billTo) && Objects.equals(this.billingDocumentSettings, creditMemo.billingDocumentSettings);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.updatedById, this.updatedTime, this.createdById, this.createdTime, this.customFields, this.customObjects, this.accountId, this.accountNumber, this.description, this.documentDate, this.reasonCode, this.invoiceId, this.transferToAccounting, this.excludeFromAutoApplyRules, this.currency, this.creditMemoNumber, this.amountRefunded, this.stateTransitions, this.postedById, this.state, this.account, this.items, this.total, this.subtotal, this.tax, this.balance, this.remainingBalance, this.appliedTo, this.billToId, this.billTo, this.billingDocumentSettings});
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreditMemo {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    updatedById: ").append(this.toIndentedString(this.updatedById)).append("\n");
        sb.append("    updatedTime: ").append(this.toIndentedString(this.updatedTime)).append("\n");
        sb.append("    createdById: ").append(this.toIndentedString(this.createdById)).append("\n");
        sb.append("    createdTime: ").append(this.toIndentedString(this.createdTime)).append("\n");
        sb.append("    customFields: ").append(this.toIndentedString(this.customFields)).append("\n");
        sb.append("    customObjects: ").append(this.toIndentedString(this.customObjects)).append("\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    accountNumber: ").append(this.toIndentedString(this.accountNumber)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    documentDate: ").append(this.toIndentedString(this.documentDate)).append("\n");
        sb.append("    reasonCode: ").append(this.toIndentedString(this.reasonCode)).append("\n");
        sb.append("    invoiceId: ").append(this.toIndentedString(this.invoiceId)).append("\n");
        sb.append("    transferToAccounting: ").append(this.toIndentedString(this.transferToAccounting)).append("\n");
        sb.append("    excludeFromAutoApplyRules: ").append(this.toIndentedString(this.excludeFromAutoApplyRules)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    creditMemoNumber: ").append(this.toIndentedString(this.creditMemoNumber)).append("\n");
        sb.append("    amountRefunded: ").append(this.toIndentedString(this.amountRefunded)).append("\n");
        sb.append("    stateTransitions: ").append(this.toIndentedString(this.stateTransitions)).append("\n");
        sb.append("    postedById: ").append(this.toIndentedString(this.postedById)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    account: ").append(this.toIndentedString(this.account)).append("\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("    total: ").append(this.toIndentedString(this.total)).append("\n");
        sb.append("    subtotal: ").append(this.toIndentedString(this.subtotal)).append("\n");
        sb.append("    tax: ").append(this.toIndentedString(this.tax)).append("\n");
        sb.append("    balance: ").append(this.toIndentedString(this.balance)).append("\n");
        sb.append("    remainingBalance: ").append(this.toIndentedString(this.remainingBalance)).append("\n");
        sb.append("    appliedTo: ").append(this.toIndentedString(this.appliedTo)).append("\n");
        sb.append("    billToId: ").append(this.toIndentedString(this.billToId)).append("\n");
        sb.append("    billTo: ").append(this.toIndentedString(this.billTo)).append("\n");
        sb.append("    billingDocumentSettings: ").append(this.toIndentedString(this.billingDocumentSettings)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StateEnum {
        DRAFT("draft"),
        POSTED("posted"),
        CANCELED("canceled"),
        FAILED("failed"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StateEnum fromValue(String value) {
            for (StateEnum b : StateEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<StateEnum> {
            public void write(JsonWriter jsonWriter, StateEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StateEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StateEnum.fromValue(value);
            }
        }
    }
}

