/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.client.JSON;
import org.threeten.bp.LocalDate;
import org.threeten.bp.OffsetDateTime;

public class TaxationItemPatchRequest {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_UPDATED_BY_ID = "updated_by_id";
    @SerializedName(value="updated_by_id")
    private String updatedById;
    public static final String SERIALIZED_NAME_UPDATED_TIME = "updated_time";
    @SerializedName(value="updated_time")
    private OffsetDateTime updatedTime;
    public static final String SERIALIZED_NAME_CREATED_BY_ID = "created_by_id";
    @SerializedName(value="created_by_id")
    private String createdById;
    public static final String SERIALIZED_NAME_CREATED_TIME = "created_time";
    @SerializedName(value="created_time")
    private OffsetDateTime createdTime;
    public static final String SERIALIZED_NAME_CUSTOM_FIELDS = "custom_fields";
    @SerializedName(value="custom_fields")
    @JsonAdapter(value=JSON.CustomFieldAdapter.class)
    private Map<String, Object> customFields = null;
    public static final String SERIALIZED_NAME_CUSTOM_OBJECTS = "custom_objects";
    @SerializedName(value="custom_objects")
    private Map<String, Object> customObjects = null;
    public static final String SERIALIZED_NAME_ON_ACCOUNT_ACCOUNT = "on_account_account";
    @SerializedName(value="on_account_account")
    private String onAccountAccount;
    public static final String SERIALIZED_NAME_AMOUNT_EXEMPT = "amount_exempt";
    @SerializedName(value="amount_exempt")
    private BigDecimal amountExempt;
    public static final String SERIALIZED_NAME_INVOICE_ITEM_ID = "invoice_item_id";
    @SerializedName(value="invoice_item_id")
    private String invoiceItemId;
    public static final String SERIALIZED_NAME_JURISDICTION = "jurisdiction";
    @SerializedName(value="jurisdiction")
    private String jurisdiction;
    public static final String SERIALIZED_NAME_LOCATION_CODE = "location_code";
    @SerializedName(value="location_code")
    private String locationCode;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private BigDecimal amount;
    public static final String SERIALIZED_NAME_TAX_CODE = "tax_code";
    @SerializedName(value="tax_code")
    private String taxCode;
    public static final String SERIALIZED_NAME_TAX_CODE_NAME = "tax_code_name";
    @SerializedName(value="tax_code_name")
    private String taxCodeName;
    public static final String SERIALIZED_NAME_TAX_DATE = "tax_date";
    @SerializedName(value="tax_date")
    private LocalDate taxDate;
    public static final String SERIALIZED_NAME_TAX_RATE = "tax_rate";
    @SerializedName(value="tax_rate")
    private BigDecimal taxRate;
    public static final String SERIALIZED_NAME_TAX_RATE_NAME = "tax_rate_name";
    @SerializedName(value="tax_rate_name")
    private String taxRateName;
    public static final String SERIALIZED_NAME_TAX_RATE_TYPE = "tax_rate_type";
    @SerializedName(value="tax_rate_type")
    private TaxRateTypeEnum taxRateType;
    public static final String SERIALIZED_NAME_SOURCE_TAX_ITEM_ID = "source_tax_item_id";
    @SerializedName(value="source_tax_item_id")
    private String sourceTaxItemId;
    public static final String SERIALIZED_NAME_TAX_INCLUSIVE = "tax_inclusive";
    @SerializedName(value="tax_inclusive")
    private Boolean taxInclusive;
    public static final String SERIALIZED_NAME_SALES_TAX_PAYABLE_ACCOUNT = "sales_tax_payable_account";
    @SerializedName(value="sales_tax_payable_account")
    private String salesTaxPayableAccount;

    public TaxationItemPatchRequest() {
    }

    public TaxationItemPatchRequest(String id, String updatedById, OffsetDateTime updatedTime, String createdById, OffsetDateTime createdTime, Map<String, Object> customObjects) {
        this();
        this.id = id;
        this.updatedById = updatedById;
        this.updatedTime = updatedTime;
        this.createdById = createdById;
        this.createdTime = createdTime;
        this.customObjects = customObjects;
    }

    @Nullable
    @ApiModelProperty(value="Unique identifier for the object.")
    public String getId() {
        return this.id;
    }

    @Nullable
    @ApiModelProperty(value="Unique identifier of the Zuora user who last updated the object")
    public String getUpdatedById() {
        return this.updatedById;
    }

    @Nullable
    @ApiModelProperty(value="The date and time when the object was last updated in ISO 8601 UTC format.")
    public OffsetDateTime getUpdatedTime() {
        return this.updatedTime;
    }

    @Nullable
    @ApiModelProperty(value="Unique identifier of the Zuora user who created the object")
    public String getCreatedById() {
        return this.createdById;
    }

    @Nullable
    @ApiModelProperty(value="The date and time when the object was created in ISO 8601 UTC format.")
    public OffsetDateTime getCreatedTime() {
        return this.createdTime;
    }

    public TaxationItemPatchRequest customFields(Map<String, Object> customFields) {
        this.customFields = customFields;
        return this;
    }

    public TaxationItemPatchRequest putCustomFieldsItem(String key, Object customFieldsItem) {
        if (this.customFields == null) {
            this.customFields = new HashMap<String, Object>();
        }
        this.customFields.put(key, customFieldsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Set of user-defined fields associated with this object. Useful for storing additional information about the object in a structured format.")
    public Map<String, Object> getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(Map<String, Object> customFields) {
        this.customFields = customFields;
    }

    @Nullable
    @ApiModelProperty(value="The custom objects associated with a Zuora standard object.")
    public Map<String, Object> getCustomObjects() {
        return this.customObjects;
    }

    public TaxationItemPatchRequest onAccountAccount(String onAccountAccount) {
        this.onAccountAccount = onAccountAccount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An active account in your Zuora Chart of Accounts.")
    public String getOnAccountAccount() {
        return this.onAccountAccount;
    }

    public void setOnAccountAccount(String onAccountAccount) {
        this.onAccountAccount = onAccountAccount;
    }

    public TaxationItemPatchRequest amountExempt(BigDecimal amountExempt) {
        this.amountExempt = amountExempt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The calculated tax amount excluded due to the exemption.")
    public BigDecimal getAmountExempt() {
        return this.amountExempt;
    }

    public void setAmountExempt(BigDecimal amountExempt) {
        this.amountExempt = amountExempt;
    }

    public TaxationItemPatchRequest invoiceItemId(String invoiceItemId) {
        this.invoiceItemId = invoiceItemId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Unique identifier of the invoice item to which the taxation item applies. **This field is required if you are creating a credit memo or debit memo from an invoice, and is not applicable if you are creating an invoice.**.     ")
    public String getInvoiceItemId() {
        return this.invoiceItemId;
    }

    public void setInvoiceItemId(String invoiceItemId) {
        this.invoiceItemId = invoiceItemId;
    }

    public TaxationItemPatchRequest jurisdiction(String jurisdiction) {
        this.jurisdiction = jurisdiction;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The jurisdiction that applies the tax or VAT. This value is typically a state, province, county, or city.")
    public String getJurisdiction() {
        return this.jurisdiction;
    }

    public void setJurisdiction(String jurisdiction) {
        this.jurisdiction = jurisdiction;
    }

    public TaxationItemPatchRequest locationCode(String locationCode) {
        this.locationCode = locationCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The identifier for the location based on the value of the `tax_code` field.")
    public String getLocationCode() {
        return this.locationCode;
    }

    public void setLocationCode(String locationCode) {
        this.locationCode = locationCode;
    }

    public TaxationItemPatchRequest name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of the taxation item.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public TaxationItemPatchRequest amount(BigDecimal amount) {
        this.amount = amount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The amount of the tax applied to the total price.")
    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public TaxationItemPatchRequest taxCode(String taxCode) {
        this.taxCode = taxCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A tax code identifier. If a `tax_code` of a price is not provided when you create or update a price, Zuora will treat the charged amount as non-taxable. If this code is provide, Zuora considers that this price is taxable and the charged amount will be handled accordingly.")
    public String getTaxCode() {
        return this.taxCode;
    }

    public void setTaxCode(String taxCode) {
        this.taxCode = taxCode;
    }

    public TaxationItemPatchRequest taxCodeName(String taxCodeName) {
        this.taxCodeName = taxCodeName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The amount of the tax applied to the total price.")
    public String getTaxCodeName() {
        return this.taxCodeName;
    }

    public void setTaxCodeName(String taxCodeName) {
        this.taxCodeName = taxCodeName;
    }

    public TaxationItemPatchRequest taxDate(LocalDate taxDate) {
        this.taxDate = taxDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Sat Jan 01 00:00:00 GMT 2022", value="The date on which the tax is applied.")
    public LocalDate getTaxDate() {
        return this.taxDate;
    }

    public void setTaxDate(LocalDate taxDate) {
        this.taxDate = taxDate;
    }

    public TaxationItemPatchRequest taxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The amount of the tax applied to the total price.")
    public BigDecimal getTaxRate() {
        return this.taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public TaxationItemPatchRequest taxRateName(String taxRateName) {
        this.taxRateName = taxRateName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of the tax rate, such as sales tax or GST. This name is displayed on billing documents.")
    public String getTaxRateName() {
        return this.taxRateName;
    }

    public void setTaxRateName(String taxRateName) {
        this.taxRateName = taxRateName;
    }

    public TaxationItemPatchRequest taxRateType(TaxRateTypeEnum taxRateType) {
        this.taxRateType = taxRateType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates whether the tax rate is an amount or a percentage.")
    public TaxRateTypeEnum getTaxRateType() {
        return this.taxRateType;
    }

    public void setTaxRateType(TaxRateTypeEnum taxRateType) {
        this.taxRateType = taxRateType;
    }

    public TaxationItemPatchRequest sourceTaxItemId(String sourceTaxItemId) {
        this.sourceTaxItemId = sourceTaxItemId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The ID of the taxation item of the invoice, from which the credit or debit memo is created. This field is only applicable when the `type` of the billing document is `credit_memo` and `debit_memo`.")
    public String getSourceTaxItemId() {
        return this.sourceTaxItemId;
    }

    public void setSourceTaxItemId(String sourceTaxItemId) {
        this.sourceTaxItemId = sourceTaxItemId;
    }

    public TaxationItemPatchRequest taxInclusive(Boolean taxInclusive) {
        this.taxInclusive = taxInclusive;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If set to `true`, it indicates that amounts are inclusive of tax.")
    public Boolean getTaxInclusive() {
        return this.taxInclusive;
    }

    public void setTaxInclusive(Boolean taxInclusive) {
        this.taxInclusive = taxInclusive;
    }

    public TaxationItemPatchRequest salesTaxPayableAccount(String salesTaxPayableAccount) {
        this.salesTaxPayableAccount = salesTaxPayableAccount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An active account in your Zuora Chart of Accounts.")
    public String getSalesTaxPayableAccount() {
        return this.salesTaxPayableAccount;
    }

    public void setSalesTaxPayableAccount(String salesTaxPayableAccount) {
        this.salesTaxPayableAccount = salesTaxPayableAccount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaxationItemPatchRequest taxationItemPatchRequest = (TaxationItemPatchRequest)o;
        return Objects.equals(this.id, taxationItemPatchRequest.id) && Objects.equals(this.updatedById, taxationItemPatchRequest.updatedById) && Objects.equals(this.updatedTime, taxationItemPatchRequest.updatedTime) && Objects.equals(this.createdById, taxationItemPatchRequest.createdById) && Objects.equals(this.createdTime, taxationItemPatchRequest.createdTime) && Objects.equals(this.customFields, taxationItemPatchRequest.customFields) && Objects.equals(this.customObjects, taxationItemPatchRequest.customObjects) && Objects.equals(this.onAccountAccount, taxationItemPatchRequest.onAccountAccount) && Objects.equals(this.amountExempt, taxationItemPatchRequest.amountExempt) && Objects.equals(this.invoiceItemId, taxationItemPatchRequest.invoiceItemId) && Objects.equals(this.jurisdiction, taxationItemPatchRequest.jurisdiction) && Objects.equals(this.locationCode, taxationItemPatchRequest.locationCode) && Objects.equals(this.name, taxationItemPatchRequest.name) && Objects.equals(this.amount, taxationItemPatchRequest.amount) && Objects.equals(this.taxCode, taxationItemPatchRequest.taxCode) && Objects.equals(this.taxCodeName, taxationItemPatchRequest.taxCodeName) && Objects.equals(this.taxDate, taxationItemPatchRequest.taxDate) && Objects.equals(this.taxRate, taxationItemPatchRequest.taxRate) && Objects.equals(this.taxRateName, taxationItemPatchRequest.taxRateName) && Objects.equals((Object)this.taxRateType, (Object)taxationItemPatchRequest.taxRateType) && Objects.equals(this.sourceTaxItemId, taxationItemPatchRequest.sourceTaxItemId) && Objects.equals(this.taxInclusive, taxationItemPatchRequest.taxInclusive) && Objects.equals(this.salesTaxPayableAccount, taxationItemPatchRequest.salesTaxPayableAccount);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.updatedById, this.updatedTime, this.createdById, this.createdTime, this.customFields, this.customObjects, this.onAccountAccount, this.amountExempt, this.invoiceItemId, this.jurisdiction, this.locationCode, this.name, this.amount, this.taxCode, this.taxCodeName, this.taxDate, this.taxRate, this.taxRateName, this.taxRateType, this.sourceTaxItemId, this.taxInclusive, this.salesTaxPayableAccount});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TaxationItemPatchRequest {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    updatedById: ").append(this.toIndentedString(this.updatedById)).append("\n");
        sb.append("    updatedTime: ").append(this.toIndentedString(this.updatedTime)).append("\n");
        sb.append("    createdById: ").append(this.toIndentedString(this.createdById)).append("\n");
        sb.append("    createdTime: ").append(this.toIndentedString(this.createdTime)).append("\n");
        sb.append("    customFields: ").append(this.toIndentedString(this.customFields)).append("\n");
        sb.append("    customObjects: ").append(this.toIndentedString(this.customObjects)).append("\n");
        sb.append("    onAccountAccount: ").append(this.toIndentedString(this.onAccountAccount)).append("\n");
        sb.append("    amountExempt: ").append(this.toIndentedString(this.amountExempt)).append("\n");
        sb.append("    invoiceItemId: ").append(this.toIndentedString(this.invoiceItemId)).append("\n");
        sb.append("    jurisdiction: ").append(this.toIndentedString(this.jurisdiction)).append("\n");
        sb.append("    locationCode: ").append(this.toIndentedString(this.locationCode)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    taxCode: ").append(this.toIndentedString(this.taxCode)).append("\n");
        sb.append("    taxCodeName: ").append(this.toIndentedString(this.taxCodeName)).append("\n");
        sb.append("    taxDate: ").append(this.toIndentedString(this.taxDate)).append("\n");
        sb.append("    taxRate: ").append(this.toIndentedString(this.taxRate)).append("\n");
        sb.append("    taxRateName: ").append(this.toIndentedString(this.taxRateName)).append("\n");
        sb.append("    taxRateType: ").append(this.toIndentedString((Object)this.taxRateType)).append("\n");
        sb.append("    sourceTaxItemId: ").append(this.toIndentedString(this.sourceTaxItemId)).append("\n");
        sb.append("    taxInclusive: ").append(this.toIndentedString(this.taxInclusive)).append("\n");
        sb.append("    salesTaxPayableAccount: ").append(this.toIndentedString(this.salesTaxPayableAccount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TaxRateTypeEnum {
        PERCENT("percent"),
        AMOUNT("amount"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private TaxRateTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TaxRateTypeEnum fromValue(String value) {
            for (TaxRateTypeEnum b : TaxRateTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<TaxRateTypeEnum> {
            public void write(JsonWriter jsonWriter, TaxRateTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TaxRateTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TaxRateTypeEnum.fromValue(value);
            }
        }
    }
}

