/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.client.JSON;
import org.openapitools.client.model.PaymentScheduleBillingDocumentResponse;
import org.openapitools.client.model.PaymentScheduleItem;
import org.openapitools.client.model.PaymentSchedulePaymentOptionRequest;
import org.openapitools.jackson.nullable.JsonNullable;
import org.threeten.bp.LocalDate;
import org.threeten.bp.OffsetDateTime;

public class PaymentSchedule {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_UPDATED_BY_ID = "updated_by_id";
    @SerializedName(value="updated_by_id")
    private String updatedById;
    public static final String SERIALIZED_NAME_UPDATED_TIME = "updated_time";
    @SerializedName(value="updated_time")
    private OffsetDateTime updatedTime;
    public static final String SERIALIZED_NAME_CREATED_BY_ID = "created_by_id";
    @SerializedName(value="created_by_id")
    private String createdById;
    public static final String SERIALIZED_NAME_CREATED_TIME = "created_time";
    @SerializedName(value="created_time")
    private OffsetDateTime createdTime;
    public static final String SERIALIZED_NAME_CUSTOM_FIELDS = "custom_fields";
    @SerializedName(value="custom_fields")
    @JsonAdapter(value=JSON.CustomFieldAdapter.class)
    private Map<String, Object> customFields = null;
    public static final String SERIALIZED_NAME_CUSTOM_OBJECTS = "custom_objects";
    @SerializedName(value="custom_objects")
    private Map<String, Object> customObjects = null;
    public static final String SERIALIZED_NAME_ACCOUNT_ID = "account_id";
    @SerializedName(value="account_id")
    private String accountId;
    public static final String SERIALIZED_NAME_ACCOUNT_NUMBER = "account_number";
    @SerializedName(value="account_number")
    private String accountNumber;
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private BigDecimal amount;
    public static final String SERIALIZED_NAME_PERIOD = "period";
    @SerializedName(value="period")
    private PeriodEnum period;
    public static final String SERIALIZED_NAME_BILLING_DOCUMENT = "billing_document";
    @SerializedName(value="billing_document")
    private PaymentScheduleBillingDocumentResponse billingDocument;
    public static final String SERIALIZED_NAME_CURRENCY = "currency";
    @SerializedName(value="currency")
    private String currency;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_ITEMS = "items";
    @SerializedName(value="items")
    private List<PaymentScheduleItem> items = null;
    public static final String SERIALIZED_NAME_NUMBER_OF_PAYMENTS = "number_of_payments";
    @SerializedName(value="number_of_payments")
    private Integer numberOfPayments;
    public static final String SERIALIZED_NAME_PAYMENT_GATEWAY_ID = "payment_gateway_id";
    @SerializedName(value="payment_gateway_id")
    private String paymentGatewayId;
    public static final String SERIALIZED_NAME_PAYMENT_METHOD_ID = "payment_method_id";
    @SerializedName(value="payment_method_id")
    private String paymentMethodId;
    public static final String SERIALIZED_NAME_PAYMENT_SCHEDULE_NUMBER = "payment_schedule_number";
    @SerializedName(value="payment_schedule_number")
    private String paymentScheduleNumber;
    public static final String SERIALIZED_NAME_RUN_HOUR = "run_hour";
    @SerializedName(value="run_hour")
    private Integer runHour;
    public static final String SERIALIZED_NAME_STANDALONE = "standalone";
    @SerializedName(value="standalone")
    private Boolean standalone;
    public static final String SERIALIZED_NAME_START_DATE = "start_date";
    @SerializedName(value="start_date")
    private LocalDate startDate;
    public static final String SERIALIZED_NAME_TOTAL_AMOUNT = "total_amount";
    @SerializedName(value="total_amount")
    private BigDecimal totalAmount;
    public static final String SERIALIZED_NAME_CUSTOM = "custom";
    @SerializedName(value="custom")
    private Boolean custom;
    public static final String SERIALIZED_NAME_NEXT_PAYMENT_DATE = "next_payment_date";
    @SerializedName(value="next_payment_date")
    private LocalDate nextPaymentDate;
    public static final String SERIALIZED_NAME_RECENT_PAYMENT_DATE = "recent_payment_date";
    @SerializedName(value="recent_payment_date")
    private LocalDate recentPaymentDate;
    public static final String SERIALIZED_NAME_STATE = "state";
    @SerializedName(value="state")
    private StateEnum state;
    public static final String SERIALIZED_NAME_TOTAL_PAYMENTS_ERRORED = "total_payments_errored";
    @SerializedName(value="total_payments_errored")
    private Integer totalPaymentsErrored;
    public static final String SERIALIZED_NAME_TOTAL_PAYMENTS_PROCESSED = "total_payments_processed";
    @SerializedName(value="total_payments_processed")
    private Integer totalPaymentsProcessed;
    public static final String SERIALIZED_NAME_PAYMENT_OPTIONS = "payment_options";
    @SerializedName(value="payment_options")
    private List<PaymentSchedulePaymentOptionRequest> paymentOptions = null;
    public static final String SERIALIZED_NAME_PREPAYMENT = "prepayment";
    @SerializedName(value="prepayment")
    private Boolean prepayment;

    public PaymentSchedule() {
    }

    public PaymentSchedule(String id, String updatedById, OffsetDateTime updatedTime, String createdById, OffsetDateTime createdTime, Map<String, Object> customObjects) {
        this();
        this.id = id;
        this.updatedById = updatedById;
        this.updatedTime = updatedTime;
        this.createdById = createdById;
        this.createdTime = createdTime;
        this.customObjects = customObjects;
    }

    @Nullable
    @ApiModelProperty(value="Unique identifier for the object.")
    public String getId() {
        return this.id;
    }

    @Nullable
    @ApiModelProperty(value="Unique identifier of the Zuora user who last updated the object")
    public String getUpdatedById() {
        return this.updatedById;
    }

    @Nullable
    @ApiModelProperty(value="The date and time when the object was last updated in ISO 8601 UTC format.")
    public OffsetDateTime getUpdatedTime() {
        return this.updatedTime;
    }

    @Nullable
    @ApiModelProperty(value="Unique identifier of the Zuora user who created the object")
    public String getCreatedById() {
        return this.createdById;
    }

    @Nullable
    @ApiModelProperty(value="The date and time when the object was created in ISO 8601 UTC format.")
    public OffsetDateTime getCreatedTime() {
        return this.createdTime;
    }

    public PaymentSchedule customFields(Map<String, Object> customFields) {
        this.customFields = customFields;
        return this;
    }

    public PaymentSchedule putCustomFieldsItem(String key, Object customFieldsItem) {
        if (this.customFields == null) {
            this.customFields = new HashMap<String, Object>();
        }
        this.customFields.put(key, customFieldsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Set of user-defined fields associated with this object. Useful for storing additional information about the object in a structured format.")
    public Map<String, Object> getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(Map<String, Object> customFields) {
        this.customFields = customFields;
    }

    @Nullable
    @ApiModelProperty(value="The custom objects associated with a Zuora standard object.")
    public Map<String, Object> getCustomObjects() {
        return this.customObjects;
    }

    public PaymentSchedule accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Unique identifier of the customer account the payment schedule belongs to.")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public PaymentSchedule accountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Account number of the customer account the payment schedule belongs to.")
    public String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public PaymentSchedule amount(BigDecimal amount) {
        this.amount = amount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The amount of each payment schedule item in the payment schedule.")
    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public PaymentSchedule period(PeriodEnum period) {
        this.period = period;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Unit in which term duration is defined. One of week or month.")
    public PeriodEnum getPeriod() {
        return this.period;
    }

    public void setPeriod(PeriodEnum period) {
        this.period = period;
    }

    public PaymentSchedule billingDocument(PaymentScheduleBillingDocumentResponse billingDocument) {
        this.billingDocument = billingDocument;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The billing document with which the payment schedule is associated. Note: This field is optional. If you have the Standalone Payment feature enabled, you can leave this field blank and set standalone to true to create standalone payments. You can also choose to create unapplied payments by leaving this object blank and setting standalone to false. If Standalone Payment is not enabled, leaving this object unspecified will create unapplied payments.")
    public PaymentScheduleBillingDocumentResponse getBillingDocument() {
        return this.billingDocument;
    }

    public void setBillingDocument(PaymentScheduleBillingDocumentResponse billingDocument) {
        this.billingDocument = billingDocument;
    }

    public PaymentSchedule currency(String currency) {
        this.currency = currency;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="USD", value="Currency of the payment schedule. Note: This field is optional. The default value is the account's default currency. This field will be ignored when items is specified.")
    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public PaymentSchedule description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="description of test account", value="An arbitrary string attached to the object. Often useful for displaying to users.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public PaymentSchedule items(List<PaymentScheduleItem> items) {
        this.items = items;
        return this;
    }

    public PaymentSchedule addItemsItem(PaymentScheduleItem itemsItem) {
        if (this.items == null) {
            this.items = new ArrayList<PaymentScheduleItem>();
        }
        this.items.add(itemsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<PaymentScheduleItem> getItems() {
        return this.items;
    }

    public void setItems(List<PaymentScheduleItem> items) {
        this.items = items;
    }

    public PaymentSchedule numberOfPayments(Integer numberOfPayments) {
        this.numberOfPayments = numberOfPayments;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of payment schedule items to be created for this payment schedule.")
    public Integer getNumberOfPayments() {
        return this.numberOfPayments;
    }

    public void setNumberOfPayments(Integer numberOfPayments) {
        this.numberOfPayments = numberOfPayments;
    }

    public PaymentSchedule paymentGatewayId(String paymentGatewayId) {
        this.paymentGatewayId = paymentGatewayId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="8ad093f27d6eee80017d6effd7a66759", value="ID of the payment gateway used to collect payments. Note: This field is optional. The default value is the account's default payment gateway ID. If no payment gateway ID is found on the customer account level, the default value will be the tenant's default payment gateway ID. This field will be ignored when items is specified.")
    public String getPaymentGatewayId() {
        return this.paymentGatewayId;
    }

    public void setPaymentGatewayId(String paymentGatewayId) {
        this.paymentGatewayId = paymentGatewayId;
    }

    public PaymentSchedule paymentMethodId(String paymentMethodId) {
        this.paymentMethodId = paymentMethodId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="8a95b1946b6aeac8718c32aab8c395f", value="ID of the payment method. Note: This field is optional. The default value is the account's default payment method ID. This field will be ignored when items is specified.")
    public String getPaymentMethodId() {
        return this.paymentMethodId;
    }

    public void setPaymentMethodId(String paymentMethodId) {
        this.paymentMethodId = paymentMethodId;
    }

    public PaymentSchedule paymentScheduleNumber(String paymentScheduleNumber) {
        this.paymentScheduleNumber = paymentScheduleNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Number of the payment schedule.")
    public String getPaymentScheduleNumber() {
        return this.paymentScheduleNumber;
    }

    public void setPaymentScheduleNumber(String paymentScheduleNumber) {
        this.paymentScheduleNumber = paymentScheduleNumber;
    }

    public PaymentSchedule runHour(Integer runHour) {
        this.runHour = runHour;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="At which hour in the day in the tenant's timezone this payment will be collected. Available values:[0,1,2,~,22,23]. If the time difference between your tenant\u2019s timezone and the timezone where Zuora servers are located is not in full hours, for example, 2.5 hours, the payment schedule items will be triggered half an hour later than your scheduled time. The default value is 0. If the payment run_hour and scheduled_date are backdated, the system will collect the payment when the next run_hour occurs.")
    public Integer getRunHour() {
        return this.runHour;
    }

    public void setRunHour(Integer runHour) {
        this.runHour = runHour;
    }

    public PaymentSchedule standalone(Boolean standalone) {
        this.standalone = standalone;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates whether the payments created by the payment schedule are standalone payments or not.              When setting to `true`, standalone payments will be created.       When setting to `false`, you can either specify a billing document, or not specifying any billing documents.       In the latter case, unapplied payments will be created.       If set to `null`, standalone payments will be created.              **Note**: This parameter is only available if standalone payments are enabled in your tenant. The default value is `true` if standalone payments are enabled in your tenant.")
    public Boolean getStandalone() {
        return this.standalone;
    }

    public void setStandalone(Boolean standalone) {
        this.standalone = standalone;
    }

    public PaymentSchedule startDate(LocalDate startDate) {
        this.startDate = startDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Sun Jan 01 00:00:00 GMT 2023", value="The date of the first scheduled payment collection. Note: This parameter is required when `items` is not specified. This parameter will be ignored when `items` is specified.")
    public LocalDate getStartDate() {
        return this.startDate;
    }

    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public PaymentSchedule totalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The total amount to be collected by the payment schedule.")
    public BigDecimal getTotalAmount() {
        return this.totalAmount;
    }

    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    public PaymentSchedule custom(Boolean custom) {
        this.custom = custom;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If it is set to `true`, the payment schedule is a custom payment schedule.")
    public Boolean getCustom() {
        return this.custom;
    }

    public void setCustom(Boolean custom) {
        this.custom = custom;
    }

    public PaymentSchedule nextPaymentDate(LocalDate nextPaymentDate) {
        this.nextPaymentDate = nextPaymentDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Sat Jan 01 00:00:00 GMT 2022", value="The date of the next scheduled payment.")
    public LocalDate getNextPaymentDate() {
        return this.nextPaymentDate;
    }

    public void setNextPaymentDate(LocalDate nextPaymentDate) {
        this.nextPaymentDate = nextPaymentDate;
    }

    public PaymentSchedule recentPaymentDate(LocalDate recentPaymentDate) {
        this.recentPaymentDate = recentPaymentDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Sat Jan 01 00:00:00 GMT 2022", value="The date of the most recent scheduled payment.")
    public LocalDate getRecentPaymentDate() {
        return this.recentPaymentDate;
    }

    public void setRecentPaymentDate(LocalDate recentPaymentDate) {
        this.recentPaymentDate = recentPaymentDate;
    }

    public PaymentSchedule state(StateEnum state) {
        this.state = state;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The status of the payment schedule. active: there are unprocessed payment schedule items. canceled: the payment schedule has been canceled. complete: the payment schedule is complete and all items have been processed.")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public PaymentSchedule totalPaymentsErrored(Integer totalPaymentsErrored) {
        this.totalPaymentsErrored = totalPaymentsErrored;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The total number of failed payments.")
    public Integer getTotalPaymentsErrored() {
        return this.totalPaymentsErrored;
    }

    public void setTotalPaymentsErrored(Integer totalPaymentsErrored) {
        this.totalPaymentsErrored = totalPaymentsErrored;
    }

    public PaymentSchedule totalPaymentsProcessed(Integer totalPaymentsProcessed) {
        this.totalPaymentsProcessed = totalPaymentsProcessed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The total number of payments processed.")
    public Integer getTotalPaymentsProcessed() {
        return this.totalPaymentsProcessed;
    }

    public void setTotalPaymentsProcessed(Integer totalPaymentsProcessed) {
        this.totalPaymentsProcessed = totalPaymentsProcessed;
    }

    public PaymentSchedule paymentOptions(List<PaymentSchedulePaymentOptionRequest> paymentOptions) {
        this.paymentOptions = paymentOptions;
        return this;
    }

    public PaymentSchedule addPaymentOptionsItem(PaymentSchedulePaymentOptionRequest paymentOptionsItem) {
        if (this.paymentOptions == null) {
            this.paymentOptions = new ArrayList<PaymentSchedulePaymentOptionRequest>();
        }
        this.paymentOptions.add(paymentOptionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Container for the payment options, which describe the transactional level rules for processing payments. Currently, only the gateway_options type is supported. Payment schedule payment_options take precedence over payment schedule item payment_options.")
    public List<PaymentSchedulePaymentOptionRequest> getPaymentOptions() {
        return this.paymentOptions;
    }

    public void setPaymentOptions(List<PaymentSchedulePaymentOptionRequest> paymentOptions) {
        this.paymentOptions = paymentOptions;
    }

    public PaymentSchedule prepayment(Boolean prepayment) {
        this.prepayment = prepayment;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates whether the payments created by the payment schedule will be used as reserved payments. This field will only be available if the prepaid cash drawdown permission is enabled. See <a href=\"https://knowledgecenter.zuora.com/Zuora_Billing/Bill_your_customers/Bill_for_usage_or_prepaid_products/Advanced_Consumption_Billing/Prepaid_with_Drawdown\" target=\"_blank\">Prepaid Cash with Drawdown for more information.</a>")
    public Boolean getPrepayment() {
        return this.prepayment;
    }

    public void setPrepayment(Boolean prepayment) {
        this.prepayment = prepayment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentSchedule paymentSchedule = (PaymentSchedule)o;
        return Objects.equals(this.id, paymentSchedule.id) && Objects.equals(this.updatedById, paymentSchedule.updatedById) && Objects.equals(this.updatedTime, paymentSchedule.updatedTime) && Objects.equals(this.createdById, paymentSchedule.createdById) && Objects.equals(this.createdTime, paymentSchedule.createdTime) && Objects.equals(this.customFields, paymentSchedule.customFields) && Objects.equals(this.customObjects, paymentSchedule.customObjects) && Objects.equals(this.accountId, paymentSchedule.accountId) && Objects.equals(this.accountNumber, paymentSchedule.accountNumber) && Objects.equals(this.amount, paymentSchedule.amount) && Objects.equals((Object)this.period, (Object)paymentSchedule.period) && Objects.equals(this.billingDocument, paymentSchedule.billingDocument) && Objects.equals(this.currency, paymentSchedule.currency) && Objects.equals(this.description, paymentSchedule.description) && Objects.equals(this.items, paymentSchedule.items) && Objects.equals(this.numberOfPayments, paymentSchedule.numberOfPayments) && Objects.equals(this.paymentGatewayId, paymentSchedule.paymentGatewayId) && Objects.equals(this.paymentMethodId, paymentSchedule.paymentMethodId) && Objects.equals(this.paymentScheduleNumber, paymentSchedule.paymentScheduleNumber) && Objects.equals(this.runHour, paymentSchedule.runHour) && Objects.equals(this.standalone, paymentSchedule.standalone) && Objects.equals(this.startDate, paymentSchedule.startDate) && Objects.equals(this.totalAmount, paymentSchedule.totalAmount) && Objects.equals(this.custom, paymentSchedule.custom) && Objects.equals(this.nextPaymentDate, paymentSchedule.nextPaymentDate) && Objects.equals(this.recentPaymentDate, paymentSchedule.recentPaymentDate) && Objects.equals((Object)this.state, (Object)paymentSchedule.state) && Objects.equals(this.totalPaymentsErrored, paymentSchedule.totalPaymentsErrored) && Objects.equals(this.totalPaymentsProcessed, paymentSchedule.totalPaymentsProcessed) && Objects.equals(this.paymentOptions, paymentSchedule.paymentOptions) && Objects.equals(this.prepayment, paymentSchedule.prepayment);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.updatedById, this.updatedTime, this.createdById, this.createdTime, this.customFields, this.customObjects, this.accountId, this.accountNumber, this.amount, this.period, this.billingDocument, this.currency, this.description, this.items, this.numberOfPayments, this.paymentGatewayId, this.paymentMethodId, this.paymentScheduleNumber, this.runHour, this.standalone, this.startDate, this.totalAmount, this.custom, this.nextPaymentDate, this.recentPaymentDate, this.state, this.totalPaymentsErrored, this.totalPaymentsProcessed, this.paymentOptions, this.prepayment});
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentSchedule {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    updatedById: ").append(this.toIndentedString(this.updatedById)).append("\n");
        sb.append("    updatedTime: ").append(this.toIndentedString(this.updatedTime)).append("\n");
        sb.append("    createdById: ").append(this.toIndentedString(this.createdById)).append("\n");
        sb.append("    createdTime: ").append(this.toIndentedString(this.createdTime)).append("\n");
        sb.append("    customFields: ").append(this.toIndentedString(this.customFields)).append("\n");
        sb.append("    customObjects: ").append(this.toIndentedString(this.customObjects)).append("\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    accountNumber: ").append(this.toIndentedString(this.accountNumber)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    period: ").append(this.toIndentedString((Object)this.period)).append("\n");
        sb.append("    billingDocument: ").append(this.toIndentedString(this.billingDocument)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("    numberOfPayments: ").append(this.toIndentedString(this.numberOfPayments)).append("\n");
        sb.append("    paymentGatewayId: ").append(this.toIndentedString(this.paymentGatewayId)).append("\n");
        sb.append("    paymentMethodId: ").append(this.toIndentedString(this.paymentMethodId)).append("\n");
        sb.append("    paymentScheduleNumber: ").append(this.toIndentedString(this.paymentScheduleNumber)).append("\n");
        sb.append("    runHour: ").append(this.toIndentedString(this.runHour)).append("\n");
        sb.append("    standalone: ").append(this.toIndentedString(this.standalone)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    totalAmount: ").append(this.toIndentedString(this.totalAmount)).append("\n");
        sb.append("    custom: ").append(this.toIndentedString(this.custom)).append("\n");
        sb.append("    nextPaymentDate: ").append(this.toIndentedString(this.nextPaymentDate)).append("\n");
        sb.append("    recentPaymentDate: ").append(this.toIndentedString(this.recentPaymentDate)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    totalPaymentsErrored: ").append(this.toIndentedString(this.totalPaymentsErrored)).append("\n");
        sb.append("    totalPaymentsProcessed: ").append(this.toIndentedString(this.totalPaymentsProcessed)).append("\n");
        sb.append("    paymentOptions: ").append(this.toIndentedString(this.paymentOptions)).append("\n");
        sb.append("    prepayment: ").append(this.toIndentedString(this.prepayment)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StateEnum {
        ACTIVE("active"),
        CANCELED("canceled"),
        COMPLETE("complete"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StateEnum fromValue(String value) {
            for (StateEnum b : StateEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<StateEnum> {
            public void write(JsonWriter jsonWriter, StateEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StateEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StateEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum PeriodEnum {
        WEEK("week"),
        MONTH("month"),
        BIWEEKLY("biweekly"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private PeriodEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static PeriodEnum fromValue(String value) {
            for (PeriodEnum b : PeriodEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<PeriodEnum> {
            public void write(JsonWriter jsonWriter, PeriodEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public PeriodEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return PeriodEnum.fromValue(value);
            }
        }
    }
}

