/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.client.JSON;
import org.openapitools.client.model.AchDebitUpdate;
import org.openapitools.client.model.BillingDetails;
import org.openapitools.client.model.CardUpdate;
import org.openapitools.client.model.CcRefMandate;
import org.openapitools.client.model.CcRefUpdate;
import org.openapitools.jackson.nullable.JsonNullable;

public class PaymentMethodPatchRequest {
    public static final String SERIALIZED_NAME_BILLING_DETAILS = "billing_details";
    @SerializedName(value="billing_details")
    private BillingDetails billingDetails;
    public static final String SERIALIZED_NAME_ACCOUNT_ID = "account_id";
    @SerializedName(value="account_id")
    private String accountId;
    public static final String SERIALIZED_NAME_ACCOUNT_NUMBER = "account_number";
    @SerializedName(value="account_number")
    private String accountNumber;
    public static final String SERIALIZED_NAME_CUSTOM_FIELDS = "custom_fields";
    @SerializedName(value="custom_fields")
    @JsonAdapter(value=JSON.CustomFieldAdapter.class)
    private Map<String, Object> customFields = null;
    public static final String SERIALIZED_NAME_CARD = "card";
    @SerializedName(value="card")
    private CardUpdate card;
    public static final String SERIALIZED_NAME_CC_REF = "cc_ref";
    @SerializedName(value="cc_ref")
    private CcRefUpdate ccRef;
    public static final String SERIALIZED_NAME_MANDATE = "mandate";
    @SerializedName(value="mandate")
    private CcRefMandate mandate;
    public static final String SERIALIZED_NAME_ACH_DEBIT = "ach_debit";
    @SerializedName(value="ach_debit")
    private AchDebitUpdate achDebit;
    public static final String SERIALIZED_NAME_MAXIMUM_PAYMENT_ATTEMPTS = "maximum_payment_attempts";
    @SerializedName(value="maximum_payment_attempts")
    private BigDecimal maximumPaymentAttempts;
    public static final String SERIALIZED_NAME_PAYMENT_RETRY_INTERVAL = "payment_retry_interval";
    @SerializedName(value="payment_retry_interval")
    private Integer paymentRetryInterval;
    public static final String SERIALIZED_NAME_DEVICE_SESSION_ID = "device_session_id";
    @SerializedName(value="device_session_id")
    private String deviceSessionId;
    public static final String SERIALIZED_NAME_GATEWAY_OPTIONS = "gateway_options";
    @SerializedName(value="gateway_options")
    private Map<String, Object> gatewayOptions = null;
    public static final String SERIALIZED_NAME_CURRENCY = "currency";
    @SerializedName(value="currency")
    private String currency;
    public static final String SERIALIZED_NAME_GATEWAY_ID = "gateway_id";
    @SerializedName(value="gateway_id")
    private String gatewayId;

    public PaymentMethodPatchRequest billingDetails(BillingDetails billingDetails) {
        this.billingDetails = billingDetails;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public BillingDetails getBillingDetails() {
        return this.billingDetails;
    }

    public void setBillingDetails(BillingDetails billingDetails) {
        this.billingDetails = billingDetails;
    }

    public PaymentMethodPatchRequest accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2c92c0f86a8dd422016a9e7a70116b0d", value="A customer account identifier.")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public PaymentMethodPatchRequest accountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="A-100001", value="A human-readable customer account identifier. It can be user-supplied.")
    public String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public PaymentMethodPatchRequest customFields(Map<String, Object> customFields) {
        this.customFields = customFields;
        return this;
    }

    public PaymentMethodPatchRequest putCustomFieldsItem(String key, Object customFieldsItem) {
        if (this.customFields == null) {
            this.customFields = new HashMap<String, Object>();
        }
        this.customFields.put(key, customFieldsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Set of user-defined fields associated with this object. Useful for storing additional information about the object in a structured format.")
    public Map<String, Object> getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(Map<String, Object> customFields) {
        this.customFields = customFields;
    }

    public PaymentMethodPatchRequest card(CardUpdate card) {
        this.card = card;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Credit card information. When providing a card number, you must meet the requirements for PCI compliance. We strongly recommend using Zuora.js instead of interacting with this API directly.")
    public CardUpdate getCard() {
        return this.card;
    }

    public void setCard(CardUpdate card) {
        this.card = card;
    }

    public PaymentMethodPatchRequest ccRef(CcRefUpdate ccRef) {
        this.ccRef = ccRef;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Credit Card Reference Transaction. See Supported payment methods for payment gateways that support this type of payment method.")
    public CcRefUpdate getCcRef() {
        return this.ccRef;
    }

    public void setCcRef(CcRefUpdate ccRef) {
        this.ccRef = ccRef;
    }

    public PaymentMethodPatchRequest mandate(CcRefMandate mandate) {
        this.mandate = mandate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public CcRefMandate getMandate() {
        return this.mandate;
    }

    public void setMandate(CcRefMandate mandate) {
        this.mandate = mandate;
    }

    public PaymentMethodPatchRequest achDebit(AchDebitUpdate achDebit) {
        this.achDebit = achDebit;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If this is an ach_debit payment method, this hash contains details about the ACH debit bank account.")
    public AchDebitUpdate getAchDebit() {
        return this.achDebit;
    }

    public void setAchDebit(AchDebitUpdate achDebit) {
        this.achDebit = achDebit;
    }

    public PaymentMethodPatchRequest maximumPaymentAttempts(BigDecimal maximumPaymentAttempts) {
        this.maximumPaymentAttempts = maximumPaymentAttempts;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="6", value="Maximum number of consecutive failed retry payment attempts using this payment method before retries are stopped.")
    public BigDecimal getMaximumPaymentAttempts() {
        return this.maximumPaymentAttempts;
    }

    public void setMaximumPaymentAttempts(BigDecimal maximumPaymentAttempts) {
        this.maximumPaymentAttempts = maximumPaymentAttempts;
    }

    public PaymentMethodPatchRequest paymentRetryInterval(Integer paymentRetryInterval) {
        this.paymentRetryInterval = paymentRetryInterval;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="3", value="The retry interval in hours.")
    public Integer getPaymentRetryInterval() {
        return this.paymentRetryInterval;
    }

    public void setPaymentRetryInterval(Integer paymentRetryInterval) {
        this.paymentRetryInterval = paymentRetryInterval;
    }

    public PaymentMethodPatchRequest deviceSessionId(String deviceSessionId) {
        this.deviceSessionId = deviceSessionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2cadffe03", value="Identifier of the device browser session.")
    public String getDeviceSessionId() {
        return this.deviceSessionId;
    }

    public void setDeviceSessionId(String deviceSessionId) {
        this.deviceSessionId = deviceSessionId;
    }

    public PaymentMethodPatchRequest gatewayOptions(Map<String, Object> gatewayOptions) {
        this.gatewayOptions = gatewayOptions;
        return this;
    }

    public PaymentMethodPatchRequest putGatewayOptionsItem(String key, Object gatewayOptionsItem) {
        if (this.gatewayOptions == null) {
            this.gatewayOptions = new HashMap<String, Object>();
        }
        this.gatewayOptions.put(key, gatewayOptionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="{\"key\":\"value\"}", value="")
    public Map<String, Object> getGatewayOptions() {
        return this.gatewayOptions;
    }

    public void setGatewayOptions(Map<String, Object> gatewayOptions) {
        this.gatewayOptions = gatewayOptions;
    }

    public PaymentMethodPatchRequest currency(String currency) {
        this.currency = currency;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="3-letter ISO 4217 currency code.")
    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public PaymentMethodPatchRequest gatewayId(String gatewayId) {
        this.gatewayId = gatewayId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Identifier of the payment gateway Zuora will use to authorize the payments that are made with this payment method.")
    public String getGatewayId() {
        return this.gatewayId;
    }

    public void setGatewayId(String gatewayId) {
        this.gatewayId = gatewayId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentMethodPatchRequest paymentMethodPatchRequest = (PaymentMethodPatchRequest)o;
        return Objects.equals(this.billingDetails, paymentMethodPatchRequest.billingDetails) && Objects.equals(this.accountId, paymentMethodPatchRequest.accountId) && Objects.equals(this.accountNumber, paymentMethodPatchRequest.accountNumber) && Objects.equals(this.customFields, paymentMethodPatchRequest.customFields) && Objects.equals(this.card, paymentMethodPatchRequest.card) && Objects.equals(this.ccRef, paymentMethodPatchRequest.ccRef) && Objects.equals(this.mandate, paymentMethodPatchRequest.mandate) && Objects.equals(this.achDebit, paymentMethodPatchRequest.achDebit) && Objects.equals(this.maximumPaymentAttempts, paymentMethodPatchRequest.maximumPaymentAttempts) && Objects.equals(this.paymentRetryInterval, paymentMethodPatchRequest.paymentRetryInterval) && Objects.equals(this.deviceSessionId, paymentMethodPatchRequest.deviceSessionId) && Objects.equals(this.gatewayOptions, paymentMethodPatchRequest.gatewayOptions) && Objects.equals(this.currency, paymentMethodPatchRequest.currency) && Objects.equals(this.gatewayId, paymentMethodPatchRequest.gatewayId);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(this.billingDetails, this.accountId, this.accountNumber, this.customFields, this.card, this.ccRef, this.mandate, this.achDebit, this.maximumPaymentAttempts, this.paymentRetryInterval, this.deviceSessionId, this.gatewayOptions, this.currency, this.gatewayId);
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentMethodPatchRequest {\n");
        sb.append("    billingDetails: ").append(this.toIndentedString(this.billingDetails)).append("\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    accountNumber: ").append(this.toIndentedString(this.accountNumber)).append("\n");
        sb.append("    customFields: ").append(this.toIndentedString(this.customFields)).append("\n");
        sb.append("    card: ").append(this.toIndentedString(this.card)).append("\n");
        sb.append("    ccRef: ").append(this.toIndentedString(this.ccRef)).append("\n");
        sb.append("    mandate: ").append(this.toIndentedString(this.mandate)).append("\n");
        sb.append("    achDebit: ").append(this.toIndentedString(this.achDebit)).append("\n");
        sb.append("    maximumPaymentAttempts: ").append(this.toIndentedString(this.maximumPaymentAttempts)).append("\n");
        sb.append("    paymentRetryInterval: ").append(this.toIndentedString(this.paymentRetryInterval)).append("\n");
        sb.append("    deviceSessionId: ").append(this.toIndentedString(this.deviceSessionId)).append("\n");
        sb.append("    gatewayOptions: ").append(this.toIndentedString(this.gatewayOptions)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    gatewayId: ").append(this.toIndentedString(this.gatewayId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

