/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.client.JSON;
import org.openapitools.client.model.Account;
import org.openapitools.client.model.GatewayStateTransitions;
import org.openapitools.client.model.PaymentMethod1;
import org.openapitools.client.model.PaymentScheduleItem;
import org.openapitools.client.model.PaymentStateTransitions;
import org.openapitools.client.model.PaymentsAppliedToResponse;
import org.openapitools.jackson.nullable.JsonNullable;
import org.threeten.bp.LocalDate;
import org.threeten.bp.OffsetDateTime;

public class Payment {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_UPDATED_BY_ID = "updated_by_id";
    @SerializedName(value="updated_by_id")
    private String updatedById;
    public static final String SERIALIZED_NAME_UPDATED_TIME = "updated_time";
    @SerializedName(value="updated_time")
    private OffsetDateTime updatedTime;
    public static final String SERIALIZED_NAME_CREATED_BY_ID = "created_by_id";
    @SerializedName(value="created_by_id")
    private String createdById;
    public static final String SERIALIZED_NAME_CREATED_TIME = "created_time";
    @SerializedName(value="created_time")
    private OffsetDateTime createdTime;
    public static final String SERIALIZED_NAME_CUSTOM_FIELDS = "custom_fields";
    @SerializedName(value="custom_fields")
    @JsonAdapter(value=JSON.CustomFieldAdapter.class)
    private Map<String, Object> customFields = null;
    public static final String SERIALIZED_NAME_CUSTOM_OBJECTS = "custom_objects";
    @SerializedName(value="custom_objects")
    private Map<String, Object> customObjects = null;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_REFERENCE_ID = "reference_id";
    @SerializedName(value="reference_id")
    private String referenceId;
    public static final String SERIALIZED_NAME_ACCOUNT_ID = "account_id";
    @SerializedName(value="account_id")
    private String accountId;
    public static final String SERIALIZED_NAME_ACCOUNT_NUMBER = "account_number";
    @SerializedName(value="account_number")
    private String accountNumber;
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private BigDecimal amount;
    public static final String SERIALIZED_NAME_AUTHORIZATION_ID = "authorization_id";
    @SerializedName(value="authorization_id")
    private String authorizationId;
    public static final String SERIALIZED_NAME_PAYMENT_DATE = "payment_date";
    @SerializedName(value="payment_date")
    private LocalDate paymentDate;
    public static final String SERIALIZED_NAME_PAYMENT_METHOD_ID = "payment_method_id";
    @SerializedName(value="payment_method_id")
    private String paymentMethodId;
    public static final String SERIALIZED_NAME_GATEWAY_ID = "gateway_id";
    @SerializedName(value="gateway_id")
    private String gatewayId;
    public static final String SERIALIZED_NAME_GATEWAY_ORDER_ID = "gateway_order_id";
    @SerializedName(value="gateway_order_id")
    private String gatewayOrderId;
    public static final String SERIALIZED_NAME_SECOND_REFERENCE_ID = "second_reference_id";
    @SerializedName(value="second_reference_id")
    private String secondReferenceId;
    public static final String SERIALIZED_NAME_GATEWAY_OPTIONS = "gateway_options";
    @SerializedName(value="gateway_options")
    private Map<String, Object> gatewayOptions = null;
    public static final String SERIALIZED_NAME_STATEMENT_DESCRIPTOR = "statement_descriptor";
    @SerializedName(value="statement_descriptor")
    private String statementDescriptor;
    public static final String SERIALIZED_NAME_STATEMENT_DESCRIPTOR_PHONE = "statement_descriptor_phone";
    @SerializedName(value="statement_descriptor_phone")
    private String statementDescriptorPhone;
    public static final String SERIALIZED_NAME_EXTERNAL = "external";
    @SerializedName(value="external")
    private Boolean external;
    public static final String SERIALIZED_NAME_CURRENCY = "currency";
    @SerializedName(value="currency")
    private String currency;
    public static final String SERIALIZED_NAME_ACCOUNT = "account";
    @SerializedName(value="account")
    private Account account;
    public static final String SERIALIZED_NAME_AMOUNT_APPLIED = "amount_applied";
    @SerializedName(value="amount_applied")
    private BigDecimal amountApplied;
    public static final String SERIALIZED_NAME_REMAINING_BALANCE = "remaining_balance";
    @SerializedName(value="remaining_balance")
    private BigDecimal remainingBalance;
    public static final String SERIALIZED_NAME_AMOUNT_REFUNDED = "amount_refunded";
    @SerializedName(value="amount_refunded")
    private BigDecimal amountRefunded;
    public static final String SERIALIZED_NAME_STATE = "state";
    @SerializedName(value="state")
    private StateEnum state;
    public static final String SERIALIZED_NAME_PAYOUT_ID = "payout_id";
    @SerializedName(value="payout_id")
    private String payoutId;
    public static final String SERIALIZED_NAME_PAYMENT_NUMBER = "payment_number";
    @SerializedName(value="payment_number")
    private String paymentNumber;
    public static final String SERIALIZED_NAME_GATEWAY_RESPONSE_CODE = "gateway_response_code";
    @SerializedName(value="gateway_response_code")
    private String gatewayResponseCode;
    public static final String SERIALIZED_NAME_PAYMENT_METHOD = "payment_method";
    @SerializedName(value="payment_method")
    private PaymentMethod1 paymentMethod;
    public static final String SERIALIZED_NAME_GATEWAY_RESPONSE = "gateway_response";
    @SerializedName(value="gateway_response")
    private String gatewayResponse;
    public static final String SERIALIZED_NAME_GATEWAY_RECONCILIATION_STATUS = "gateway_reconciliation_status";
    @SerializedName(value="gateway_reconciliation_status")
    private String gatewayReconciliationStatus;
    public static final String SERIALIZED_NAME_GATEWAY_RECONCILIATION_REASON = "gateway_reconciliation_reason";
    @SerializedName(value="gateway_reconciliation_reason")
    private String gatewayReconciliationReason;
    public static final String SERIALIZED_NAME_GATEWAY_STATE = "gateway_state";
    @SerializedName(value="gateway_state")
    private GatewayStateEnum gatewayState;
    public static final String SERIALIZED_NAME_APPLIED_TO = "applied_to";
    @SerializedName(value="applied_to")
    private List<PaymentsAppliedToResponse> appliedTo = null;
    public static final String SERIALIZED_NAME_PAYMENT_SCHEDULE_ITEMS = "payment_schedule_items";
    @SerializedName(value="payment_schedule_items")
    private List<PaymentScheduleItem> paymentScheduleItems = null;
    public static final String SERIALIZED_NAME_STATE_TRANSITIONS = "state_transitions";
    @SerializedName(value="state_transitions")
    private PaymentStateTransitions stateTransitions;
    public static final String SERIALIZED_NAME_GATEWAY_STATE_TRANSITIONS = "gateway_state_transitions";
    @SerializedName(value="gateway_state_transitions")
    private GatewayStateTransitions gatewayStateTransitions;

    public Payment() {
    }

    public Payment(String id, String updatedById, OffsetDateTime updatedTime, String createdById, OffsetDateTime createdTime, Map<String, Object> customObjects, StateEnum state, GatewayStateEnum gatewayState, List<PaymentsAppliedToResponse> appliedTo) {
        this();
        this.id = id;
        this.updatedById = updatedById;
        this.updatedTime = updatedTime;
        this.createdById = createdById;
        this.createdTime = createdTime;
        this.customObjects = customObjects;
        this.state = state;
        this.gatewayState = gatewayState;
        this.appliedTo = appliedTo;
    }

    @Nullable
    @ApiModelProperty(value="Unique identifier for the object.")
    public String getId() {
        return this.id;
    }

    @Nullable
    @ApiModelProperty(value="Unique identifier of the Zuora user who last updated the object")
    public String getUpdatedById() {
        return this.updatedById;
    }

    @Nullable
    @ApiModelProperty(value="The date and time when the object was last updated in ISO 8601 UTC format.")
    public OffsetDateTime getUpdatedTime() {
        return this.updatedTime;
    }

    @Nullable
    @ApiModelProperty(value="Unique identifier of the Zuora user who created the object")
    public String getCreatedById() {
        return this.createdById;
    }

    @Nullable
    @ApiModelProperty(value="The date and time when the object was created in ISO 8601 UTC format.")
    public OffsetDateTime getCreatedTime() {
        return this.createdTime;
    }

    public Payment customFields(Map<String, Object> customFields) {
        this.customFields = customFields;
        return this;
    }

    public Payment putCustomFieldsItem(String key, Object customFieldsItem) {
        if (this.customFields == null) {
            this.customFields = new HashMap<String, Object>();
        }
        this.customFields.put(key, customFieldsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Set of user-defined fields associated with this object. Useful for storing additional information about the object in a structured format.")
    public Map<String, Object> getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(Map<String, Object> customFields) {
        this.customFields = customFields;
    }

    @Nullable
    @ApiModelProperty(value="The custom objects associated with a Zuora standard object.")
    public Map<String, Object> getCustomObjects() {
        return this.customObjects;
    }

    public Payment description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An arbitrary string attached to the object. Often useful for displaying to users.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Payment referenceId(String referenceId) {
        this.referenceId = referenceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Transaction identifier returned by the payment gateway. You may use this field to reconcile payments between your payment gateway and Zuora Payments.")
    public String getReferenceId() {
        return this.referenceId;
    }

    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    public Payment accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Identifier of the customer account associated with this payment.")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public Payment accountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Human-readable identifier of the account associated with this payment. It can be user-supplied.")
    public String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public Payment amount(BigDecimal amount) {
        this.amount = amount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The total amount of the payment.")
    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public Payment authorizationId(String authorizationId) {
        this.authorizationId = authorizationId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Identifier of the authorization transaction from the payment gateway.")
    public String getAuthorizationId() {
        return this.authorizationId;
    }

    public void setAuthorizationId(String authorizationId) {
        this.authorizationId = authorizationId;
    }

    public Payment paymentDate(LocalDate paymentDate) {
        this.paymentDate = paymentDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The date and time when the payment takes effect.")
    public LocalDate getPaymentDate() {
        return this.paymentDate;
    }

    public void setPaymentDate(LocalDate paymentDate) {
        this.paymentDate = paymentDate;
    }

    public Payment paymentMethodId(String paymentMethodId) {
        this.paymentMethodId = paymentMethodId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Identifier of the payment method used to create this payment.")
    public String getPaymentMethodId() {
        return this.paymentMethodId;
    }

    public void setPaymentMethodId(String paymentMethodId) {
        this.paymentMethodId = paymentMethodId;
    }

    public Payment gatewayId(String gatewayId) {
        this.gatewayId = gatewayId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Identifier of the payment gateway that Zuora will use to authorize this payment.")
    public String getGatewayId() {
        return this.gatewayId;
    }

    public void setGatewayId(String gatewayId) {
        this.gatewayId = gatewayId;
    }

    public Payment gatewayOrderId(String gatewayOrderId) {
        this.gatewayOrderId = gatewayOrderId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A merchant-specified natural key value that can be passed to the payment gateway when a payment is created. If not specified, the payment number will be passed in instead.")
    public String getGatewayOrderId() {
        return this.gatewayOrderId;
    }

    public void setGatewayOrderId(String gatewayOrderId) {
        this.gatewayOrderId = gatewayOrderId;
    }

    public Payment secondReferenceId(String secondReferenceId) {
        this.secondReferenceId = secondReferenceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A second transaction identifier returned by the payment gateway if there is an additional transaction for the refunds. You may use this field to reconcile payments between your payment gateway and Zuora Payments.")
    public String getSecondReferenceId() {
        return this.secondReferenceId;
    }

    public void setSecondReferenceId(String secondReferenceId) {
        this.secondReferenceId = secondReferenceId;
    }

    public Payment gatewayOptions(Map<String, Object> gatewayOptions) {
        this.gatewayOptions = gatewayOptions;
        return this;
    }

    public Payment putGatewayOptionsItem(String key, Object gatewayOptionsItem) {
        if (this.gatewayOptions == null) {
            this.gatewayOptions = new HashMap<String, Object>();
        }
        this.gatewayOptions.put(key, gatewayOptionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="{\"key\":\"value\"}", value="")
    public Map<String, Object> getGatewayOptions() {
        return this.gatewayOptions;
    }

    public void setGatewayOptions(Map<String, Object> gatewayOptions) {
        this.gatewayOptions = gatewayOptions;
    }

    public Payment statementDescriptor(String statementDescriptor) {
        this.statementDescriptor = statementDescriptor;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A payment gateway-specific field used by Orbital, Vantiv and Verifi.")
    public String getStatementDescriptor() {
        return this.statementDescriptor;
    }

    public void setStatementDescriptor(String statementDescriptor) {
        this.statementDescriptor = statementDescriptor;
    }

    public Payment statementDescriptorPhone(String statementDescriptorPhone) {
        this.statementDescriptorPhone = statementDescriptorPhone;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A payment gateway-specific field used by Orbital, Vantiv and Verifi.")
    public String getStatementDescriptorPhone() {
        return this.statementDescriptorPhone;
    }

    public void setStatementDescriptorPhone(String statementDescriptorPhone) {
        this.statementDescriptorPhone = statementDescriptorPhone;
    }

    public Payment external(Boolean external) {
        this.external = external;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If true, indicates that this payment is not handled by Zuora.")
    public Boolean getExternal() {
        return this.external;
    }

    public void setExternal(Boolean external) {
        this.external = external;
    }

    public Payment currency(String currency) {
        this.currency = currency;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="3-letter ISO 4217 currency code.")
    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public Payment account(Account account) {
        this.account = account;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The customer account associated with this payment.")
    public Account getAccount() {
        return this.account;
    }

    public void setAccount(Account account) {
        this.account = account;
    }

    public Payment amountApplied(BigDecimal amountApplied) {
        this.amountApplied = amountApplied;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The total amount applied.")
    public BigDecimal getAmountApplied() {
        return this.amountApplied;
    }

    public void setAmountApplied(BigDecimal amountApplied) {
        this.amountApplied = amountApplied;
    }

    public Payment remainingBalance(BigDecimal remainingBalance) {
        this.remainingBalance = remainingBalance;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The total remaining balance.")
    public BigDecimal getRemainingBalance() {
        return this.remainingBalance;
    }

    public void setRemainingBalance(BigDecimal remainingBalance) {
        this.remainingBalance = remainingBalance;
    }

    public Payment amountRefunded(BigDecimal amountRefunded) {
        this.amountRefunded = amountRefunded;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The total amount refunded.")
    public BigDecimal getAmountRefunded() {
        return this.amountRefunded;
    }

    public void setAmountRefunded(BigDecimal amountRefunded) {
        this.amountRefunded = amountRefunded;
    }

    @Nullable
    @ApiModelProperty(value="The state of the payment.")
    public StateEnum getState() {
        return this.state;
    }

    public Payment payoutId(String payoutId) {
        this.payoutId = payoutId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Identifier of the payout associated with this payment.")
    public String getPayoutId() {
        return this.payoutId;
    }

    public void setPayoutId(String payoutId) {
        this.payoutId = payoutId;
    }

    public Payment paymentNumber(String paymentNumber) {
        this.paymentNumber = paymentNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Human-readable identifier for this object; may be user-supplied.")
    public String getPaymentNumber() {
        return this.paymentNumber;
    }

    public void setPaymentNumber(String paymentNumber) {
        this.paymentNumber = paymentNumber;
    }

    public Payment gatewayResponseCode(String gatewayResponseCode) {
        this.gatewayResponseCode = gatewayResponseCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Code returned by the payment gateway for this payment.")
    public String getGatewayResponseCode() {
        return this.gatewayResponseCode;
    }

    public void setGatewayResponseCode(String gatewayResponseCode) {
        this.gatewayResponseCode = gatewayResponseCode;
    }

    public Payment paymentMethod(PaymentMethod1 paymentMethod) {
        this.paymentMethod = paymentMethod;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public PaymentMethod1 getPaymentMethod() {
        return this.paymentMethod;
    }

    public void setPaymentMethod(PaymentMethod1 paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    public Payment gatewayResponse(String gatewayResponse) {
        this.gatewayResponse = gatewayResponse;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Message returned by the payment gateway for this payment.")
    public String getGatewayResponse() {
        return this.gatewayResponse;
    }

    public void setGatewayResponse(String gatewayResponse) {
        this.gatewayResponse = gatewayResponse;
    }

    public Payment gatewayReconciliationStatus(String gatewayReconciliationStatus) {
        this.gatewayReconciliationStatus = gatewayReconciliationStatus;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Gateway reconciliation state.")
    public String getGatewayReconciliationStatus() {
        return this.gatewayReconciliationStatus;
    }

    public void setGatewayReconciliationStatus(String gatewayReconciliationStatus) {
        this.gatewayReconciliationStatus = gatewayReconciliationStatus;
    }

    public Payment gatewayReconciliationReason(String gatewayReconciliationReason) {
        this.gatewayReconciliationReason = gatewayReconciliationReason;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Gateway reconciliation reason.")
    public String getGatewayReconciliationReason() {
        return this.gatewayReconciliationReason;
    }

    public void setGatewayReconciliationReason(String gatewayReconciliationReason) {
        this.gatewayReconciliationReason = gatewayReconciliationReason;
    }

    @Nullable
    @ApiModelProperty(value="The payment gateway state of the payment.")
    public GatewayStateEnum getGatewayState() {
        return this.gatewayState;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<PaymentsAppliedToResponse> getAppliedTo() {
        return this.appliedTo;
    }

    public Payment paymentScheduleItems(List<PaymentScheduleItem> paymentScheduleItems) {
        this.paymentScheduleItems = paymentScheduleItems;
        return this;
    }

    public Payment addPaymentScheduleItemsItem(PaymentScheduleItem paymentScheduleItemsItem) {
        if (this.paymentScheduleItems == null) {
            this.paymentScheduleItems = new ArrayList<PaymentScheduleItem>();
        }
        this.paymentScheduleItems.add(paymentScheduleItemsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<PaymentScheduleItem> getPaymentScheduleItems() {
        return this.paymentScheduleItems;
    }

    public void setPaymentScheduleItems(List<PaymentScheduleItem> paymentScheduleItems) {
        this.paymentScheduleItems = paymentScheduleItems;
    }

    public Payment stateTransitions(PaymentStateTransitions stateTransitions) {
        this.stateTransitions = stateTransitions;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public PaymentStateTransitions getStateTransitions() {
        return this.stateTransitions;
    }

    public void setStateTransitions(PaymentStateTransitions stateTransitions) {
        this.stateTransitions = stateTransitions;
    }

    public Payment gatewayStateTransitions(GatewayStateTransitions gatewayStateTransitions) {
        this.gatewayStateTransitions = gatewayStateTransitions;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public GatewayStateTransitions getGatewayStateTransitions() {
        return this.gatewayStateTransitions;
    }

    public void setGatewayStateTransitions(GatewayStateTransitions gatewayStateTransitions) {
        this.gatewayStateTransitions = gatewayStateTransitions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Payment payment = (Payment)o;
        return Objects.equals(this.id, payment.id) && Objects.equals(this.updatedById, payment.updatedById) && Objects.equals(this.updatedTime, payment.updatedTime) && Objects.equals(this.createdById, payment.createdById) && Objects.equals(this.createdTime, payment.createdTime) && Objects.equals(this.customFields, payment.customFields) && Objects.equals(this.customObjects, payment.customObjects) && Objects.equals(this.description, payment.description) && Objects.equals(this.referenceId, payment.referenceId) && Objects.equals(this.accountId, payment.accountId) && Objects.equals(this.accountNumber, payment.accountNumber) && Objects.equals(this.amount, payment.amount) && Objects.equals(this.authorizationId, payment.authorizationId) && Objects.equals(this.paymentDate, payment.paymentDate) && Objects.equals(this.paymentMethodId, payment.paymentMethodId) && Objects.equals(this.gatewayId, payment.gatewayId) && Objects.equals(this.gatewayOrderId, payment.gatewayOrderId) && Objects.equals(this.secondReferenceId, payment.secondReferenceId) && Objects.equals(this.gatewayOptions, payment.gatewayOptions) && Objects.equals(this.statementDescriptor, payment.statementDescriptor) && Objects.equals(this.statementDescriptorPhone, payment.statementDescriptorPhone) && Objects.equals(this.external, payment.external) && Objects.equals(this.currency, payment.currency) && Objects.equals(this.account, payment.account) && Objects.equals(this.amountApplied, payment.amountApplied) && Objects.equals(this.remainingBalance, payment.remainingBalance) && Objects.equals(this.amountRefunded, payment.amountRefunded) && Objects.equals((Object)this.state, (Object)payment.state) && Objects.equals(this.payoutId, payment.payoutId) && Objects.equals(this.paymentNumber, payment.paymentNumber) && Objects.equals(this.gatewayResponseCode, payment.gatewayResponseCode) && Objects.equals(this.paymentMethod, payment.paymentMethod) && Objects.equals(this.gatewayResponse, payment.gatewayResponse) && Objects.equals(this.gatewayReconciliationStatus, payment.gatewayReconciliationStatus) && Objects.equals(this.gatewayReconciliationReason, payment.gatewayReconciliationReason) && Objects.equals((Object)this.gatewayState, (Object)payment.gatewayState) && Objects.equals(this.appliedTo, payment.appliedTo) && Objects.equals(this.paymentScheduleItems, payment.paymentScheduleItems) && Objects.equals(this.stateTransitions, payment.stateTransitions) && Objects.equals(this.gatewayStateTransitions, payment.gatewayStateTransitions);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.updatedById, this.updatedTime, this.createdById, this.createdTime, this.customFields, this.customObjects, this.description, this.referenceId, this.accountId, this.accountNumber, this.amount, this.authorizationId, this.paymentDate, this.paymentMethodId, this.gatewayId, this.gatewayOrderId, this.secondReferenceId, this.gatewayOptions, this.statementDescriptor, this.statementDescriptorPhone, this.external, this.currency, this.account, this.amountApplied, this.remainingBalance, this.amountRefunded, this.state, this.payoutId, this.paymentNumber, this.gatewayResponseCode, this.paymentMethod, this.gatewayResponse, this.gatewayReconciliationStatus, this.gatewayReconciliationReason, this.gatewayState, this.appliedTo, this.paymentScheduleItems, this.stateTransitions, this.gatewayStateTransitions});
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Payment {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    updatedById: ").append(this.toIndentedString(this.updatedById)).append("\n");
        sb.append("    updatedTime: ").append(this.toIndentedString(this.updatedTime)).append("\n");
        sb.append("    createdById: ").append(this.toIndentedString(this.createdById)).append("\n");
        sb.append("    createdTime: ").append(this.toIndentedString(this.createdTime)).append("\n");
        sb.append("    customFields: ").append(this.toIndentedString(this.customFields)).append("\n");
        sb.append("    customObjects: ").append(this.toIndentedString(this.customObjects)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    referenceId: ").append(this.toIndentedString(this.referenceId)).append("\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    accountNumber: ").append(this.toIndentedString(this.accountNumber)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    authorizationId: ").append(this.toIndentedString(this.authorizationId)).append("\n");
        sb.append("    paymentDate: ").append(this.toIndentedString(this.paymentDate)).append("\n");
        sb.append("    paymentMethodId: ").append(this.toIndentedString(this.paymentMethodId)).append("\n");
        sb.append("    gatewayId: ").append(this.toIndentedString(this.gatewayId)).append("\n");
        sb.append("    gatewayOrderId: ").append(this.toIndentedString(this.gatewayOrderId)).append("\n");
        sb.append("    secondReferenceId: ").append(this.toIndentedString(this.secondReferenceId)).append("\n");
        sb.append("    gatewayOptions: ").append(this.toIndentedString(this.gatewayOptions)).append("\n");
        sb.append("    statementDescriptor: ").append(this.toIndentedString(this.statementDescriptor)).append("\n");
        sb.append("    statementDescriptorPhone: ").append(this.toIndentedString(this.statementDescriptorPhone)).append("\n");
        sb.append("    external: ").append(this.toIndentedString(this.external)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    account: ").append(this.toIndentedString(this.account)).append("\n");
        sb.append("    amountApplied: ").append(this.toIndentedString(this.amountApplied)).append("\n");
        sb.append("    remainingBalance: ").append(this.toIndentedString(this.remainingBalance)).append("\n");
        sb.append("    amountRefunded: ").append(this.toIndentedString(this.amountRefunded)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    payoutId: ").append(this.toIndentedString(this.payoutId)).append("\n");
        sb.append("    paymentNumber: ").append(this.toIndentedString(this.paymentNumber)).append("\n");
        sb.append("    gatewayResponseCode: ").append(this.toIndentedString(this.gatewayResponseCode)).append("\n");
        sb.append("    paymentMethod: ").append(this.toIndentedString(this.paymentMethod)).append("\n");
        sb.append("    gatewayResponse: ").append(this.toIndentedString(this.gatewayResponse)).append("\n");
        sb.append("    gatewayReconciliationStatus: ").append(this.toIndentedString(this.gatewayReconciliationStatus)).append("\n");
        sb.append("    gatewayReconciliationReason: ").append(this.toIndentedString(this.gatewayReconciliationReason)).append("\n");
        sb.append("    gatewayState: ").append(this.toIndentedString((Object)this.gatewayState)).append("\n");
        sb.append("    appliedTo: ").append(this.toIndentedString(this.appliedTo)).append("\n");
        sb.append("    paymentScheduleItems: ").append(this.toIndentedString(this.paymentScheduleItems)).append("\n");
        sb.append("    stateTransitions: ").append(this.toIndentedString(this.stateTransitions)).append("\n");
        sb.append("    gatewayStateTransitions: ").append(this.toIndentedString(this.gatewayStateTransitions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum GatewayStateEnum {
        MARKED_FOR_SUBMISSION("marked_for_submission"),
        SUBMITTED("submitted"),
        SETTLED("settled"),
        NOT_SUBMITTED("not_submitted"),
        FAILED("failed"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private GatewayStateEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static GatewayStateEnum fromValue(String value) {
            for (GatewayStateEnum b : GatewayStateEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<GatewayStateEnum> {
            public void write(JsonWriter jsonWriter, GatewayStateEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public GatewayStateEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return GatewayStateEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StateEnum {
        DRAFT("draft"),
        POSTED("posted"),
        PROCESSING("processing"),
        PROCESSED("processed"),
        ERROR("error"),
        CANCELED("canceled"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StateEnum fromValue(String value) {
            for (StateEnum b : StateEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<StateEnum> {
            public void write(JsonWriter jsonWriter, StateEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StateEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StateEnum.fromValue(value);
            }
        }
    }
}

