/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;
import org.openapitools.client.ApiCallback;
import org.openapitools.client.ApiClient;
import org.openapitools.client.ApiException;
import org.openapitools.client.ApiResponse;
import org.openapitools.client.Configuration;
import org.openapitools.client.Pair;
import org.openapitools.client.model.ErrorResponse;
import org.openapitools.client.model.GetByIdQueryParams;
import org.openapitools.client.model.Headers;
import org.openapitools.client.model.PaymentSchedule;
import org.openapitools.client.model.PaymentScheduleCancel;
import org.openapitools.client.model.PaymentScheduleCreateRequest;
import org.openapitools.client.model.PaymentSchedulePatchRequest;

public class PaymentSchedulesApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public PaymentSchedulesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public PaymentSchedulesApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call cancelPaymentScheduleCall(String paymentScheduleId, PaymentScheduleCancel paymentScheduleCancel, List<String> fields, List<String> paymentScheduleFields, List<String> paymentScheduleItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        PaymentScheduleCancel localVarPostBody = paymentScheduleCancel;
        String localVarPath = "/payment_schedules/{payment_schedule_id}/cancel".replace("{payment_schedule_id}", this.localVarApiClient.escapeString(paymentScheduleId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (paymentScheduleFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "payment_schedule.fields[]", paymentScheduleFields));
        }
        if (paymentScheduleItemFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "payment_schedule_item.fields[]", paymentScheduleItemFields));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraCacheEnabled != null) {
            localVarHeaderParams.put("zuora-cache-enabled", this.localVarApiClient.parameterToString(zuoraCacheEnabled));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call cancelPaymentScheduleValidateBeforeCall(String paymentScheduleId, PaymentScheduleCancel paymentScheduleCancel, List<String> fields, List<String> paymentScheduleFields, List<String> paymentScheduleItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (paymentScheduleId == null) {
            throw new ApiException("Missing the required parameter 'paymentScheduleId' when calling cancelPaymentSchedule(Async)");
        }
        if (paymentScheduleCancel == null) {
            throw new ApiException("Missing the required parameter 'paymentScheduleCancel' when calling cancelPaymentSchedule(Async)");
        }
        return this.cancelPaymentScheduleCall(paymentScheduleId, paymentScheduleCancel, fields, paymentScheduleFields, paymentScheduleItemFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, _callback);
    }

    private ApiResponse<PaymentSchedule> cancelPaymentScheduleWithHttpInfo(String paymentScheduleId, PaymentScheduleCancel paymentScheduleCancel, List<String> fields, List<String> paymentScheduleFields, List<String> paymentScheduleItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.cancelPaymentScheduleValidateBeforeCall(paymentScheduleId, paymentScheduleCancel, fields, paymentScheduleFields, paymentScheduleItemFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<PaymentSchedule>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call cancelPaymentScheduleAsync(String paymentScheduleId, PaymentScheduleCancel paymentScheduleCancel, List<String> fields, List<String> paymentScheduleFields, List<String> paymentScheduleItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback<PaymentSchedule> _callback) throws ApiException {
        Call localVarCall = this.cancelPaymentScheduleValidateBeforeCall(paymentScheduleId, paymentScheduleCancel, fields, paymentScheduleFields, paymentScheduleItemFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<PaymentSchedule>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public CancelPaymentScheduleParams cancelPaymentScheduleParams(String paymentScheduleId, PaymentScheduleCancel paymentScheduleCancel) {
        return new CancelPaymentScheduleParams(paymentScheduleId, paymentScheduleCancel);
    }

    public PaymentSchedule cancelPaymentSchedule(String paymentScheduleId, PaymentScheduleCancel paymentScheduleCancel) throws ApiException {
        CancelPaymentScheduleParams params = new CancelPaymentScheduleParams(paymentScheduleId, paymentScheduleCancel);
        return this.executeCancelPaymentScheduleAPICall(params).getData();
    }

    public PaymentSchedule cancelPaymentSchedule(String paymentScheduleId, PaymentScheduleCancel paymentScheduleCancel, List<String> expand) throws ApiException {
        CancelPaymentScheduleParams params = new CancelPaymentScheduleParams(paymentScheduleId, paymentScheduleCancel);
        params.expand(expand);
        return this.executeCancelPaymentScheduleAPICall(params).getData();
    }

    public PaymentSchedule cancelPaymentSchedule(String paymentScheduleId, PaymentScheduleCancel paymentScheduleCancel, List<String> expand, Headers headers) throws ApiException {
        CancelPaymentScheduleParams params = new CancelPaymentScheduleParams(paymentScheduleId, paymentScheduleCancel).expand(expand).headers(headers);
        return this.executeCancelPaymentScheduleAPICall(params).getData();
    }

    public PaymentSchedule post(CancelPaymentScheduleParams params) throws ApiException {
        return this.executeCancelPaymentScheduleAPICall(params).getData();
    }

    public ApiResponse<PaymentSchedule> postWithHttpInfo(CancelPaymentScheduleParams params) throws ApiException {
        return this.executeCancelPaymentScheduleAPICall(params);
    }

    ApiResponse<PaymentSchedule> executeCancelPaymentScheduleAPICall(CancelPaymentScheduleParams params) throws ApiException {
        return this.cancelPaymentScheduleWithHttpInfo(params.paymentScheduleId, params.paymentScheduleCancel, params.fields, params.paymentScheduleFields, params.paymentScheduleItemFields, params.expand, params.filter, params.pageSize, params.zuoraTrackId, params.async, params.zuoraCacheEnabled, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraOrgIds);
    }

    private Call createPaymentScheduleCall(PaymentScheduleCreateRequest paymentScheduleCreateRequest, List<String> fields, List<String> paymentScheduleFields, List<String> paymentScheduleItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        PaymentScheduleCreateRequest localVarPostBody = paymentScheduleCreateRequest;
        String localVarPath = "/payment_schedules";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (paymentScheduleFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "payment_schedule.fields[]", paymentScheduleFields));
        }
        if (paymentScheduleItemFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "payment_schedule_item.fields[]", paymentScheduleItemFields));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraCacheEnabled != null) {
            localVarHeaderParams.put("zuora-cache-enabled", this.localVarApiClient.parameterToString(zuoraCacheEnabled));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createPaymentScheduleValidateBeforeCall(PaymentScheduleCreateRequest paymentScheduleCreateRequest, List<String> fields, List<String> paymentScheduleFields, List<String> paymentScheduleItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (paymentScheduleCreateRequest == null) {
            throw new ApiException("Missing the required parameter 'paymentScheduleCreateRequest' when calling createPaymentSchedule(Async)");
        }
        return this.createPaymentScheduleCall(paymentScheduleCreateRequest, fields, paymentScheduleFields, paymentScheduleItemFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, _callback);
    }

    private ApiResponse<PaymentSchedule> createPaymentScheduleWithHttpInfo(PaymentScheduleCreateRequest paymentScheduleCreateRequest, List<String> fields, List<String> paymentScheduleFields, List<String> paymentScheduleItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.createPaymentScheduleValidateBeforeCall(paymentScheduleCreateRequest, fields, paymentScheduleFields, paymentScheduleItemFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<PaymentSchedule>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call createPaymentScheduleAsync(PaymentScheduleCreateRequest paymentScheduleCreateRequest, List<String> fields, List<String> paymentScheduleFields, List<String> paymentScheduleItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback<PaymentSchedule> _callback) throws ApiException {
        Call localVarCall = this.createPaymentScheduleValidateBeforeCall(paymentScheduleCreateRequest, fields, paymentScheduleFields, paymentScheduleItemFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<PaymentSchedule>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public CreatePaymentScheduleParams createPaymentScheduleParams(PaymentScheduleCreateRequest paymentScheduleCreateRequest) {
        return new CreatePaymentScheduleParams(paymentScheduleCreateRequest);
    }

    public PaymentSchedule createPaymentSchedule(PaymentScheduleCreateRequest paymentScheduleCreateRequest) throws ApiException {
        CreatePaymentScheduleParams params = new CreatePaymentScheduleParams(paymentScheduleCreateRequest);
        return this.executeCreatePaymentScheduleAPICall(params).getData();
    }

    public PaymentSchedule createPaymentSchedule(PaymentScheduleCreateRequest paymentScheduleCreateRequest, List<String> expand) throws ApiException {
        CreatePaymentScheduleParams params = new CreatePaymentScheduleParams(paymentScheduleCreateRequest);
        params.expand(expand);
        return this.executeCreatePaymentScheduleAPICall(params).getData();
    }

    public PaymentSchedule createPaymentSchedule(PaymentScheduleCreateRequest paymentScheduleCreateRequest, List<String> expand, Headers headers) throws ApiException {
        CreatePaymentScheduleParams params = new CreatePaymentScheduleParams(paymentScheduleCreateRequest).expand(expand).headers(headers);
        return this.executeCreatePaymentScheduleAPICall(params).getData();
    }

    public PaymentSchedule create(CreatePaymentScheduleParams params) throws ApiException {
        return this.executeCreatePaymentScheduleAPICall(params).getData();
    }

    public ApiResponse<PaymentSchedule> createWithHttpInfo(CreatePaymentScheduleParams params) throws ApiException {
        return this.executeCreatePaymentScheduleAPICall(params);
    }

    ApiResponse<PaymentSchedule> executeCreatePaymentScheduleAPICall(CreatePaymentScheduleParams params) throws ApiException {
        return this.createPaymentScheduleWithHttpInfo(params.paymentScheduleCreateRequest, params.fields, params.paymentScheduleFields, params.paymentScheduleItemFields, params.expand, params.filter, params.pageSize, params.zuoraTrackId, params.async, params.zuoraCacheEnabled, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraOrgIds);
    }

    private Call getPaymentScheduleCall(String paymentScheduleId, List<String> fields, List<String> paymentScheduleFields, List<String> paymentScheduleItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/payment_schedules/{payment_schedule_id}".replace("{payment_schedule_id}", this.localVarApiClient.escapeString(paymentScheduleId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (paymentScheduleFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "payment_schedule.fields[]", paymentScheduleFields));
        }
        if (paymentScheduleItemFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "payment_schedule_item.fields[]", paymentScheduleItemFields));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraCacheEnabled != null) {
            localVarHeaderParams.put("zuora-cache-enabled", this.localVarApiClient.parameterToString(zuoraCacheEnabled));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getPaymentScheduleValidateBeforeCall(String paymentScheduleId, List<String> fields, List<String> paymentScheduleFields, List<String> paymentScheduleItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (paymentScheduleId == null) {
            throw new ApiException("Missing the required parameter 'paymentScheduleId' when calling getPaymentSchedule(Async)");
        }
        return this.getPaymentScheduleCall(paymentScheduleId, fields, paymentScheduleFields, paymentScheduleItemFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, _callback);
    }

    private ApiResponse<PaymentSchedule> getPaymentScheduleWithHttpInfo(String paymentScheduleId, List<String> fields, List<String> paymentScheduleFields, List<String> paymentScheduleItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.getPaymentScheduleValidateBeforeCall(paymentScheduleId, fields, paymentScheduleFields, paymentScheduleItemFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<PaymentSchedule>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call getPaymentScheduleAsync(String paymentScheduleId, List<String> fields, List<String> paymentScheduleFields, List<String> paymentScheduleItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback<PaymentSchedule> _callback) throws ApiException {
        Call localVarCall = this.getPaymentScheduleValidateBeforeCall(paymentScheduleId, fields, paymentScheduleFields, paymentScheduleItemFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<PaymentSchedule>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetPaymentScheduleParams getPaymentScheduleParams(String paymentScheduleId) {
        return new GetPaymentScheduleParams(paymentScheduleId);
    }

    public PaymentSchedule getPaymentSchedule(String paymentScheduleId) throws ApiException {
        GetPaymentScheduleParams params = new GetPaymentScheduleParams(paymentScheduleId);
        return this.executeGetPaymentScheduleAPICall(params).getData();
    }

    public PaymentSchedule getPaymentSchedule(String paymentScheduleId, List<String> expand) throws ApiException {
        GetPaymentScheduleParams params = new GetPaymentScheduleParams(paymentScheduleId);
        params.expand(expand);
        return this.executeGetPaymentScheduleAPICall(params).getData();
    }

    public PaymentSchedule getPaymentSchedule(String paymentScheduleId, List<String> expand, Headers headers) throws ApiException {
        GetPaymentScheduleParams params = new GetPaymentScheduleParams(paymentScheduleId).expand(expand).headers(headers);
        return this.executeGetPaymentScheduleAPICall(params).getData();
    }

    public PaymentSchedule get(GetPaymentScheduleParams params) throws ApiException {
        return this.executeGetPaymentScheduleAPICall(params).getData();
    }

    public ApiResponse<PaymentSchedule> getWithHttpInfo(GetPaymentScheduleParams params) throws ApiException {
        return this.executeGetPaymentScheduleAPICall(params);
    }

    ApiResponse<PaymentSchedule> executeGetPaymentScheduleAPICall(GetPaymentScheduleParams params) throws ApiException {
        return this.getPaymentScheduleWithHttpInfo(params.paymentScheduleId, params.fields, params.paymentScheduleFields, params.paymentScheduleItemFields, params.expand, params.filter, params.pageSize, params.zuoraTrackId, params.async, params.zuoraCacheEnabled, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraOrgIds);
    }

    private Call updatePaymentScheduleCall(String paymentScheduleId, PaymentSchedulePatchRequest paymentSchedulePatchRequest, List<String> fields, List<String> paymentScheduleFields, List<String> paymentScheduleItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        PaymentSchedulePatchRequest localVarPostBody = paymentSchedulePatchRequest;
        String localVarPath = "/payment_schedules/{payment_schedule_id}".replace("{payment_schedule_id}", this.localVarApiClient.escapeString(paymentScheduleId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (paymentScheduleFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "payment_schedule.fields[]", paymentScheduleFields));
        }
        if (paymentScheduleItemFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "payment_schedule_item.fields[]", paymentScheduleItemFields));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraCacheEnabled != null) {
            localVarHeaderParams.put("zuora-cache-enabled", this.localVarApiClient.parameterToString(zuoraCacheEnabled));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updatePaymentScheduleValidateBeforeCall(String paymentScheduleId, PaymentSchedulePatchRequest paymentSchedulePatchRequest, List<String> fields, List<String> paymentScheduleFields, List<String> paymentScheduleItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (paymentScheduleId == null) {
            throw new ApiException("Missing the required parameter 'paymentScheduleId' when calling updatePaymentSchedule(Async)");
        }
        if (paymentSchedulePatchRequest == null) {
            throw new ApiException("Missing the required parameter 'paymentSchedulePatchRequest' when calling updatePaymentSchedule(Async)");
        }
        return this.updatePaymentScheduleCall(paymentScheduleId, paymentSchedulePatchRequest, fields, paymentScheduleFields, paymentScheduleItemFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, _callback);
    }

    private ApiResponse<PaymentSchedule> updatePaymentScheduleWithHttpInfo(String paymentScheduleId, PaymentSchedulePatchRequest paymentSchedulePatchRequest, List<String> fields, List<String> paymentScheduleFields, List<String> paymentScheduleItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.updatePaymentScheduleValidateBeforeCall(paymentScheduleId, paymentSchedulePatchRequest, fields, paymentScheduleFields, paymentScheduleItemFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<PaymentSchedule>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call updatePaymentScheduleAsync(String paymentScheduleId, PaymentSchedulePatchRequest paymentSchedulePatchRequest, List<String> fields, List<String> paymentScheduleFields, List<String> paymentScheduleItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback<PaymentSchedule> _callback) throws ApiException {
        Call localVarCall = this.updatePaymentScheduleValidateBeforeCall(paymentScheduleId, paymentSchedulePatchRequest, fields, paymentScheduleFields, paymentScheduleItemFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<PaymentSchedule>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public UpdatePaymentScheduleParams updatePaymentScheduleParams(String paymentScheduleId, PaymentSchedulePatchRequest paymentSchedulePatchRequest) {
        return new UpdatePaymentScheduleParams(paymentScheduleId, paymentSchedulePatchRequest);
    }

    public PaymentSchedule updatePaymentSchedule(String paymentScheduleId, PaymentSchedulePatchRequest paymentSchedulePatchRequest) throws ApiException {
        UpdatePaymentScheduleParams params = new UpdatePaymentScheduleParams(paymentScheduleId, paymentSchedulePatchRequest);
        return this.executeUpdatePaymentScheduleAPICall(params).getData();
    }

    public PaymentSchedule updatePaymentSchedule(String paymentScheduleId, PaymentSchedulePatchRequest paymentSchedulePatchRequest, List<String> expand) throws ApiException {
        UpdatePaymentScheduleParams params = new UpdatePaymentScheduleParams(paymentScheduleId, paymentSchedulePatchRequest);
        params.expand(expand);
        return this.executeUpdatePaymentScheduleAPICall(params).getData();
    }

    public PaymentSchedule updatePaymentSchedule(String paymentScheduleId, PaymentSchedulePatchRequest paymentSchedulePatchRequest, List<String> expand, Headers headers) throws ApiException {
        UpdatePaymentScheduleParams params = new UpdatePaymentScheduleParams(paymentScheduleId, paymentSchedulePatchRequest).expand(expand).headers(headers);
        return this.executeUpdatePaymentScheduleAPICall(params).getData();
    }

    public PaymentSchedule update(UpdatePaymentScheduleParams params) throws ApiException {
        return this.executeUpdatePaymentScheduleAPICall(params).getData();
    }

    public ApiResponse<PaymentSchedule> updateWithHttpInfo(UpdatePaymentScheduleParams params) throws ApiException {
        return this.executeUpdatePaymentScheduleAPICall(params);
    }

    ApiResponse<PaymentSchedule> executeUpdatePaymentScheduleAPICall(UpdatePaymentScheduleParams params) throws ApiException {
        return this.updatePaymentScheduleWithHttpInfo(params.paymentScheduleId, params.paymentSchedulePatchRequest, params.fields, params.paymentScheduleFields, params.paymentScheduleItemFields, params.expand, params.filter, params.pageSize, params.zuoraTrackId, params.async, params.zuoraCacheEnabled, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraOrgIds);
    }

    public static class UpdatePaymentScheduleParams {
        private final String paymentScheduleId;
        private final PaymentSchedulePatchRequest paymentSchedulePatchRequest;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private List<String> fields;
        private List<String> paymentScheduleFields;
        private List<String> paymentScheduleItemFields;
        private List<String> expand;
        private List<String> filter;
        private Integer pageSize;
        private String zuoraTrackId;
        private Boolean async;
        private Boolean zuoraCacheEnabled;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraOrgIds;

        public UpdatePaymentScheduleParams(String paymentScheduleId, PaymentSchedulePatchRequest paymentSchedulePatchRequest) {
            this.paymentScheduleId = paymentScheduleId;
            this.paymentSchedulePatchRequest = paymentSchedulePatchRequest;
        }

        public UpdatePaymentScheduleParams getByIdQueryParams(GetByIdQueryParams getByIdQueryParams) {
            this.getByIdQueryParams = getByIdQueryParams;
            if (this.expand != null) {
                this.expand = getByIdQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = getByIdQueryParams.getFilter();
            }
            if (this.pageSize != null) {
                this.pageSize = getByIdQueryParams.getPageSize();
            }
            return this;
        }

        public UpdatePaymentScheduleParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraCacheEnabled() != null) {
                this.zuoraCacheEnabled = headers.getZuoraCacheEnabled();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public UpdatePaymentScheduleParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public UpdatePaymentScheduleParams paymentScheduleFields(List<String> paymentScheduleFields) {
            this.paymentScheduleFields = paymentScheduleFields;
            return this;
        }

        public UpdatePaymentScheduleParams paymentScheduleItemFields(List<String> paymentScheduleItemFields) {
            this.paymentScheduleItemFields = paymentScheduleItemFields;
            return this;
        }

        public UpdatePaymentScheduleParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public UpdatePaymentScheduleParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public UpdatePaymentScheduleParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }
    }

    public static class GetPaymentScheduleParams {
        private final String paymentScheduleId;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private List<String> fields;
        private List<String> paymentScheduleFields;
        private List<String> paymentScheduleItemFields;
        private List<String> expand;
        private List<String> filter;
        private Integer pageSize;
        private String zuoraTrackId;
        private Boolean async;
        private Boolean zuoraCacheEnabled;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraOrgIds;

        public GetPaymentScheduleParams(String paymentScheduleId) {
            this.paymentScheduleId = paymentScheduleId;
        }

        public GetPaymentScheduleParams getByIdQueryParams(GetByIdQueryParams getByIdQueryParams) {
            this.getByIdQueryParams = getByIdQueryParams;
            if (this.expand != null) {
                this.expand = getByIdQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = getByIdQueryParams.getFilter();
            }
            if (this.pageSize != null) {
                this.pageSize = getByIdQueryParams.getPageSize();
            }
            return this;
        }

        public GetPaymentScheduleParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraCacheEnabled() != null) {
                this.zuoraCacheEnabled = headers.getZuoraCacheEnabled();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public GetPaymentScheduleParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public GetPaymentScheduleParams paymentScheduleFields(List<String> paymentScheduleFields) {
            this.paymentScheduleFields = paymentScheduleFields;
            return this;
        }

        public GetPaymentScheduleParams paymentScheduleItemFields(List<String> paymentScheduleItemFields) {
            this.paymentScheduleItemFields = paymentScheduleItemFields;
            return this;
        }

        public GetPaymentScheduleParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public GetPaymentScheduleParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public GetPaymentScheduleParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }
    }

    public static class CreatePaymentScheduleParams {
        private final PaymentScheduleCreateRequest paymentScheduleCreateRequest;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private List<String> fields;
        private List<String> paymentScheduleFields;
        private List<String> paymentScheduleItemFields;
        private List<String> expand;
        private List<String> filter;
        private Integer pageSize;
        private String zuoraTrackId;
        private Boolean async;
        private Boolean zuoraCacheEnabled;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraOrgIds;

        public CreatePaymentScheduleParams(PaymentScheduleCreateRequest paymentScheduleCreateRequest) {
            this.paymentScheduleCreateRequest = paymentScheduleCreateRequest;
        }

        public CreatePaymentScheduleParams getByIdQueryParams(GetByIdQueryParams getByIdQueryParams) {
            this.getByIdQueryParams = getByIdQueryParams;
            if (this.expand != null) {
                this.expand = getByIdQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = getByIdQueryParams.getFilter();
            }
            if (this.pageSize != null) {
                this.pageSize = getByIdQueryParams.getPageSize();
            }
            return this;
        }

        public CreatePaymentScheduleParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraCacheEnabled() != null) {
                this.zuoraCacheEnabled = headers.getZuoraCacheEnabled();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public CreatePaymentScheduleParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public CreatePaymentScheduleParams paymentScheduleFields(List<String> paymentScheduleFields) {
            this.paymentScheduleFields = paymentScheduleFields;
            return this;
        }

        public CreatePaymentScheduleParams paymentScheduleItemFields(List<String> paymentScheduleItemFields) {
            this.paymentScheduleItemFields = paymentScheduleItemFields;
            return this;
        }

        public CreatePaymentScheduleParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public CreatePaymentScheduleParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public CreatePaymentScheduleParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }
    }

    public static class CancelPaymentScheduleParams {
        private final String paymentScheduleId;
        private final PaymentScheduleCancel paymentScheduleCancel;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private List<String> fields;
        private List<String> paymentScheduleFields;
        private List<String> paymentScheduleItemFields;
        private List<String> expand;
        private List<String> filter;
        private Integer pageSize;
        private String zuoraTrackId;
        private Boolean async;
        private Boolean zuoraCacheEnabled;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraOrgIds;

        public CancelPaymentScheduleParams(String paymentScheduleId, PaymentScheduleCancel paymentScheduleCancel) {
            this.paymentScheduleId = paymentScheduleId;
            this.paymentScheduleCancel = paymentScheduleCancel;
        }

        public CancelPaymentScheduleParams getByIdQueryParams(GetByIdQueryParams getByIdQueryParams) {
            this.getByIdQueryParams = getByIdQueryParams;
            if (this.expand != null) {
                this.expand = getByIdQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = getByIdQueryParams.getFilter();
            }
            if (this.pageSize != null) {
                this.pageSize = getByIdQueryParams.getPageSize();
            }
            return this;
        }

        public CancelPaymentScheduleParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraCacheEnabled() != null) {
                this.zuoraCacheEnabled = headers.getZuoraCacheEnabled();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public CancelPaymentScheduleParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public CancelPaymentScheduleParams paymentScheduleFields(List<String> paymentScheduleFields) {
            this.paymentScheduleFields = paymentScheduleFields;
            return this;
        }

        public CancelPaymentScheduleParams paymentScheduleItemFields(List<String> paymentScheduleItemFields) {
            this.paymentScheduleItemFields = paymentScheduleItemFields;
            return this;
        }

        public CancelPaymentScheduleParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public CancelPaymentScheduleParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public CancelPaymentScheduleParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }
    }
}

