/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.model;

import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

@JsonAdapter(value=Adapter.class)
public enum OrderStatusParameter {
    DRAFT("draft"),
    PENDING("pending"),
    COMPLETED("completed"),
    CANCELLED("cancelled"),
    SCHEDULED("scheduled"),
    EXECUTING("executing"),
    FAILED("failed"),
    ALL("all");

    private String value;

    private OrderStatusParameter(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static OrderStatusParameter fromValue(String value) {
        for (OrderStatusParameter b : OrderStatusParameter.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        String value = jsonElement.getAsString();
        OrderStatusParameter.fromValue(value);
    }

    public static class Adapter
    extends TypeAdapter<OrderStatusParameter> {
        public void write(JsonWriter jsonWriter, OrderStatusParameter enumeration) throws IOException {
            jsonWriter.value(enumeration.getValue());
        }

        public OrderStatusParameter read(JsonReader jsonReader) throws IOException {
            String value = jsonReader.nextString();
            return OrderStatusParameter.fromValue(value);
        }
    }
}

