/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.model;

import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

@JsonAdapter(value=Adapter.class)
public enum ListPriceBase {
    BILLING_PERIOD("Per Billing Period"),
    MONTH("Per Month"),
    WEEK("Per Week"),
    YEAR("Per Year"),
    SPECIFIC_MONTHS("Per Specific Months"),
    VALIDITY_PERIOD("Per Validity Period");

    private String value;

    private ListPriceBase(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ListPriceBase fromValue(String value) {
        for (ListPriceBase b : ListPriceBase.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        String value = jsonElement.getAsString();
        ListPriceBase.fromValue(value);
    }

    public static class Adapter
    extends TypeAdapter<ListPriceBase> {
        public void write(JsonWriter jsonWriter, ListPriceBase enumeration) throws IOException {
            jsonWriter.value(enumeration.getValue());
        }

        public ListPriceBase read(JsonReader jsonReader) throws IOException {
            String value = jsonReader.nextString();
            return ListPriceBase.fromValue(value);
        }
    }
}

