/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nullable;
import org.threeten.bp.LocalDate;

@ApiModel(description="The tax certificate information.")
public class TaxCertificate {
    public static final String SERIALIZED_NAME_COMPANY_CODE = "company_code";
    @SerializedName(value="company_code")
    private String companyCode;
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_START_DATE = "start_date";
    @SerializedName(value="start_date")
    private LocalDate startDate;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_ENTITY_USE_CODE = "entity_use_code";
    @SerializedName(value="entity_use_code")
    private String entityUseCode;
    public static final String SERIALIZED_NAME_END_DATE = "end_date";
    @SerializedName(value="end_date")
    private LocalDate endDate;
    public static final String SERIALIZED_NAME_ISSUING_JURISDICTION = "issuing_jurisdiction";
    @SerializedName(value="issuing_jurisdiction")
    private String issuingJurisdiction;
    public static final String SERIALIZED_NAME_STATE = "state";
    @SerializedName(value="state")
    private StateEnum state;
    public static final String SERIALIZED_NAME_TAX_IDENTIFIER = "tax_identifier";
    @SerializedName(value="tax_identifier")
    private String taxIdentifier;

    public TaxCertificate companyCode(String companyCode) {
        this.companyCode = companyCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="ABC", value="Unique code that identifies a company account in Avalara. Use this field to calculate taxes based on country of origin and sold-to addresses in Avalara.")
    public String getCompanyCode() {
        return this.companyCode;
    }

    public void setCompanyCode(String companyCode) {
        this.companyCode = companyCode;
    }

    public TaxCertificate id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Identifier of the tax exemption certificate.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public TaxCertificate startDate(LocalDate startDate) {
        this.startDate = startDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Sat Jan 01 00:00:00 GMT 2022", value="The tax certificate start date.")
    public LocalDate getStartDate() {
        return this.startDate;
    }

    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public TaxCertificate description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Description of the tax exemption certificate.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public TaxCertificate entityUseCode(String entityUseCode) {
        this.entityUseCode = entityUseCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A unique entity use code used by Avalara to apply exemptions. This field is required only when you choose Avalara as your tax engine. See [Exempt Transactions](https://developer.avalara.com/avatax/handling-tax-exempt-customers/) for more information.")
    public String getEntityUseCode() {
        return this.entityUseCode;
    }

    public void setEntityUseCode(String entityUseCode) {
        this.entityUseCode = entityUseCode;
    }

    public TaxCertificate endDate(LocalDate endDate) {
        this.endDate = endDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Sun Jan 01 00:00:00 GMT 2023", value="The tax certificate end date.")
    public LocalDate getEndDate() {
        return this.endDate;
    }

    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public TaxCertificate issuingJurisdiction(String issuingJurisdiction) {
        this.issuingJurisdiction = issuingJurisdiction;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Georgia", value="Typically, this is a state or government agency")
    public String getIssuingJurisdiction() {
        return this.issuingJurisdiction;
    }

    public void setIssuingJurisdiction(String issuingJurisdiction) {
        this.issuingJurisdiction = issuingJurisdiction;
    }

    public TaxCertificate state(StateEnum state) {
        this.state = state;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Status of the tax exemption certificate, indication whether the certificate has been verified.")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public TaxCertificate taxIdentifier(String taxIdentifier) {
        this.taxIdentifier = taxIdentifier;
        return this;
    }

    @Deprecated
    @Nullable
    @ApiModelProperty(example="DE123456789", value="Value Added Tax (VAT) ID. Each VAT ID must begin with the code of the country code and followed by a block of digits or characters.")
    public String getTaxIdentifier() {
        return this.taxIdentifier;
    }

    public void setTaxIdentifier(String taxIdentifier) {
        this.taxIdentifier = taxIdentifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaxCertificate taxCertificate = (TaxCertificate)o;
        return Objects.equals(this.companyCode, taxCertificate.companyCode) && Objects.equals(this.id, taxCertificate.id) && Objects.equals(this.startDate, taxCertificate.startDate) && Objects.equals(this.description, taxCertificate.description) && Objects.equals(this.entityUseCode, taxCertificate.entityUseCode) && Objects.equals(this.endDate, taxCertificate.endDate) && Objects.equals(this.issuingJurisdiction, taxCertificate.issuingJurisdiction) && Objects.equals((Object)this.state, (Object)taxCertificate.state) && Objects.equals(this.taxIdentifier, taxCertificate.taxIdentifier);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.companyCode, this.id, this.startDate, this.description, this.entityUseCode, this.endDate, this.issuingJurisdiction, this.state, this.taxIdentifier});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TaxCertificate {\n");
        sb.append("    companyCode: ").append(this.toIndentedString(this.companyCode)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    entityUseCode: ").append(this.toIndentedString(this.entityUseCode)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    issuingJurisdiction: ").append(this.toIndentedString(this.issuingJurisdiction)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    taxIdentifier: ").append(this.toIndentedString(this.taxIdentifier)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StateEnum {
        PENDING("pending"),
        VERIFIED("verified"),
        NOT_VALID("not_valid"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StateEnum fromValue(String value) {
            for (StateEnum b : StateEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<StateEnum> {
            public void write(JsonWriter jsonWriter, StateEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StateEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StateEnum.fromValue(value);
            }
        }
    }
}

