/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.client.JSON;
import org.openapitools.client.model.AccountCreateRequest;
import org.openapitools.client.model.Contact;
import org.openapitools.client.model.FlexibleBillingDocumentSettings;
import org.openapitools.client.model.ProcessingOptions;
import org.openapitools.client.model.StartOn;
import org.openapitools.client.model.SubscriptionPlanCreateRequest;
import org.openapitools.client.model.SubscriptionPreviewAccountRequest;
import org.openapitools.client.model.Term;
import org.openapitools.jackson.nullable.JsonNullable;
import org.threeten.bp.LocalDate;

public class SubscriptionPreviewRequest {
    public static final String SERIALIZED_NAME_INVOICE_OWNER_ACCOUNT_ID = "invoice_owner_account_id";
    @SerializedName(value="invoice_owner_account_id")
    private String invoiceOwnerAccountId;
    public static final String SERIALIZED_NAME_INVOICE_OWNER_ACCOUNT_NUMBER = "invoice_owner_account_number";
    @SerializedName(value="invoice_owner_account_number")
    private String invoiceOwnerAccountNumber;
    public static final String SERIALIZED_NAME_INVOICE_OWNER_ACCOUNT_DATA = "invoice_owner_account_data";
    @SerializedName(value="invoice_owner_account_data")
    private AccountCreateRequest invoiceOwnerAccountData;
    public static final String SERIALIZED_NAME_ACCOUNT_ID = "account_id";
    @SerializedName(value="account_id")
    private String accountId;
    public static final String SERIALIZED_NAME_ACCOUNT_NUMBER = "account_number";
    @SerializedName(value="account_number")
    private String accountNumber;
    public static final String SERIALIZED_NAME_ACCOUNT_DATA = "account_data";
    @SerializedName(value="account_data")
    private SubscriptionPreviewAccountRequest accountData;
    public static final String SERIALIZED_NAME_AUTO_RENEW = "auto_renew";
    @SerializedName(value="auto_renew")
    private Boolean autoRenew;
    public static final String SERIALIZED_NAME_SUBSCRIPTION_NUMBER = "subscription_number";
    @SerializedName(value="subscription_number")
    private String subscriptionNumber;
    public static final String SERIALIZED_NAME_INITIAL_TERM = "initial_term";
    @SerializedName(value="initial_term")
    private Term initialTerm;
    public static final String SERIALIZED_NAME_RENEWAL_TERM = "renewal_term";
    @SerializedName(value="renewal_term")
    private Term renewalTerm;
    public static final String SERIALIZED_NAME_START_ON = "start_on";
    @SerializedName(value="start_on")
    private StartOn startOn;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_INVOICE_SEPARATELY = "invoice_separately";
    @SerializedName(value="invoice_separately")
    private Boolean invoiceSeparately;
    public static final String SERIALIZED_NAME_PROCESSING_OPTIONS = "processing_options";
    @SerializedName(value="processing_options")
    private ProcessingOptions processingOptions;
    public static final String SERIALIZED_NAME_CUSTOM_FIELDS = "custom_fields";
    @SerializedName(value="custom_fields")
    @JsonAdapter(value=JSON.CustomFieldAdapter.class)
    private Map<String, Object> customFields = null;
    public static final String SERIALIZED_NAME_SUBSCRIPTION_PLANS = "subscription_plans";
    @SerializedName(value="subscription_plans")
    private List<SubscriptionPlanCreateRequest> subscriptionPlans = null;
    public static final String SERIALIZED_NAME_BILL_TO_ID = "bill_to_id";
    @SerializedName(value="bill_to_id")
    @JsonAdapter(value=JSON.NullableFieldAdapter.class)
    private String billToId;
    public static final String SERIALIZED_NAME_PAYMENT_TERMS = "payment_terms";
    @SerializedName(value="payment_terms")
    @JsonAdapter(value=JSON.NullableFieldAdapter.class)
    private String paymentTerms;
    public static final String SERIALIZED_NAME_BILL_TO = "bill_to";
    @SerializedName(value="bill_to")
    private Contact billTo;
    public static final String SERIALIZED_NAME_BILLING_DOCUMENT_SETTINGS = "billing_document_settings";
    @SerializedName(value="billing_document_settings")
    private FlexibleBillingDocumentSettings billingDocumentSettings;
    public static final String SERIALIZED_NAME_SOLD_TO_ID = "sold_to_id";
    @SerializedName(value="sold_to_id")
    @JsonAdapter(value=JSON.NullableFieldAdapter.class)
    private String soldToId;
    public static final String SERIALIZED_NAME_SOLD_TO = "sold_to";
    @SerializedName(value="sold_to")
    private Contact soldTo;
    public static final String SERIALIZED_NAME_CURRENCY = "currency";
    @SerializedName(value="currency")
    private String currency;
    public static final String SERIALIZED_NAME_CHANGE_REASON = "change_reason";
    @SerializedName(value="change_reason")
    private String changeReason;
    public static final String SERIALIZED_NAME_NUMBER_OF_PERIODS = "number_of_periods";
    @SerializedName(value="number_of_periods")
    private Integer numberOfPeriods;
    public static final String SERIALIZED_NAME_TERM_END = "term_end";
    @SerializedName(value="term_end")
    private Boolean termEnd;
    public static final String SERIALIZED_NAME_METRICS = "metrics";
    @SerializedName(value="metrics")
    private List<MetricsEnum> metrics = null;
    public static final String SERIALIZED_NAME_END_DATE = "end_date";
    @SerializedName(value="end_date")
    private LocalDate endDate;

    public SubscriptionPreviewRequest() {
    }

    public SubscriptionPreviewRequest(Contact billTo, Contact soldTo) {
        this();
        this.billTo = billTo;
        this.soldTo = soldTo;
    }

    public SubscriptionPreviewRequest invoiceOwnerAccountId(String invoiceOwnerAccountId) {
        this.invoiceOwnerAccountId = invoiceOwnerAccountId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Identifier of the account that owns the invoice associated with this subscription. If you specify this field, do not specify `invoice_owner_account_data`.")
    public String getInvoiceOwnerAccountId() {
        return this.invoiceOwnerAccountId;
    }

    public void setInvoiceOwnerAccountId(String invoiceOwnerAccountId) {
        this.invoiceOwnerAccountId = invoiceOwnerAccountId;
    }

    public SubscriptionPreviewRequest invoiceOwnerAccountNumber(String invoiceOwnerAccountNumber) {
        this.invoiceOwnerAccountNumber = invoiceOwnerAccountNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Identifier of the account that owns the invoice associated with this subscription. If you specify this field, do not specify `invoice_owner_account_data`.")
    public String getInvoiceOwnerAccountNumber() {
        return this.invoiceOwnerAccountNumber;
    }

    public void setInvoiceOwnerAccountNumber(String invoiceOwnerAccountNumber) {
        this.invoiceOwnerAccountNumber = invoiceOwnerAccountNumber;
    }

    public SubscriptionPreviewRequest invoiceOwnerAccountData(AccountCreateRequest invoiceOwnerAccountData) {
        this.invoiceOwnerAccountData = invoiceOwnerAccountData;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The information of the new account that owns the invoice associated with this subscription. If you specify this field, do not specify `invoice_owner_account_id`.")
    public AccountCreateRequest getInvoiceOwnerAccountData() {
        return this.invoiceOwnerAccountData;
    }

    public void setInvoiceOwnerAccountData(AccountCreateRequest invoiceOwnerAccountData) {
        this.invoiceOwnerAccountData = invoiceOwnerAccountData;
    }

    public SubscriptionPreviewRequest accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Identifier of the account that owns the subscription. Subscription owner account can be different from the invoice owner account. If you specify this field, do not specify `account_data`.")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public SubscriptionPreviewRequest accountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Identifier of the account that owns the subscription. Subscription owner account can be different from the invoice owner account. If you specify this field, do not specify `account_data`.")
    public String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public SubscriptionPreviewRequest accountData(SubscriptionPreviewAccountRequest accountData) {
        this.accountData = accountData;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public SubscriptionPreviewAccountRequest getAccountData() {
        return this.accountData;
    }

    public void setAccountData(SubscriptionPreviewAccountRequest accountData) {
        this.accountData = accountData;
    }

    public SubscriptionPreviewRequest autoRenew(Boolean autoRenew) {
        this.autoRenew = autoRenew;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If true, the subscription automatically renews at the end of the current term.")
    public Boolean getAutoRenew() {
        return this.autoRenew;
    }

    public void setAutoRenew(Boolean autoRenew) {
        this.autoRenew = autoRenew;
    }

    public SubscriptionPreviewRequest subscriptionNumber(String subscriptionNumber) {
        this.subscriptionNumber = subscriptionNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Human-readable identifier of the subscription; maybe user-supplied.")
    public String getSubscriptionNumber() {
        return this.subscriptionNumber;
    }

    public void setSubscriptionNumber(String subscriptionNumber) {
        this.subscriptionNumber = subscriptionNumber;
    }

    public SubscriptionPreviewRequest initialTerm(Term initialTerm) {
        this.initialTerm = initialTerm;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Initial term information for the subscription.")
    public Term getInitialTerm() {
        return this.initialTerm;
    }

    public void setInitialTerm(Term initialTerm) {
        this.initialTerm = initialTerm;
    }

    public SubscriptionPreviewRequest renewalTerm(Term renewalTerm) {
        this.renewalTerm = renewalTerm;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Renewal term information for the subscription")
    public Term getRenewalTerm() {
        return this.renewalTerm;
    }

    public void setRenewalTerm(Term renewalTerm) {
        this.renewalTerm = renewalTerm;
    }

    public SubscriptionPreviewRequest startOn(StartOn startOn) {
        this.startOn = startOn;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public StartOn getStartOn() {
        return this.startOn;
    }

    public void setStartOn(StartOn startOn) {
        this.startOn = startOn;
    }

    public SubscriptionPreviewRequest description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Description of the subscription. Often useful for displaying to users.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public SubscriptionPreviewRequest invoiceSeparately(Boolean invoiceSeparately) {
        this.invoiceSeparately = invoiceSeparately;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Separates a single subscription from other subscriptions and creates an invoice for this subscription. If the value is `true`, the subscription is billed separately from other subscriptions. If the value is `false`, the subscription is included with other subscriptions in the account invoice.")
    public Boolean getInvoiceSeparately() {
        return this.invoiceSeparately;
    }

    public void setInvoiceSeparately(Boolean invoiceSeparately) {
        this.invoiceSeparately = invoiceSeparately;
    }

    public SubscriptionPreviewRequest processingOptions(ProcessingOptions processingOptions) {
        this.processingOptions = processingOptions;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ProcessingOptions getProcessingOptions() {
        return this.processingOptions;
    }

    public void setProcessingOptions(ProcessingOptions processingOptions) {
        this.processingOptions = processingOptions;
    }

    public SubscriptionPreviewRequest customFields(Map<String, Object> customFields) {
        this.customFields = customFields;
        return this;
    }

    public SubscriptionPreviewRequest putCustomFieldsItem(String key, Object customFieldsItem) {
        if (this.customFields == null) {
            this.customFields = new HashMap<String, Object>();
        }
        this.customFields.put(key, customFieldsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Set of user-defined fields associated with this object. Useful for storing additional information about the object in a structured format.")
    public Map<String, Object> getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(Map<String, Object> customFields) {
        this.customFields = customFields;
    }

    public SubscriptionPreviewRequest subscriptionPlans(List<SubscriptionPlanCreateRequest> subscriptionPlans) {
        this.subscriptionPlans = subscriptionPlans;
        return this;
    }

    public SubscriptionPreviewRequest addSubscriptionPlansItem(SubscriptionPlanCreateRequest subscriptionPlansItem) {
        if (this.subscriptionPlans == null) {
            this.subscriptionPlans = new ArrayList<SubscriptionPlanCreateRequest>();
        }
        this.subscriptionPlans.add(subscriptionPlansItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The plans associated with the new subscription.")
    public List<SubscriptionPlanCreateRequest> getSubscriptionPlans() {
        return this.subscriptionPlans;
    }

    public void setSubscriptionPlans(List<SubscriptionPlanCreateRequest> subscriptionPlans) {
        this.subscriptionPlans = subscriptionPlans;
    }

    public SubscriptionPreviewRequest billToId(String billToId) {
        this.billToId = billToId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2c92c0f86a8dd422016a9e7a70116b0d", value="ID of the bill-to contact.")
    public String getBillToId() {
        return this.billToId;
    }

    public void setBillToId(String billToId) {
        this.billToId = billToId;
    }

    public SubscriptionPreviewRequest paymentTerms(String paymentTerms) {
        this.paymentTerms = paymentTerms;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of payment term associated with the invoice.")
    public String getPaymentTerms() {
        return this.paymentTerms;
    }

    public void setPaymentTerms(String paymentTerms) {
        this.paymentTerms = paymentTerms;
    }

    @Nullable
    @ApiModelProperty(value="The billing address for the customer.")
    public Contact getBillTo() {
        return this.billTo;
    }

    public SubscriptionPreviewRequest billingDocumentSettings(FlexibleBillingDocumentSettings billingDocumentSettings) {
        this.billingDocumentSettings = billingDocumentSettings;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The billing document settings for the customer.")
    public FlexibleBillingDocumentSettings getBillingDocumentSettings() {
        return this.billingDocumentSettings;
    }

    public void setBillingDocumentSettings(FlexibleBillingDocumentSettings billingDocumentSettings) {
        this.billingDocumentSettings = billingDocumentSettings;
    }

    public SubscriptionPreviewRequest soldToId(String soldToId) {
        this.soldToId = soldToId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2c92c0f86a8dd422016a9e7a70116b0d", value="ID of the sold-to contact.")
    public String getSoldToId() {
        return this.soldToId;
    }

    public void setSoldToId(String soldToId) {
        this.soldToId = soldToId;
    }

    @Nullable
    @ApiModelProperty(value="The selling address for the customer.")
    public Contact getSoldTo() {
        return this.soldTo;
    }

    public SubscriptionPreviewRequest currency(String currency) {
        this.currency = currency;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="3-letter ISO 4217 currency code. This field is available only if you have the [Multiple Currencies](https://knowledgecenter.zuora.com/Zuora_Billing/Bill_your_customers/Flexible_Billing/Multiple_Currencies) feature enabled.")
    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public SubscriptionPreviewRequest changeReason(String changeReason) {
        this.changeReason = changeReason;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A brief description of the reason for this change.")
    public String getChangeReason() {
        return this.changeReason;
    }

    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }

    public SubscriptionPreviewRequest numberOfPeriods(Integer numberOfPeriods) {
        this.numberOfPeriods = numberOfPeriods;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specifies how many billing periods you want to preview.")
    public Integer getNumberOfPeriods() {
        return this.numberOfPeriods;
    }

    public void setNumberOfPeriods(Integer numberOfPeriods) {
        this.numberOfPeriods = numberOfPeriods;
    }

    public SubscriptionPreviewRequest termEnd(Boolean termEnd) {
        this.termEnd = termEnd;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates whether to preview the subscription till the end of the current term.")
    public Boolean getTermEnd() {
        return this.termEnd;
    }

    public void setTermEnd(Boolean termEnd) {
        this.termEnd = termEnd;
    }

    public SubscriptionPreviewRequest metrics(List<MetricsEnum> metrics) {
        this.metrics = metrics;
        return this;
    }

    public SubscriptionPreviewRequest addMetricsItem(MetricsEnum metricsItem) {
        if (this.metrics == null) {
            this.metrics = new ArrayList<MetricsEnum>();
        }
        this.metrics.add(metricsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specifies the metrics you want to preview.    You can preivew metrics of billing documents, the order delta metrics, or both.")
    public List<MetricsEnum> getMetrics() {
        return this.metrics;
    }

    public void setMetrics(List<MetricsEnum> metrics) {
        this.metrics = metrics;
    }

    public SubscriptionPreviewRequest endDate(LocalDate endDate) {
        this.endDate = endDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="End date of the period for which you want to preview the subscription")
    public LocalDate getEndDate() {
        return this.endDate;
    }

    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubscriptionPreviewRequest subscriptionPreviewRequest = (SubscriptionPreviewRequest)o;
        return Objects.equals(this.invoiceOwnerAccountId, subscriptionPreviewRequest.invoiceOwnerAccountId) && Objects.equals(this.invoiceOwnerAccountNumber, subscriptionPreviewRequest.invoiceOwnerAccountNumber) && Objects.equals(this.invoiceOwnerAccountData, subscriptionPreviewRequest.invoiceOwnerAccountData) && Objects.equals(this.accountId, subscriptionPreviewRequest.accountId) && Objects.equals(this.accountNumber, subscriptionPreviewRequest.accountNumber) && Objects.equals(this.accountData, subscriptionPreviewRequest.accountData) && Objects.equals(this.autoRenew, subscriptionPreviewRequest.autoRenew) && Objects.equals(this.subscriptionNumber, subscriptionPreviewRequest.subscriptionNumber) && Objects.equals(this.initialTerm, subscriptionPreviewRequest.initialTerm) && Objects.equals(this.renewalTerm, subscriptionPreviewRequest.renewalTerm) && Objects.equals(this.startOn, subscriptionPreviewRequest.startOn) && Objects.equals(this.description, subscriptionPreviewRequest.description) && Objects.equals(this.invoiceSeparately, subscriptionPreviewRequest.invoiceSeparately) && Objects.equals(this.processingOptions, subscriptionPreviewRequest.processingOptions) && Objects.equals(this.customFields, subscriptionPreviewRequest.customFields) && Objects.equals(this.subscriptionPlans, subscriptionPreviewRequest.subscriptionPlans) && Objects.equals(this.billToId, subscriptionPreviewRequest.billToId) && Objects.equals(this.paymentTerms, subscriptionPreviewRequest.paymentTerms) && Objects.equals(this.billTo, subscriptionPreviewRequest.billTo) && Objects.equals(this.billingDocumentSettings, subscriptionPreviewRequest.billingDocumentSettings) && Objects.equals(this.soldToId, subscriptionPreviewRequest.soldToId) && Objects.equals(this.soldTo, subscriptionPreviewRequest.soldTo) && Objects.equals(this.currency, subscriptionPreviewRequest.currency) && Objects.equals(this.changeReason, subscriptionPreviewRequest.changeReason) && Objects.equals(this.numberOfPeriods, subscriptionPreviewRequest.numberOfPeriods) && Objects.equals(this.termEnd, subscriptionPreviewRequest.termEnd) && Objects.equals(this.metrics, subscriptionPreviewRequest.metrics) && Objects.equals(this.endDate, subscriptionPreviewRequest.endDate);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(this.invoiceOwnerAccountId, this.invoiceOwnerAccountNumber, this.invoiceOwnerAccountData, this.accountId, this.accountNumber, this.accountData, this.autoRenew, this.subscriptionNumber, this.initialTerm, this.renewalTerm, this.startOn, this.description, this.invoiceSeparately, this.processingOptions, this.customFields, this.subscriptionPlans, this.billToId, this.paymentTerms, this.billTo, this.billingDocumentSettings, this.soldToId, this.soldTo, this.currency, this.changeReason, this.numberOfPeriods, this.termEnd, this.metrics, this.endDate);
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SubscriptionPreviewRequest {\n");
        sb.append("    invoiceOwnerAccountId: ").append(this.toIndentedString(this.invoiceOwnerAccountId)).append("\n");
        sb.append("    invoiceOwnerAccountNumber: ").append(this.toIndentedString(this.invoiceOwnerAccountNumber)).append("\n");
        sb.append("    invoiceOwnerAccountData: ").append(this.toIndentedString(this.invoiceOwnerAccountData)).append("\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    accountNumber: ").append(this.toIndentedString(this.accountNumber)).append("\n");
        sb.append("    accountData: ").append(this.toIndentedString(this.accountData)).append("\n");
        sb.append("    autoRenew: ").append(this.toIndentedString(this.autoRenew)).append("\n");
        sb.append("    subscriptionNumber: ").append(this.toIndentedString(this.subscriptionNumber)).append("\n");
        sb.append("    initialTerm: ").append(this.toIndentedString(this.initialTerm)).append("\n");
        sb.append("    renewalTerm: ").append(this.toIndentedString(this.renewalTerm)).append("\n");
        sb.append("    startOn: ").append(this.toIndentedString(this.startOn)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    invoiceSeparately: ").append(this.toIndentedString(this.invoiceSeparately)).append("\n");
        sb.append("    processingOptions: ").append(this.toIndentedString(this.processingOptions)).append("\n");
        sb.append("    customFields: ").append(this.toIndentedString(this.customFields)).append("\n");
        sb.append("    subscriptionPlans: ").append(this.toIndentedString(this.subscriptionPlans)).append("\n");
        sb.append("    billToId: ").append(this.toIndentedString(this.billToId)).append("\n");
        sb.append("    paymentTerms: ").append(this.toIndentedString(this.paymentTerms)).append("\n");
        sb.append("    billTo: ").append(this.toIndentedString(this.billTo)).append("\n");
        sb.append("    billingDocumentSettings: ").append(this.toIndentedString(this.billingDocumentSettings)).append("\n");
        sb.append("    soldToId: ").append(this.toIndentedString(this.soldToId)).append("\n");
        sb.append("    soldTo: ").append(this.toIndentedString(this.soldTo)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    changeReason: ").append(this.toIndentedString(this.changeReason)).append("\n");
        sb.append("    numberOfPeriods: ").append(this.toIndentedString(this.numberOfPeriods)).append("\n");
        sb.append("    termEnd: ").append(this.toIndentedString(this.termEnd)).append("\n");
        sb.append("    metrics: ").append(this.toIndentedString(this.metrics)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum MetricsEnum {
        BILLING_DOCUMENTS("billing_documents"),
        DELTA_METRICS("delta_metrics"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private MetricsEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static MetricsEnum fromValue(String value) {
            for (MetricsEnum b : MetricsEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<MetricsEnum> {
            public void write(JsonWriter jsonWriter, MetricsEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public MetricsEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return MetricsEnum.fromValue(value);
            }
        }
    }
}

