/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.client.JSON;
import org.openapitools.client.model.ItemTier;
import org.openapitools.client.model.Overage;
import org.openapitools.client.model.Price;
import org.openapitools.client.model.Recurring;
import org.openapitools.client.model.SubscriptionPlan;
import org.threeten.bp.LocalDate;
import org.threeten.bp.OffsetDateTime;

@ApiModel(description="Subscription item information.")
public class SubscriptionItem {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_UPDATED_BY_ID = "updated_by_id";
    @SerializedName(value="updated_by_id")
    private String updatedById;
    public static final String SERIALIZED_NAME_UPDATED_TIME = "updated_time";
    @SerializedName(value="updated_time")
    private OffsetDateTime updatedTime;
    public static final String SERIALIZED_NAME_CREATED_BY_ID = "created_by_id";
    @SerializedName(value="created_by_id")
    private String createdById;
    public static final String SERIALIZED_NAME_CREATED_TIME = "created_time";
    @SerializedName(value="created_time")
    private OffsetDateTime createdTime;
    public static final String SERIALIZED_NAME_CUSTOM_FIELDS = "custom_fields";
    @SerializedName(value="custom_fields")
    @JsonAdapter(value=JSON.CustomFieldAdapter.class)
    private Map<String, Object> customFields = null;
    public static final String SERIALIZED_NAME_CUSTOM_OBJECTS = "custom_objects";
    @SerializedName(value="custom_objects")
    private Map<String, Object> customObjects = null;
    public static final String SERIALIZED_NAME_SUBSCRIPTION_ITEM_NUMBER = "subscription_item_number";
    @SerializedName(value="subscription_item_number")
    private String subscriptionItemNumber;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_PRODUCT_ID = "product_id";
    @SerializedName(value="product_id")
    private String productId;
    public static final String SERIALIZED_NAME_CHARGED_THROUGH_DATE = "charged_through_date";
    @SerializedName(value="charged_through_date")
    private LocalDate chargedThroughDate;
    public static final String SERIALIZED_NAME_RECURRING = "recurring";
    @SerializedName(value="recurring")
    private Recurring recurring;
    public static final String SERIALIZED_NAME_ACTIVE = "active";
    @SerializedName(value="active")
    private Boolean active;
    public static final String SERIALIZED_NAME_STATE = "state";
    @SerializedName(value="state")
    private StateEnum state;
    public static final String SERIALIZED_NAME_START_EVENT = "start_event";
    @SerializedName(value="start_event")
    private StartEventEnum startEvent;
    public static final String SERIALIZED_NAME_TIERS_MODE = "tiers_mode";
    @SerializedName(value="tiers_mode")
    private TiersModeEnum tiersMode;
    public static final String SERIALIZED_NAME_TIERS = "tiers";
    @SerializedName(value="tiers")
    private List<ItemTier> tiers = null;
    public static final String SERIALIZED_NAME_TAX_CODE = "tax_code";
    @SerializedName(value="tax_code")
    private String taxCode;
    public static final String SERIALIZED_NAME_TAX_INCLUSIVE = "tax_inclusive";
    @SerializedName(value="tax_inclusive")
    private Boolean taxInclusive;
    public static final String SERIALIZED_NAME_UNIT_OF_MEASURE = "unit_of_measure";
    @SerializedName(value="unit_of_measure")
    private String unitOfMeasure;
    public static final String SERIALIZED_NAME_QUANTITY = "quantity";
    @SerializedName(value="quantity")
    private BigDecimal quantity;
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private BigDecimal amount;
    public static final String SERIALIZED_NAME_UNIT_AMOUNT = "unit_amount";
    @SerializedName(value="unit_amount")
    private BigDecimal unitAmount;
    public static final String SERIALIZED_NAME_DISCOUNT_AMOUNT = "discount_amount";
    @SerializedName(value="discount_amount")
    private BigDecimal discountAmount;
    public static final String SERIALIZED_NAME_DISCOUNT_PERCENT = "discount_percent";
    @SerializedName(value="discount_percent")
    private BigDecimal discountPercent;
    public static final String SERIALIZED_NAME_APPLY_DISCOUNT_TO = "apply_discount_to";
    @SerializedName(value="apply_discount_to")
    private List<ApplyDiscountToEnum> applyDiscountTo = null;
    public static final String SERIALIZED_NAME_DISCOUNT_LEVEL = "discount_level";
    @SerializedName(value="discount_level")
    private DiscountLevelEnum discountLevel;
    public static final String SERIALIZED_NAME_PRICE_BASE_INTERVAL = "price_base_interval";
    @SerializedName(value="price_base_interval")
    private PriceBaseIntervalEnum priceBaseInterval;
    public static final String SERIALIZED_NAME_OVERAGE = "overage";
    @SerializedName(value="overage")
    private Overage overage;
    public static final String SERIALIZED_NAME_CHARGE_MODEL = "charge_model";
    @SerializedName(value="charge_model")
    private String chargeModel;
    public static final String SERIALIZED_NAME_CHARGE_TYPE = "charge_type";
    @SerializedName(value="charge_type")
    private String chargeType;
    public static final String SERIALIZED_NAME_PRICE_ID = "price_id";
    @SerializedName(value="price_id")
    private String priceId;
    public static final String SERIALIZED_NAME_PRICE = "price";
    @SerializedName(value="price")
    private Price price;
    public static final String SERIALIZED_NAME_SUBSCRIPTION_PLAN_ID = "subscription_plan_id";
    @SerializedName(value="subscription_plan_id")
    private String subscriptionPlanId;
    public static final String SERIALIZED_NAME_SUBSCRIPTION_PLAN = "subscription_plan";
    @SerializedName(value="subscription_plan")
    private SubscriptionPlan subscriptionPlan;
    public static final String SERIALIZED_NAME_START_DATE = "start_date";
    @SerializedName(value="start_date")
    private LocalDate startDate;
    public static final String SERIALIZED_NAME_END_DATE = "end_date";
    @SerializedName(value="end_date")
    private LocalDate endDate;
    public static final String SERIALIZED_NAME_PROCESSED_THROUGH_DATE = "processed_through_date";
    @SerializedName(value="processed_through_date")
    private LocalDate processedThroughDate;

    public SubscriptionItem() {
    }

    public SubscriptionItem(String id, String updatedById, OffsetDateTime updatedTime, String createdById, OffsetDateTime createdTime, Map<String, Object> customObjects, LocalDate startDate, LocalDate endDate, LocalDate processedThroughDate) {
        this();
        this.id = id;
        this.updatedById = updatedById;
        this.updatedTime = updatedTime;
        this.createdById = createdById;
        this.createdTime = createdTime;
        this.customObjects = customObjects;
        this.startDate = startDate;
        this.endDate = endDate;
        this.processedThroughDate = processedThroughDate;
    }

    @Nullable
    @ApiModelProperty(value="Unique identifier for the object.")
    public String getId() {
        return this.id;
    }

    @Nullable
    @ApiModelProperty(value="Unique identifier of the Zuora user who last updated the object")
    public String getUpdatedById() {
        return this.updatedById;
    }

    @Nullable
    @ApiModelProperty(value="The date and time when the object was last updated in ISO 8601 UTC format.")
    public OffsetDateTime getUpdatedTime() {
        return this.updatedTime;
    }

    @Nullable
    @ApiModelProperty(value="Unique identifier of the Zuora user who created the object")
    public String getCreatedById() {
        return this.createdById;
    }

    @Nullable
    @ApiModelProperty(value="The date and time when the object was created in ISO 8601 UTC format.")
    public OffsetDateTime getCreatedTime() {
        return this.createdTime;
    }

    public SubscriptionItem customFields(Map<String, Object> customFields) {
        this.customFields = customFields;
        return this;
    }

    public SubscriptionItem putCustomFieldsItem(String key, Object customFieldsItem) {
        if (this.customFields == null) {
            this.customFields = new HashMap<String, Object>();
        }
        this.customFields.put(key, customFieldsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Set of user-defined fields associated with this object. Useful for storing additional information about the object in a structured format.")
    public Map<String, Object> getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(Map<String, Object> customFields) {
        this.customFields = customFields;
    }

    @Nullable
    @ApiModelProperty(value="The custom objects associated with a Zuora standard object.")
    public Map<String, Object> getCustomObjects() {
        return this.customObjects;
    }

    public SubscriptionItem subscriptionItemNumber(String subscriptionItemNumber) {
        this.subscriptionItemNumber = subscriptionItemNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Human-readable identifier of the subscription item. It can be user-supplied.")
    public String getSubscriptionItemNumber() {
        return this.subscriptionItemNumber;
    }

    public void setSubscriptionItemNumber(String subscriptionItemNumber) {
        this.subscriptionItemNumber = subscriptionItemNumber;
    }

    public SubscriptionItem name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of the subscription item.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SubscriptionItem description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An arbitrary string attached to the object. Often useful for displaying to users.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public SubscriptionItem productId(String productId) {
        this.productId = productId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Identifier of the product with which this subscription is associated.")
    public String getProductId() {
        return this.productId;
    }

    public void setProductId(String productId) {
        this.productId = productId;
    }

    public SubscriptionItem chargedThroughDate(LocalDate chargedThroughDate) {
        this.chargedThroughDate = chargedThroughDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The date through which a customer has been billed for the subscription item.")
    public LocalDate getChargedThroughDate() {
        return this.chargedThroughDate;
    }

    public void setChargedThroughDate(LocalDate chargedThroughDate) {
        this.chargedThroughDate = chargedThroughDate;
    }

    public SubscriptionItem recurring(Recurring recurring) {
        this.recurring = recurring;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Recurring getRecurring() {
        return this.recurring;
    }

    public void setRecurring(Recurring recurring) {
        this.recurring = recurring;
    }

    public SubscriptionItem active(Boolean active) {
        this.active = active;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates whether the price is active and can be used for new purchases.")
    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public SubscriptionItem state(StateEnum state) {
        this.state = state;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Based on the current date to populate a state field with the enumeration: [inactive, active, expired] where inactive would represent charge segments with a start_date in the future and expired charge segments with an end_date in the past.")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public SubscriptionItem startEvent(StartEventEnum startEvent) {
        this.startEvent = startEvent;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specifies when to start billing your customer.")
    public StartEventEnum getStartEvent() {
        return this.startEvent;
    }

    public void setStartEvent(StartEventEnum startEvent) {
        this.startEvent = startEvent;
    }

    public SubscriptionItem tiersMode(TiersModeEnum tiersMode) {
        this.tiersMode = tiersMode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specifies the kind of tiering.")
    public TiersModeEnum getTiersMode() {
        return this.tiersMode;
    }

    public void setTiersMode(TiersModeEnum tiersMode) {
        this.tiersMode = tiersMode;
    }

    public SubscriptionItem tiers(List<ItemTier> tiers) {
        this.tiers = tiers;
        return this;
    }

    public SubscriptionItem addTiersItem(ItemTier tiersItem) {
        if (this.tiers == null) {
            this.tiers = new ArrayList<ItemTier>();
        }
        this.tiers.add(tiersItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<ItemTier> getTiers() {
        return this.tiers;
    }

    public void setTiers(List<ItemTier> tiers) {
        this.tiers = tiers;
    }

    public SubscriptionItem taxCode(String taxCode) {
        this.taxCode = taxCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A tax code identifier. If the `tax_code` of a price is not provided when you create or override a price, Zuora will treat the charged amount as non-taxable. If this code is provide, Zuora considers that this price is taxable and the charged amount will be handled accordingly.")
    public String getTaxCode() {
        return this.taxCode;
    }

    public void setTaxCode(String taxCode) {
        this.taxCode = taxCode;
    }

    public SubscriptionItem taxInclusive(Boolean taxInclusive) {
        this.taxInclusive = taxInclusive;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If this field is set to `true`, it indicates that amounts are inclusive of tax.")
    public Boolean getTaxInclusive() {
        return this.taxInclusive;
    }

    public void setTaxInclusive(Boolean taxInclusive) {
        this.taxInclusive = taxInclusive;
    }

    public SubscriptionItem unitOfMeasure(String unitOfMeasure) {
        this.unitOfMeasure = unitOfMeasure;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A configured unit of measure. This field is required for per-unit prices.")
    public String getUnitOfMeasure() {
        return this.unitOfMeasure;
    }

    public void setUnitOfMeasure(String unitOfMeasure) {
        this.unitOfMeasure = unitOfMeasure;
    }

    public SubscriptionItem quantity(BigDecimal quantity) {
        this.quantity = quantity;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Quantity of the product to which your customers subscribe.")
    public BigDecimal getQuantity() {
        return this.quantity;
    }

    public void setQuantity(BigDecimal quantity) {
        this.quantity = quantity;
    }

    public SubscriptionItem amount(BigDecimal amount) {
        this.amount = amount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The amount of the price. Specify this field if you want to override the original price with a flat-fee price")
    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public SubscriptionItem unitAmount(BigDecimal unitAmount) {
        this.unitAmount = unitAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The unit amount of the price. Specify this field if you want to override the original price with a per-unit price.")
    public BigDecimal getUnitAmount() {
        return this.unitAmount;
    }

    public void setUnitAmount(BigDecimal unitAmount) {
        this.unitAmount = unitAmount;
    }

    public SubscriptionItem discountAmount(BigDecimal discountAmount) {
        this.discountAmount = discountAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Discount amount. Specify this field if you offer an amount-based discount.")
    public BigDecimal getDiscountAmount() {
        return this.discountAmount;
    }

    public void setDiscountAmount(BigDecimal discountAmount) {
        this.discountAmount = discountAmount;
    }

    public SubscriptionItem discountPercent(BigDecimal discountPercent) {
        this.discountPercent = discountPercent;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Discount percent. Specify this field if you offer a percentage-based discount.")
    public BigDecimal getDiscountPercent() {
        return this.discountPercent;
    }

    public void setDiscountPercent(BigDecimal discountPercent) {
        this.discountPercent = discountPercent;
    }

    public SubscriptionItem applyDiscountTo(List<ApplyDiscountToEnum> applyDiscountTo) {
        this.applyDiscountTo = applyDiscountTo;
        return this;
    }

    public SubscriptionItem addApplyDiscountToItem(ApplyDiscountToEnum applyDiscountToItem) {
        if (this.applyDiscountTo == null) {
            this.applyDiscountTo = new ArrayList<ApplyDiscountToEnum>();
        }
        this.applyDiscountTo.add(applyDiscountToItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Any combination of one_time, recurring and plan.")
    public List<ApplyDiscountToEnum> getApplyDiscountTo() {
        return this.applyDiscountTo;
    }

    public void setApplyDiscountTo(List<ApplyDiscountToEnum> applyDiscountTo) {
        this.applyDiscountTo = applyDiscountTo;
    }

    public SubscriptionItem discountLevel(DiscountLevelEnum discountLevel) {
        this.discountLevel = discountLevel;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specifies at what level a discount should be applied: one of account, subscription or plan.")
    public DiscountLevelEnum getDiscountLevel() {
        return this.discountLevel;
    }

    public void setDiscountLevel(DiscountLevelEnum discountLevel) {
        this.discountLevel = discountLevel;
    }

    public SubscriptionItem priceBaseInterval(PriceBaseIntervalEnum priceBaseInterval) {
        this.priceBaseInterval = priceBaseInterval;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specifies the base interval of the price the subscriber is subscribed to. If not provided, this field defaults to `billing_period`.")
    public PriceBaseIntervalEnum getPriceBaseInterval() {
        return this.priceBaseInterval;
    }

    public void setPriceBaseInterval(PriceBaseIntervalEnum priceBaseInterval) {
        this.priceBaseInterval = priceBaseInterval;
    }

    public SubscriptionItem overage(Overage overage) {
        this.overage = overage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Overage getOverage() {
        return this.overage;
    }

    public void setOverage(Overage overage) {
        this.overage = overage;
    }

    public SubscriptionItem chargeModel(String chargeModel) {
        this.chargeModel = chargeModel;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Charge model of the price. See [Charge models](https://knowledgecenter.zuora.com/Billing/Subscriptions/Product_Catalog/B_Charge_Models) for more information.")
    public String getChargeModel() {
        return this.chargeModel;
    }

    public void setChargeModel(String chargeModel) {
        this.chargeModel = chargeModel;
    }

    public SubscriptionItem chargeType(String chargeType) {
        this.chargeType = chargeType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Type of the charge. It can be one of the following types: one-time, recurring, or usage.")
    public String getChargeType() {
        return this.chargeType;
    }

    public void setChargeType(String chargeType) {
        this.chargeType = chargeType;
    }

    public SubscriptionItem priceId(String priceId) {
        this.priceId = priceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Identifier of the price.")
    public String getPriceId() {
        return this.priceId;
    }

    public void setPriceId(String priceId) {
        this.priceId = priceId;
    }

    public SubscriptionItem price(Price price) {
        this.price = price;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Price getPrice() {
        return this.price;
    }

    public void setPrice(Price price) {
        this.price = price;
    }

    public SubscriptionItem subscriptionPlanId(String subscriptionPlanId) {
        this.subscriptionPlanId = subscriptionPlanId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Identifier of the subscription plan this subscription item belongs to.")
    public String getSubscriptionPlanId() {
        return this.subscriptionPlanId;
    }

    public void setSubscriptionPlanId(String subscriptionPlanId) {
        this.subscriptionPlanId = subscriptionPlanId;
    }

    public SubscriptionItem subscriptionPlan(SubscriptionPlan subscriptionPlan) {
        this.subscriptionPlan = subscriptionPlan;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public SubscriptionPlan getSubscriptionPlan() {
        return this.subscriptionPlan;
    }

    public void setSubscriptionPlan(SubscriptionPlan subscriptionPlan) {
        this.subscriptionPlan = subscriptionPlan;
    }

    @Nullable
    @ApiModelProperty(value="The date when the subscription item starts.")
    public LocalDate getStartDate() {
        return this.startDate;
    }

    @Nullable
    @ApiModelProperty(value="The date when the subscription item ends.")
    public LocalDate getEndDate() {
        return this.endDate;
    }

    @Nullable
    @ApiModelProperty(value="The date until when charges are processed. When billing takes place in arrears, such as usage-based prices, this field value is the the same as the `ChargedThroughDate` value. This date is the earliest date when a charge can be amended.")
    public LocalDate getProcessedThroughDate() {
        return this.processedThroughDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubscriptionItem subscriptionItem = (SubscriptionItem)o;
        return Objects.equals(this.id, subscriptionItem.id) && Objects.equals(this.updatedById, subscriptionItem.updatedById) && Objects.equals(this.updatedTime, subscriptionItem.updatedTime) && Objects.equals(this.createdById, subscriptionItem.createdById) && Objects.equals(this.createdTime, subscriptionItem.createdTime) && Objects.equals(this.customFields, subscriptionItem.customFields) && Objects.equals(this.customObjects, subscriptionItem.customObjects) && Objects.equals(this.subscriptionItemNumber, subscriptionItem.subscriptionItemNumber) && Objects.equals(this.name, subscriptionItem.name) && Objects.equals(this.description, subscriptionItem.description) && Objects.equals(this.productId, subscriptionItem.productId) && Objects.equals(this.chargedThroughDate, subscriptionItem.chargedThroughDate) && Objects.equals(this.recurring, subscriptionItem.recurring) && Objects.equals(this.active, subscriptionItem.active) && Objects.equals((Object)this.state, (Object)subscriptionItem.state) && Objects.equals((Object)this.startEvent, (Object)subscriptionItem.startEvent) && Objects.equals((Object)this.tiersMode, (Object)subscriptionItem.tiersMode) && Objects.equals(this.tiers, subscriptionItem.tiers) && Objects.equals(this.taxCode, subscriptionItem.taxCode) && Objects.equals(this.taxInclusive, subscriptionItem.taxInclusive) && Objects.equals(this.unitOfMeasure, subscriptionItem.unitOfMeasure) && Objects.equals(this.quantity, subscriptionItem.quantity) && Objects.equals(this.amount, subscriptionItem.amount) && Objects.equals(this.unitAmount, subscriptionItem.unitAmount) && Objects.equals(this.discountAmount, subscriptionItem.discountAmount) && Objects.equals(this.discountPercent, subscriptionItem.discountPercent) && Objects.equals(this.applyDiscountTo, subscriptionItem.applyDiscountTo) && Objects.equals((Object)this.discountLevel, (Object)subscriptionItem.discountLevel) && Objects.equals((Object)this.priceBaseInterval, (Object)subscriptionItem.priceBaseInterval) && Objects.equals(this.overage, subscriptionItem.overage) && Objects.equals(this.chargeModel, subscriptionItem.chargeModel) && Objects.equals(this.chargeType, subscriptionItem.chargeType) && Objects.equals(this.priceId, subscriptionItem.priceId) && Objects.equals(this.price, subscriptionItem.price) && Objects.equals(this.subscriptionPlanId, subscriptionItem.subscriptionPlanId) && Objects.equals(this.subscriptionPlan, subscriptionItem.subscriptionPlan) && Objects.equals(this.startDate, subscriptionItem.startDate) && Objects.equals(this.endDate, subscriptionItem.endDate) && Objects.equals(this.processedThroughDate, subscriptionItem.processedThroughDate);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.updatedById, this.updatedTime, this.createdById, this.createdTime, this.customFields, this.customObjects, this.subscriptionItemNumber, this.name, this.description, this.productId, this.chargedThroughDate, this.recurring, this.active, this.state, this.startEvent, this.tiersMode, this.tiers, this.taxCode, this.taxInclusive, this.unitOfMeasure, this.quantity, this.amount, this.unitAmount, this.discountAmount, this.discountPercent, this.applyDiscountTo, this.discountLevel, this.priceBaseInterval, this.overage, this.chargeModel, this.chargeType, this.priceId, this.price, this.subscriptionPlanId, this.subscriptionPlan, this.startDate, this.endDate, this.processedThroughDate});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SubscriptionItem {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    updatedById: ").append(this.toIndentedString(this.updatedById)).append("\n");
        sb.append("    updatedTime: ").append(this.toIndentedString(this.updatedTime)).append("\n");
        sb.append("    createdById: ").append(this.toIndentedString(this.createdById)).append("\n");
        sb.append("    createdTime: ").append(this.toIndentedString(this.createdTime)).append("\n");
        sb.append("    customFields: ").append(this.toIndentedString(this.customFields)).append("\n");
        sb.append("    customObjects: ").append(this.toIndentedString(this.customObjects)).append("\n");
        sb.append("    subscriptionItemNumber: ").append(this.toIndentedString(this.subscriptionItemNumber)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    productId: ").append(this.toIndentedString(this.productId)).append("\n");
        sb.append("    chargedThroughDate: ").append(this.toIndentedString(this.chargedThroughDate)).append("\n");
        sb.append("    recurring: ").append(this.toIndentedString(this.recurring)).append("\n");
        sb.append("    active: ").append(this.toIndentedString(this.active)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    startEvent: ").append(this.toIndentedString((Object)this.startEvent)).append("\n");
        sb.append("    tiersMode: ").append(this.toIndentedString((Object)this.tiersMode)).append("\n");
        sb.append("    tiers: ").append(this.toIndentedString(this.tiers)).append("\n");
        sb.append("    taxCode: ").append(this.toIndentedString(this.taxCode)).append("\n");
        sb.append("    taxInclusive: ").append(this.toIndentedString(this.taxInclusive)).append("\n");
        sb.append("    unitOfMeasure: ").append(this.toIndentedString(this.unitOfMeasure)).append("\n");
        sb.append("    quantity: ").append(this.toIndentedString(this.quantity)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    unitAmount: ").append(this.toIndentedString(this.unitAmount)).append("\n");
        sb.append("    discountAmount: ").append(this.toIndentedString(this.discountAmount)).append("\n");
        sb.append("    discountPercent: ").append(this.toIndentedString(this.discountPercent)).append("\n");
        sb.append("    applyDiscountTo: ").append(this.toIndentedString(this.applyDiscountTo)).append("\n");
        sb.append("    discountLevel: ").append(this.toIndentedString((Object)this.discountLevel)).append("\n");
        sb.append("    priceBaseInterval: ").append(this.toIndentedString((Object)this.priceBaseInterval)).append("\n");
        sb.append("    overage: ").append(this.toIndentedString(this.overage)).append("\n");
        sb.append("    chargeModel: ").append(this.toIndentedString(this.chargeModel)).append("\n");
        sb.append("    chargeType: ").append(this.toIndentedString(this.chargeType)).append("\n");
        sb.append("    priceId: ").append(this.toIndentedString(this.priceId)).append("\n");
        sb.append("    price: ").append(this.toIndentedString(this.price)).append("\n");
        sb.append("    subscriptionPlanId: ").append(this.toIndentedString(this.subscriptionPlanId)).append("\n");
        sb.append("    subscriptionPlan: ").append(this.toIndentedString(this.subscriptionPlan)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    processedThroughDate: ").append(this.toIndentedString(this.processedThroughDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum PriceBaseIntervalEnum {
        MONTH("month"),
        BILLING_PERIOD("billing_period"),
        WEEK("week"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private PriceBaseIntervalEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static PriceBaseIntervalEnum fromValue(String value) {
            for (PriceBaseIntervalEnum b : PriceBaseIntervalEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<PriceBaseIntervalEnum> {
            public void write(JsonWriter jsonWriter, PriceBaseIntervalEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public PriceBaseIntervalEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return PriceBaseIntervalEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum DiscountLevelEnum {
        ACCOUNT("account"),
        SUBSCRIPTION("subscription"),
        PLAN("plan"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private DiscountLevelEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static DiscountLevelEnum fromValue(String value) {
            for (DiscountLevelEnum b : DiscountLevelEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<DiscountLevelEnum> {
            public void write(JsonWriter jsonWriter, DiscountLevelEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public DiscountLevelEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return DiscountLevelEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ApplyDiscountToEnum {
        ONE_TIME("one_time"),
        RECURRING("recurring"),
        USAGE("usage"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private ApplyDiscountToEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ApplyDiscountToEnum fromValue(String value) {
            for (ApplyDiscountToEnum b : ApplyDiscountToEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<ApplyDiscountToEnum> {
            public void write(JsonWriter jsonWriter, ApplyDiscountToEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ApplyDiscountToEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ApplyDiscountToEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TiersModeEnum {
        GRADUATED("graduated"),
        VOLUME("volume"),
        HIGH_WATERMARK_VOLUME("high_watermark_volume"),
        HIGH_WATERMARK_GRADUATED("high_watermark_graduated"),
        GRADUATED_WITH_OVERAGE("graduated_with_overage"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private TiersModeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TiersModeEnum fromValue(String value) {
            for (TiersModeEnum b : TiersModeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<TiersModeEnum> {
            public void write(JsonWriter jsonWriter, TiersModeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TiersModeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TiersModeEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StartEventEnum {
        CONTRACT_EFFECTIVE("contract_effective"),
        SERVICE_ACTIVATION("service_activation"),
        CUSTOMER_ACCEPTANCE("customer_acceptance"),
        SPECIFIC_DATE("specific_date"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private StartEventEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StartEventEnum fromValue(String value) {
            for (StartEventEnum b : StartEventEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<StartEventEnum> {
            public void write(JsonWriter jsonWriter, StartEventEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StartEventEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StartEventEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StateEnum {
        INACTIVE("inactive"),
        ACTIVE("active"),
        EXPIRED("expired"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StateEnum fromValue(String value) {
            for (StateEnum b : StateEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<StateEnum> {
            public void write(JsonWriter jsonWriter, StateEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StateEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StateEnum.fromValue(value);
            }
        }
    }
}

