/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openapitools.client.JSON;
import org.openapitools.client.model.BillingDocumentPaymentApplicationRequest;
import org.openapitools.client.model.RefundCreditMemoRequest;
import org.openapitools.jackson.nullable.JsonNullable;
import org.threeten.bp.LocalDate;

public class RefundCreateRequest {
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private BigDecimal amount;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_GATEWAY_OPTIONS = "gateway_options";
    @SerializedName(value="gateway_options")
    private Map<String, Object> gatewayOptions = null;
    public static final String SERIALIZED_NAME_REFUND_DATE = "refund_date";
    @SerializedName(value="refund_date")
    private LocalDate refundDate;
    public static final String SERIALIZED_NAME_REFUND_METHOD_TYPE = "refund_method_type";
    @SerializedName(value="refund_method_type")
    private RefundMethodTypeEnum refundMethodType;
    public static final String SERIALIZED_NAME_PAYMENT_ID = "payment_id";
    @SerializedName(value="payment_id")
    private String paymentId;
    public static final String SERIALIZED_NAME_REASON_CODE = "reason_code";
    @SerializedName(value="reason_code")
    private String reasonCode;
    public static final String SERIALIZED_NAME_STATEMENT_DESCRIPTOR = "statement_descriptor";
    @SerializedName(value="statement_descriptor")
    private String statementDescriptor;
    public static final String SERIALIZED_NAME_STATEMENT_DESCRIPTOR_PHONE = "statement_descriptor_phone";
    @SerializedName(value="statement_descriptor_phone")
    private String statementDescriptorPhone;
    public static final String SERIALIZED_NAME_EXTERNAL = "external";
    @SerializedName(value="external")
    private Boolean external;
    public static final String SERIALIZED_NAME_REFERENCE_ID = "reference_id";
    @SerializedName(value="reference_id")
    private String referenceId;
    public static final String SERIALIZED_NAME_SECOND_REFERENCE_ID = "second_reference_id";
    @SerializedName(value="second_reference_id")
    private String secondReferenceId;
    public static final String SERIALIZED_NAME_BANK_ACCOUNT_ACCOUNT = "bank_account_account";
    @SerializedName(value="bank_account_account")
    private String bankAccountAccount;
    public static final String SERIALIZED_NAME_ON_ACCOUNT_ACCOUNT = "on_account_account";
    @SerializedName(value="on_account_account")
    private String onAccountAccount;
    public static final String SERIALIZED_NAME_UNAPPLIED_PAYMENT_ACCOUNT = "unapplied_payment_account";
    @SerializedName(value="unapplied_payment_account")
    private String unappliedPaymentAccount;
    public static final String SERIALIZED_NAME_CUSTOM_FIELDS = "custom_fields";
    @SerializedName(value="custom_fields")
    @JsonAdapter(value=JSON.CustomFieldAdapter.class)
    private Map<String, Object> customFields = null;
    public static final String SERIALIZED_NAME_PAYMENT_METHOD_ID = "payment_method_id";
    @SerializedName(value="payment_method_id")
    private String paymentMethodId;
    public static final String SERIALIZED_NAME_CREDIT_MEMO = "credit_memo";
    @SerializedName(value="credit_memo")
    private RefundCreditMemoRequest creditMemo;
    public static final String SERIALIZED_NAME_BILLING_DOCUMENTS = "billing_documents";
    @SerializedName(value="billing_documents")
    private List<BillingDocumentPaymentApplicationRequest> billingDocuments = null;

    public RefundCreateRequest() {
    }

    public RefundCreateRequest(String paymentId, String paymentMethodId) {
        this();
        this.paymentId = paymentId;
        this.paymentMethodId = paymentMethodId;
    }

    public RefundCreateRequest amount(BigDecimal amount) {
        this.amount = amount;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Refund amount.")
    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public RefundCreateRequest description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An arbitrary string attached to the object. Often useful for displaying to users.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public RefundCreateRequest gatewayOptions(Map<String, Object> gatewayOptions) {
        this.gatewayOptions = gatewayOptions;
        return this;
    }

    public RefundCreateRequest putGatewayOptionsItem(String key, Object gatewayOptionsItem) {
        if (this.gatewayOptions == null) {
            this.gatewayOptions = new HashMap<String, Object>();
        }
        this.gatewayOptions.put(key, gatewayOptionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="{\"key\":\"value\"}", value="")
    public Map<String, Object> getGatewayOptions() {
        return this.gatewayOptions;
    }

    public void setGatewayOptions(Map<String, Object> gatewayOptions) {
        this.gatewayOptions = gatewayOptions;
    }

    public RefundCreateRequest refundDate(LocalDate refundDate) {
        this.refundDate = refundDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The date when the refund takes effect.")
    public LocalDate getRefundDate() {
        return this.refundDate;
    }

    public void setRefundDate(LocalDate refundDate) {
        this.refundDate = refundDate;
    }

    public RefundCreateRequest refundMethodType(RefundMethodTypeEnum refundMethodType) {
        this.refundMethodType = refundMethodType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public RefundMethodTypeEnum getRefundMethodType() {
        return this.refundMethodType;
    }

    public void setRefundMethodType(RefundMethodTypeEnum refundMethodType) {
        this.refundMethodType = refundMethodType;
    }

    @Nullable
    @ApiModelProperty(value="Identifier for the payment, either `payment_number` or `payment_id.")
    public String getPaymentId() {
        return this.paymentId;
    }

    public RefundCreateRequest reasonCode(String reasonCode) {
        this.reasonCode = reasonCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="User-provided reason for the refund.")
    public String getReasonCode() {
        return this.reasonCode;
    }

    public void setReasonCode(String reasonCode) {
        this.reasonCode = reasonCode;
    }

    public RefundCreateRequest statementDescriptor(String statementDescriptor) {
        this.statementDescriptor = statementDescriptor;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A payment gateway-specific field used by Orbital, Vantiv and Verifi.")
    public String getStatementDescriptor() {
        return this.statementDescriptor;
    }

    public void setStatementDescriptor(String statementDescriptor) {
        this.statementDescriptor = statementDescriptor;
    }

    public RefundCreateRequest statementDescriptorPhone(String statementDescriptorPhone) {
        this.statementDescriptorPhone = statementDescriptorPhone;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A payment gateway-specific field used by Orbital, Vantiv and Verifi.")
    public String getStatementDescriptorPhone() {
        return this.statementDescriptorPhone;
    }

    public void setStatementDescriptorPhone(String statementDescriptorPhone) {
        this.statementDescriptorPhone = statementDescriptorPhone;
    }

    public RefundCreateRequest external(Boolean external) {
        this.external = external;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If true, indicates that this refund is not handled by Zuora.")
    public Boolean getExternal() {
        return this.external;
    }

    public void setExternal(Boolean external) {
        this.external = external;
    }

    public RefundCreateRequest referenceId(String referenceId) {
        this.referenceId = referenceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Transaction identifier returned by the payment gateway. You may use this field to reconcile refunds between your payment gateway and Zuora Payments.")
    public String getReferenceId() {
        return this.referenceId;
    }

    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    public RefundCreateRequest secondReferenceId(String secondReferenceId) {
        this.secondReferenceId = secondReferenceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A second transaction identifier returned by the payment gateway if there is an additional transaction for the refunds. You may use this field to reconcile payments between your payment gateway and Zuora Payments.")
    public String getSecondReferenceId() {
        return this.secondReferenceId;
    }

    public void setSecondReferenceId(String secondReferenceId) {
        this.secondReferenceId = secondReferenceId;
    }

    public RefundCreateRequest bankAccountAccount(String bankAccountAccount) {
        this.bankAccountAccount = bankAccountAccount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An active account in your Zuora Chart of Accounts.")
    public String getBankAccountAccount() {
        return this.bankAccountAccount;
    }

    public void setBankAccountAccount(String bankAccountAccount) {
        this.bankAccountAccount = bankAccountAccount;
    }

    public RefundCreateRequest onAccountAccount(String onAccountAccount) {
        this.onAccountAccount = onAccountAccount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An active account in your Zuora Chart of Accounts.")
    public String getOnAccountAccount() {
        return this.onAccountAccount;
    }

    public void setOnAccountAccount(String onAccountAccount) {
        this.onAccountAccount = onAccountAccount;
    }

    public RefundCreateRequest unappliedPaymentAccount(String unappliedPaymentAccount) {
        this.unappliedPaymentAccount = unappliedPaymentAccount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An active account in your Zuora Chart of Accounts.")
    public String getUnappliedPaymentAccount() {
        return this.unappliedPaymentAccount;
    }

    public void setUnappliedPaymentAccount(String unappliedPaymentAccount) {
        this.unappliedPaymentAccount = unappliedPaymentAccount;
    }

    public RefundCreateRequest customFields(Map<String, Object> customFields) {
        this.customFields = customFields;
        return this;
    }

    public RefundCreateRequest putCustomFieldsItem(String key, Object customFieldsItem) {
        if (this.customFields == null) {
            this.customFields = new HashMap<String, Object>();
        }
        this.customFields.put(key, customFieldsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Set of user-defined fields associated with this object. Useful for storing additional information about the object in a structured format.")
    public Map<String, Object> getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(Map<String, Object> customFields) {
        this.customFields = customFields;
    }

    @Nullable
    @ApiModelProperty(value="Identifier of the payment method used to create this refund.")
    public String getPaymentMethodId() {
        return this.paymentMethodId;
    }

    public RefundCreateRequest creditMemo(RefundCreditMemoRequest creditMemo) {
        this.creditMemo = creditMemo;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The related credit memo.")
    public RefundCreditMemoRequest getCreditMemo() {
        return this.creditMemo;
    }

    public void setCreditMemo(RefundCreditMemoRequest creditMemo) {
        this.creditMemo = creditMemo;
    }

    public RefundCreateRequest billingDocuments(List<BillingDocumentPaymentApplicationRequest> billingDocuments) {
        this.billingDocuments = billingDocuments;
        return this;
    }

    public RefundCreateRequest addBillingDocumentsItem(BillingDocumentPaymentApplicationRequest billingDocumentsItem) {
        if (this.billingDocuments == null) {
            this.billingDocuments = new ArrayList<BillingDocumentPaymentApplicationRequest>();
        }
        this.billingDocuments.add(billingDocumentsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates to which billing documents (invoices or debit memos) is the refund applied.")
    public List<BillingDocumentPaymentApplicationRequest> getBillingDocuments() {
        return this.billingDocuments;
    }

    public void setBillingDocuments(List<BillingDocumentPaymentApplicationRequest> billingDocuments) {
        this.billingDocuments = billingDocuments;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RefundCreateRequest refundCreateRequest = (RefundCreateRequest)o;
        return Objects.equals(this.amount, refundCreateRequest.amount) && Objects.equals(this.description, refundCreateRequest.description) && Objects.equals(this.gatewayOptions, refundCreateRequest.gatewayOptions) && Objects.equals(this.refundDate, refundCreateRequest.refundDate) && Objects.equals((Object)this.refundMethodType, (Object)refundCreateRequest.refundMethodType) && Objects.equals(this.paymentId, refundCreateRequest.paymentId) && Objects.equals(this.reasonCode, refundCreateRequest.reasonCode) && Objects.equals(this.statementDescriptor, refundCreateRequest.statementDescriptor) && Objects.equals(this.statementDescriptorPhone, refundCreateRequest.statementDescriptorPhone) && Objects.equals(this.external, refundCreateRequest.external) && Objects.equals(this.referenceId, refundCreateRequest.referenceId) && Objects.equals(this.secondReferenceId, refundCreateRequest.secondReferenceId) && Objects.equals(this.bankAccountAccount, refundCreateRequest.bankAccountAccount) && Objects.equals(this.onAccountAccount, refundCreateRequest.onAccountAccount) && Objects.equals(this.unappliedPaymentAccount, refundCreateRequest.unappliedPaymentAccount) && Objects.equals(this.customFields, refundCreateRequest.customFields) && Objects.equals(this.paymentMethodId, refundCreateRequest.paymentMethodId) && Objects.equals(this.creditMemo, refundCreateRequest.creditMemo) && Objects.equals(this.billingDocuments, refundCreateRequest.billingDocuments);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.amount, this.description, this.gatewayOptions, this.refundDate, this.refundMethodType, this.paymentId, this.reasonCode, this.statementDescriptor, this.statementDescriptorPhone, this.external, this.referenceId, this.secondReferenceId, this.bankAccountAccount, this.onAccountAccount, this.unappliedPaymentAccount, this.customFields, this.paymentMethodId, this.creditMemo, this.billingDocuments});
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RefundCreateRequest {\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    gatewayOptions: ").append(this.toIndentedString(this.gatewayOptions)).append("\n");
        sb.append("    refundDate: ").append(this.toIndentedString(this.refundDate)).append("\n");
        sb.append("    refundMethodType: ").append(this.toIndentedString((Object)this.refundMethodType)).append("\n");
        sb.append("    paymentId: ").append(this.toIndentedString(this.paymentId)).append("\n");
        sb.append("    reasonCode: ").append(this.toIndentedString(this.reasonCode)).append("\n");
        sb.append("    statementDescriptor: ").append(this.toIndentedString(this.statementDescriptor)).append("\n");
        sb.append("    statementDescriptorPhone: ").append(this.toIndentedString(this.statementDescriptorPhone)).append("\n");
        sb.append("    external: ").append(this.toIndentedString(this.external)).append("\n");
        sb.append("    referenceId: ").append(this.toIndentedString(this.referenceId)).append("\n");
        sb.append("    secondReferenceId: ").append(this.toIndentedString(this.secondReferenceId)).append("\n");
        sb.append("    bankAccountAccount: ").append(this.toIndentedString(this.bankAccountAccount)).append("\n");
        sb.append("    onAccountAccount: ").append(this.toIndentedString(this.onAccountAccount)).append("\n");
        sb.append("    unappliedPaymentAccount: ").append(this.toIndentedString(this.unappliedPaymentAccount)).append("\n");
        sb.append("    customFields: ").append(this.toIndentedString(this.customFields)).append("\n");
        sb.append("    paymentMethodId: ").append(this.toIndentedString(this.paymentMethodId)).append("\n");
        sb.append("    creditMemo: ").append(this.toIndentedString(this.creditMemo)).append("\n");
        sb.append("    billingDocuments: ").append(this.toIndentedString(this.billingDocuments)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum RefundMethodTypeEnum {
        CASH("cash"),
        CHECK("check"),
        WIRE_TRANSFER("wire_transfer"),
        PAY_PAL("pay_pal"),
        CREDIT_CARD("credit_card"),
        CC_REF("cc_ref"),
        ACH_DEBIT("ach_debit"),
        DEBIT_CARD("debit_card"),
        OTHER("other"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private RefundMethodTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static RefundMethodTypeEnum fromValue(String value) {
            for (RefundMethodTypeEnum b : RefundMethodTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<RefundMethodTypeEnum> {
            public void write(JsonWriter jsonWriter, RefundMethodTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public RefundMethodTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return RefundMethodTypeEnum.fromValue(value);
            }
        }
    }
}

