/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.client.JSON;
import org.openapitools.client.model.Payment;
import org.openapitools.client.model.PaymentSchedule;
import org.openapitools.client.model.PaymentScheduleBillingDocumentResponse;
import org.openapitools.client.model.PaymentScheduleItemPayments;
import org.openapitools.jackson.nullable.JsonNullable;
import org.threeten.bp.LocalDate;
import org.threeten.bp.OffsetDateTime;

public class PaymentScheduleItem {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_UPDATED_BY_ID = "updated_by_id";
    @SerializedName(value="updated_by_id")
    private String updatedById;
    public static final String SERIALIZED_NAME_UPDATED_TIME = "updated_time";
    @SerializedName(value="updated_time")
    private OffsetDateTime updatedTime;
    public static final String SERIALIZED_NAME_CREATED_BY_ID = "created_by_id";
    @SerializedName(value="created_by_id")
    private String createdById;
    public static final String SERIALIZED_NAME_CREATED_TIME = "created_time";
    @SerializedName(value="created_time")
    private OffsetDateTime createdTime;
    public static final String SERIALIZED_NAME_CUSTOM_FIELDS = "custom_fields";
    @SerializedName(value="custom_fields")
    @JsonAdapter(value=JSON.CustomFieldAdapter.class)
    private Map<String, Object> customFields = null;
    public static final String SERIALIZED_NAME_CUSTOM_OBJECTS = "custom_objects";
    @SerializedName(value="custom_objects")
    private Map<String, Object> customObjects = null;
    public static final String SERIALIZED_NAME_ACCOUNT_ID = "account_id";
    @SerializedName(value="account_id")
    private String accountId;
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private BigDecimal amount;
    public static final String SERIALIZED_NAME_BALANCE = "balance";
    @SerializedName(value="balance")
    private BigDecimal balance;
    public static final String SERIALIZED_NAME_BILLING_DOCUMENT = "billing_document";
    @SerializedName(value="billing_document")
    private PaymentScheduleBillingDocumentResponse billingDocument;
    public static final String SERIALIZED_NAME_CANCELLATION_REASON = "cancellation_reason";
    @SerializedName(value="cancellation_reason")
    private String cancellationReason;
    public static final String SERIALIZED_NAME_CURRENCY = "currency";
    @SerializedName(value="currency")
    private String currency;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_PAYMENT_SCHEDULE_ITEM_NUMBER = "payment_schedule_item_number";
    @SerializedName(value="payment_schedule_item_number")
    private String paymentScheduleItemNumber;
    public static final String SERIALIZED_NAME_PAYMENT_GATEWAY_ID = "payment_gateway_id";
    @SerializedName(value="payment_gateway_id")
    private String paymentGatewayId;
    public static final String SERIALIZED_NAME_PAYMENT_METHOD_ID = "payment_method_id";
    @SerializedName(value="payment_method_id")
    private String paymentMethodId;
    public static final String SERIALIZED_NAME_PAYMENT_OPTION_ID = "payment_option_id";
    @SerializedName(value="payment_option_id")
    private String paymentOptionId;
    public static final String SERIALIZED_NAME_PAYMENT_SCHEDULE_ID = "payment_schedule_id";
    @SerializedName(value="payment_schedule_id")
    private String paymentScheduleId;
    public static final String SERIALIZED_NAME_PAYMENT_SCHEDULE_NUMBER = "payment_schedule_number";
    @SerializedName(value="payment_schedule_number")
    private String paymentScheduleNumber;
    public static final String SERIALIZED_NAME_PAYMENTS = "payments";
    @SerializedName(value="payments")
    private List<PaymentScheduleItemPayments> payments = null;
    public static final String SERIALIZED_NAME_RUN_HOUR = "run_hour";
    @SerializedName(value="run_hour")
    private Integer runHour;
    public static final String SERIALIZED_NAME_SCHEDULED_DATE = "scheduled_date";
    @SerializedName(value="scheduled_date")
    private LocalDate scheduledDate;
    public static final String SERIALIZED_NAME_STANDALONE = "standalone";
    @SerializedName(value="standalone")
    private Boolean standalone;
    public static final String SERIALIZED_NAME_STATE = "state";
    @SerializedName(value="state")
    private StateEnum state;
    public static final String SERIALIZED_NAME_ERROR_MESSAGE = "error_message";
    @SerializedName(value="error_message")
    private String errorMessage;
    public static final String SERIALIZED_NAME_PAYMENT = "payment";
    @SerializedName(value="payment")
    private Payment payment;
    public static final String SERIALIZED_NAME_PAYMENT_SCHEDULE = "payment_schedule";
    @SerializedName(value="payment_schedule")
    private PaymentSchedule paymentSchedule;

    public PaymentScheduleItem() {
    }

    public PaymentScheduleItem(String id, String updatedById, OffsetDateTime updatedTime, String createdById, OffsetDateTime createdTime, Map<String, Object> customObjects, Payment payment, PaymentSchedule paymentSchedule) {
        this();
        this.id = id;
        this.updatedById = updatedById;
        this.updatedTime = updatedTime;
        this.createdById = createdById;
        this.createdTime = createdTime;
        this.customObjects = customObjects;
        this.payment = payment;
        this.paymentSchedule = paymentSchedule;
    }

    @Nullable
    @ApiModelProperty(value="Unique identifier for the object.")
    public String getId() {
        return this.id;
    }

    @Nullable
    @ApiModelProperty(value="Unique identifier of the Zuora user who last updated the object")
    public String getUpdatedById() {
        return this.updatedById;
    }

    @Nullable
    @ApiModelProperty(value="The date and time when the object was last updated in ISO 8601 UTC format.")
    public OffsetDateTime getUpdatedTime() {
        return this.updatedTime;
    }

    @Nullable
    @ApiModelProperty(value="Unique identifier of the Zuora user who created the object")
    public String getCreatedById() {
        return this.createdById;
    }

    @Nullable
    @ApiModelProperty(value="The date and time when the object was created in ISO 8601 UTC format.")
    public OffsetDateTime getCreatedTime() {
        return this.createdTime;
    }

    public PaymentScheduleItem customFields(Map<String, Object> customFields) {
        this.customFields = customFields;
        return this;
    }

    public PaymentScheduleItem putCustomFieldsItem(String key, Object customFieldsItem) {
        if (this.customFields == null) {
            this.customFields = new HashMap<String, Object>();
        }
        this.customFields.put(key, customFieldsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Set of user-defined fields associated with this object. Useful for storing additional information about the object in a structured format.")
    public Map<String, Object> getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(Map<String, Object> customFields) {
        this.customFields = customFields;
    }

    @Nullable
    @ApiModelProperty(value="The custom objects associated with a Zuora standard object.")
    public Map<String, Object> getCustomObjects() {
        return this.customObjects;
    }

    public PaymentScheduleItem accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="8ad093f27d6eee80017d6effd7a66759", value="Unique identifier of the customer account the payment schedule belongs to.")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public PaymentScheduleItem amount(BigDecimal amount) {
        this.amount = amount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The amount to be collected by this payment schedule item.")
    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public PaymentScheduleItem balance(BigDecimal balance) {
        this.balance = balance;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The remaining balance of payment schedule item.")
    public BigDecimal getBalance() {
        return this.balance;
    }

    public void setBalance(BigDecimal balance) {
        this.balance = balance;
    }

    public PaymentScheduleItem billingDocument(PaymentScheduleBillingDocumentResponse billingDocument) {
        this.billingDocument = billingDocument;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The billing document with which the payment schedule is associated. If you have the Standalone Payment feature enabled, you can leave this field blank and set standalone to true to create standalone payments. You can also choose to create unapplied payments by leaving this object blank and setting standalone to false. If Standalone Payment is not enabled, leaving this object unspecified will create unapplied payments.")
    public PaymentScheduleBillingDocumentResponse getBillingDocument() {
        return this.billingDocument;
    }

    public void setBillingDocument(PaymentScheduleBillingDocumentResponse billingDocument) {
        this.billingDocument = billingDocument;
    }

    public PaymentScheduleItem cancellationReason(String cancellationReason) {
        this.cancellationReason = cancellationReason;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The reason for the cancellation of payment schedule item.")
    public String getCancellationReason() {
        return this.cancellationReason;
    }

    public void setCancellationReason(String cancellationReason) {
        this.cancellationReason = cancellationReason;
    }

    public PaymentScheduleItem currency(String currency) {
        this.currency = currency;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="USD", value="Currency of the payment schedule. The default value is the account's default currency. This field will be ignored when items is specified.")
    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public PaymentScheduleItem description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="description of payment schedule item", value="An arbitrary string attached to the object. Often useful for displaying to users.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public PaymentScheduleItem paymentScheduleItemNumber(String paymentScheduleItemNumber) {
        this.paymentScheduleItemNumber = paymentScheduleItemNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Number of the payment schedule item.")
    public String getPaymentScheduleItemNumber() {
        return this.paymentScheduleItemNumber;
    }

    public void setPaymentScheduleItemNumber(String paymentScheduleItemNumber) {
        this.paymentScheduleItemNumber = paymentScheduleItemNumber;
    }

    public PaymentScheduleItem paymentGatewayId(String paymentGatewayId) {
        this.paymentGatewayId = paymentGatewayId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="8ad093f27d6eee80017d6effd7a66759", value="ID of the payment gateway used to collect payments. The default value is the account's default payment gateway ID. If no payment gateway ID is found on the customer account level, the default value will be the tenant's default payment gateway ID. This field will be ignored when `items` is specified.")
    public String getPaymentGatewayId() {
        return this.paymentGatewayId;
    }

    public void setPaymentGatewayId(String paymentGatewayId) {
        this.paymentGatewayId = paymentGatewayId;
    }

    public PaymentScheduleItem paymentMethodId(String paymentMethodId) {
        this.paymentMethodId = paymentMethodId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="8a95b1946b6aeac8718c32aab8c395f", value="ID of the payment method. The default value is the account's default payment method ID. This field will be ignored when `items` is specified.")
    public String getPaymentMethodId() {
        return this.paymentMethodId;
    }

    public void setPaymentMethodId(String paymentMethodId) {
        this.paymentMethodId = paymentMethodId;
    }

    public PaymentScheduleItem paymentOptionId(String paymentOptionId) {
        this.paymentOptionId = paymentOptionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ID of the payment option.")
    public String getPaymentOptionId() {
        return this.paymentOptionId;
    }

    public void setPaymentOptionId(String paymentOptionId) {
        this.paymentOptionId = paymentOptionId;
    }

    public PaymentScheduleItem paymentScheduleId(String paymentScheduleId) {
        this.paymentScheduleId = paymentScheduleId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ID of the payment schedule.")
    public String getPaymentScheduleId() {
        return this.paymentScheduleId;
    }

    public void setPaymentScheduleId(String paymentScheduleId) {
        this.paymentScheduleId = paymentScheduleId;
    }

    public PaymentScheduleItem paymentScheduleNumber(String paymentScheduleNumber) {
        this.paymentScheduleNumber = paymentScheduleNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Number of the payment schedule.")
    public String getPaymentScheduleNumber() {
        return this.paymentScheduleNumber;
    }

    public void setPaymentScheduleNumber(String paymentScheduleNumber) {
        this.paymentScheduleNumber = paymentScheduleNumber;
    }

    public PaymentScheduleItem payments(List<PaymentScheduleItemPayments> payments) {
        this.payments = payments;
        return this;
    }

    public PaymentScheduleItem addPaymentsItem(PaymentScheduleItemPayments paymentsItem) {
        if (this.payments == null) {
            this.payments = new ArrayList<PaymentScheduleItemPayments>();
        }
        this.payments.add(paymentsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<PaymentScheduleItemPayments> getPayments() {
        return this.payments;
    }

    public void setPayments(List<PaymentScheduleItemPayments> payments) {
        this.payments = payments;
    }

    public PaymentScheduleItem runHour(Integer runHour) {
        this.runHour = runHour;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="At which hour in the day in the tenant's timezone this payment will be collected. Available values:[0,1,2,~,22,23]. If the time difference between your tenant\u2019s timezone and the timezone where Zuora servers are located is not in full hours, for example, 2.5 hours, the payment schedule items will be triggered half an hour later than your scheduled time. The default value is 0. If the payment run_hour and scheduled_date are backdated, the system will collect the payment when the next run_hour occurs.")
    public Integer getRunHour() {
        return this.runHour;
    }

    public void setRunHour(Integer runHour) {
        this.runHour = runHour;
    }

    public PaymentScheduleItem scheduledDate(LocalDate scheduledDate) {
        this.scheduledDate = scheduledDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Sat Jan 01 00:00:00 GMT 2022", value="The scheduled date of collection.")
    public LocalDate getScheduledDate() {
        return this.scheduledDate;
    }

    public void setScheduledDate(LocalDate scheduledDate) {
        this.scheduledDate = scheduledDate;
    }

    public PaymentScheduleItem standalone(Boolean standalone) {
        this.standalone = standalone;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates whether the payments created by the payment schedule are standalone payments or not. When setting to true, standalone payments will be created. When setting to false, you can either specify a billing document, or not specifying any billing documents. In the later case, unapplied payments will be created. If set to null, standalone payments will be created. Note: This parameter is only available if standalone payments are enabled in your tenant. Do not include this parameter if standalone payment have not been enabled in your tenant. If standalone payments are enabled, the default value is true.")
    public Boolean getStandalone() {
        return this.standalone;
    }

    public void setStandalone(Boolean standalone) {
        this.standalone = standalone;
    }

    public PaymentScheduleItem state(StateEnum state) {
        this.state = state;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The status of the payment schedule item. active: there are unprocessed payment schedule items. canceled: the payment schedule has been canceled. complete: the payment schedule is complete and all items have been processed.")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public PaymentScheduleItem errorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An error message indicating why payment collection failed for this payment schedule item.")
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    @Nullable
    @ApiModelProperty(value="List of customer payments.")
    public Payment getPayment() {
        return this.payment;
    }

    @Nullable
    @ApiModelProperty(value="Payment schedule record.")
    public PaymentSchedule getPaymentSchedule() {
        return this.paymentSchedule;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentScheduleItem paymentScheduleItem = (PaymentScheduleItem)o;
        return Objects.equals(this.id, paymentScheduleItem.id) && Objects.equals(this.updatedById, paymentScheduleItem.updatedById) && Objects.equals(this.updatedTime, paymentScheduleItem.updatedTime) && Objects.equals(this.createdById, paymentScheduleItem.createdById) && Objects.equals(this.createdTime, paymentScheduleItem.createdTime) && Objects.equals(this.customFields, paymentScheduleItem.customFields) && Objects.equals(this.customObjects, paymentScheduleItem.customObjects) && Objects.equals(this.accountId, paymentScheduleItem.accountId) && Objects.equals(this.amount, paymentScheduleItem.amount) && Objects.equals(this.balance, paymentScheduleItem.balance) && Objects.equals(this.billingDocument, paymentScheduleItem.billingDocument) && Objects.equals(this.cancellationReason, paymentScheduleItem.cancellationReason) && Objects.equals(this.currency, paymentScheduleItem.currency) && Objects.equals(this.description, paymentScheduleItem.description) && Objects.equals(this.paymentScheduleItemNumber, paymentScheduleItem.paymentScheduleItemNumber) && Objects.equals(this.paymentGatewayId, paymentScheduleItem.paymentGatewayId) && Objects.equals(this.paymentMethodId, paymentScheduleItem.paymentMethodId) && Objects.equals(this.paymentOptionId, paymentScheduleItem.paymentOptionId) && Objects.equals(this.paymentScheduleId, paymentScheduleItem.paymentScheduleId) && Objects.equals(this.paymentScheduleNumber, paymentScheduleItem.paymentScheduleNumber) && Objects.equals(this.payments, paymentScheduleItem.payments) && Objects.equals(this.runHour, paymentScheduleItem.runHour) && Objects.equals(this.scheduledDate, paymentScheduleItem.scheduledDate) && Objects.equals(this.standalone, paymentScheduleItem.standalone) && Objects.equals((Object)this.state, (Object)paymentScheduleItem.state) && Objects.equals(this.errorMessage, paymentScheduleItem.errorMessage) && Objects.equals(this.payment, paymentScheduleItem.payment) && Objects.equals(this.paymentSchedule, paymentScheduleItem.paymentSchedule);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.updatedById, this.updatedTime, this.createdById, this.createdTime, this.customFields, this.customObjects, this.accountId, this.amount, this.balance, this.billingDocument, this.cancellationReason, this.currency, this.description, this.paymentScheduleItemNumber, this.paymentGatewayId, this.paymentMethodId, this.paymentOptionId, this.paymentScheduleId, this.paymentScheduleNumber, this.payments, this.runHour, this.scheduledDate, this.standalone, this.state, this.errorMessage, this.payment, this.paymentSchedule});
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentScheduleItem {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    updatedById: ").append(this.toIndentedString(this.updatedById)).append("\n");
        sb.append("    updatedTime: ").append(this.toIndentedString(this.updatedTime)).append("\n");
        sb.append("    createdById: ").append(this.toIndentedString(this.createdById)).append("\n");
        sb.append("    createdTime: ").append(this.toIndentedString(this.createdTime)).append("\n");
        sb.append("    customFields: ").append(this.toIndentedString(this.customFields)).append("\n");
        sb.append("    customObjects: ").append(this.toIndentedString(this.customObjects)).append("\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    balance: ").append(this.toIndentedString(this.balance)).append("\n");
        sb.append("    billingDocument: ").append(this.toIndentedString(this.billingDocument)).append("\n");
        sb.append("    cancellationReason: ").append(this.toIndentedString(this.cancellationReason)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    paymentScheduleItemNumber: ").append(this.toIndentedString(this.paymentScheduleItemNumber)).append("\n");
        sb.append("    paymentGatewayId: ").append(this.toIndentedString(this.paymentGatewayId)).append("\n");
        sb.append("    paymentMethodId: ").append(this.toIndentedString(this.paymentMethodId)).append("\n");
        sb.append("    paymentOptionId: ").append(this.toIndentedString(this.paymentOptionId)).append("\n");
        sb.append("    paymentScheduleId: ").append(this.toIndentedString(this.paymentScheduleId)).append("\n");
        sb.append("    paymentScheduleNumber: ").append(this.toIndentedString(this.paymentScheduleNumber)).append("\n");
        sb.append("    payments: ").append(this.toIndentedString(this.payments)).append("\n");
        sb.append("    runHour: ").append(this.toIndentedString(this.runHour)).append("\n");
        sb.append("    scheduledDate: ").append(this.toIndentedString(this.scheduledDate)).append("\n");
        sb.append("    standalone: ").append(this.toIndentedString(this.standalone)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    errorMessage: ").append(this.toIndentedString(this.errorMessage)).append("\n");
        sb.append("    payment: ").append(this.toIndentedString(this.payment)).append("\n");
        sb.append("    paymentSchedule: ").append(this.toIndentedString(this.paymentSchedule)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StateEnum {
        PENDING("pending"),
        CANCELED("canceled"),
        COMPLETE("complete"),
        ERROR("error"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StateEnum fromValue(String value) {
            for (StateEnum b : StateEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<StateEnum> {
            public void write(JsonWriter jsonWriter, StateEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StateEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StateEnum.fromValue(value);
            }
        }
    }
}

