/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PaymentMethodVoidAuthorizationRequest {
    public static final String SERIALIZED_NAME_ACCOUNT_ID = "account_id";
    @SerializedName(value="account_id")
    private String accountId;
    public static final String SERIALIZED_NAME_ACCOUNT_NUMBER = "account_number";
    @SerializedName(value="account_number")
    private String accountNumber;
    public static final String SERIALIZED_NAME_GATEWAY_ID = "gateway_id";
    @SerializedName(value="gateway_id")
    private String gatewayId;
    public static final String SERIALIZED_NAME_GATEWAY_OPTIONS = "gateway_options";
    @SerializedName(value="gateway_options")
    private Map<String, Object> gatewayOptions = null;
    public static final String SERIALIZED_NAME_GATEWAY_ORDER_ID = "gateway_order_id";
    @SerializedName(value="gateway_order_id")
    private String gatewayOrderId;
    public static final String SERIALIZED_NAME_AUTH_TRANSACTION_ID = "auth_transaction_id";
    @SerializedName(value="auth_transaction_id")
    private String authTransactionId;

    public PaymentMethodVoidAuthorizationRequest accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2c92c0f86a8dd422016a9e7a70116b0d", value="A customer account identifier. Either `account_id` or `account_number` is required.")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public PaymentMethodVoidAuthorizationRequest accountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="RC-00000011", value="A Human-readable customer account identifier. Either `account_id` or `account_number` is required.")
    public String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public PaymentMethodVoidAuthorizationRequest gatewayId(String gatewayId) {
        this.gatewayId = gatewayId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="8ad093d07ae636bb017ae97518762aa3", value="Identifier of the payment gateway that Zuora will use to authorize the payments that are made with this payment method. If you do not set this field, Zuora will use one of the following payment gateways instead: The default payment gateway of the customer account that owns the payment method, if the payment method is associated with a customer account or the default payment gateway of your Zuora tenant.")
    public String getGatewayId() {
        return this.gatewayId;
    }

    public void setGatewayId(String gatewayId) {
        this.gatewayId = gatewayId;
    }

    public PaymentMethodVoidAuthorizationRequest gatewayOptions(Map<String, Object> gatewayOptions) {
        this.gatewayOptions = gatewayOptions;
        return this;
    }

    public PaymentMethodVoidAuthorizationRequest putGatewayOptionsItem(String key, Object gatewayOptionsItem) {
        if (this.gatewayOptions == null) {
            this.gatewayOptions = new HashMap<String, Object>();
        }
        this.gatewayOptions.put(key, gatewayOptionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="{\"key\":\"value\"}", value="A hash containing gateway-specific parameters.")
    public Map<String, Object> getGatewayOptions() {
        return this.gatewayOptions;
    }

    public void setGatewayOptions(Map<String, Object> gatewayOptions) {
        this.gatewayOptions = gatewayOptions;
    }

    public PaymentMethodVoidAuthorizationRequest gatewayOrderId(String gatewayOrderId) {
        this.gatewayOrderId = gatewayOrderId;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="A merchant-specified natural key value that can be passed to the electronic payment gateway when a payment is created. If not specified, the payment number will be passed in instead. Gateways check duplicates on the gateway order ID to ensure that the merchant do not accidentally enter the same transaction twice. This ID can also be used to do reconciliation and tie the payment to a natural key in external systems. The source of this ID varies by merchant. Some merchants use their shopping cart order IDs, and others use something different. Merchants use this ID to track transactions in their eCommerce systems. When you create a payment for capturing the authorized funds, it is highly recommended to pass in the `gateway_order_id` that you used when authorizing the funds by using the Create authorization operation, together with the `authorization_id` field.")
    public String getGatewayOrderId() {
        return this.gatewayOrderId;
    }

    public void setGatewayOrderId(String gatewayOrderId) {
        this.gatewayOrderId = gatewayOrderId;
    }

    public PaymentMethodVoidAuthorizationRequest authTransactionId(String authTransactionId) {
        this.authTransactionId = authTransactionId;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Identifier of the authorization transaction from the payment gateway.")
    public String getAuthTransactionId() {
        return this.authTransactionId;
    }

    public void setAuthTransactionId(String authTransactionId) {
        this.authTransactionId = authTransactionId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentMethodVoidAuthorizationRequest paymentMethodVoidAuthorizationRequest = (PaymentMethodVoidAuthorizationRequest)o;
        return Objects.equals(this.accountId, paymentMethodVoidAuthorizationRequest.accountId) && Objects.equals(this.accountNumber, paymentMethodVoidAuthorizationRequest.accountNumber) && Objects.equals(this.gatewayId, paymentMethodVoidAuthorizationRequest.gatewayId) && Objects.equals(this.gatewayOptions, paymentMethodVoidAuthorizationRequest.gatewayOptions) && Objects.equals(this.gatewayOrderId, paymentMethodVoidAuthorizationRequest.gatewayOrderId) && Objects.equals(this.authTransactionId, paymentMethodVoidAuthorizationRequest.authTransactionId);
    }

    public int hashCode() {
        return Objects.hash(this.accountId, this.accountNumber, this.gatewayId, this.gatewayOptions, this.gatewayOrderId, this.authTransactionId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentMethodVoidAuthorizationRequest {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    accountNumber: ").append(this.toIndentedString(this.accountNumber)).append("\n");
        sb.append("    gatewayId: ").append(this.toIndentedString(this.gatewayId)).append("\n");
        sb.append("    gatewayOptions: ").append(this.toIndentedString(this.gatewayOptions)).append("\n");
        sb.append("    gatewayOrderId: ").append(this.toIndentedString(this.gatewayOrderId)).append("\n");
        sb.append("    authTransactionId: ").append(this.toIndentedString(this.authTransactionId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

