/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="An object defining how overage charges are calculated.")
public class Overage {
    public static final String SERIALIZED_NAME_INTERVAL_COUNT = "interval_count";
    @SerializedName(value="interval_count")
    private Integer intervalCount;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private TypeEnum type;
    public static final String SERIALIZED_NAME_INCLUDED_UNITS = "included_units";
    @SerializedName(value="included_units")
    private BigDecimal includedUnits;
    public static final String SERIALIZED_NAME_CREDIT_UNUSED_UNITS = "credit_unused_units";
    @SerializedName(value="credit_unused_units")
    private Boolean creditUnusedUnits;
    public static final String SERIALIZED_NAME_APPLY_AT_END_OF_SMOOTHING_PERIOD = "apply_at_end_of_smoothing_period";
    @SerializedName(value="apply_at_end_of_smoothing_period")
    private Boolean applyAtEndOfSmoothingPeriod;

    public Overage intervalCount(Integer intervalCount) {
        this.intervalCount = intervalCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specifies the number of intervals used to calculate smoothed overage charges.")
    public Integer getIntervalCount() {
        return this.intervalCount;
    }

    public void setIntervalCount(Integer intervalCount) {
        this.intervalCount = intervalCount;
    }

    public Overage type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Represents the overage type: one of rolling_window or rollover.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public Overage includedUnits(BigDecimal includedUnits) {
        this.includedUnits = includedUnits;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specifies the included units to which overage charges do not apply.")
    public BigDecimal getIncludedUnits() {
        return this.includedUnits;
    }

    public void setIncludedUnits(BigDecimal includedUnits) {
        this.includedUnits = includedUnits;
    }

    public Overage creditUnusedUnits(Boolean creditUnusedUnits) {
        this.creditUnusedUnits = creditUnusedUnits;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specifies whether or not to credit unused units.")
    public Boolean getCreditUnusedUnits() {
        return this.creditUnusedUnits;
    }

    public void setCreditUnusedUnits(Boolean creditUnusedUnits) {
        this.creditUnusedUnits = creditUnusedUnits;
    }

    public Overage applyAtEndOfSmoothingPeriod(Boolean applyAtEndOfSmoothingPeriod) {
        this.applyAtEndOfSmoothingPeriod = applyAtEndOfSmoothingPeriod;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates if the overage price is calculated at the end of the smoothing period.")
    public Boolean getApplyAtEndOfSmoothingPeriod() {
        return this.applyAtEndOfSmoothingPeriod;
    }

    public void setApplyAtEndOfSmoothingPeriod(Boolean applyAtEndOfSmoothingPeriod) {
        this.applyAtEndOfSmoothingPeriod = applyAtEndOfSmoothingPeriod;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Overage overage = (Overage)o;
        return Objects.equals(this.intervalCount, overage.intervalCount) && Objects.equals((Object)this.type, (Object)overage.type) && Objects.equals(this.includedUnits, overage.includedUnits) && Objects.equals(this.creditUnusedUnits, overage.creditUnusedUnits) && Objects.equals(this.applyAtEndOfSmoothingPeriod, overage.applyAtEndOfSmoothingPeriod);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.intervalCount, this.type, this.includedUnits, this.creditUnusedUnits, this.applyAtEndOfSmoothingPeriod});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Overage {\n");
        sb.append("    intervalCount: ").append(this.toIndentedString(this.intervalCount)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    includedUnits: ").append(this.toIndentedString(this.includedUnits)).append("\n");
        sb.append("    creditUnusedUnits: ").append(this.toIndentedString(this.creditUnusedUnits)).append("\n");
        sb.append("    applyAtEndOfSmoothingPeriod: ").append(this.toIndentedString(this.applyAtEndOfSmoothingPeriod)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        ROLLING_WINDOW("rolling_window"),
        ROLLOVER("rollover"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(value);
            }
        }
    }
}

