/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.client.JSON;
import org.openapitools.client.model.OrderLineItemRevenue;
import org.threeten.bp.LocalDate;

@ApiModel(description="Update an order line item")
public class LineItemPatchRequest {
    public static final String SERIALIZED_NAME_REVENUE = "revenue";
    @SerializedName(value="revenue")
    private OrderLineItemRevenue revenue;
    public static final String SERIALIZED_NAME_UNIT_OF_MEASURE = "unit_of_measure";
    @SerializedName(value="unit_of_measure")
    private String unitOfMeasure;
    public static final String SERIALIZED_NAME_ACCOUNTING_CODE = "accounting_code";
    @SerializedName(value="accounting_code")
    private String accountingCode;
    public static final String SERIALIZED_NAME_ADJUSTMENT_LIABILITY_ACCOUNT = "adjustment_liability_account";
    @SerializedName(value="adjustment_liability_account")
    private String adjustmentLiabilityAccount;
    public static final String SERIALIZED_NAME_UNIT_AMOUNT = "unit_amount";
    @SerializedName(value="unit_amount")
    private BigDecimal unitAmount;
    public static final String SERIALIZED_NAME_TARGET_DATE = "target_date";
    @SerializedName(value="target_date")
    private LocalDate targetDate;
    public static final String SERIALIZED_NAME_BILLING_RULE = "billing_rule";
    @SerializedName(value="billing_rule")
    private BillingRuleEnum billingRule;
    public static final String SERIALIZED_NAME_CONTRACT_ASSET_ACCOUNT = "contract_asset_account";
    @SerializedName(value="contract_asset_account")
    private String contractAssetAccount;
    public static final String SERIALIZED_NAME_CONTRACT_LIABILITY_ACCOUNT = "contract_liability_account";
    @SerializedName(value="contract_liability_account")
    private String contractLiabilityAccount;
    public static final String SERIALIZED_NAME_CUSTOM_FIELDS = "custom_fields";
    @SerializedName(value="custom_fields")
    @JsonAdapter(value=JSON.CustomFieldAdapter.class)
    private Map<String, Object> customFields = null;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_DISCOUNT_UNIT_AMOUNT = "discount_unit_amount";
    @SerializedName(value="discount_unit_amount")
    private BigDecimal discountUnitAmount;
    public static final String SERIALIZED_NAME_DISCOUNT_PERCENT = "discount_percent";
    @SerializedName(value="discount_percent")
    private BigDecimal discountPercent;
    public static final String SERIALIZED_NAME_CATEGORY = "category";
    @SerializedName(value="category")
    private CategoryEnum category;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private TypeEnum type;
    public static final String SERIALIZED_NAME_LIST_UNIT_PRICE = "list_unit_price";
    @SerializedName(value="list_unit_price")
    private BigDecimal listUnitPrice;
    public static final String SERIALIZED_NAME_PRODUCT_CODE = "product_code";
    @SerializedName(value="product_code")
    private String productCode;
    public static final String SERIALIZED_NAME_PURCHASE_ORDER_NUMBER = "purchase_order_number";
    @SerializedName(value="purchase_order_number")
    private String purchaseOrderNumber;
    public static final String SERIALIZED_NAME_QUANTITY = "quantity";
    @SerializedName(value="quantity")
    private BigDecimal quantity;
    public static final String SERIALIZED_NAME_RELATED_SUBSCRIPTION_NUMBER = "related_subscription_number";
    @SerializedName(value="related_subscription_number")
    private String relatedSubscriptionNumber;
    public static final String SERIALIZED_NAME_SOLD_TO_ID = "sold_to_id";
    @SerializedName(value="sold_to_id")
    private String soldToId;
    public static final String SERIALIZED_NAME_TAX_CODE = "tax_code";
    @SerializedName(value="tax_code")
    private String taxCode;
    public static final String SERIALIZED_NAME_UNBILLED_RECEIVABLES_ACCOUNT = "unbilled_receivables_account";
    @SerializedName(value="unbilled_receivables_account")
    private String unbilledReceivablesAccount;
    public static final String SERIALIZED_NAME_STATE = "state";
    @SerializedName(value="state")
    private StateEnum state;
    public static final String SERIALIZED_NAME_ITEM_NUMBER = "item_number";
    @SerializedName(value="item_number")
    private String itemNumber;
    public static final String SERIALIZED_NAME_START_DATE = "start_date";
    @SerializedName(value="start_date")
    private LocalDate startDate;
    public static final String SERIALIZED_NAME_END_DATE = "end_date";
    @SerializedName(value="end_date")
    private LocalDate endDate;

    public LineItemPatchRequest revenue(OrderLineItemRevenue revenue) {
        this.revenue = revenue;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public OrderLineItemRevenue getRevenue() {
        return this.revenue;
    }

    public void setRevenue(OrderLineItemRevenue revenue) {
        this.revenue = revenue;
    }

    public LineItemPatchRequest unitOfMeasure(String unitOfMeasure) {
        this.unitOfMeasure = unitOfMeasure;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A configured unit of measure.")
    public String getUnitOfMeasure() {
        return this.unitOfMeasure;
    }

    public void setUnitOfMeasure(String unitOfMeasure) {
        this.unitOfMeasure = unitOfMeasure;
    }

    public LineItemPatchRequest accountingCode(String accountingCode) {
        this.accountingCode = accountingCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An active accounting code in your Zuora chart of accounts.")
    public String getAccountingCode() {
        return this.accountingCode;
    }

    public void setAccountingCode(String accountingCode) {
        this.accountingCode = accountingCode;
    }

    public LineItemPatchRequest adjustmentLiabilityAccount(String adjustmentLiabilityAccount) {
        this.adjustmentLiabilityAccount = adjustmentLiabilityAccount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An active accounting code in your Zuora chart of accounts.")
    public String getAdjustmentLiabilityAccount() {
        return this.adjustmentLiabilityAccount;
    }

    public void setAdjustmentLiabilityAccount(String adjustmentLiabilityAccount) {
        this.adjustmentLiabilityAccount = adjustmentLiabilityAccount;
    }

    public LineItemPatchRequest unitAmount(BigDecimal unitAmount) {
        this.unitAmount = unitAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The unit amount to be charged.")
    public BigDecimal getUnitAmount() {
        return this.unitAmount;
    }

    public void setUnitAmount(BigDecimal unitAmount) {
        this.unitAmount = unitAmount;
    }

    public LineItemPatchRequest targetDate(LocalDate targetDate) {
        this.targetDate = targetDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="All order line items that were unbilled on or before this date are included in future bill runs.")
    public LocalDate getTargetDate() {
        return this.targetDate;
    }

    public void setTargetDate(LocalDate targetDate) {
        this.targetDate = targetDate;
    }

    public LineItemPatchRequest billingRule(BillingRuleEnum billingRule) {
        this.billingRule = billingRule;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The billing rule for the order line item.")
    public BillingRuleEnum getBillingRule() {
        return this.billingRule;
    }

    public void setBillingRule(BillingRuleEnum billingRule) {
        this.billingRule = billingRule;
    }

    public LineItemPatchRequest contractAssetAccount(String contractAssetAccount) {
        this.contractAssetAccount = contractAssetAccount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An active accounting code in your Zuora chart of accounts.")
    public String getContractAssetAccount() {
        return this.contractAssetAccount;
    }

    public void setContractAssetAccount(String contractAssetAccount) {
        this.contractAssetAccount = contractAssetAccount;
    }

    public LineItemPatchRequest contractLiabilityAccount(String contractLiabilityAccount) {
        this.contractLiabilityAccount = contractLiabilityAccount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An active accounting code in your Zuora chart of accounts.")
    public String getContractLiabilityAccount() {
        return this.contractLiabilityAccount;
    }

    public void setContractLiabilityAccount(String contractLiabilityAccount) {
        this.contractLiabilityAccount = contractLiabilityAccount;
    }

    public LineItemPatchRequest customFields(Map<String, Object> customFields) {
        this.customFields = customFields;
        return this;
    }

    public LineItemPatchRequest putCustomFieldsItem(String key, Object customFieldsItem) {
        if (this.customFields == null) {
            this.customFields = new HashMap<String, Object>();
        }
        this.customFields.put(key, customFieldsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Set of user-defined fields associated with this object. Useful for storing additional information about the object in a structured format.")
    public Map<String, Object> getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(Map<String, Object> customFields) {
        this.customFields = customFields;
    }

    public LineItemPatchRequest description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An arbitrary string attached to the object. Often useful for displaying to users.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public LineItemPatchRequest discountUnitAmount(BigDecimal discountUnitAmount) {
        this.discountUnitAmount = discountUnitAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Discount amount per unit.")
    public BigDecimal getDiscountUnitAmount() {
        return this.discountUnitAmount;
    }

    public void setDiscountUnitAmount(BigDecimal discountUnitAmount) {
        this.discountUnitAmount = discountUnitAmount;
    }

    public LineItemPatchRequest discountPercent(BigDecimal discountPercent) {
        this.discountPercent = discountPercent;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Discount percent.")
    public BigDecimal getDiscountPercent() {
        return this.discountPercent;
    }

    public void setDiscountPercent(BigDecimal discountPercent) {
        this.discountPercent = discountPercent;
    }

    public LineItemPatchRequest category(CategoryEnum category) {
        this.category = category;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Category of the order line item.")
    public CategoryEnum getCategory() {
        return this.category;
    }

    public void setCategory(CategoryEnum category) {
        this.category = category;
    }

    public LineItemPatchRequest name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of the order line item.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public LineItemPatchRequest type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The type of the order line item.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public LineItemPatchRequest listUnitPrice(BigDecimal listUnitPrice) {
        this.listUnitPrice = listUnitPrice;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The list price per unit for the order line item.")
    public BigDecimal getListUnitPrice() {
        return this.listUnitPrice;
    }

    public void setListUnitPrice(BigDecimal listUnitPrice) {
        this.listUnitPrice = listUnitPrice;
    }

    public LineItemPatchRequest productCode(String productCode) {
        this.productCode = productCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The product code for the order line item.")
    public String getProductCode() {
        return this.productCode;
    }

    public void setProductCode(String productCode) {
        this.productCode = productCode;
    }

    public LineItemPatchRequest purchaseOrderNumber(String purchaseOrderNumber) {
        this.purchaseOrderNumber = purchaseOrderNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Used by customers to specify the Purchase Order Number provided by the buyer.")
    public String getPurchaseOrderNumber() {
        return this.purchaseOrderNumber;
    }

    public void setPurchaseOrderNumber(String purchaseOrderNumber) {
        this.purchaseOrderNumber = purchaseOrderNumber;
    }

    public LineItemPatchRequest quantity(BigDecimal quantity) {
        this.quantity = quantity;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The quantity of the product ordered.")
    public BigDecimal getQuantity() {
        return this.quantity;
    }

    public void setQuantity(BigDecimal quantity) {
        this.quantity = quantity;
    }

    public LineItemPatchRequest relatedSubscriptionNumber(String relatedSubscriptionNumber) {
        this.relatedSubscriptionNumber = relatedSubscriptionNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Use this field to relate an order line item to an subscription.")
    public String getRelatedSubscriptionNumber() {
        return this.relatedSubscriptionNumber;
    }

    public void setRelatedSubscriptionNumber(String relatedSubscriptionNumber) {
        this.relatedSubscriptionNumber = relatedSubscriptionNumber;
    }

    public LineItemPatchRequest soldToId(String soldToId) {
        this.soldToId = soldToId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="8ad0823f8040e52d0180433026b156fe", value="The unique identifier of a contact belonging to the billing account of the order line item. Use this field to assign and existing contact as the sold to contact of an order line item.")
    public String getSoldToId() {
        return this.soldToId;
    }

    public void setSoldToId(String soldToId) {
        this.soldToId = soldToId;
    }

    public LineItemPatchRequest taxCode(String taxCode) {
        this.taxCode = taxCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The tax code for the order line item.")
    public String getTaxCode() {
        return this.taxCode;
    }

    public void setTaxCode(String taxCode) {
        this.taxCode = taxCode;
    }

    public LineItemPatchRequest unbilledReceivablesAccount(String unbilledReceivablesAccount) {
        this.unbilledReceivablesAccount = unbilledReceivablesAccount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An active accounting code in your Zuora chart of accounts..")
    public String getUnbilledReceivablesAccount() {
        return this.unbilledReceivablesAccount;
    }

    public void setUnbilledReceivablesAccount(String unbilledReceivablesAccount) {
        this.unbilledReceivablesAccount = unbilledReceivablesAccount;
    }

    public LineItemPatchRequest state(StateEnum state) {
        this.state = state;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The state of an order line item. If you want to generate billing documents for order line items, you must set this field to `sent_to_billing`. For invoice preview, you do not need to set this field.")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public LineItemPatchRequest itemNumber(String itemNumber) {
        this.itemNumber = itemNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Human-readable identifier of the order item. It can be user-supplied.")
    public String getItemNumber() {
        return this.itemNumber;
    }

    public void setItemNumber(String itemNumber) {
        this.itemNumber = itemNumber;
    }

    public LineItemPatchRequest startDate(LocalDate startDate) {
        this.startDate = startDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Sat Jan 01 00:00:00 GMT 2022", value="The date a transaction starts. The default value of this field is the order date.")
    public LocalDate getStartDate() {
        return this.startDate;
    }

    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public LineItemPatchRequest endDate(LocalDate endDate) {
        this.endDate = endDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Sat Jan 01 00:00:00 GMT 2022", value="The date the order line item transitions to complete.")
    public LocalDate getEndDate() {
        return this.endDate;
    }

    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LineItemPatchRequest lineItemPatchRequest = (LineItemPatchRequest)o;
        return Objects.equals(this.revenue, lineItemPatchRequest.revenue) && Objects.equals(this.unitOfMeasure, lineItemPatchRequest.unitOfMeasure) && Objects.equals(this.accountingCode, lineItemPatchRequest.accountingCode) && Objects.equals(this.adjustmentLiabilityAccount, lineItemPatchRequest.adjustmentLiabilityAccount) && Objects.equals(this.unitAmount, lineItemPatchRequest.unitAmount) && Objects.equals(this.targetDate, lineItemPatchRequest.targetDate) && Objects.equals((Object)this.billingRule, (Object)lineItemPatchRequest.billingRule) && Objects.equals(this.contractAssetAccount, lineItemPatchRequest.contractAssetAccount) && Objects.equals(this.contractLiabilityAccount, lineItemPatchRequest.contractLiabilityAccount) && Objects.equals(this.customFields, lineItemPatchRequest.customFields) && Objects.equals(this.description, lineItemPatchRequest.description) && Objects.equals(this.discountUnitAmount, lineItemPatchRequest.discountUnitAmount) && Objects.equals(this.discountPercent, lineItemPatchRequest.discountPercent) && Objects.equals((Object)this.category, (Object)lineItemPatchRequest.category) && Objects.equals(this.name, lineItemPatchRequest.name) && Objects.equals((Object)this.type, (Object)lineItemPatchRequest.type) && Objects.equals(this.listUnitPrice, lineItemPatchRequest.listUnitPrice) && Objects.equals(this.productCode, lineItemPatchRequest.productCode) && Objects.equals(this.purchaseOrderNumber, lineItemPatchRequest.purchaseOrderNumber) && Objects.equals(this.quantity, lineItemPatchRequest.quantity) && Objects.equals(this.relatedSubscriptionNumber, lineItemPatchRequest.relatedSubscriptionNumber) && Objects.equals(this.soldToId, lineItemPatchRequest.soldToId) && Objects.equals(this.taxCode, lineItemPatchRequest.taxCode) && Objects.equals(this.unbilledReceivablesAccount, lineItemPatchRequest.unbilledReceivablesAccount) && Objects.equals((Object)this.state, (Object)lineItemPatchRequest.state) && Objects.equals(this.itemNumber, lineItemPatchRequest.itemNumber) && Objects.equals(this.startDate, lineItemPatchRequest.startDate) && Objects.equals(this.endDate, lineItemPatchRequest.endDate);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.revenue, this.unitOfMeasure, this.accountingCode, this.adjustmentLiabilityAccount, this.unitAmount, this.targetDate, this.billingRule, this.contractAssetAccount, this.contractLiabilityAccount, this.customFields, this.description, this.discountUnitAmount, this.discountPercent, this.category, this.name, this.type, this.listUnitPrice, this.productCode, this.purchaseOrderNumber, this.quantity, this.relatedSubscriptionNumber, this.soldToId, this.taxCode, this.unbilledReceivablesAccount, this.state, this.itemNumber, this.startDate, this.endDate});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LineItemPatchRequest {\n");
        sb.append("    revenue: ").append(this.toIndentedString(this.revenue)).append("\n");
        sb.append("    unitOfMeasure: ").append(this.toIndentedString(this.unitOfMeasure)).append("\n");
        sb.append("    accountingCode: ").append(this.toIndentedString(this.accountingCode)).append("\n");
        sb.append("    adjustmentLiabilityAccount: ").append(this.toIndentedString(this.adjustmentLiabilityAccount)).append("\n");
        sb.append("    unitAmount: ").append(this.toIndentedString(this.unitAmount)).append("\n");
        sb.append("    targetDate: ").append(this.toIndentedString(this.targetDate)).append("\n");
        sb.append("    billingRule: ").append(this.toIndentedString((Object)this.billingRule)).append("\n");
        sb.append("    contractAssetAccount: ").append(this.toIndentedString(this.contractAssetAccount)).append("\n");
        sb.append("    contractLiabilityAccount: ").append(this.toIndentedString(this.contractLiabilityAccount)).append("\n");
        sb.append("    customFields: ").append(this.toIndentedString(this.customFields)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    discountUnitAmount: ").append(this.toIndentedString(this.discountUnitAmount)).append("\n");
        sb.append("    discountPercent: ").append(this.toIndentedString(this.discountPercent)).append("\n");
        sb.append("    category: ").append(this.toIndentedString((Object)this.category)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    listUnitPrice: ").append(this.toIndentedString(this.listUnitPrice)).append("\n");
        sb.append("    productCode: ").append(this.toIndentedString(this.productCode)).append("\n");
        sb.append("    purchaseOrderNumber: ").append(this.toIndentedString(this.purchaseOrderNumber)).append("\n");
        sb.append("    quantity: ").append(this.toIndentedString(this.quantity)).append("\n");
        sb.append("    relatedSubscriptionNumber: ").append(this.toIndentedString(this.relatedSubscriptionNumber)).append("\n");
        sb.append("    soldToId: ").append(this.toIndentedString(this.soldToId)).append("\n");
        sb.append("    taxCode: ").append(this.toIndentedString(this.taxCode)).append("\n");
        sb.append("    unbilledReceivablesAccount: ").append(this.toIndentedString(this.unbilledReceivablesAccount)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    itemNumber: ").append(this.toIndentedString(this.itemNumber)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StateEnum {
        PENDING("pending"),
        BOOKED("booked"),
        SENT_TO_BILLING("sent_to_billing"),
        COMPLETE("complete"),
        CANCELED("canceled"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StateEnum fromValue(String value) {
            for (StateEnum b : StateEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<StateEnum> {
            public void write(JsonWriter jsonWriter, StateEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StateEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StateEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        PRODUCT("product"),
        FEE("fee"),
        SERVICES("services"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum CategoryEnum {
        SALE("sale"),
        RETURN("return"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private CategoryEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static CategoryEnum fromValue(String value) {
            for (CategoryEnum b : CategoryEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<CategoryEnum> {
            public void write(JsonWriter jsonWriter, CategoryEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public CategoryEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return CategoryEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum BillingRuleEnum {
        WITHOUT_FULFILLMENT("trigger_without_fulfillment"),
        ON_FULFILLMENT("trigger_on_fulfillment"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private BillingRuleEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static BillingRuleEnum fromValue(String value) {
            for (BillingRuleEnum b : BillingRuleEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<BillingRuleEnum> {
            public void write(JsonWriter jsonWriter, BillingRuleEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public BillingRuleEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return BillingRuleEnum.fromValue(value);
            }
        }
    }
}

