/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.client.JSON;
import org.openapitools.client.model.ProcessingOptions;
import org.openapitools.client.model.WriteOffSuscriptionRequest;
import org.openapitools.jackson.nullable.JsonNullable;

public class CancelSubscriptionRequest {
    public static final String SERIALIZED_NAME_CANCEL_DATE = "cancel_date";
    @SerializedName(value="cancel_date")
    private String cancelDate;
    public static final String SERIALIZED_NAME_CANCEL_AT = "cancel_at";
    @SerializedName(value="cancel_at")
    private CancelAtEnum cancelAt;
    public static final String SERIALIZED_NAME_PROCESSING_OPTIONS = "processing_options";
    @SerializedName(value="processing_options")
    private ProcessingOptions processingOptions;
    public static final String SERIALIZED_NAME_REFUND_AMOUNT = "refund_amount";
    @SerializedName(value="refund_amount")
    private BigDecimal refundAmount;
    public static final String SERIALIZED_NAME_WRITE_OFF = "write_off";
    @SerializedName(value="write_off")
    private Boolean writeOff = false;
    public static final String SERIALIZED_NAME_WRITE_OFF_BEHAVIOR = "write_off_behavior";
    @SerializedName(value="write_off_behavior")
    private WriteOffSuscriptionRequest writeOffBehavior;
    public static final String SERIALIZED_NAME_CUSTOM_FIELDS = "custom_fields";
    @SerializedName(value="custom_fields")
    @JsonAdapter(value=JSON.CustomFieldAdapter.class)
    private Map<String, Object> customFields = null;
    public static final String SERIALIZED_NAME_CHANGE_REASON = "change_reason";
    @SerializedName(value="change_reason")
    private String changeReason;

    public CancelSubscriptionRequest cancelDate(String cancelDate) {
        this.cancelDate = cancelDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Date on which the subscription is canceled.")
    public String getCancelDate() {
        return this.cancelDate;
    }

    public void setCancelDate(String cancelDate) {
        this.cancelDate = cancelDate;
    }

    public CancelSubscriptionRequest cancelAt(CancelAtEnum cancelAt) {
        this.cancelAt = cancelAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The date on which the subscription is canceled. Can be either the end of the subscription term or the end of the billing period.")
    public CancelAtEnum getCancelAt() {
        return this.cancelAt;
    }

    public void setCancelAt(CancelAtEnum cancelAt) {
        this.cancelAt = cancelAt;
    }

    public CancelSubscriptionRequest processingOptions(ProcessingOptions processingOptions) {
        this.processingOptions = processingOptions;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Processing options for the invoice or payment.")
    public ProcessingOptions getProcessingOptions() {
        return this.processingOptions;
    }

    public void setProcessingOptions(ProcessingOptions processingOptions) {
        this.processingOptions = processingOptions;
    }

    public CancelSubscriptionRequest refundAmount(BigDecimal refundAmount) {
        this.refundAmount = refundAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Amount to be refunded")
    public BigDecimal getRefundAmount() {
        return this.refundAmount;
    }

    public void setRefundAmount(BigDecimal refundAmount) {
        this.refundAmount = refundAmount;
    }

    public CancelSubscriptionRequest writeOff(Boolean writeOff) {
        this.writeOff = writeOff;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates whether to write off the outstanding balance on the invoice after canceling the subscription.")
    public Boolean getWriteOff() {
        return this.writeOff;
    }

    public void setWriteOff(Boolean writeOff) {
        this.writeOff = writeOff;
    }

    public CancelSubscriptionRequest writeOffBehavior(WriteOffSuscriptionRequest writeOffBehavior) {
        this.writeOffBehavior = writeOffBehavior;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public WriteOffSuscriptionRequest getWriteOffBehavior() {
        return this.writeOffBehavior;
    }

    public void setWriteOffBehavior(WriteOffSuscriptionRequest writeOffBehavior) {
        this.writeOffBehavior = writeOffBehavior;
    }

    public CancelSubscriptionRequest customFields(Map<String, Object> customFields) {
        this.customFields = customFields;
        return this;
    }

    public CancelSubscriptionRequest putCustomFieldsItem(String key, Object customFieldsItem) {
        if (this.customFields == null) {
            this.customFields = new HashMap<String, Object>();
        }
        this.customFields.put(key, customFieldsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Set of user-defined fields associated with this object. Useful for storing additional information about the object in a structured format.")
    public Map<String, Object> getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(Map<String, Object> customFields) {
        this.customFields = customFields;
    }

    public CancelSubscriptionRequest changeReason(String changeReason) {
        this.changeReason = changeReason;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A brief description of the reason for this change.")
    public String getChangeReason() {
        return this.changeReason;
    }

    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CancelSubscriptionRequest cancelSubscriptionRequest = (CancelSubscriptionRequest)o;
        return Objects.equals(this.cancelDate, cancelSubscriptionRequest.cancelDate) && Objects.equals((Object)this.cancelAt, (Object)cancelSubscriptionRequest.cancelAt) && Objects.equals(this.processingOptions, cancelSubscriptionRequest.processingOptions) && Objects.equals(this.refundAmount, cancelSubscriptionRequest.refundAmount) && Objects.equals(this.writeOff, cancelSubscriptionRequest.writeOff) && Objects.equals(this.writeOffBehavior, cancelSubscriptionRequest.writeOffBehavior) && Objects.equals(this.customFields, cancelSubscriptionRequest.customFields) && Objects.equals(this.changeReason, cancelSubscriptionRequest.changeReason);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.cancelDate, this.cancelAt, this.processingOptions, this.refundAmount, this.writeOff, this.writeOffBehavior, this.customFields, this.changeReason});
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CancelSubscriptionRequest {\n");
        sb.append("    cancelDate: ").append(this.toIndentedString(this.cancelDate)).append("\n");
        sb.append("    cancelAt: ").append(this.toIndentedString((Object)this.cancelAt)).append("\n");
        sb.append("    processingOptions: ").append(this.toIndentedString(this.processingOptions)).append("\n");
        sb.append("    refundAmount: ").append(this.toIndentedString(this.refundAmount)).append("\n");
        sb.append("    writeOff: ").append(this.toIndentedString(this.writeOff)).append("\n");
        sb.append("    writeOffBehavior: ").append(this.toIndentedString(this.writeOffBehavior)).append("\n");
        sb.append("    customFields: ").append(this.toIndentedString(this.customFields)).append("\n");
        sb.append("    changeReason: ").append(this.toIndentedString(this.changeReason)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum CancelAtEnum {
        INVOICE_PERIOD_END("invoice_period_end"),
        SUBSCRIPTION_TERM_END("subscription_term_end"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private CancelAtEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static CancelAtEnum fromValue(String value) {
            for (CancelAtEnum b : CancelAtEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<CancelAtEnum> {
            public void write(JsonWriter jsonWriter, CancelAtEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public CancelAtEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return CancelAtEnum.fromValue(value);
            }
        }
    }
}

