/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;
import org.openapitools.client.ApiCallback;
import org.openapitools.client.ApiClient;
import org.openapitools.client.ApiException;
import org.openapitools.client.ApiResponse;
import org.openapitools.client.Configuration;
import org.openapitools.client.Pair;
import org.openapitools.client.model.ErrorResponse;
import org.openapitools.client.model.GetByIdQueryParams;
import org.openapitools.client.model.Headers;
import org.openapitools.client.model.LineItemPatchRequest;
import org.openapitools.client.model.OrderLineItem;

public class OrderLineItemsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public OrderLineItemsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public OrderLineItemsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call getOrderLineItemCall(String orderLineItemId, List<String> fields, List<String> lineItemFields, List<String> invoiceItemsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/order_line_items/{order_line_item_id}".replace("{order_line_item_id}", this.localVarApiClient.escapeString(orderLineItemId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (lineItemFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "line_item.fields[]", lineItemFields));
        }
        if (invoiceItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "invoice_items.fields[]", invoiceItemsFields));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraCacheEnabled != null) {
            localVarHeaderParams.put("zuora-cache-enabled", this.localVarApiClient.parameterToString(zuoraCacheEnabled));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getOrderLineItemValidateBeforeCall(String orderLineItemId, List<String> fields, List<String> lineItemFields, List<String> invoiceItemsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (orderLineItemId == null) {
            throw new ApiException("Missing the required parameter 'orderLineItemId' when calling getOrderLineItem(Async)");
        }
        return this.getOrderLineItemCall(orderLineItemId, fields, lineItemFields, invoiceItemsFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, _callback);
    }

    private ApiResponse<OrderLineItem> getOrderLineItemWithHttpInfo(String orderLineItemId, List<String> fields, List<String> lineItemFields, List<String> invoiceItemsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.getOrderLineItemValidateBeforeCall(orderLineItemId, fields, lineItemFields, invoiceItemsFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<OrderLineItem>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call getOrderLineItemAsync(String orderLineItemId, List<String> fields, List<String> lineItemFields, List<String> invoiceItemsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback<OrderLineItem> _callback) throws ApiException {
        Call localVarCall = this.getOrderLineItemValidateBeforeCall(orderLineItemId, fields, lineItemFields, invoiceItemsFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<OrderLineItem>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetOrderLineItemParams getOrderLineItemParams(String orderLineItemId) {
        return new GetOrderLineItemParams(orderLineItemId);
    }

    public OrderLineItem getOrderLineItem(String orderLineItemId) throws ApiException {
        GetOrderLineItemParams params = new GetOrderLineItemParams(orderLineItemId);
        return this.executeGetOrderLineItemAPICall(params).getData();
    }

    public OrderLineItem getOrderLineItem(String orderLineItemId, List<String> expand) throws ApiException {
        GetOrderLineItemParams params = new GetOrderLineItemParams(orderLineItemId);
        params.expand(expand);
        return this.executeGetOrderLineItemAPICall(params).getData();
    }

    public OrderLineItem getOrderLineItem(String orderLineItemId, List<String> expand, Headers headers) throws ApiException {
        GetOrderLineItemParams params = new GetOrderLineItemParams(orderLineItemId).expand(expand).headers(headers);
        return this.executeGetOrderLineItemAPICall(params).getData();
    }

    public OrderLineItem getOrderLineItem(GetOrderLineItemParams params) throws ApiException {
        return this.executeGetOrderLineItemAPICall(params).getData();
    }

    public ApiResponse<OrderLineItem> getOrderLineItemWithHttpInfo(GetOrderLineItemParams params) throws ApiException {
        return this.executeGetOrderLineItemAPICall(params);
    }

    ApiResponse<OrderLineItem> executeGetOrderLineItemAPICall(GetOrderLineItemParams params) throws ApiException {
        return this.getOrderLineItemWithHttpInfo(params.orderLineItemId, params.fields, params.lineItemFields, params.invoiceItemsFields, params.expand, params.filter, params.pageSize, params.zuoraTrackId, params.async, params.zuoraCacheEnabled, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraOrgIds);
    }

    private Call patchOrderLineItemCall(String orderLineItemId, LineItemPatchRequest lineItemPatchRequest, List<String> fields, List<String> lineItemFields, List<String> invoiceItemsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        LineItemPatchRequest localVarPostBody = lineItemPatchRequest;
        String localVarPath = "/order_line_items/{order_line_item_id}".replace("{order_line_item_id}", this.localVarApiClient.escapeString(orderLineItemId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (lineItemFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "line_item.fields[]", lineItemFields));
        }
        if (invoiceItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "invoice_items.fields[]", invoiceItemsFields));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraCacheEnabled != null) {
            localVarHeaderParams.put("zuora-cache-enabled", this.localVarApiClient.parameterToString(zuoraCacheEnabled));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchOrderLineItemValidateBeforeCall(String orderLineItemId, LineItemPatchRequest lineItemPatchRequest, List<String> fields, List<String> lineItemFields, List<String> invoiceItemsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (orderLineItemId == null) {
            throw new ApiException("Missing the required parameter 'orderLineItemId' when calling patchOrderLineItem(Async)");
        }
        if (lineItemPatchRequest == null) {
            throw new ApiException("Missing the required parameter 'lineItemPatchRequest' when calling patchOrderLineItem(Async)");
        }
        return this.patchOrderLineItemCall(orderLineItemId, lineItemPatchRequest, fields, lineItemFields, invoiceItemsFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, _callback);
    }

    private ApiResponse<OrderLineItem> patchOrderLineItemWithHttpInfo(String orderLineItemId, LineItemPatchRequest lineItemPatchRequest, List<String> fields, List<String> lineItemFields, List<String> invoiceItemsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.patchOrderLineItemValidateBeforeCall(orderLineItemId, lineItemPatchRequest, fields, lineItemFields, invoiceItemsFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<OrderLineItem>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call patchOrderLineItemAsync(String orderLineItemId, LineItemPatchRequest lineItemPatchRequest, List<String> fields, List<String> lineItemFields, List<String> invoiceItemsFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback<OrderLineItem> _callback) throws ApiException {
        Call localVarCall = this.patchOrderLineItemValidateBeforeCall(orderLineItemId, lineItemPatchRequest, fields, lineItemFields, invoiceItemsFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<OrderLineItem>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public PatchOrderLineItemParams patchOrderLineItemParams(String orderLineItemId, LineItemPatchRequest lineItemPatchRequest) {
        return new PatchOrderLineItemParams(orderLineItemId, lineItemPatchRequest);
    }

    public OrderLineItem patchOrderLineItem(String orderLineItemId, LineItemPatchRequest lineItemPatchRequest) throws ApiException {
        PatchOrderLineItemParams params = new PatchOrderLineItemParams(orderLineItemId, lineItemPatchRequest);
        return this.executePatchOrderLineItemAPICall(params).getData();
    }

    public OrderLineItem patchOrderLineItem(String orderLineItemId, LineItemPatchRequest lineItemPatchRequest, List<String> expand) throws ApiException {
        PatchOrderLineItemParams params = new PatchOrderLineItemParams(orderLineItemId, lineItemPatchRequest);
        params.expand(expand);
        return this.executePatchOrderLineItemAPICall(params).getData();
    }

    public OrderLineItem patchOrderLineItem(String orderLineItemId, LineItemPatchRequest lineItemPatchRequest, List<String> expand, Headers headers) throws ApiException {
        PatchOrderLineItemParams params = new PatchOrderLineItemParams(orderLineItemId, lineItemPatchRequest).expand(expand).headers(headers);
        return this.executePatchOrderLineItemAPICall(params).getData();
    }

    public OrderLineItem patchOrderLineItem(PatchOrderLineItemParams params) throws ApiException {
        return this.executePatchOrderLineItemAPICall(params).getData();
    }

    public ApiResponse<OrderLineItem> patchOrderLineItemWithHttpInfo(PatchOrderLineItemParams params) throws ApiException {
        return this.executePatchOrderLineItemAPICall(params);
    }

    ApiResponse<OrderLineItem> executePatchOrderLineItemAPICall(PatchOrderLineItemParams params) throws ApiException {
        return this.patchOrderLineItemWithHttpInfo(params.orderLineItemId, params.lineItemPatchRequest, params.fields, params.lineItemFields, params.invoiceItemsFields, params.expand, params.filter, params.pageSize, params.zuoraTrackId, params.async, params.zuoraCacheEnabled, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraOrgIds);
    }

    public static class PatchOrderLineItemParams {
        private final String orderLineItemId;
        private final LineItemPatchRequest lineItemPatchRequest;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private List<String> fields;
        private List<String> lineItemFields;
        private List<String> invoiceItemsFields;
        private List<String> expand;
        private List<String> filter;
        private Integer pageSize;
        private String zuoraTrackId;
        private Boolean async;
        private Boolean zuoraCacheEnabled;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraOrgIds;

        public PatchOrderLineItemParams(String orderLineItemId, LineItemPatchRequest lineItemPatchRequest) {
            this.orderLineItemId = orderLineItemId;
            this.lineItemPatchRequest = lineItemPatchRequest;
        }

        public PatchOrderLineItemParams getByIdQueryParams(GetByIdQueryParams getByIdQueryParams) {
            this.getByIdQueryParams = getByIdQueryParams;
            if (this.expand != null) {
                this.expand = getByIdQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = getByIdQueryParams.getFilter();
            }
            if (this.pageSize != null) {
                this.pageSize = getByIdQueryParams.getPageSize();
            }
            return this;
        }

        public PatchOrderLineItemParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraCacheEnabled() != null) {
                this.zuoraCacheEnabled = headers.getZuoraCacheEnabled();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public PatchOrderLineItemParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public PatchOrderLineItemParams lineItemFields(List<String> lineItemFields) {
            this.lineItemFields = lineItemFields;
            return this;
        }

        public PatchOrderLineItemParams invoiceItemsFields(List<String> invoiceItemsFields) {
            this.invoiceItemsFields = invoiceItemsFields;
            return this;
        }

        public PatchOrderLineItemParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public PatchOrderLineItemParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public PatchOrderLineItemParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }
    }

    public static class GetOrderLineItemParams {
        private final String orderLineItemId;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private List<String> fields;
        private List<String> lineItemFields;
        private List<String> invoiceItemsFields;
        private List<String> expand;
        private List<String> filter;
        private Integer pageSize;
        private String zuoraTrackId;
        private Boolean async;
        private Boolean zuoraCacheEnabled;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraOrgIds;

        public GetOrderLineItemParams(String orderLineItemId) {
            this.orderLineItemId = orderLineItemId;
        }

        public GetOrderLineItemParams getByIdQueryParams(GetByIdQueryParams getByIdQueryParams) {
            this.getByIdQueryParams = getByIdQueryParams;
            if (this.expand != null) {
                this.expand = getByIdQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = getByIdQueryParams.getFilter();
            }
            if (this.pageSize != null) {
                this.pageSize = getByIdQueryParams.getPageSize();
            }
            return this;
        }

        public GetOrderLineItemParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraCacheEnabled() != null) {
                this.zuoraCacheEnabled = headers.getZuoraCacheEnabled();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public GetOrderLineItemParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public GetOrderLineItemParams lineItemFields(List<String> lineItemFields) {
            this.lineItemFields = lineItemFields;
            return this;
        }

        public GetOrderLineItemParams invoiceItemsFields(List<String> invoiceItemsFields) {
            this.invoiceItemsFields = invoiceItemsFields;
            return this;
        }

        public GetOrderLineItemParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public GetOrderLineItemParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public GetOrderLineItemParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }
    }
}

