/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.client.JSON;
import org.openapitools.client.model.WriteOffItemsRequest;
import org.threeten.bp.LocalDate;

public class WriteOffRequest {
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_DOCUMENT_DATE = "document_date";
    @SerializedName(value="document_date")
    private LocalDate documentDate;
    public static final String SERIALIZED_NAME_REASON_CODE = "reason_code";
    @SerializedName(value="reason_code")
    private String reasonCode;
    public static final String SERIALIZED_NAME_CUSTOM_FIELDS = "custom_fields";
    @SerializedName(value="custom_fields")
    @JsonAdapter(value=JSON.CustomFieldAdapter.class)
    private Map<String, String> customFields = null;
    public static final String SERIALIZED_NAME_INVOICE_ITEMS = "invoice_items";
    @SerializedName(value="invoice_items")
    private List<WriteOffItemsRequest> invoiceItems = null;

    public WriteOffRequest description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An arbitrary string associated with the object. Often useful for displaying to users.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public WriteOffRequest documentDate(LocalDate documentDate) {
        this.documentDate = documentDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Sun Jan 01 00:00:00 GMT 2023", value="The date when the invoice takes effect.")
    public LocalDate getDocumentDate() {
        return this.documentDate;
    }

    public void setDocumentDate(LocalDate documentDate) {
        this.documentDate = documentDate;
    }

    public WriteOffRequest reasonCode(String reasonCode) {
        this.reasonCode = reasonCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Reason for issuing this credit memo")
    public String getReasonCode() {
        return this.reasonCode;
    }

    public void setReasonCode(String reasonCode) {
        this.reasonCode = reasonCode;
    }

    public WriteOffRequest customFields(Map<String, String> customFields) {
        this.customFields = customFields;
        return this;
    }

    public WriteOffRequest putCustomFieldsItem(String key, String customFieldsItem) {
        if (this.customFields == null) {
            this.customFields = new HashMap<String, String>();
        }
        this.customFields.put(key, customFieldsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Set of user-defined fields associated with this object. Useful for storing additional information about the object in a structured format.")
    public Map<String, String> getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(Map<String, String> customFields) {
        this.customFields = customFields;
    }

    public WriteOffRequest invoiceItems(List<WriteOffItemsRequest> invoiceItems) {
        this.invoiceItems = invoiceItems;
        return this;
    }

    public WriteOffRequest addInvoiceItemsItem(WriteOffItemsRequest invoiceItemsItem) {
        if (this.invoiceItems == null) {
            this.invoiceItems = new ArrayList<WriteOffItemsRequest>();
        }
        this.invoiceItems.add(invoiceItemsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Information of all invoice items.")
    public List<WriteOffItemsRequest> getInvoiceItems() {
        return this.invoiceItems;
    }

    public void setInvoiceItems(List<WriteOffItemsRequest> invoiceItems) {
        this.invoiceItems = invoiceItems;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WriteOffRequest writeOffRequest = (WriteOffRequest)o;
        return Objects.equals(this.description, writeOffRequest.description) && Objects.equals(this.documentDate, writeOffRequest.documentDate) && Objects.equals(this.reasonCode, writeOffRequest.reasonCode) && Objects.equals(this.customFields, writeOffRequest.customFields) && Objects.equals(this.invoiceItems, writeOffRequest.invoiceItems);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.documentDate, this.reasonCode, this.customFields, this.invoiceItems);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WriteOffRequest {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    documentDate: ").append(this.toIndentedString(this.documentDate)).append("\n");
        sb.append("    reasonCode: ").append(this.toIndentedString(this.reasonCode)).append("\n");
        sb.append("    customFields: ").append(this.toIndentedString(this.customFields)).append("\n");
        sb.append("    invoiceItems: ").append(this.toIndentedString(this.invoiceItems)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

