/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.model;

import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

@JsonAdapter(value=Adapter.class)
public enum ChargeFunction {
    STANDARD("Standard"),
    PREPAYMENT("Prepayment"),
    COMMITMENTTRUEUP("CommitmentTrueUp"),
    DRAWDOWN("Drawdown"),
    CREDITCOMMITMENT("CreditCommitment"),
    DRAWDOWNANDCREDITCOMMITMENT("DrawdownAndCreditCommitment");

    private String value;

    private ChargeFunction(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ChargeFunction fromValue(String value) {
        for (ChargeFunction b : ChargeFunction.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        String value = jsonElement.getAsString();
        ChargeFunction.fromValue(value);
    }

    public static class Adapter
    extends TypeAdapter<ChargeFunction> {
        public void write(JsonWriter jsonWriter, ChargeFunction enumeration) throws IOException {
            jsonWriter.value(enumeration.getValue());
        }

        public ChargeFunction read(JsonReader jsonReader) throws IOException {
            String value = jsonReader.nextString();
            return ChargeFunction.fromValue(value);
        }
    }
}

