/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nullable;
import org.threeten.bp.OffsetDateTime;

public class WorkflowRun {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private Integer id;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private TypeEnum type;
    public static final String SERIALIZED_NAME_STATE = "state";
    @SerializedName(value="state")
    private StateEnum state;
    public static final String SERIALIZED_NAME_ORIGINAL_WORKFLOW_ID = "original_workflow_id";
    @SerializedName(value="original_workflow_id")
    private Integer originalWorkflowId;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_CREATED_TIME = "created_time";
    @SerializedName(value="created_time")
    private OffsetDateTime createdTime;
    public static final String SERIALIZED_NAME_UPDATED_TIME = "updated_time";
    @SerializedName(value="updated_time")
    private OffsetDateTime updatedTime;

    public WorkflowRun id(Integer id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The unique ID of an active version.")
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public WorkflowRun type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The type of the active version. Currently the only valid value is `Workflow::Setup`.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public WorkflowRun state(StateEnum state) {
        this.state = state;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The status of an active version.")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public WorkflowRun originalWorkflowId(Integer originalWorkflowId) {
        this.originalWorkflowId = originalWorkflowId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Identifier of the original Workflow version.")
    public Integer getOriginalWorkflowId() {
        return this.originalWorkflowId;
    }

    public void setOriginalWorkflowId(Integer originalWorkflowId) {
        this.originalWorkflowId = originalWorkflowId;
    }

    public WorkflowRun name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of the workflow definition.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public WorkflowRun createdTime(OffsetDateTime createdTime) {
        this.createdTime = createdTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public OffsetDateTime getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(OffsetDateTime createdTime) {
        this.createdTime = createdTime;
    }

    public WorkflowRun updatedTime(OffsetDateTime updatedTime) {
        this.updatedTime = updatedTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public OffsetDateTime getUpdatedTime() {
        return this.updatedTime;
    }

    public void setUpdatedTime(OffsetDateTime updatedTime) {
        this.updatedTime = updatedTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkflowRun workflowRun = (WorkflowRun)o;
        return Objects.equals(this.id, workflowRun.id) && Objects.equals((Object)this.type, (Object)workflowRun.type) && Objects.equals((Object)this.state, (Object)workflowRun.state) && Objects.equals(this.originalWorkflowId, workflowRun.originalWorkflowId) && Objects.equals(this.name, workflowRun.name) && Objects.equals(this.createdTime, workflowRun.createdTime) && Objects.equals(this.updatedTime, workflowRun.updatedTime);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.type, this.state, this.originalWorkflowId, this.name, this.createdTime, this.updatedTime});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WorkflowRun {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    originalWorkflowId: ").append(this.toIndentedString(this.originalWorkflowId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    createdTime: ").append(this.toIndentedString(this.createdTime)).append("\n");
        sb.append("    updatedTime: ").append(this.toIndentedString(this.updatedTime)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StateEnum {
        QUEUED("queued"),
        PROCESSING("processing"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StateEnum fromValue(String value) {
            for (StateEnum b : StateEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<StateEnum> {
            public void write(JsonWriter jsonWriter, StateEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StateEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StateEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        SETUP("setup"),
        INSTANCE("instance"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(value);
            }
        }
    }
}

