/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Objects;
import javax.annotation.Nullable;

public class Drawdown {
    public static final String SERIALIZED_NAME_CONVERSION_RATE = "conversion_rate";
    @SerializedName(value="conversion_rate")
    private BigDecimal conversionRate;
    public static final String SERIALIZED_NAME_UNIT_OF_MEASURE = "unit_of_measure";
    @SerializedName(value="unit_of_measure")
    private String unitOfMeasure;

    public Drawdown conversionRate(BigDecimal conversionRate) {
        this.conversionRate = conversionRate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The conversion rate between usage unit of measure (UOM) and drawdown unit of measure for a drawdown charge.        **Note**:    <ul>    <li>Must be a positive number (>0).</li>    <li>Must be `1` when usage UOM and drawdown UOM are the same.</li>     <li>If both `conversion_rate` and `unit_of_measure` for the drawdown are empty, the system will set default values respectively: <ul>      <li> `conversion_rate`: 1 </li>      <li> `unit_of_measure`: Same as the usage UOM of this drawdown charge. </li></ul></li></ul>        The `conversion_rate` and `unit_of_measure` fields need to have values or be empty at the same time.     ")
    public BigDecimal getConversionRate() {
        return this.conversionRate;
    }

    public void setConversionRate(BigDecimal conversionRate) {
        this.conversionRate = conversionRate;
    }

    public Drawdown unitOfMeasure(String unitOfMeasure) {
        this.unitOfMeasure = unitOfMeasure;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Unit of measurement for a drawdown charge.")
    public String getUnitOfMeasure() {
        return this.unitOfMeasure;
    }

    public void setUnitOfMeasure(String unitOfMeasure) {
        this.unitOfMeasure = unitOfMeasure;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Drawdown drawdown = (Drawdown)o;
        return Objects.equals(this.conversionRate, drawdown.conversionRate) && Objects.equals(this.unitOfMeasure, drawdown.unitOfMeasure);
    }

    public int hashCode() {
        return Objects.hash(this.conversionRate, this.unitOfMeasure);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Drawdown {\n");
        sb.append("    conversionRate: ").append(this.toIndentedString(this.conversionRate)).append("\n");
        sb.append("    unitOfMeasure: ").append(this.toIndentedString(this.unitOfMeasure)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

