/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openapitools.client.JSON;
import org.threeten.bp.OffsetDateTime;

public class UsageCreateRequest {
    public static final String SERIALIZED_NAME_ACCOUNT_NUMBER = "account_number";
    @SerializedName(value="account_number")
    private String accountNumber;
    public static final String SERIALIZED_NAME_ACCOUNT_ID = "account_id";
    @SerializedName(value="account_id")
    private String accountId;
    public static final String SERIALIZED_NAME_SUBSCRIPTION_ITEM_ID = "subscription_item_id";
    @SerializedName(value="subscription_item_id")
    private String subscriptionItemId;
    public static final String SERIALIZED_NAME_SUBSCRIPTION_ITEM_NUMBER = "subscription_item_number";
    @SerializedName(value="subscription_item_number")
    private String subscriptionItemNumber;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_END_TIME = "end_time";
    @SerializedName(value="end_time")
    private OffsetDateTime endTime;
    public static final String SERIALIZED_NAME_QUANTITY = "quantity";
    @SerializedName(value="quantity")
    private BigDecimal quantity;
    public static final String SERIALIZED_NAME_START_TIME = "start_time";
    @SerializedName(value="start_time")
    private OffsetDateTime startTime;
    public static final String SERIALIZED_NAME_SUBSCRIPTION_ID = "subscription_id";
    @SerializedName(value="subscription_id")
    private String subscriptionId;
    public static final String SERIALIZED_NAME_SUBSCRIPTION_NUMBER = "subscription_number";
    @SerializedName(value="subscription_number")
    private String subscriptionNumber;
    public static final String SERIALIZED_NAME_UNIT_OF_MEASURE = "unit_of_measure";
    @SerializedName(value="unit_of_measure")
    private String unitOfMeasure;
    public static final String SERIALIZED_NAME_CUSTOM_FIELDS = "custom_fields";
    @SerializedName(value="custom_fields")
    @JsonAdapter(value=JSON.CustomFieldAdapter.class)
    private Map<String, String> customFields = null;

    public UsageCreateRequest accountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="A-100001", value="Human-readable identifier of the account. It can be user-supplied. Either `account_number` or `account_id` is required.")
    public String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public UsageCreateRequest accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Identifier of the account associated with this subscription. Either `account_id` or `account_number` is required.")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public UsageCreateRequest subscriptionItemId(String subscriptionItemId) {
        this.subscriptionItemId = subscriptionItemId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Identifier of the subscription item.")
    public String getSubscriptionItemId() {
        return this.subscriptionItemId;
    }

    public void setSubscriptionItemId(String subscriptionItemId) {
        this.subscriptionItemId = subscriptionItemId;
    }

    public UsageCreateRequest subscriptionItemNumber(String subscriptionItemNumber) {
        this.subscriptionItemNumber = subscriptionItemNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Human-readable identifier of the subscription item.")
    public String getSubscriptionItemNumber() {
        return this.subscriptionItemNumber;
    }

    public void setSubscriptionItemNumber(String subscriptionItemNumber) {
        this.subscriptionItemNumber = subscriptionItemNumber;
    }

    public UsageCreateRequest description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="description of test account", value="An arbitrary string attached to the object. Often useful for displaying to users.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public UsageCreateRequest endTime(OffsetDateTime endTime) {
        this.endTime = endTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The end time for which usage is recorded.")
    public OffsetDateTime getEndTime() {
        return this.endTime;
    }

    public void setEndTime(OffsetDateTime endTime) {
        this.endTime = endTime;
    }

    public UsageCreateRequest quantity(BigDecimal quantity) {
        this.quantity = quantity;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The number of units of this item.")
    public BigDecimal getQuantity() {
        return this.quantity;
    }

    public void setQuantity(BigDecimal quantity) {
        this.quantity = quantity;
    }

    public UsageCreateRequest startTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The start time for which usage is recorded.")
    public OffsetDateTime getStartTime() {
        return this.startTime;
    }

    public void setStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
    }

    public UsageCreateRequest subscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The identifier of the subscription associated with the billing document item.")
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public void setSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
    }

    public UsageCreateRequest subscriptionNumber(String subscriptionNumber) {
        this.subscriptionNumber = subscriptionNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Human-readable identifier of the subscription. It can be user-supplied.")
    public String getSubscriptionNumber() {
        return this.subscriptionNumber;
    }

    public void setSubscriptionNumber(String subscriptionNumber) {
        this.subscriptionNumber = subscriptionNumber;
    }

    public UsageCreateRequest unitOfMeasure(String unitOfMeasure) {
        this.unitOfMeasure = unitOfMeasure;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Specifies the units to measure usage. Units of measure are configured in Zuora Central. Your values depend on your configuration in Billing Settings.")
    public String getUnitOfMeasure() {
        return this.unitOfMeasure;
    }

    public void setUnitOfMeasure(String unitOfMeasure) {
        this.unitOfMeasure = unitOfMeasure;
    }

    public UsageCreateRequest customFields(Map<String, String> customFields) {
        this.customFields = customFields;
        return this;
    }

    public UsageCreateRequest putCustomFieldsItem(String key, String customFieldsItem) {
        if (this.customFields == null) {
            this.customFields = new HashMap<String, String>();
        }
        this.customFields.put(key, customFieldsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Set of user-defined fields associated with this object. Useful for storing additional information about the object in a structured format.")
    public Map<String, String> getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(Map<String, String> customFields) {
        this.customFields = customFields;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UsageCreateRequest usageCreateRequest = (UsageCreateRequest)o;
        return Objects.equals(this.accountNumber, usageCreateRequest.accountNumber) && Objects.equals(this.accountId, usageCreateRequest.accountId) && Objects.equals(this.subscriptionItemId, usageCreateRequest.subscriptionItemId) && Objects.equals(this.subscriptionItemNumber, usageCreateRequest.subscriptionItemNumber) && Objects.equals(this.description, usageCreateRequest.description) && Objects.equals(this.endTime, usageCreateRequest.endTime) && Objects.equals(this.quantity, usageCreateRequest.quantity) && Objects.equals(this.startTime, usageCreateRequest.startTime) && Objects.equals(this.subscriptionId, usageCreateRequest.subscriptionId) && Objects.equals(this.subscriptionNumber, usageCreateRequest.subscriptionNumber) && Objects.equals(this.unitOfMeasure, usageCreateRequest.unitOfMeasure) && Objects.equals(this.customFields, usageCreateRequest.customFields);
    }

    public int hashCode() {
        return Objects.hash(this.accountNumber, this.accountId, this.subscriptionItemId, this.subscriptionItemNumber, this.description, this.endTime, this.quantity, this.startTime, this.subscriptionId, this.subscriptionNumber, this.unitOfMeasure, this.customFields);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UsageCreateRequest {\n");
        sb.append("    accountNumber: ").append(this.toIndentedString(this.accountNumber)).append("\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    subscriptionItemId: ").append(this.toIndentedString(this.subscriptionItemId)).append("\n");
        sb.append("    subscriptionItemNumber: ").append(this.toIndentedString(this.subscriptionItemNumber)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    endTime: ").append(this.toIndentedString(this.endTime)).append("\n");
        sb.append("    quantity: ").append(this.toIndentedString(this.quantity)).append("\n");
        sb.append("    startTime: ").append(this.toIndentedString(this.startTime)).append("\n");
        sb.append("    subscriptionId: ").append(this.toIndentedString(this.subscriptionId)).append("\n");
        sb.append("    subscriptionNumber: ").append(this.toIndentedString(this.subscriptionNumber)).append("\n");
        sb.append("    unitOfMeasure: ").append(this.toIndentedString(this.unitOfMeasure)).append("\n");
        sb.append("    customFields: ").append(this.toIndentedString(this.customFields)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

