/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.client.JSON;
import org.openapitools.client.model.Account;
import org.openapitools.client.model.Contact;
import org.openapitools.client.model.FlexibleBillingDocumentSettings;
import org.openapitools.client.model.InvoiceItemListResponse;
import org.openapitools.client.model.PrepaidBalance;
import org.openapitools.client.model.PrepaidBalances;
import org.openapitools.client.model.SubscriptionPlanListResponse;
import org.openapitools.client.model.Term;
import org.openapitools.jackson.nullable.JsonNullable;
import org.threeten.bp.LocalDate;
import org.threeten.bp.OffsetDateTime;

@ApiModel(description="Subscription information.")
public class Subscription {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_UPDATED_BY_ID = "updated_by_id";
    @SerializedName(value="updated_by_id")
    private String updatedById;
    public static final String SERIALIZED_NAME_UPDATED_TIME = "updated_time";
    @SerializedName(value="updated_time")
    private OffsetDateTime updatedTime;
    public static final String SERIALIZED_NAME_CREATED_BY_ID = "created_by_id";
    @SerializedName(value="created_by_id")
    private String createdById;
    public static final String SERIALIZED_NAME_CREATED_TIME = "created_time";
    @SerializedName(value="created_time")
    private OffsetDateTime createdTime;
    public static final String SERIALIZED_NAME_CUSTOM_FIELDS = "custom_fields";
    @SerializedName(value="custom_fields")
    @JsonAdapter(value=JSON.CustomFieldAdapter.class)
    private Map<String, String> customFields = null;
    public static final String SERIALIZED_NAME_CUSTOM_OBJECTS = "custom_objects";
    @SerializedName(value="custom_objects")
    private Map<String, Object> customObjects = null;
    public static final String SERIALIZED_NAME_SUBSCRIPTION_NUMBER = "subscription_number";
    @SerializedName(value="subscription_number")
    private String subscriptionNumber;
    public static final String SERIALIZED_NAME_STATE = "state";
    @SerializedName(value="state")
    private StateEnum state;
    public static final String SERIALIZED_NAME_VERSION = "version";
    @SerializedName(value="version")
    private Integer version;
    public static final String SERIALIZED_NAME_ACCOUNT_ID = "account_id";
    @SerializedName(value="account_id")
    private String accountId;
    public static final String SERIALIZED_NAME_ACCOUNT = "account";
    @SerializedName(value="account")
    private Account account;
    public static final String SERIALIZED_NAME_INVOICE_OWNER_ACCOUNT_ID = "invoice_owner_account_id";
    @SerializedName(value="invoice_owner_account_id")
    private String invoiceOwnerAccountId;
    public static final String SERIALIZED_NAME_INVOICE_OWNER_ACCOUNT = "invoice_owner_account";
    @SerializedName(value="invoice_owner_account")
    private Account invoiceOwnerAccount;
    public static final String SERIALIZED_NAME_AUTO_RENEW = "auto_renew";
    @SerializedName(value="auto_renew")
    private Boolean autoRenew;
    public static final String SERIALIZED_NAME_LATEST_VERSION = "latest_version";
    @SerializedName(value="latest_version")
    private Boolean latestVersion;
    public static final String SERIALIZED_NAME_INITIAL_TERM = "initial_term";
    @SerializedName(value="initial_term")
    private Term initialTerm;
    public static final String SERIALIZED_NAME_CURRENT_TERM = "current_term";
    @SerializedName(value="current_term")
    private Term currentTerm;
    public static final String SERIALIZED_NAME_RENEWAL_TERM = "renewal_term";
    @SerializedName(value="renewal_term")
    private Term renewalTerm;
    public static final String SERIALIZED_NAME_START_DATE = "start_date";
    @SerializedName(value="start_date")
    private LocalDate startDate;
    public static final String SERIALIZED_NAME_END_DATE = "end_date";
    @SerializedName(value="end_date")
    private LocalDate endDate;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_CONTRACT_EFFECTIVE = "contract_effective";
    @SerializedName(value="contract_effective")
    private LocalDate contractEffective;
    public static final String SERIALIZED_NAME_SERVICE_ACTIVATION = "service_activation";
    @SerializedName(value="service_activation")
    private LocalDate serviceActivation;
    public static final String SERIALIZED_NAME_CUSTOMER_ACCEPTANCE = "customer_acceptance";
    @SerializedName(value="customer_acceptance")
    private LocalDate customerAcceptance;
    public static final String SERIALIZED_NAME_INVOICE_SEPARATELY = "invoice_separately";
    @SerializedName(value="invoice_separately")
    private Boolean invoiceSeparately;
    public static final String SERIALIZED_NAME_ORDER_NUMBER = "order_number";
    @SerializedName(value="order_number")
    private String orderNumber;
    public static final String SERIALIZED_NAME_SUBSCRIPTION_PLANS = "subscription_plans";
    @SerializedName(value="subscription_plans")
    private SubscriptionPlanListResponse subscriptionPlans;
    public static final String SERIALIZED_NAME_INVOICE_ITEMS = "invoice_items";
    @SerializedName(value="invoice_items")
    private InvoiceItemListResponse invoiceItems;
    public static final String SERIALIZED_NAME_PREPAID_BALANCE = "prepaid_balance";
    @SerializedName(value="prepaid_balance")
    private List<PrepaidBalance> prepaidBalance = null;
    public static final String SERIALIZED_NAME_PREPAID_BALANCES = "prepaid_balances";
    @SerializedName(value="prepaid_balances")
    private List<PrepaidBalances> prepaidBalances = null;
    public static final String SERIALIZED_NAME_CONTRACTED_MRR = "contracted_mrr";
    @SerializedName(value="contracted_mrr")
    private String contractedMrr;
    public static final String SERIALIZED_NAME_CURRENCY = "currency";
    @SerializedName(value="currency")
    private String currency;
    public static final String SERIALIZED_NAME_CANCEL_REASON = "cancel_reason";
    @SerializedName(value="cancel_reason")
    private String cancelReason;
    public static final String SERIALIZED_NAME_LAST_BOOKING_DATE = "last_booking_date";
    @SerializedName(value="last_booking_date")
    private LocalDate lastBookingDate;
    public static final String SERIALIZED_NAME_BILL_TO_ID = "bill_to_id";
    @SerializedName(value="bill_to_id")
    @JsonAdapter(value=JSON.NullableFieldAdapter.class)
    private String billToId;
    public static final String SERIALIZED_NAME_PAYMENT_TERMS = "payment_terms";
    @SerializedName(value="payment_terms")
    @JsonAdapter(value=JSON.NullableFieldAdapter.class)
    private String paymentTerms;
    public static final String SERIALIZED_NAME_BILL_TO = "bill_to";
    @SerializedName(value="bill_to")
    private Contact billTo;
    public static final String SERIALIZED_NAME_BILLING_DOCUMENT_SETTINGS = "billing_document_settings";
    @SerializedName(value="billing_document_settings")
    private FlexibleBillingDocumentSettings billingDocumentSettings;
    public static final String SERIALIZED_NAME_SOLD_TO_ID = "sold_to_id";
    @SerializedName(value="sold_to_id")
    @JsonAdapter(value=JSON.NullableFieldAdapter.class)
    private String soldToId;
    public static final String SERIALIZED_NAME_SOLD_TO = "sold_to";
    @SerializedName(value="sold_to")
    private Contact soldTo;

    public Subscription() {
    }

    public Subscription(String id, String updatedById, OffsetDateTime updatedTime, String createdById, OffsetDateTime createdTime, Map<String, Object> customObjects, SubscriptionPlanListResponse subscriptionPlans, InvoiceItemListResponse invoiceItems, List<PrepaidBalance> prepaidBalance, List<PrepaidBalances> prepaidBalances, Contact billTo, Contact soldTo) {
        this();
        this.id = id;
        this.updatedById = updatedById;
        this.updatedTime = updatedTime;
        this.createdById = createdById;
        this.createdTime = createdTime;
        this.customObjects = customObjects;
        this.subscriptionPlans = subscriptionPlans;
        this.invoiceItems = invoiceItems;
        this.prepaidBalance = prepaidBalance;
        this.prepaidBalances = prepaidBalances;
        this.billTo = billTo;
        this.soldTo = soldTo;
    }

    @Nullable
    @ApiModelProperty(value="Unique identifier for the object.")
    public String getId() {
        return this.id;
    }

    @Nullable
    @ApiModelProperty(value="Unique identifier of the Zuora user who last updated the object")
    public String getUpdatedById() {
        return this.updatedById;
    }

    @Nullable
    @ApiModelProperty(value="The date and time when the object was last updated in ISO 8601 UTC format.")
    public OffsetDateTime getUpdatedTime() {
        return this.updatedTime;
    }

    @Nullable
    @ApiModelProperty(value="Unique identifier of the Zuora user who created the object")
    public String getCreatedById() {
        return this.createdById;
    }

    @Nullable
    @ApiModelProperty(value="The date and time when the object was created in ISO 8601 UTC format.")
    public OffsetDateTime getCreatedTime() {
        return this.createdTime;
    }

    public Subscription customFields(Map<String, String> customFields) {
        this.customFields = customFields;
        return this;
    }

    public Subscription putCustomFieldsItem(String key, String customFieldsItem) {
        if (this.customFields == null) {
            this.customFields = new HashMap<String, String>();
        }
        this.customFields.put(key, customFieldsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Set of user-defined fields associated with this object. Useful for storing additional information about the object in a structured format.")
    public Map<String, String> getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(Map<String, String> customFields) {
        this.customFields = customFields;
    }

    @Nullable
    @ApiModelProperty(value="The custom objects associated with a Zuora standard object.")
    public Map<String, Object> getCustomObjects() {
        return this.customObjects;
    }

    public Subscription subscriptionNumber(String subscriptionNumber) {
        this.subscriptionNumber = subscriptionNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Human-readable identifier of the subscription. It can be user-supplied.")
    public String getSubscriptionNumber() {
        return this.subscriptionNumber;
    }

    public void setSubscriptionNumber(String subscriptionNumber) {
        this.subscriptionNumber = subscriptionNumber;
    }

    public Subscription state(StateEnum state) {
        this.state = state;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Status of the subscription.")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public Subscription version(Integer version) {
        this.version = version;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The version of the subscription. This version can be used in the `filter[]` query parameter to filter subscriptions.")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public Subscription accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Identifier of the account associated with this subscription.")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public Subscription account(Account account) {
        this.account = account;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Information of the new account associated with the subscription.")
    public Account getAccount() {
        return this.account;
    }

    public void setAccount(Account account) {
        this.account = account;
    }

    public Subscription invoiceOwnerAccountId(String invoiceOwnerAccountId) {
        this.invoiceOwnerAccountId = invoiceOwnerAccountId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Identifier of the account that owns the invoice associated with this subscription.")
    public String getInvoiceOwnerAccountId() {
        return this.invoiceOwnerAccountId;
    }

    public void setInvoiceOwnerAccountId(String invoiceOwnerAccountId) {
        this.invoiceOwnerAccountId = invoiceOwnerAccountId;
    }

    public Subscription invoiceOwnerAccount(Account invoiceOwnerAccount) {
        this.invoiceOwnerAccount = invoiceOwnerAccount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Identifier of the account that owns the subscription.")
    public Account getInvoiceOwnerAccount() {
        return this.invoiceOwnerAccount;
    }

    public void setInvoiceOwnerAccount(Account invoiceOwnerAccount) {
        this.invoiceOwnerAccount = invoiceOwnerAccount;
    }

    public Subscription autoRenew(Boolean autoRenew) {
        this.autoRenew = autoRenew;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If this field is set to `true`, the subscription automatically renews at the end of the current term.")
    public Boolean getAutoRenew() {
        return this.autoRenew;
    }

    public void setAutoRenew(Boolean autoRenew) {
        this.autoRenew = autoRenew;
    }

    public Subscription latestVersion(Boolean latestVersion) {
        this.latestVersion = latestVersion;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If true, this is the latest version of the subscription")
    public Boolean getLatestVersion() {
        return this.latestVersion;
    }

    public void setLatestVersion(Boolean latestVersion) {
        this.latestVersion = latestVersion;
    }

    public Subscription initialTerm(Term initialTerm) {
        this.initialTerm = initialTerm;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Initial term information for the subscription.")
    public Term getInitialTerm() {
        return this.initialTerm;
    }

    public void setInitialTerm(Term initialTerm) {
        this.initialTerm = initialTerm;
    }

    public Subscription currentTerm(Term currentTerm) {
        this.currentTerm = currentTerm;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Current term information for the subscription")
    public Term getCurrentTerm() {
        return this.currentTerm;
    }

    public void setCurrentTerm(Term currentTerm) {
        this.currentTerm = currentTerm;
    }

    public Subscription renewalTerm(Term renewalTerm) {
        this.renewalTerm = renewalTerm;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Renewal term information for the subscription.")
    public Term getRenewalTerm() {
        return this.renewalTerm;
    }

    public void setRenewalTerm(Term renewalTerm) {
        this.renewalTerm = renewalTerm;
    }

    public Subscription startDate(LocalDate startDate) {
        this.startDate = startDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Wed Jan 01 00:00:00 GMT 2020", value="Date when the subscription starts.")
    public LocalDate getStartDate() {
        return this.startDate;
    }

    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public Subscription endDate(LocalDate endDate) {
        this.endDate = endDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Sun Jan 01 00:00:00 GMT 2023", value="Date when the subscription ends.")
    public LocalDate getEndDate() {
        return this.endDate;
    }

    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public Subscription description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Description of the subscription. Often useful for displaying to users.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Subscription contractEffective(LocalDate contractEffective) {
        this.contractEffective = contractEffective;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Sun Jan 01 00:00:00 GMT 2023", value="Date when the subscriber contract is effective.")
    public LocalDate getContractEffective() {
        return this.contractEffective;
    }

    public void setContractEffective(LocalDate contractEffective) {
        this.contractEffective = contractEffective;
    }

    public Subscription serviceActivation(LocalDate serviceActivation) {
        this.serviceActivation = serviceActivation;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Sun Jan 01 00:00:00 GMT 2023", value="Date when the subscribed-to service is activated.")
    public LocalDate getServiceActivation() {
        return this.serviceActivation;
    }

    public void setServiceActivation(LocalDate serviceActivation) {
        this.serviceActivation = serviceActivation;
    }

    public Subscription customerAcceptance(LocalDate customerAcceptance) {
        this.customerAcceptance = customerAcceptance;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Sun Jan 01 00:00:00 GMT 2023", value="Date when all the services or products in the subscription are accepted by the subscriber.")
    public LocalDate getCustomerAcceptance() {
        return this.customerAcceptance;
    }

    public void setCustomerAcceptance(LocalDate customerAcceptance) {
        this.customerAcceptance = customerAcceptance;
    }

    public Subscription invoiceSeparately(Boolean invoiceSeparately) {
        this.invoiceSeparately = invoiceSeparately;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If true, the subscription is billed separately from other subscriptions. If false, the subscription is included with other subscriptions in the account invoice. The default is false.")
    public Boolean getInvoiceSeparately() {
        return this.invoiceSeparately;
    }

    public void setInvoiceSeparately(Boolean invoiceSeparately) {
        this.invoiceSeparately = invoiceSeparately;
    }

    public Subscription orderNumber(String orderNumber) {
        this.orderNumber = orderNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The order number of the order created by Zuora.")
    public String getOrderNumber() {
        return this.orderNumber;
    }

    public void setOrderNumber(String orderNumber) {
        this.orderNumber = orderNumber;
    }

    @Nullable
    @ApiModelProperty(value="List of subscription plans.")
    public SubscriptionPlanListResponse getSubscriptionPlans() {
        return this.subscriptionPlans;
    }

    @Nullable
    @ApiModelProperty(value="List of invoice items.")
    public InvoiceItemListResponse getInvoiceItems() {
        return this.invoiceItems;
    }

    @Deprecated
    @Nullable
    @ApiModelProperty(value="Total prepaid units available during a subscription. It is an aggregate of all funds under a subscription. **Deprecated, please use `prepaid_balances` instead.**")
    public List<PrepaidBalance> getPrepaidBalance() {
        return this.prepaidBalance;
    }

    @Nullable
    @ApiModelProperty(value="Total prepaid units available during a subscription. It is an aggregate of all funds under a subscription.")
    public List<PrepaidBalances> getPrepaidBalances() {
        return this.prepaidBalances;
    }

    public Subscription contractedMrr(String contractedMrr) {
        this.contractedMrr = contractedMrr;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Monthly recurring revenue of the subscription.")
    public String getContractedMrr() {
        return this.contractedMrr;
    }

    public void setContractedMrr(String contractedMrr) {
        this.contractedMrr = contractedMrr;
    }

    public Subscription currency(String currency) {
        this.currency = currency;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="3-letter ISO 4217 currency code. This field is available only if you have the [Multiple Currencies](https://knowledgecenter.zuora.com/Zuora_Billing/Bill_your_customers/Flexible_Billing/Multiple_Currencies) feature enabled.")
    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public Subscription cancelReason(String cancelReason) {
        this.cancelReason = cancelReason;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The reason for cancelling the subscription.")
    public String getCancelReason() {
        return this.cancelReason;
    }

    public void setCancelReason(String cancelReason) {
        this.cancelReason = cancelReason;
    }

    public Subscription lastBookingDate(LocalDate lastBookingDate) {
        this.lastBookingDate = lastBookingDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Sun Jan 01 00:00:00 GMT 2023", value="The last booking date of the subscription object. You can override the date value when creating a subscription through the \"Subscribe and Amend\" API. The default value `today` is set per the user's timezone. The value of this field is as follows:    <ul>     <li>For a new subscription created by the [Subscribe and Amend](https://knowledgecenter.zuora.com/Billing/Subscriptions/Orders/Orders_Harmonization/Orders_Migration_Guidance#Subscribe_and_Amend_APIs_to_Migrate) APIs, this field has the value of the subscription creation date. </li>     <li>For a subscription changed by an amendment, this field has the value of the amendment booking date.</li>     <li>For a subscription created or changed by an order, this field has the value of the order date.</li>     </ul>  ")
    public LocalDate getLastBookingDate() {
        return this.lastBookingDate;
    }

    public void setLastBookingDate(LocalDate lastBookingDate) {
        this.lastBookingDate = lastBookingDate;
    }

    public Subscription billToId(String billToId) {
        this.billToId = billToId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2c92c0f86a8dd422016a9e7a70116b0d", value="ID of the bill-to contact.")
    public String getBillToId() {
        return this.billToId;
    }

    public void setBillToId(String billToId) {
        this.billToId = billToId;
    }

    public Subscription paymentTerms(String paymentTerms) {
        this.paymentTerms = paymentTerms;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of payment term associated with the invoice.")
    public String getPaymentTerms() {
        return this.paymentTerms;
    }

    public void setPaymentTerms(String paymentTerms) {
        this.paymentTerms = paymentTerms;
    }

    @Nullable
    @ApiModelProperty(value="The billing address for the customer.")
    public Contact getBillTo() {
        return this.billTo;
    }

    public Subscription billingDocumentSettings(FlexibleBillingDocumentSettings billingDocumentSettings) {
        this.billingDocumentSettings = billingDocumentSettings;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The billing document settings for the customer.")
    public FlexibleBillingDocumentSettings getBillingDocumentSettings() {
        return this.billingDocumentSettings;
    }

    public void setBillingDocumentSettings(FlexibleBillingDocumentSettings billingDocumentSettings) {
        this.billingDocumentSettings = billingDocumentSettings;
    }

    public Subscription soldToId(String soldToId) {
        this.soldToId = soldToId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2c92c0f86a8dd422016a9e7a70116b0d", value="ID of the sold-to contact.")
    public String getSoldToId() {
        return this.soldToId;
    }

    public void setSoldToId(String soldToId) {
        this.soldToId = soldToId;
    }

    @Nullable
    @ApiModelProperty(value="The selling address for the customer.")
    public Contact getSoldTo() {
        return this.soldTo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Subscription subscription = (Subscription)o;
        return Objects.equals(this.id, subscription.id) && Objects.equals(this.updatedById, subscription.updatedById) && Objects.equals(this.updatedTime, subscription.updatedTime) && Objects.equals(this.createdById, subscription.createdById) && Objects.equals(this.createdTime, subscription.createdTime) && Objects.equals(this.customFields, subscription.customFields) && Objects.equals(this.customObjects, subscription.customObjects) && Objects.equals(this.subscriptionNumber, subscription.subscriptionNumber) && Objects.equals((Object)this.state, (Object)subscription.state) && Objects.equals(this.version, subscription.version) && Objects.equals(this.accountId, subscription.accountId) && Objects.equals(this.account, subscription.account) && Objects.equals(this.invoiceOwnerAccountId, subscription.invoiceOwnerAccountId) && Objects.equals(this.invoiceOwnerAccount, subscription.invoiceOwnerAccount) && Objects.equals(this.autoRenew, subscription.autoRenew) && Objects.equals(this.latestVersion, subscription.latestVersion) && Objects.equals(this.initialTerm, subscription.initialTerm) && Objects.equals(this.currentTerm, subscription.currentTerm) && Objects.equals(this.renewalTerm, subscription.renewalTerm) && Objects.equals(this.startDate, subscription.startDate) && Objects.equals(this.endDate, subscription.endDate) && Objects.equals(this.description, subscription.description) && Objects.equals(this.contractEffective, subscription.contractEffective) && Objects.equals(this.serviceActivation, subscription.serviceActivation) && Objects.equals(this.customerAcceptance, subscription.customerAcceptance) && Objects.equals(this.invoiceSeparately, subscription.invoiceSeparately) && Objects.equals(this.orderNumber, subscription.orderNumber) && Objects.equals(this.subscriptionPlans, subscription.subscriptionPlans) && Objects.equals(this.invoiceItems, subscription.invoiceItems) && Objects.equals(this.prepaidBalance, subscription.prepaidBalance) && Objects.equals(this.prepaidBalances, subscription.prepaidBalances) && Objects.equals(this.contractedMrr, subscription.contractedMrr) && Objects.equals(this.currency, subscription.currency) && Objects.equals(this.cancelReason, subscription.cancelReason) && Objects.equals(this.lastBookingDate, subscription.lastBookingDate) && Objects.equals(this.billToId, subscription.billToId) && Objects.equals(this.paymentTerms, subscription.paymentTerms) && Objects.equals(this.billTo, subscription.billTo) && Objects.equals(this.billingDocumentSettings, subscription.billingDocumentSettings) && Objects.equals(this.soldToId, subscription.soldToId) && Objects.equals(this.soldTo, subscription.soldTo);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.updatedById, this.updatedTime, this.createdById, this.createdTime, this.customFields, this.customObjects, this.subscriptionNumber, this.state, this.version, this.accountId, this.account, this.invoiceOwnerAccountId, this.invoiceOwnerAccount, this.autoRenew, this.latestVersion, this.initialTerm, this.currentTerm, this.renewalTerm, this.startDate, this.endDate, this.description, this.contractEffective, this.serviceActivation, this.customerAcceptance, this.invoiceSeparately, this.orderNumber, this.subscriptionPlans, this.invoiceItems, this.prepaidBalance, this.prepaidBalances, this.contractedMrr, this.currency, this.cancelReason, this.lastBookingDate, this.billToId, this.paymentTerms, this.billTo, this.billingDocumentSettings, this.soldToId, this.soldTo});
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Subscription {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    updatedById: ").append(this.toIndentedString(this.updatedById)).append("\n");
        sb.append("    updatedTime: ").append(this.toIndentedString(this.updatedTime)).append("\n");
        sb.append("    createdById: ").append(this.toIndentedString(this.createdById)).append("\n");
        sb.append("    createdTime: ").append(this.toIndentedString(this.createdTime)).append("\n");
        sb.append("    customFields: ").append(this.toIndentedString(this.customFields)).append("\n");
        sb.append("    customObjects: ").append(this.toIndentedString(this.customObjects)).append("\n");
        sb.append("    subscriptionNumber: ").append(this.toIndentedString(this.subscriptionNumber)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    account: ").append(this.toIndentedString(this.account)).append("\n");
        sb.append("    invoiceOwnerAccountId: ").append(this.toIndentedString(this.invoiceOwnerAccountId)).append("\n");
        sb.append("    invoiceOwnerAccount: ").append(this.toIndentedString(this.invoiceOwnerAccount)).append("\n");
        sb.append("    autoRenew: ").append(this.toIndentedString(this.autoRenew)).append("\n");
        sb.append("    latestVersion: ").append(this.toIndentedString(this.latestVersion)).append("\n");
        sb.append("    initialTerm: ").append(this.toIndentedString(this.initialTerm)).append("\n");
        sb.append("    currentTerm: ").append(this.toIndentedString(this.currentTerm)).append("\n");
        sb.append("    renewalTerm: ").append(this.toIndentedString(this.renewalTerm)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    contractEffective: ").append(this.toIndentedString(this.contractEffective)).append("\n");
        sb.append("    serviceActivation: ").append(this.toIndentedString(this.serviceActivation)).append("\n");
        sb.append("    customerAcceptance: ").append(this.toIndentedString(this.customerAcceptance)).append("\n");
        sb.append("    invoiceSeparately: ").append(this.toIndentedString(this.invoiceSeparately)).append("\n");
        sb.append("    orderNumber: ").append(this.toIndentedString(this.orderNumber)).append("\n");
        sb.append("    subscriptionPlans: ").append(this.toIndentedString(this.subscriptionPlans)).append("\n");
        sb.append("    invoiceItems: ").append(this.toIndentedString(this.invoiceItems)).append("\n");
        sb.append("    prepaidBalance: ").append(this.toIndentedString(this.prepaidBalance)).append("\n");
        sb.append("    prepaidBalances: ").append(this.toIndentedString(this.prepaidBalances)).append("\n");
        sb.append("    contractedMrr: ").append(this.toIndentedString(this.contractedMrr)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    cancelReason: ").append(this.toIndentedString(this.cancelReason)).append("\n");
        sb.append("    lastBookingDate: ").append(this.toIndentedString(this.lastBookingDate)).append("\n");
        sb.append("    billToId: ").append(this.toIndentedString(this.billToId)).append("\n");
        sb.append("    paymentTerms: ").append(this.toIndentedString(this.paymentTerms)).append("\n");
        sb.append("    billTo: ").append(this.toIndentedString(this.billTo)).append("\n");
        sb.append("    billingDocumentSettings: ").append(this.toIndentedString(this.billingDocumentSettings)).append("\n");
        sb.append("    soldToId: ").append(this.toIndentedString(this.soldToId)).append("\n");
        sb.append("    soldTo: ").append(this.toIndentedString(this.soldTo)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StateEnum {
        DRAFT("draft"),
        PENDING_ACTIVATION("pending_activation"),
        PENDING_ACCEPTANCE("pending_acceptance"),
        ACTIVE("active"),
        EXPIRED("expired"),
        CANCELED("canceled"),
        PAUSED("paused"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StateEnum fromValue(String value) {
            for (StateEnum b : StateEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<StateEnum> {
            public void write(JsonWriter jsonWriter, StateEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StateEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StateEnum.fromValue(value);
            }
        }
    }
}

