/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.api;

import com.google.gson.reflect.TypeToken;
import com.zuora.ApiCallback;
import com.zuora.ApiClient;
import com.zuora.ApiException;
import com.zuora.ApiResponse;
import com.zuora.Configuration;
import com.zuora.Pair;
import com.zuora.model.CommonResponse;
import com.zuora.model.CreateAccountingPeriodRequest;
import com.zuora.model.CreateAccountingPeriodResponse;
import com.zuora.model.GetAccountingPeriodResponse;
import com.zuora.model.GetAccountingPeriodsResponse;
import com.zuora.model.UpdateAccountingPeriodRequest;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class AccountingPeriodsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public AccountingPeriodsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AccountingPeriodsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call closeAccountingPeriodCall(String apId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/accounting-periods/{ap-id}/close".replace("{ap-id}", this.localVarApiClient.escapeString(apId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call closeAccountingPeriodValidateBeforeCall(String apId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (apId == null) {
            throw new ApiException("Missing the required parameter 'apId' when calling closeAccountingPeriod(Async)");
        }
        return this.closeAccountingPeriodCall(apId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected CommonResponse closeAccountingPeriod(String apId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<CommonResponse> localVarResp = this.closeAccountingPeriodWithHttpInfo(apId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<CommonResponse> closeAccountingPeriodWithHttpInfo(String apId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.closeAccountingPeriodValidateBeforeCall(apId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        Type localVarReturnType = new TypeToken<CommonResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call closeAccountingPeriodAsync(String apId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<CommonResponse> _callback) throws ApiException {
        Call localVarCall = this.closeAccountingPeriodValidateBeforeCall(apId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<CommonResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public CloseAccountingPeriodApi closeAccountingPeriodApi(String apId) {
        return new CloseAccountingPeriodApi(apId);
    }

    private Call createAccountingPeriodCall(CreateAccountingPeriodRequest request, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CreateAccountingPeriodRequest localVarPostBody = request;
        String localVarPath = "/v1/accounting-periods";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (idempotencyKey != null) {
            localVarHeaderParams.put("Idempotency-Key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createAccountingPeriodValidateBeforeCall(CreateAccountingPeriodRequest request, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (request == null) {
            throw new ApiException("Missing the required parameter 'request' when calling createAccountingPeriod(Async)");
        }
        return this.createAccountingPeriodCall(request, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected CreateAccountingPeriodResponse createAccountingPeriod(CreateAccountingPeriodRequest request, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<CreateAccountingPeriodResponse> localVarResp = this.createAccountingPeriodWithHttpInfo(request, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<CreateAccountingPeriodResponse> createAccountingPeriodWithHttpInfo(CreateAccountingPeriodRequest request, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.createAccountingPeriodValidateBeforeCall(request, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        Type localVarReturnType = new TypeToken<CreateAccountingPeriodResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call createAccountingPeriodAsync(CreateAccountingPeriodRequest request, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<CreateAccountingPeriodResponse> _callback) throws ApiException {
        Call localVarCall = this.createAccountingPeriodValidateBeforeCall(request, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<CreateAccountingPeriodResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public CreateAccountingPeriodApi createAccountingPeriodApi(CreateAccountingPeriodRequest request) {
        return new CreateAccountingPeriodApi(request);
    }

    private Call deleteAccountingPeriodCall(String apId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/accounting-periods/{ap-id}".replace("{ap-id}", this.localVarApiClient.escapeString(apId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteAccountingPeriodValidateBeforeCall(String apId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (apId == null) {
            throw new ApiException("Missing the required parameter 'apId' when calling deleteAccountingPeriod(Async)");
        }
        return this.deleteAccountingPeriodCall(apId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected CommonResponse deleteAccountingPeriod(String apId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<CommonResponse> localVarResp = this.deleteAccountingPeriodWithHttpInfo(apId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<CommonResponse> deleteAccountingPeriodWithHttpInfo(String apId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.deleteAccountingPeriodValidateBeforeCall(apId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        Type localVarReturnType = new TypeToken<CommonResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call deleteAccountingPeriodAsync(String apId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<CommonResponse> _callback) throws ApiException {
        Call localVarCall = this.deleteAccountingPeriodValidateBeforeCall(apId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<CommonResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public DeleteAccountingPeriodApi deleteAccountingPeriodApi(String apId) {
        return new DeleteAccountingPeriodApi(apId);
    }

    private Call getAccountingPeriodCall(String apId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/accounting-periods/{ap-id}".replace("{ap-id}", this.localVarApiClient.escapeString(apId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAccountingPeriodValidateBeforeCall(String apId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (apId == null) {
            throw new ApiException("Missing the required parameter 'apId' when calling getAccountingPeriod(Async)");
        }
        return this.getAccountingPeriodCall(apId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected GetAccountingPeriodResponse getAccountingPeriod(String apId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<GetAccountingPeriodResponse> localVarResp = this.getAccountingPeriodWithHttpInfo(apId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<GetAccountingPeriodResponse> getAccountingPeriodWithHttpInfo(String apId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.getAccountingPeriodValidateBeforeCall(apId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        Type localVarReturnType = new TypeToken<GetAccountingPeriodResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getAccountingPeriodAsync(String apId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<GetAccountingPeriodResponse> _callback) throws ApiException {
        Call localVarCall = this.getAccountingPeriodValidateBeforeCall(apId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<GetAccountingPeriodResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetAccountingPeriodApi getAccountingPeriodApi(String apId) {
        return new GetAccountingPeriodApi(apId);
    }

    private Call getAllAccountingPeriodsCall(String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer page, Integer pageSize, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/accounting-periods";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pageSize", pageSize));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAllAccountingPeriodsValidateBeforeCall(String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer page, Integer pageSize, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        return this.getAllAccountingPeriodsCall(acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, page, pageSize, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected GetAccountingPeriodsResponse getAllAccountingPeriods(String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer page, Integer pageSize, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<GetAccountingPeriodsResponse> localVarResp = this.getAllAccountingPeriodsWithHttpInfo(acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, page, pageSize, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<GetAccountingPeriodsResponse> getAllAccountingPeriodsWithHttpInfo(String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer page, Integer pageSize, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.getAllAccountingPeriodsValidateBeforeCall(acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, page, pageSize, zuoraVersion, zuoraOrgIds, null);
        Type localVarReturnType = new TypeToken<GetAccountingPeriodsResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getAllAccountingPeriodsAsync(String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer page, Integer pageSize, String zuoraVersion, String zuoraOrgIds, ApiCallback<GetAccountingPeriodsResponse> _callback) throws ApiException {
        Call localVarCall = this.getAllAccountingPeriodsValidateBeforeCall(acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, page, pageSize, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<GetAccountingPeriodsResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetAllAccountingPeriodsApi getAllAccountingPeriodsApi() {
        return new GetAllAccountingPeriodsApi();
    }

    private Call pendingCloseAccountingPeriodCall(String apId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/accounting-periods/{ap-id}/pending-close".replace("{ap-id}", this.localVarApiClient.escapeString(apId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call pendingCloseAccountingPeriodValidateBeforeCall(String apId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (apId == null) {
            throw new ApiException("Missing the required parameter 'apId' when calling pendingCloseAccountingPeriod(Async)");
        }
        return this.pendingCloseAccountingPeriodCall(apId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected CommonResponse pendingCloseAccountingPeriod(String apId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<CommonResponse> localVarResp = this.pendingCloseAccountingPeriodWithHttpInfo(apId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<CommonResponse> pendingCloseAccountingPeriodWithHttpInfo(String apId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.pendingCloseAccountingPeriodValidateBeforeCall(apId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        Type localVarReturnType = new TypeToken<CommonResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call pendingCloseAccountingPeriodAsync(String apId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<CommonResponse> _callback) throws ApiException {
        Call localVarCall = this.pendingCloseAccountingPeriodValidateBeforeCall(apId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<CommonResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public PendingCloseAccountingPeriodApi pendingCloseAccountingPeriodApi(String apId) {
        return new PendingCloseAccountingPeriodApi(apId);
    }

    private Call reopenAccountingPeriodCall(String apId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/accounting-periods/{ap-id}/reopen".replace("{ap-id}", this.localVarApiClient.escapeString(apId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call reopenAccountingPeriodValidateBeforeCall(String apId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (apId == null) {
            throw new ApiException("Missing the required parameter 'apId' when calling reopenAccountingPeriod(Async)");
        }
        return this.reopenAccountingPeriodCall(apId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected CommonResponse reopenAccountingPeriod(String apId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<CommonResponse> localVarResp = this.reopenAccountingPeriodWithHttpInfo(apId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<CommonResponse> reopenAccountingPeriodWithHttpInfo(String apId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.reopenAccountingPeriodValidateBeforeCall(apId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        Type localVarReturnType = new TypeToken<CommonResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call reopenAccountingPeriodAsync(String apId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<CommonResponse> _callback) throws ApiException {
        Call localVarCall = this.reopenAccountingPeriodValidateBeforeCall(apId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<CommonResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public ReopenAccountingPeriodApi reopenAccountingPeriodApi(String apId) {
        return new ReopenAccountingPeriodApi(apId);
    }

    private Call runTrialBalanceCall(String apId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/accounting-periods/{ap-id}/run-trial-balance".replace("{ap-id}", this.localVarApiClient.escapeString(apId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call runTrialBalanceValidateBeforeCall(String apId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (apId == null) {
            throw new ApiException("Missing the required parameter 'apId' when calling runTrialBalance(Async)");
        }
        return this.runTrialBalanceCall(apId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected CommonResponse runTrialBalance(String apId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<CommonResponse> localVarResp = this.runTrialBalanceWithHttpInfo(apId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<CommonResponse> runTrialBalanceWithHttpInfo(String apId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.runTrialBalanceValidateBeforeCall(apId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        Type localVarReturnType = new TypeToken<CommonResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call runTrialBalanceAsync(String apId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<CommonResponse> _callback) throws ApiException {
        Call localVarCall = this.runTrialBalanceValidateBeforeCall(apId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<CommonResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public RunTrialBalanceApi runTrialBalanceApi(String apId) {
        return new RunTrialBalanceApi(apId);
    }

    private Call updateAccountingPeriodCall(String apId, UpdateAccountingPeriodRequest request, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        UpdateAccountingPeriodRequest localVarPostBody = request;
        String localVarPath = "/v1/accounting-periods/{ap-id}".replace("{ap-id}", this.localVarApiClient.escapeString(apId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("Zuora-Org-Ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateAccountingPeriodValidateBeforeCall(String apId, UpdateAccountingPeriodRequest request, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (apId == null) {
            throw new ApiException("Missing the required parameter 'apId' when calling updateAccountingPeriod(Async)");
        }
        if (request == null) {
            throw new ApiException("Missing the required parameter 'request' when calling updateAccountingPeriod(Async)");
        }
        return this.updateAccountingPeriodCall(apId, request, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
    }

    protected CommonResponse updateAccountingPeriod(String apId, UpdateAccountingPeriodRequest request, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        ApiResponse<CommonResponse> localVarResp = this.updateAccountingPeriodWithHttpInfo(apId, request, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds);
        return localVarResp.getData();
    }

    private ApiResponse<CommonResponse> updateAccountingPeriodWithHttpInfo(String apId, UpdateAccountingPeriodRequest request, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.updateAccountingPeriodValidateBeforeCall(apId, request, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, null);
        Type localVarReturnType = new TypeToken<CommonResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call updateAccountingPeriodAsync(String apId, UpdateAccountingPeriodRequest request, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, String zuoraOrgIds, ApiCallback<CommonResponse> _callback) throws ApiException {
        Call localVarCall = this.updateAccountingPeriodValidateBeforeCall(apId, request, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<CommonResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public UpdateAccountingPeriodApi updateAccountingPeriodApi(String apId, UpdateAccountingPeriodRequest request) {
        return new UpdateAccountingPeriodApi(apId, request);
    }

    public class UpdateAccountingPeriodApi {
        private final String apId;
        private final UpdateAccountingPeriodRequest request;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private UpdateAccountingPeriodApi(String apId, UpdateAccountingPeriodRequest request) {
            this.apId = apId;
            this.request = request;
        }

        public UpdateAccountingPeriodApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public UpdateAccountingPeriodApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public UpdateAccountingPeriodApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public UpdateAccountingPeriodApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public UpdateAccountingPeriodApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public UpdateAccountingPeriodApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public UpdateAccountingPeriodApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return AccountingPeriodsApi.this.updateAccountingPeriodCall(this.apId, this.request, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public CommonResponse execute() throws ApiException {
            ApiResponse localVarResp = AccountingPeriodsApi.this.updateAccountingPeriodWithHttpInfo(this.apId, this.request, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return (CommonResponse)localVarResp.getData();
        }

        private ApiResponse<CommonResponse> executeWithHttpInfo() throws ApiException {
            return AccountingPeriodsApi.this.updateAccountingPeriodWithHttpInfo(this.apId, this.request, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<CommonResponse> _callback) throws ApiException {
            return AccountingPeriodsApi.this.updateAccountingPeriodAsync(this.apId, this.request, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class RunTrialBalanceApi {
        private final String apId;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private RunTrialBalanceApi(String apId) {
            this.apId = apId;
        }

        public RunTrialBalanceApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public RunTrialBalanceApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public RunTrialBalanceApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public RunTrialBalanceApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public RunTrialBalanceApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public RunTrialBalanceApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public RunTrialBalanceApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return AccountingPeriodsApi.this.runTrialBalanceCall(this.apId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public CommonResponse execute() throws ApiException {
            ApiResponse localVarResp = AccountingPeriodsApi.this.runTrialBalanceWithHttpInfo(this.apId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return (CommonResponse)localVarResp.getData();
        }

        private ApiResponse<CommonResponse> executeWithHttpInfo() throws ApiException {
            return AccountingPeriodsApi.this.runTrialBalanceWithHttpInfo(this.apId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<CommonResponse> _callback) throws ApiException {
            return AccountingPeriodsApi.this.runTrialBalanceAsync(this.apId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class ReopenAccountingPeriodApi {
        private final String apId;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private ReopenAccountingPeriodApi(String apId) {
            this.apId = apId;
        }

        public ReopenAccountingPeriodApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public ReopenAccountingPeriodApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public ReopenAccountingPeriodApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public ReopenAccountingPeriodApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public ReopenAccountingPeriodApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public ReopenAccountingPeriodApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public ReopenAccountingPeriodApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return AccountingPeriodsApi.this.reopenAccountingPeriodCall(this.apId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public CommonResponse execute() throws ApiException {
            ApiResponse localVarResp = AccountingPeriodsApi.this.reopenAccountingPeriodWithHttpInfo(this.apId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return (CommonResponse)localVarResp.getData();
        }

        private ApiResponse<CommonResponse> executeWithHttpInfo() throws ApiException {
            return AccountingPeriodsApi.this.reopenAccountingPeriodWithHttpInfo(this.apId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<CommonResponse> _callback) throws ApiException {
            return AccountingPeriodsApi.this.reopenAccountingPeriodAsync(this.apId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class PendingCloseAccountingPeriodApi {
        private final String apId;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private PendingCloseAccountingPeriodApi(String apId) {
            this.apId = apId;
        }

        public PendingCloseAccountingPeriodApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public PendingCloseAccountingPeriodApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public PendingCloseAccountingPeriodApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public PendingCloseAccountingPeriodApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public PendingCloseAccountingPeriodApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public PendingCloseAccountingPeriodApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public PendingCloseAccountingPeriodApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return AccountingPeriodsApi.this.pendingCloseAccountingPeriodCall(this.apId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public CommonResponse execute() throws ApiException {
            ApiResponse localVarResp = AccountingPeriodsApi.this.pendingCloseAccountingPeriodWithHttpInfo(this.apId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return (CommonResponse)localVarResp.getData();
        }

        private ApiResponse<CommonResponse> executeWithHttpInfo() throws ApiException {
            return AccountingPeriodsApi.this.pendingCloseAccountingPeriodWithHttpInfo(this.apId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<CommonResponse> _callback) throws ApiException {
            return AccountingPeriodsApi.this.pendingCloseAccountingPeriodAsync(this.apId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class GetAllAccountingPeriodsApi {
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private Integer page;
        private Integer pageSize;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private GetAllAccountingPeriodsApi() {
        }

        public GetAllAccountingPeriodsApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public GetAllAccountingPeriodsApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public GetAllAccountingPeriodsApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public GetAllAccountingPeriodsApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public GetAllAccountingPeriodsApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public GetAllAccountingPeriodsApi page(Integer page) {
            this.page = page;
            return this;
        }

        public GetAllAccountingPeriodsApi pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public GetAllAccountingPeriodsApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public GetAllAccountingPeriodsApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return AccountingPeriodsApi.this.getAllAccountingPeriodsCall(this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.page, this.pageSize, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public GetAccountingPeriodsResponse execute() throws ApiException {
            ApiResponse localVarResp = AccountingPeriodsApi.this.getAllAccountingPeriodsWithHttpInfo(this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.page, this.pageSize, this.zuoraVersion, this.zuoraOrgIds);
            return (GetAccountingPeriodsResponse)localVarResp.getData();
        }

        private ApiResponse<GetAccountingPeriodsResponse> executeWithHttpInfo() throws ApiException {
            return AccountingPeriodsApi.this.getAllAccountingPeriodsWithHttpInfo(this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.page, this.pageSize, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<GetAccountingPeriodsResponse> _callback) throws ApiException {
            return AccountingPeriodsApi.this.getAllAccountingPeriodsAsync(this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.page, this.pageSize, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class GetAccountingPeriodApi {
        private final String apId;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private GetAccountingPeriodApi(String apId) {
            this.apId = apId;
        }

        public GetAccountingPeriodApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public GetAccountingPeriodApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public GetAccountingPeriodApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public GetAccountingPeriodApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public GetAccountingPeriodApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public GetAccountingPeriodApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public GetAccountingPeriodApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return AccountingPeriodsApi.this.getAccountingPeriodCall(this.apId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public GetAccountingPeriodResponse execute() throws ApiException {
            ApiResponse localVarResp = AccountingPeriodsApi.this.getAccountingPeriodWithHttpInfo(this.apId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return (GetAccountingPeriodResponse)localVarResp.getData();
        }

        private ApiResponse<GetAccountingPeriodResponse> executeWithHttpInfo() throws ApiException {
            return AccountingPeriodsApi.this.getAccountingPeriodWithHttpInfo(this.apId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<GetAccountingPeriodResponse> _callback) throws ApiException {
            return AccountingPeriodsApi.this.getAccountingPeriodAsync(this.apId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class DeleteAccountingPeriodApi {
        private final String apId;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private DeleteAccountingPeriodApi(String apId) {
            this.apId = apId;
        }

        public DeleteAccountingPeriodApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public DeleteAccountingPeriodApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public DeleteAccountingPeriodApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public DeleteAccountingPeriodApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public DeleteAccountingPeriodApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public DeleteAccountingPeriodApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public DeleteAccountingPeriodApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return AccountingPeriodsApi.this.deleteAccountingPeriodCall(this.apId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public CommonResponse execute() throws ApiException {
            ApiResponse localVarResp = AccountingPeriodsApi.this.deleteAccountingPeriodWithHttpInfo(this.apId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return (CommonResponse)localVarResp.getData();
        }

        private ApiResponse<CommonResponse> executeWithHttpInfo() throws ApiException {
            return AccountingPeriodsApi.this.deleteAccountingPeriodWithHttpInfo(this.apId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<CommonResponse> _callback) throws ApiException {
            return AccountingPeriodsApi.this.deleteAccountingPeriodAsync(this.apId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class CreateAccountingPeriodApi {
        private final CreateAccountingPeriodRequest request;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private CreateAccountingPeriodApi(CreateAccountingPeriodRequest request) {
            this.request = request;
        }

        public CreateAccountingPeriodApi idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public CreateAccountingPeriodApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public CreateAccountingPeriodApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public CreateAccountingPeriodApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public CreateAccountingPeriodApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public CreateAccountingPeriodApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public CreateAccountingPeriodApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public CreateAccountingPeriodApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return AccountingPeriodsApi.this.createAccountingPeriodCall(this.request, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public CreateAccountingPeriodResponse execute() throws ApiException {
            ApiResponse localVarResp = AccountingPeriodsApi.this.createAccountingPeriodWithHttpInfo(this.request, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return (CreateAccountingPeriodResponse)localVarResp.getData();
        }

        private ApiResponse<CreateAccountingPeriodResponse> executeWithHttpInfo() throws ApiException {
            return AccountingPeriodsApi.this.createAccountingPeriodWithHttpInfo(this.request, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<CreateAccountingPeriodResponse> _callback) throws ApiException {
            return AccountingPeriodsApi.this.createAccountingPeriodAsync(this.request, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }

    public class CloseAccountingPeriodApi {
        private final String apId;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;
        private String zuoraOrgIds;

        private CloseAccountingPeriodApi(String apId) {
            this.apId = apId;
        }

        public CloseAccountingPeriodApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public CloseAccountingPeriodApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public CloseAccountingPeriodApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public CloseAccountingPeriodApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public CloseAccountingPeriodApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public CloseAccountingPeriodApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public CloseAccountingPeriodApi zuoraOrgIds(String zuoraOrgIds) {
            this.zuoraOrgIds = zuoraOrgIds;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return AccountingPeriodsApi.this.closeAccountingPeriodCall(this.apId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }

        public CommonResponse execute() throws ApiException {
            ApiResponse localVarResp = AccountingPeriodsApi.this.closeAccountingPeriodWithHttpInfo(this.apId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
            return (CommonResponse)localVarResp.getData();
        }

        private ApiResponse<CommonResponse> executeWithHttpInfo() throws ApiException {
            return AccountingPeriodsApi.this.closeAccountingPeriodWithHttpInfo(this.apId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds);
        }

        public Call executeAsync(ApiCallback<CommonResponse> _callback) throws ApiException {
            return AccountingPeriodsApi.this.closeAccountingPeriodAsync(this.apId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, this.zuoraOrgIds, _callback);
        }
    }
}

