/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.zuora.JSON;
import com.zuora.model.AccountData;
import com.zuora.model.Options;
import com.zuora.model.PaymentData;
import com.zuora.model.SubscriptionData;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public class SignUpRequest {
    public static final String SERIALIZED_NAME_ACCOUNT_DATA = "accountData";
    @SerializedName(value="accountData")
    private AccountData accountData;
    public static final String SERIALIZED_NAME_ACCOUNT_IDENTIFIER_FIELD = "accountIdentifierField";
    @SerializedName(value="accountIdentifierField")
    private String accountIdentifierField;
    public static final String SERIALIZED_NAME_CUSTOM_FIELDS = "customFields";
    @SerializedName(value="customFields")
    private Map<String, Object> customFields = new HashMap<String, Object>();
    public static final String SERIALIZED_NAME_OPTIONS = "options";
    @SerializedName(value="options")
    private Options options;
    public static final String SERIALIZED_NAME_PAYMENT_DATA = "paymentData";
    @SerializedName(value="paymentData")
    private PaymentData paymentData;
    public static final String SERIALIZED_NAME_SUBSCRIPTION_DATA = "subscriptionData";
    @SerializedName(value="subscriptionData")
    private SubscriptionData subscriptionData;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public SignUpRequest accountData(AccountData accountData) {
        this.accountData = accountData;
        return this;
    }

    @Nullable
    public AccountData getAccountData() {
        return this.accountData;
    }

    public void setAccountData(AccountData accountData) {
        this.accountData = accountData;
    }

    public SignUpRequest accountIdentifierField(String accountIdentifierField) {
        this.accountIdentifierField = accountIdentifierField;
        return this;
    }

    @Nullable
    public String getAccountIdentifierField() {
        return this.accountIdentifierField;
    }

    public void setAccountIdentifierField(String accountIdentifierField) {
        this.accountIdentifierField = accountIdentifierField;
    }

    public SignUpRequest customFields(Map<String, Object> customFields) {
        this.customFields = customFields;
        return this;
    }

    public SignUpRequest putCustomFieldsItem(String key, Object customFieldsItem) {
        if (this.customFields == null) {
            this.customFields = new HashMap<String, Object>();
        }
        this.customFields.put(key, customFieldsItem);
        return this;
    }

    @Nullable
    public Map<String, Object> getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(Map<String, Object> customFields) {
        this.customFields = customFields;
    }

    public SignUpRequest options(Options options) {
        this.options = options;
        return this;
    }

    @Nullable
    public Options getOptions() {
        return this.options;
    }

    public void setOptions(Options options) {
        this.options = options;
    }

    public SignUpRequest paymentData(PaymentData paymentData) {
        this.paymentData = paymentData;
        return this;
    }

    @Nullable
    public PaymentData getPaymentData() {
        return this.paymentData;
    }

    public void setPaymentData(PaymentData paymentData) {
        this.paymentData = paymentData;
    }

    public SignUpRequest subscriptionData(SubscriptionData subscriptionData) {
        this.subscriptionData = subscriptionData;
        return this;
    }

    @Nullable
    public SubscriptionData getSubscriptionData() {
        return this.subscriptionData;
    }

    public void setSubscriptionData(SubscriptionData subscriptionData) {
        this.subscriptionData = subscriptionData;
    }

    public SignUpRequest putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SignUpRequest signUpRequest = (SignUpRequest)o;
        return Objects.equals(this.accountData, signUpRequest.accountData) && Objects.equals(this.accountIdentifierField, signUpRequest.accountIdentifierField) && Objects.equals(this.customFields, signUpRequest.customFields) && Objects.equals(this.options, signUpRequest.options) && Objects.equals(this.paymentData, signUpRequest.paymentData) && Objects.equals(this.subscriptionData, signUpRequest.subscriptionData) && Objects.equals(this.additionalProperties, signUpRequest.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.accountData, this.accountIdentifierField, this.customFields, this.options, this.paymentData, this.subscriptionData, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SignUpRequest {\n");
        sb.append("    accountData: ").append(this.toIndentedString(this.accountData)).append("\n");
        sb.append("    accountIdentifierField: ").append(this.toIndentedString(this.accountIdentifierField)).append("\n");
        sb.append("    customFields: ").append(this.toIndentedString(this.customFields)).append("\n");
        sb.append("    options: ").append(this.toIndentedString(this.options)).append("\n");
        sb.append("    paymentData: ").append(this.toIndentedString(this.paymentData)).append("\n");
        sb.append("    subscriptionData: ").append(this.toIndentedString(this.subscriptionData)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in SignUpRequest is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_ACCOUNT_DATA) != null && !jsonObj.get(SERIALIZED_NAME_ACCOUNT_DATA).isJsonNull()) {
            AccountData.validateJsonElement(jsonObj.get(SERIALIZED_NAME_ACCOUNT_DATA));
        }
        if (jsonObj.get(SERIALIZED_NAME_ACCOUNT_IDENTIFIER_FIELD) != null && !jsonObj.get(SERIALIZED_NAME_ACCOUNT_IDENTIFIER_FIELD).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ACCOUNT_IDENTIFIER_FIELD).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `accountIdentifierField` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ACCOUNT_IDENTIFIER_FIELD).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_OPTIONS) != null && !jsonObj.get(SERIALIZED_NAME_OPTIONS).isJsonNull()) {
            Options.validateJsonElement(jsonObj.get(SERIALIZED_NAME_OPTIONS));
        }
        if (jsonObj.get(SERIALIZED_NAME_PAYMENT_DATA) != null && !jsonObj.get(SERIALIZED_NAME_PAYMENT_DATA).isJsonNull()) {
            PaymentData.validateJsonElement(jsonObj.get(SERIALIZED_NAME_PAYMENT_DATA));
        }
        if (jsonObj.get(SERIALIZED_NAME_SUBSCRIPTION_DATA) != null && !jsonObj.get(SERIALIZED_NAME_SUBSCRIPTION_DATA).isJsonNull()) {
            SubscriptionData.validateJsonElement(jsonObj.get(SERIALIZED_NAME_SUBSCRIPTION_DATA));
        }
    }

    public static SignUpRequest fromJson(String jsonString) throws IOException {
        return (SignUpRequest)JSON.getGson().fromJson(jsonString, SignUpRequest.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ACCOUNT_DATA);
        openapiFields.add(SERIALIZED_NAME_ACCOUNT_IDENTIFIER_FIELD);
        openapiFields.add(SERIALIZED_NAME_CUSTOM_FIELDS);
        openapiFields.add(SERIALIZED_NAME_OPTIONS);
        openapiFields.add(SERIALIZED_NAME_PAYMENT_DATA);
        openapiFields.add(SERIALIZED_NAME_SUBSCRIPTION_DATA);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!SignUpRequest.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(SignUpRequest.class));
            return new TypeAdapter<SignUpRequest>(){

                public void write(JsonWriter out, SignUpRequest value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    out.beginObject();
                    for (Map.Entry e : obj.entrySet()) {
                        out.name((String)e.getKey());
                        elementAdapter.write(out, e.getValue());
                    }
                    if (value.getAdditionalProperties() != null) {
                        boolean oldSerializeNulls = out.getSerializeNulls();
                        out.setSerializeNulls(true);
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                            } else if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                            } else if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                            } else if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                            } else if (entry.getValue() == null) {
                                obj.add(entry.getKey(), null);
                            } else {
                                obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                            }
                            out.name(entry.getKey());
                            elementAdapter.write(out, (Object)obj.get(entry.getKey()));
                        }
                        out.setSerializeNulls(oldSerializeNulls);
                    }
                    out.endObject();
                }

                public SignUpRequest read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    SignUpRequest.validateJsonElement(jsonElement);
                    JsonObject jsonObj = jsonElement.getAsJsonObject();
                    SignUpRequest instance = (SignUpRequest)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        if (((JsonElement)entry.getValue()).isJsonArray()) {
                            instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), List.class));
                            continue;
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

