/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.api;

import com.google.gson.reflect.TypeToken;
import com.zuora.ApiCallback;
import com.zuora.ApiClient;
import com.zuora.ApiException;
import com.zuora.ApiResponse;
import com.zuora.Configuration;
import com.zuora.Pair;
import com.zuora.model.CancelPaymentSchedule;
import com.zuora.model.CreatePaymentScheduleItemsRequest;
import com.zuora.model.CreatePaymentScheduleRequest;
import com.zuora.model.CreatePaymentSchedulesRequest;
import com.zuora.model.CreatePaymentSchedulesResponse;
import com.zuora.model.GetPaymentScheduleItemResponse;
import com.zuora.model.GetPaymentScheduleStatisticResponse;
import com.zuora.model.GetPaymentSchedulesResponse;
import com.zuora.model.PaymentScheduleResponse;
import com.zuora.model.PreviewPaymentSchedule;
import com.zuora.model.RetryPaymentScheduleItemRequest;
import com.zuora.model.RetryPaymentScheduleItemResponse;
import com.zuora.model.UpdatePaymentScheduleItemRequest;
import com.zuora.model.UpdatePaymentScheduleRequest;
import java.lang.reflect.Type;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class PaymentSchedulesApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public PaymentSchedulesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public PaymentSchedulesApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call addItemsToCustomPaymentScheduleCall(String paymentScheduleKey, CreatePaymentScheduleItemsRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CreatePaymentScheduleItemsRequest localVarPostBody = body;
        String localVarPath = "/v1/payment-schedules/{paymentScheduleKey}/items".replace("{paymentScheduleKey}", this.localVarApiClient.escapeString(paymentScheduleKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (idempotencyKey != null) {
            localVarHeaderParams.put("Idempotency-Key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("zuora-version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call addItemsToCustomPaymentScheduleValidateBeforeCall(String paymentScheduleKey, CreatePaymentScheduleItemsRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback _callback) throws ApiException {
        if (paymentScheduleKey == null) {
            throw new ApiException("Missing the required parameter 'paymentScheduleKey' when calling addItemsToCustomPaymentSchedule(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling addItemsToCustomPaymentSchedule(Async)");
        }
        return this.addItemsToCustomPaymentScheduleCall(paymentScheduleKey, body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, _callback);
    }

    public PaymentScheduleResponse addItemsToCustomPaymentSchedule(String paymentScheduleKey, CreatePaymentScheduleItemsRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion) throws ApiException {
        ApiResponse<PaymentScheduleResponse> localVarResp = this.addItemsToCustomPaymentScheduleWithHttpInfo(paymentScheduleKey, body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion);
        return localVarResp.getData();
    }

    private ApiResponse<PaymentScheduleResponse> addItemsToCustomPaymentScheduleWithHttpInfo(String paymentScheduleKey, CreatePaymentScheduleItemsRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion) throws ApiException {
        Call localVarCall = this.addItemsToCustomPaymentScheduleValidateBeforeCall(paymentScheduleKey, body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, null);
        Type localVarReturnType = new TypeToken<PaymentScheduleResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call addItemsToCustomPaymentScheduleAsync(String paymentScheduleKey, CreatePaymentScheduleItemsRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback<PaymentScheduleResponse> _callback) throws ApiException {
        Call localVarCall = this.addItemsToCustomPaymentScheduleValidateBeforeCall(paymentScheduleKey, body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, _callback);
        Type localVarReturnType = new TypeToken<PaymentScheduleResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public AddItemsToCustomPaymentScheduleApi addItemsToCustomPaymentScheduleApi(String paymentScheduleKey, CreatePaymentScheduleItemsRequest body) {
        return new AddItemsToCustomPaymentScheduleApi(paymentScheduleKey, body);
    }

    private Call cancelPaymentScheduleCall(String paymentScheduleKey, CancelPaymentSchedule body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CancelPaymentSchedule localVarPostBody = body;
        String localVarPath = "/v1/payment-schedules/{paymentScheduleKey}/cancel".replace("{paymentScheduleKey}", this.localVarApiClient.escapeString(paymentScheduleKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("zuora-version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call cancelPaymentScheduleValidateBeforeCall(String paymentScheduleKey, CancelPaymentSchedule body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback _callback) throws ApiException {
        if (paymentScheduleKey == null) {
            throw new ApiException("Missing the required parameter 'paymentScheduleKey' when calling cancelPaymentSchedule(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling cancelPaymentSchedule(Async)");
        }
        return this.cancelPaymentScheduleCall(paymentScheduleKey, body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, _callback);
    }

    public PaymentScheduleResponse cancelPaymentSchedule(String paymentScheduleKey, CancelPaymentSchedule body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion) throws ApiException {
        ApiResponse<PaymentScheduleResponse> localVarResp = this.cancelPaymentScheduleWithHttpInfo(paymentScheduleKey, body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion);
        return localVarResp.getData();
    }

    private ApiResponse<PaymentScheduleResponse> cancelPaymentScheduleWithHttpInfo(String paymentScheduleKey, CancelPaymentSchedule body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion) throws ApiException {
        Call localVarCall = this.cancelPaymentScheduleValidateBeforeCall(paymentScheduleKey, body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, null);
        Type localVarReturnType = new TypeToken<PaymentScheduleResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call cancelPaymentScheduleAsync(String paymentScheduleKey, CancelPaymentSchedule body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback<PaymentScheduleResponse> _callback) throws ApiException {
        Call localVarCall = this.cancelPaymentScheduleValidateBeforeCall(paymentScheduleKey, body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, _callback);
        Type localVarReturnType = new TypeToken<PaymentScheduleResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public CancelPaymentScheduleApi cancelPaymentScheduleApi(String paymentScheduleKey, CancelPaymentSchedule body) {
        return new CancelPaymentScheduleApi(paymentScheduleKey, body);
    }

    private Call cancelPaymentScheduleItemCall(String itemId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/payment-schedule-items/{item-id}/cancel".replace("{item-id}", this.localVarApiClient.escapeString(itemId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("zuora-version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call cancelPaymentScheduleItemValidateBeforeCall(String itemId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback _callback) throws ApiException {
        if (itemId == null) {
            throw new ApiException("Missing the required parameter 'itemId' when calling cancelPaymentScheduleItem(Async)");
        }
        return this.cancelPaymentScheduleItemCall(itemId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, _callback);
    }

    public GetPaymentScheduleItemResponse cancelPaymentScheduleItem(String itemId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion) throws ApiException {
        ApiResponse<GetPaymentScheduleItemResponse> localVarResp = this.cancelPaymentScheduleItemWithHttpInfo(itemId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion);
        return localVarResp.getData();
    }

    private ApiResponse<GetPaymentScheduleItemResponse> cancelPaymentScheduleItemWithHttpInfo(String itemId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion) throws ApiException {
        Call localVarCall = this.cancelPaymentScheduleItemValidateBeforeCall(itemId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, null);
        Type localVarReturnType = new TypeToken<GetPaymentScheduleItemResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call cancelPaymentScheduleItemAsync(String itemId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback<GetPaymentScheduleItemResponse> _callback) throws ApiException {
        Call localVarCall = this.cancelPaymentScheduleItemValidateBeforeCall(itemId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, _callback);
        Type localVarReturnType = new TypeToken<GetPaymentScheduleItemResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public CancelPaymentScheduleItemApi cancelPaymentScheduleItemApi(String itemId) {
        return new CancelPaymentScheduleItemApi(itemId);
    }

    private Call createPaymentScheduleCall(CreatePaymentScheduleRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CreatePaymentScheduleRequest localVarPostBody = body;
        String localVarPath = "/v1/payment-schedules";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (idempotencyKey != null) {
            localVarHeaderParams.put("Idempotency-Key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("zuora-version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createPaymentScheduleValidateBeforeCall(CreatePaymentScheduleRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback _callback) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createPaymentSchedule(Async)");
        }
        return this.createPaymentScheduleCall(body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, _callback);
    }

    public PaymentScheduleResponse createPaymentSchedule(CreatePaymentScheduleRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion) throws ApiException {
        ApiResponse<PaymentScheduleResponse> localVarResp = this.createPaymentScheduleWithHttpInfo(body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion);
        return localVarResp.getData();
    }

    private ApiResponse<PaymentScheduleResponse> createPaymentScheduleWithHttpInfo(CreatePaymentScheduleRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion) throws ApiException {
        Call localVarCall = this.createPaymentScheduleValidateBeforeCall(body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, null);
        Type localVarReturnType = new TypeToken<PaymentScheduleResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call createPaymentScheduleAsync(CreatePaymentScheduleRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback<PaymentScheduleResponse> _callback) throws ApiException {
        Call localVarCall = this.createPaymentScheduleValidateBeforeCall(body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, _callback);
        Type localVarReturnType = new TypeToken<PaymentScheduleResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public CreatePaymentScheduleApi createPaymentScheduleApi(CreatePaymentScheduleRequest body) {
        return new CreatePaymentScheduleApi(body);
    }

    private Call createPaymentSchedulesCall(CreatePaymentSchedulesRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CreatePaymentSchedulesRequest localVarPostBody = body;
        String localVarPath = "/v1/payment-schedules/batch";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (idempotencyKey != null) {
            localVarHeaderParams.put("Idempotency-Key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("zuora-version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createPaymentSchedulesValidateBeforeCall(CreatePaymentSchedulesRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback _callback) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createPaymentSchedules(Async)");
        }
        return this.createPaymentSchedulesCall(body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, _callback);
    }

    public CreatePaymentSchedulesResponse createPaymentSchedules(CreatePaymentSchedulesRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion) throws ApiException {
        ApiResponse<CreatePaymentSchedulesResponse> localVarResp = this.createPaymentSchedulesWithHttpInfo(body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion);
        return localVarResp.getData();
    }

    private ApiResponse<CreatePaymentSchedulesResponse> createPaymentSchedulesWithHttpInfo(CreatePaymentSchedulesRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion) throws ApiException {
        Call localVarCall = this.createPaymentSchedulesValidateBeforeCall(body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, null);
        Type localVarReturnType = new TypeToken<CreatePaymentSchedulesResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call createPaymentSchedulesAsync(CreatePaymentSchedulesRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback<CreatePaymentSchedulesResponse> _callback) throws ApiException {
        Call localVarCall = this.createPaymentSchedulesValidateBeforeCall(body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, _callback);
        Type localVarReturnType = new TypeToken<CreatePaymentSchedulesResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public CreatePaymentSchedulesApi createPaymentSchedulesApi(CreatePaymentSchedulesRequest body) {
        return new CreatePaymentSchedulesApi(body);
    }

    private Call getPaymentScheduleCall(String paymentScheduleKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer nextPendingItems, Integer lastProcessedItems, String zuoraVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/payment-schedules/{paymentScheduleKey}".replace("{paymentScheduleKey}", this.localVarApiClient.escapeString(paymentScheduleKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (nextPendingItems != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("nextPendingItems", nextPendingItems));
        }
        if (lastProcessedItems != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("lastProcessedItems", lastProcessedItems));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("zuora-version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getPaymentScheduleValidateBeforeCall(String paymentScheduleKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer nextPendingItems, Integer lastProcessedItems, String zuoraVersion, ApiCallback _callback) throws ApiException {
        if (paymentScheduleKey == null) {
            throw new ApiException("Missing the required parameter 'paymentScheduleKey' when calling getPaymentSchedule(Async)");
        }
        return this.getPaymentScheduleCall(paymentScheduleKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, nextPendingItems, lastProcessedItems, zuoraVersion, _callback);
    }

    public PaymentScheduleResponse getPaymentSchedule(String paymentScheduleKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer nextPendingItems, Integer lastProcessedItems, String zuoraVersion) throws ApiException {
        ApiResponse<PaymentScheduleResponse> localVarResp = this.getPaymentScheduleWithHttpInfo(paymentScheduleKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, nextPendingItems, lastProcessedItems, zuoraVersion);
        return localVarResp.getData();
    }

    private ApiResponse<PaymentScheduleResponse> getPaymentScheduleWithHttpInfo(String paymentScheduleKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer nextPendingItems, Integer lastProcessedItems, String zuoraVersion) throws ApiException {
        Call localVarCall = this.getPaymentScheduleValidateBeforeCall(paymentScheduleKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, nextPendingItems, lastProcessedItems, zuoraVersion, null);
        Type localVarReturnType = new TypeToken<PaymentScheduleResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getPaymentScheduleAsync(String paymentScheduleKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer nextPendingItems, Integer lastProcessedItems, String zuoraVersion, ApiCallback<PaymentScheduleResponse> _callback) throws ApiException {
        Call localVarCall = this.getPaymentScheduleValidateBeforeCall(paymentScheduleKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, nextPendingItems, lastProcessedItems, zuoraVersion, _callback);
        Type localVarReturnType = new TypeToken<PaymentScheduleResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetPaymentScheduleApi getPaymentScheduleApi(String paymentScheduleKey) {
        return new GetPaymentScheduleApi(paymentScheduleKey);
    }

    private Call getPaymentScheduleItemCall(String itemId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/payment-schedule-items/{item-id}".replace("{item-id}", this.localVarApiClient.escapeString(itemId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("zuora-version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getPaymentScheduleItemValidateBeforeCall(String itemId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback _callback) throws ApiException {
        if (itemId == null) {
            throw new ApiException("Missing the required parameter 'itemId' when calling getPaymentScheduleItem(Async)");
        }
        return this.getPaymentScheduleItemCall(itemId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, _callback);
    }

    public GetPaymentScheduleItemResponse getPaymentScheduleItem(String itemId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion) throws ApiException {
        ApiResponse<GetPaymentScheduleItemResponse> localVarResp = this.getPaymentScheduleItemWithHttpInfo(itemId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion);
        return localVarResp.getData();
    }

    private ApiResponse<GetPaymentScheduleItemResponse> getPaymentScheduleItemWithHttpInfo(String itemId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion) throws ApiException {
        Call localVarCall = this.getPaymentScheduleItemValidateBeforeCall(itemId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, null);
        Type localVarReturnType = new TypeToken<GetPaymentScheduleItemResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getPaymentScheduleItemAsync(String itemId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback<GetPaymentScheduleItemResponse> _callback) throws ApiException {
        Call localVarCall = this.getPaymentScheduleItemValidateBeforeCall(itemId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, _callback);
        Type localVarReturnType = new TypeToken<GetPaymentScheduleItemResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetPaymentScheduleItemApi getPaymentScheduleItemApi(String itemId) {
        return new GetPaymentScheduleItemApi(itemId);
    }

    private Call getPaymentScheduleStatisticCall(LocalDate yyyyMmDd, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/payment-schedules/statistics/{yyyy-mm-dd}".replace("{yyyy-mm-dd}", this.localVarApiClient.escapeString(yyyyMmDd.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getPaymentScheduleStatisticValidateBeforeCall(LocalDate yyyyMmDd, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback _callback) throws ApiException {
        if (yyyyMmDd == null) {
            throw new ApiException("Missing the required parameter 'yyyyMmDd' when calling getPaymentScheduleStatistic(Async)");
        }
        return this.getPaymentScheduleStatisticCall(yyyyMmDd, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, _callback);
    }

    public GetPaymentScheduleStatisticResponse getPaymentScheduleStatistic(LocalDate yyyyMmDd, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion) throws ApiException {
        ApiResponse<GetPaymentScheduleStatisticResponse> localVarResp = this.getPaymentScheduleStatisticWithHttpInfo(yyyyMmDd, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion);
        return localVarResp.getData();
    }

    private ApiResponse<GetPaymentScheduleStatisticResponse> getPaymentScheduleStatisticWithHttpInfo(LocalDate yyyyMmDd, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion) throws ApiException {
        Call localVarCall = this.getPaymentScheduleStatisticValidateBeforeCall(yyyyMmDd, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, null);
        Type localVarReturnType = new TypeToken<GetPaymentScheduleStatisticResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getPaymentScheduleStatisticAsync(LocalDate yyyyMmDd, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback<GetPaymentScheduleStatisticResponse> _callback) throws ApiException {
        Call localVarCall = this.getPaymentScheduleStatisticValidateBeforeCall(yyyyMmDd, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, _callback);
        Type localVarReturnType = new TypeToken<GetPaymentScheduleStatisticResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetPaymentScheduleStatisticApi getPaymentScheduleStatisticApi(LocalDate yyyyMmDd) {
        return new GetPaymentScheduleStatisticApi(yyyyMmDd);
    }

    private Call getPaymentSchedulesCall(String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer lastProcessedItems, Integer nextPendingItems, String accountId, Integer accountNumber, String zuoraVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/payment-schedules";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (lastProcessedItems != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("lastProcessedItems", lastProcessedItems));
        }
        if (nextPendingItems != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("nextPendingItems", nextPendingItems));
        }
        if (accountId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("accountId", accountId));
        }
        if (accountNumber != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("accountNumber", accountNumber));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("zuora-version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getPaymentSchedulesValidateBeforeCall(String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer lastProcessedItems, Integer nextPendingItems, String accountId, Integer accountNumber, String zuoraVersion, ApiCallback _callback) throws ApiException {
        return this.getPaymentSchedulesCall(acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, lastProcessedItems, nextPendingItems, accountId, accountNumber, zuoraVersion, _callback);
    }

    public GetPaymentSchedulesResponse getPaymentSchedules(String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer lastProcessedItems, Integer nextPendingItems, String accountId, Integer accountNumber, String zuoraVersion) throws ApiException {
        ApiResponse<GetPaymentSchedulesResponse> localVarResp = this.getPaymentSchedulesWithHttpInfo(acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, lastProcessedItems, nextPendingItems, accountId, accountNumber, zuoraVersion);
        return localVarResp.getData();
    }

    private ApiResponse<GetPaymentSchedulesResponse> getPaymentSchedulesWithHttpInfo(String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer lastProcessedItems, Integer nextPendingItems, String accountId, Integer accountNumber, String zuoraVersion) throws ApiException {
        Call localVarCall = this.getPaymentSchedulesValidateBeforeCall(acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, lastProcessedItems, nextPendingItems, accountId, accountNumber, zuoraVersion, null);
        Type localVarReturnType = new TypeToken<GetPaymentSchedulesResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getPaymentSchedulesAsync(String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, Integer lastProcessedItems, Integer nextPendingItems, String accountId, Integer accountNumber, String zuoraVersion, ApiCallback<GetPaymentSchedulesResponse> _callback) throws ApiException {
        Call localVarCall = this.getPaymentSchedulesValidateBeforeCall(acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, lastProcessedItems, nextPendingItems, accountId, accountNumber, zuoraVersion, _callback);
        Type localVarReturnType = new TypeToken<GetPaymentSchedulesResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetPaymentSchedulesApi getPaymentSchedulesApi() {
        return new GetPaymentSchedulesApi();
    }

    private Call retryPaymentScheduleItemCall(RetryPaymentScheduleItemRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        RetryPaymentScheduleItemRequest localVarPostBody = body;
        String localVarPath = "/v1/payment-schedule-items/retry-payment";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (idempotencyKey != null) {
            localVarHeaderParams.put("Idempotency-Key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("zuora-version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call retryPaymentScheduleItemValidateBeforeCall(RetryPaymentScheduleItemRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback _callback) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling retryPaymentScheduleItem(Async)");
        }
        return this.retryPaymentScheduleItemCall(body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, _callback);
    }

    public RetryPaymentScheduleItemResponse retryPaymentScheduleItem(RetryPaymentScheduleItemRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion) throws ApiException {
        ApiResponse<RetryPaymentScheduleItemResponse> localVarResp = this.retryPaymentScheduleItemWithHttpInfo(body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion);
        return localVarResp.getData();
    }

    private ApiResponse<RetryPaymentScheduleItemResponse> retryPaymentScheduleItemWithHttpInfo(RetryPaymentScheduleItemRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion) throws ApiException {
        Call localVarCall = this.retryPaymentScheduleItemValidateBeforeCall(body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, null);
        Type localVarReturnType = new TypeToken<RetryPaymentScheduleItemResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call retryPaymentScheduleItemAsync(RetryPaymentScheduleItemRequest body, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback<RetryPaymentScheduleItemResponse> _callback) throws ApiException {
        Call localVarCall = this.retryPaymentScheduleItemValidateBeforeCall(body, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, _callback);
        Type localVarReturnType = new TypeToken<RetryPaymentScheduleItemResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public RetryPaymentScheduleItemApi retryPaymentScheduleItemApi(RetryPaymentScheduleItemRequest body) {
        return new RetryPaymentScheduleItemApi(body);
    }

    private Call skipPaymentScheduleItemCall(String itemId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/payment-schedule-items/{item-id}/skip".replace("{item-id}", this.localVarApiClient.escapeString(itemId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("zuora-version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call skipPaymentScheduleItemValidateBeforeCall(String itemId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback _callback) throws ApiException {
        if (itemId == null) {
            throw new ApiException("Missing the required parameter 'itemId' when calling skipPaymentScheduleItem(Async)");
        }
        return this.skipPaymentScheduleItemCall(itemId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, _callback);
    }

    public GetPaymentScheduleItemResponse skipPaymentScheduleItem(String itemId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion) throws ApiException {
        ApiResponse<GetPaymentScheduleItemResponse> localVarResp = this.skipPaymentScheduleItemWithHttpInfo(itemId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion);
        return localVarResp.getData();
    }

    private ApiResponse<GetPaymentScheduleItemResponse> skipPaymentScheduleItemWithHttpInfo(String itemId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion) throws ApiException {
        Call localVarCall = this.skipPaymentScheduleItemValidateBeforeCall(itemId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, null);
        Type localVarReturnType = new TypeToken<GetPaymentScheduleItemResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call skipPaymentScheduleItemAsync(String itemId, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback<GetPaymentScheduleItemResponse> _callback) throws ApiException {
        Call localVarCall = this.skipPaymentScheduleItemValidateBeforeCall(itemId, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, _callback);
        Type localVarReturnType = new TypeToken<GetPaymentScheduleItemResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public SkipPaymentScheduleItemApi skipPaymentScheduleItemApi(String itemId) {
        return new SkipPaymentScheduleItemApi(itemId);
    }

    private Call updatePaymentScheduleCall(String paymentScheduleKey, UpdatePaymentScheduleRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        UpdatePaymentScheduleRequest localVarPostBody = body;
        String localVarPath = "/v1/payment-schedules/{paymentScheduleKey}".replace("{paymentScheduleKey}", this.localVarApiClient.escapeString(paymentScheduleKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("zuora-version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updatePaymentScheduleValidateBeforeCall(String paymentScheduleKey, UpdatePaymentScheduleRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback _callback) throws ApiException {
        if (paymentScheduleKey == null) {
            throw new ApiException("Missing the required parameter 'paymentScheduleKey' when calling updatePaymentSchedule(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling updatePaymentSchedule(Async)");
        }
        return this.updatePaymentScheduleCall(paymentScheduleKey, body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, _callback);
    }

    public PaymentScheduleResponse updatePaymentSchedule(String paymentScheduleKey, UpdatePaymentScheduleRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion) throws ApiException {
        ApiResponse<PaymentScheduleResponse> localVarResp = this.updatePaymentScheduleWithHttpInfo(paymentScheduleKey, body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion);
        return localVarResp.getData();
    }

    private ApiResponse<PaymentScheduleResponse> updatePaymentScheduleWithHttpInfo(String paymentScheduleKey, UpdatePaymentScheduleRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion) throws ApiException {
        Call localVarCall = this.updatePaymentScheduleValidateBeforeCall(paymentScheduleKey, body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, null);
        Type localVarReturnType = new TypeToken<PaymentScheduleResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call updatePaymentScheduleAsync(String paymentScheduleKey, UpdatePaymentScheduleRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback<PaymentScheduleResponse> _callback) throws ApiException {
        Call localVarCall = this.updatePaymentScheduleValidateBeforeCall(paymentScheduleKey, body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, _callback);
        Type localVarReturnType = new TypeToken<PaymentScheduleResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public UpdatePaymentScheduleApi updatePaymentScheduleApi(String paymentScheduleKey, UpdatePaymentScheduleRequest body) {
        return new UpdatePaymentScheduleApi(paymentScheduleKey, body);
    }

    private Call updatePaymentScheduleItemCall(String itemId, UpdatePaymentScheduleItemRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        UpdatePaymentScheduleItemRequest localVarPostBody = body;
        String localVarPath = "/v1/payment-schedule-items/{item-id}".replace("{item-id}", this.localVarApiClient.escapeString(itemId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("zuora-version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updatePaymentScheduleItemValidateBeforeCall(String itemId, UpdatePaymentScheduleItemRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback _callback) throws ApiException {
        if (itemId == null) {
            throw new ApiException("Missing the required parameter 'itemId' when calling updatePaymentScheduleItem(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling updatePaymentScheduleItem(Async)");
        }
        return this.updatePaymentScheduleItemCall(itemId, body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, _callback);
    }

    public GetPaymentScheduleItemResponse updatePaymentScheduleItem(String itemId, UpdatePaymentScheduleItemRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion) throws ApiException {
        ApiResponse<GetPaymentScheduleItemResponse> localVarResp = this.updatePaymentScheduleItemWithHttpInfo(itemId, body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion);
        return localVarResp.getData();
    }

    private ApiResponse<GetPaymentScheduleItemResponse> updatePaymentScheduleItemWithHttpInfo(String itemId, UpdatePaymentScheduleItemRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion) throws ApiException {
        Call localVarCall = this.updatePaymentScheduleItemValidateBeforeCall(itemId, body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, null);
        Type localVarReturnType = new TypeToken<GetPaymentScheduleItemResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call updatePaymentScheduleItemAsync(String itemId, UpdatePaymentScheduleItemRequest body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback<GetPaymentScheduleItemResponse> _callback) throws ApiException {
        Call localVarCall = this.updatePaymentScheduleItemValidateBeforeCall(itemId, body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, _callback);
        Type localVarReturnType = new TypeToken<GetPaymentScheduleItemResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public UpdatePaymentScheduleItemApi updatePaymentScheduleItemApi(String itemId, UpdatePaymentScheduleItemRequest body) {
        return new UpdatePaymentScheduleItemApi(itemId, body);
    }

    private Call updatePaymentSchedulePreviewCall(String paymentScheduleKey, PreviewPaymentSchedule body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        PreviewPaymentSchedule localVarPostBody = body;
        String localVarPath = "/v1/payment-schedules/{paymentScheduleKey}/preview".replace("{paymentScheduleKey}", this.localVarApiClient.escapeString(paymentScheduleKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("zuora-version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updatePaymentSchedulePreviewValidateBeforeCall(String paymentScheduleKey, PreviewPaymentSchedule body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback _callback) throws ApiException {
        if (paymentScheduleKey == null) {
            throw new ApiException("Missing the required parameter 'paymentScheduleKey' when calling updatePaymentSchedulePreview(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling updatePaymentSchedulePreview(Async)");
        }
        return this.updatePaymentSchedulePreviewCall(paymentScheduleKey, body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, _callback);
    }

    public PaymentScheduleResponse updatePaymentSchedulePreview(String paymentScheduleKey, PreviewPaymentSchedule body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion) throws ApiException {
        ApiResponse<PaymentScheduleResponse> localVarResp = this.updatePaymentSchedulePreviewWithHttpInfo(paymentScheduleKey, body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion);
        return localVarResp.getData();
    }

    private ApiResponse<PaymentScheduleResponse> updatePaymentSchedulePreviewWithHttpInfo(String paymentScheduleKey, PreviewPaymentSchedule body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion) throws ApiException {
        Call localVarCall = this.updatePaymentSchedulePreviewValidateBeforeCall(paymentScheduleKey, body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, null);
        Type localVarReturnType = new TypeToken<PaymentScheduleResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call updatePaymentSchedulePreviewAsync(String paymentScheduleKey, PreviewPaymentSchedule body, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback<PaymentScheduleResponse> _callback) throws ApiException {
        Call localVarCall = this.updatePaymentSchedulePreviewValidateBeforeCall(paymentScheduleKey, body, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, _callback);
        Type localVarReturnType = new TypeToken<PaymentScheduleResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public UpdatePaymentSchedulePreviewApi updatePaymentSchedulePreviewApi(String paymentScheduleKey, PreviewPaymentSchedule body) {
        return new UpdatePaymentSchedulePreviewApi(paymentScheduleKey, body);
    }

    public class UpdatePaymentSchedulePreviewApi {
        private final String paymentScheduleKey;
        private final PreviewPaymentSchedule body;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;

        private UpdatePaymentSchedulePreviewApi(String paymentScheduleKey, PreviewPaymentSchedule body) {
            this.paymentScheduleKey = paymentScheduleKey;
            this.body = body;
        }

        public UpdatePaymentSchedulePreviewApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public UpdatePaymentSchedulePreviewApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public UpdatePaymentSchedulePreviewApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public UpdatePaymentSchedulePreviewApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public UpdatePaymentSchedulePreviewApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public UpdatePaymentSchedulePreviewApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return PaymentSchedulesApi.this.updatePaymentSchedulePreviewCall(this.paymentScheduleKey, this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, _callback);
        }

        public PaymentScheduleResponse execute() throws ApiException {
            ApiResponse localVarResp = PaymentSchedulesApi.this.updatePaymentSchedulePreviewWithHttpInfo(this.paymentScheduleKey, this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion);
            return (PaymentScheduleResponse)localVarResp.getData();
        }

        private ApiResponse<PaymentScheduleResponse> executeWithHttpInfo() throws ApiException {
            return PaymentSchedulesApi.this.updatePaymentSchedulePreviewWithHttpInfo(this.paymentScheduleKey, this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion);
        }

        public Call executeAsync(ApiCallback<PaymentScheduleResponse> _callback) throws ApiException {
            return PaymentSchedulesApi.this.updatePaymentSchedulePreviewAsync(this.paymentScheduleKey, this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, _callback);
        }
    }

    public class UpdatePaymentScheduleItemApi {
        private final String itemId;
        private final UpdatePaymentScheduleItemRequest body;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;

        private UpdatePaymentScheduleItemApi(String itemId, UpdatePaymentScheduleItemRequest body) {
            this.itemId = itemId;
            this.body = body;
        }

        public UpdatePaymentScheduleItemApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public UpdatePaymentScheduleItemApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public UpdatePaymentScheduleItemApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public UpdatePaymentScheduleItemApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public UpdatePaymentScheduleItemApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public UpdatePaymentScheduleItemApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return PaymentSchedulesApi.this.updatePaymentScheduleItemCall(this.itemId, this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, _callback);
        }

        public GetPaymentScheduleItemResponse execute() throws ApiException {
            ApiResponse localVarResp = PaymentSchedulesApi.this.updatePaymentScheduleItemWithHttpInfo(this.itemId, this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion);
            return (GetPaymentScheduleItemResponse)localVarResp.getData();
        }

        private ApiResponse<GetPaymentScheduleItemResponse> executeWithHttpInfo() throws ApiException {
            return PaymentSchedulesApi.this.updatePaymentScheduleItemWithHttpInfo(this.itemId, this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion);
        }

        public Call executeAsync(ApiCallback<GetPaymentScheduleItemResponse> _callback) throws ApiException {
            return PaymentSchedulesApi.this.updatePaymentScheduleItemAsync(this.itemId, this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, _callback);
        }
    }

    public class UpdatePaymentScheduleApi {
        private final String paymentScheduleKey;
        private final UpdatePaymentScheduleRequest body;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;

        private UpdatePaymentScheduleApi(String paymentScheduleKey, UpdatePaymentScheduleRequest body) {
            this.paymentScheduleKey = paymentScheduleKey;
            this.body = body;
        }

        public UpdatePaymentScheduleApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public UpdatePaymentScheduleApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public UpdatePaymentScheduleApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public UpdatePaymentScheduleApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public UpdatePaymentScheduleApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public UpdatePaymentScheduleApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return PaymentSchedulesApi.this.updatePaymentScheduleCall(this.paymentScheduleKey, this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, _callback);
        }

        public PaymentScheduleResponse execute() throws ApiException {
            ApiResponse localVarResp = PaymentSchedulesApi.this.updatePaymentScheduleWithHttpInfo(this.paymentScheduleKey, this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion);
            return (PaymentScheduleResponse)localVarResp.getData();
        }

        private ApiResponse<PaymentScheduleResponse> executeWithHttpInfo() throws ApiException {
            return PaymentSchedulesApi.this.updatePaymentScheduleWithHttpInfo(this.paymentScheduleKey, this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion);
        }

        public Call executeAsync(ApiCallback<PaymentScheduleResponse> _callback) throws ApiException {
            return PaymentSchedulesApi.this.updatePaymentScheduleAsync(this.paymentScheduleKey, this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, _callback);
        }
    }

    public class SkipPaymentScheduleItemApi {
        private final String itemId;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;

        private SkipPaymentScheduleItemApi(String itemId) {
            this.itemId = itemId;
        }

        public SkipPaymentScheduleItemApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public SkipPaymentScheduleItemApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public SkipPaymentScheduleItemApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public SkipPaymentScheduleItemApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public SkipPaymentScheduleItemApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public SkipPaymentScheduleItemApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return PaymentSchedulesApi.this.skipPaymentScheduleItemCall(this.itemId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, _callback);
        }

        public GetPaymentScheduleItemResponse execute() throws ApiException {
            ApiResponse localVarResp = PaymentSchedulesApi.this.skipPaymentScheduleItemWithHttpInfo(this.itemId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion);
            return (GetPaymentScheduleItemResponse)localVarResp.getData();
        }

        private ApiResponse<GetPaymentScheduleItemResponse> executeWithHttpInfo() throws ApiException {
            return PaymentSchedulesApi.this.skipPaymentScheduleItemWithHttpInfo(this.itemId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion);
        }

        public Call executeAsync(ApiCallback<GetPaymentScheduleItemResponse> _callback) throws ApiException {
            return PaymentSchedulesApi.this.skipPaymentScheduleItemAsync(this.itemId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, _callback);
        }
    }

    public class RetryPaymentScheduleItemApi {
        private final RetryPaymentScheduleItemRequest body;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;

        private RetryPaymentScheduleItemApi(RetryPaymentScheduleItemRequest body) {
            this.body = body;
        }

        public RetryPaymentScheduleItemApi idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public RetryPaymentScheduleItemApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public RetryPaymentScheduleItemApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public RetryPaymentScheduleItemApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public RetryPaymentScheduleItemApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public RetryPaymentScheduleItemApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public RetryPaymentScheduleItemApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return PaymentSchedulesApi.this.retryPaymentScheduleItemCall(this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, _callback);
        }

        public RetryPaymentScheduleItemResponse execute() throws ApiException {
            ApiResponse localVarResp = PaymentSchedulesApi.this.retryPaymentScheduleItemWithHttpInfo(this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion);
            return (RetryPaymentScheduleItemResponse)localVarResp.getData();
        }

        private ApiResponse<RetryPaymentScheduleItemResponse> executeWithHttpInfo() throws ApiException {
            return PaymentSchedulesApi.this.retryPaymentScheduleItemWithHttpInfo(this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion);
        }

        public Call executeAsync(ApiCallback<RetryPaymentScheduleItemResponse> _callback) throws ApiException {
            return PaymentSchedulesApi.this.retryPaymentScheduleItemAsync(this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, _callback);
        }
    }

    public class GetPaymentSchedulesApi {
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private Integer lastProcessedItems;
        private Integer nextPendingItems;
        private String accountId;
        private Integer accountNumber;
        private String zuoraVersion;

        private GetPaymentSchedulesApi() {
        }

        public GetPaymentSchedulesApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public GetPaymentSchedulesApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public GetPaymentSchedulesApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public GetPaymentSchedulesApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public GetPaymentSchedulesApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public GetPaymentSchedulesApi lastProcessedItems(Integer lastProcessedItems) {
            this.lastProcessedItems = lastProcessedItems;
            return this;
        }

        public GetPaymentSchedulesApi nextPendingItems(Integer nextPendingItems) {
            this.nextPendingItems = nextPendingItems;
            return this;
        }

        public GetPaymentSchedulesApi accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public GetPaymentSchedulesApi accountNumber(Integer accountNumber) {
            this.accountNumber = accountNumber;
            return this;
        }

        public GetPaymentSchedulesApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return PaymentSchedulesApi.this.getPaymentSchedulesCall(this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.lastProcessedItems, this.nextPendingItems, this.accountId, this.accountNumber, this.zuoraVersion, _callback);
        }

        public GetPaymentSchedulesResponse execute() throws ApiException {
            ApiResponse localVarResp = PaymentSchedulesApi.this.getPaymentSchedulesWithHttpInfo(this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.lastProcessedItems, this.nextPendingItems, this.accountId, this.accountNumber, this.zuoraVersion);
            return (GetPaymentSchedulesResponse)localVarResp.getData();
        }

        private ApiResponse<GetPaymentSchedulesResponse> executeWithHttpInfo() throws ApiException {
            return PaymentSchedulesApi.this.getPaymentSchedulesWithHttpInfo(this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.lastProcessedItems, this.nextPendingItems, this.accountId, this.accountNumber, this.zuoraVersion);
        }

        public Call executeAsync(ApiCallback<GetPaymentSchedulesResponse> _callback) throws ApiException {
            return PaymentSchedulesApi.this.getPaymentSchedulesAsync(this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.lastProcessedItems, this.nextPendingItems, this.accountId, this.accountNumber, this.zuoraVersion, _callback);
        }
    }

    public class GetPaymentScheduleStatisticApi {
        private final LocalDate yyyyMmDd;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;

        private GetPaymentScheduleStatisticApi(LocalDate yyyyMmDd) {
            this.yyyyMmDd = yyyyMmDd;
        }

        public GetPaymentScheduleStatisticApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public GetPaymentScheduleStatisticApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public GetPaymentScheduleStatisticApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public GetPaymentScheduleStatisticApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public GetPaymentScheduleStatisticApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public GetPaymentScheduleStatisticApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return PaymentSchedulesApi.this.getPaymentScheduleStatisticCall(this.yyyyMmDd, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, _callback);
        }

        public GetPaymentScheduleStatisticResponse execute() throws ApiException {
            ApiResponse localVarResp = PaymentSchedulesApi.this.getPaymentScheduleStatisticWithHttpInfo(this.yyyyMmDd, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion);
            return (GetPaymentScheduleStatisticResponse)localVarResp.getData();
        }

        private ApiResponse<GetPaymentScheduleStatisticResponse> executeWithHttpInfo() throws ApiException {
            return PaymentSchedulesApi.this.getPaymentScheduleStatisticWithHttpInfo(this.yyyyMmDd, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion);
        }

        public Call executeAsync(ApiCallback<GetPaymentScheduleStatisticResponse> _callback) throws ApiException {
            return PaymentSchedulesApi.this.getPaymentScheduleStatisticAsync(this.yyyyMmDd, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, _callback);
        }
    }

    public class GetPaymentScheduleItemApi {
        private final String itemId;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;

        private GetPaymentScheduleItemApi(String itemId) {
            this.itemId = itemId;
        }

        public GetPaymentScheduleItemApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public GetPaymentScheduleItemApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public GetPaymentScheduleItemApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public GetPaymentScheduleItemApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public GetPaymentScheduleItemApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public GetPaymentScheduleItemApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return PaymentSchedulesApi.this.getPaymentScheduleItemCall(this.itemId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, _callback);
        }

        public GetPaymentScheduleItemResponse execute() throws ApiException {
            ApiResponse localVarResp = PaymentSchedulesApi.this.getPaymentScheduleItemWithHttpInfo(this.itemId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion);
            return (GetPaymentScheduleItemResponse)localVarResp.getData();
        }

        private ApiResponse<GetPaymentScheduleItemResponse> executeWithHttpInfo() throws ApiException {
            return PaymentSchedulesApi.this.getPaymentScheduleItemWithHttpInfo(this.itemId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion);
        }

        public Call executeAsync(ApiCallback<GetPaymentScheduleItemResponse> _callback) throws ApiException {
            return PaymentSchedulesApi.this.getPaymentScheduleItemAsync(this.itemId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, _callback);
        }
    }

    public class GetPaymentScheduleApi {
        private final String paymentScheduleKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private Integer nextPendingItems;
        private Integer lastProcessedItems;
        private String zuoraVersion;

        private GetPaymentScheduleApi(String paymentScheduleKey) {
            this.paymentScheduleKey = paymentScheduleKey;
        }

        public GetPaymentScheduleApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public GetPaymentScheduleApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public GetPaymentScheduleApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public GetPaymentScheduleApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public GetPaymentScheduleApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public GetPaymentScheduleApi nextPendingItems(Integer nextPendingItems) {
            this.nextPendingItems = nextPendingItems;
            return this;
        }

        public GetPaymentScheduleApi lastProcessedItems(Integer lastProcessedItems) {
            this.lastProcessedItems = lastProcessedItems;
            return this;
        }

        public GetPaymentScheduleApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return PaymentSchedulesApi.this.getPaymentScheduleCall(this.paymentScheduleKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.nextPendingItems, this.lastProcessedItems, this.zuoraVersion, _callback);
        }

        public PaymentScheduleResponse execute() throws ApiException {
            ApiResponse localVarResp = PaymentSchedulesApi.this.getPaymentScheduleWithHttpInfo(this.paymentScheduleKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.nextPendingItems, this.lastProcessedItems, this.zuoraVersion);
            return (PaymentScheduleResponse)localVarResp.getData();
        }

        private ApiResponse<PaymentScheduleResponse> executeWithHttpInfo() throws ApiException {
            return PaymentSchedulesApi.this.getPaymentScheduleWithHttpInfo(this.paymentScheduleKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.nextPendingItems, this.lastProcessedItems, this.zuoraVersion);
        }

        public Call executeAsync(ApiCallback<PaymentScheduleResponse> _callback) throws ApiException {
            return PaymentSchedulesApi.this.getPaymentScheduleAsync(this.paymentScheduleKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.nextPendingItems, this.lastProcessedItems, this.zuoraVersion, _callback);
        }
    }

    public class CreatePaymentSchedulesApi {
        private final CreatePaymentSchedulesRequest body;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;

        private CreatePaymentSchedulesApi(CreatePaymentSchedulesRequest body) {
            this.body = body;
        }

        public CreatePaymentSchedulesApi idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public CreatePaymentSchedulesApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public CreatePaymentSchedulesApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public CreatePaymentSchedulesApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public CreatePaymentSchedulesApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public CreatePaymentSchedulesApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public CreatePaymentSchedulesApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return PaymentSchedulesApi.this.createPaymentSchedulesCall(this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, _callback);
        }

        public CreatePaymentSchedulesResponse execute() throws ApiException {
            ApiResponse localVarResp = PaymentSchedulesApi.this.createPaymentSchedulesWithHttpInfo(this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion);
            return (CreatePaymentSchedulesResponse)localVarResp.getData();
        }

        private ApiResponse<CreatePaymentSchedulesResponse> executeWithHttpInfo() throws ApiException {
            return PaymentSchedulesApi.this.createPaymentSchedulesWithHttpInfo(this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion);
        }

        public Call executeAsync(ApiCallback<CreatePaymentSchedulesResponse> _callback) throws ApiException {
            return PaymentSchedulesApi.this.createPaymentSchedulesAsync(this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, _callback);
        }
    }

    public class CreatePaymentScheduleApi {
        private final CreatePaymentScheduleRequest body;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;

        private CreatePaymentScheduleApi(CreatePaymentScheduleRequest body) {
            this.body = body;
        }

        public CreatePaymentScheduleApi idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public CreatePaymentScheduleApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public CreatePaymentScheduleApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public CreatePaymentScheduleApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public CreatePaymentScheduleApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public CreatePaymentScheduleApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public CreatePaymentScheduleApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return PaymentSchedulesApi.this.createPaymentScheduleCall(this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, _callback);
        }

        public PaymentScheduleResponse execute() throws ApiException {
            ApiResponse localVarResp = PaymentSchedulesApi.this.createPaymentScheduleWithHttpInfo(this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion);
            return (PaymentScheduleResponse)localVarResp.getData();
        }

        private ApiResponse<PaymentScheduleResponse> executeWithHttpInfo() throws ApiException {
            return PaymentSchedulesApi.this.createPaymentScheduleWithHttpInfo(this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion);
        }

        public Call executeAsync(ApiCallback<PaymentScheduleResponse> _callback) throws ApiException {
            return PaymentSchedulesApi.this.createPaymentScheduleAsync(this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, _callback);
        }
    }

    public class CancelPaymentScheduleItemApi {
        private final String itemId;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;

        private CancelPaymentScheduleItemApi(String itemId) {
            this.itemId = itemId;
        }

        public CancelPaymentScheduleItemApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public CancelPaymentScheduleItemApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public CancelPaymentScheduleItemApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public CancelPaymentScheduleItemApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public CancelPaymentScheduleItemApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public CancelPaymentScheduleItemApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return PaymentSchedulesApi.this.cancelPaymentScheduleItemCall(this.itemId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, _callback);
        }

        public GetPaymentScheduleItemResponse execute() throws ApiException {
            ApiResponse localVarResp = PaymentSchedulesApi.this.cancelPaymentScheduleItemWithHttpInfo(this.itemId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion);
            return (GetPaymentScheduleItemResponse)localVarResp.getData();
        }

        private ApiResponse<GetPaymentScheduleItemResponse> executeWithHttpInfo() throws ApiException {
            return PaymentSchedulesApi.this.cancelPaymentScheduleItemWithHttpInfo(this.itemId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion);
        }

        public Call executeAsync(ApiCallback<GetPaymentScheduleItemResponse> _callback) throws ApiException {
            return PaymentSchedulesApi.this.cancelPaymentScheduleItemAsync(this.itemId, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, _callback);
        }
    }

    public class CancelPaymentScheduleApi {
        private final String paymentScheduleKey;
        private final CancelPaymentSchedule body;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;

        private CancelPaymentScheduleApi(String paymentScheduleKey, CancelPaymentSchedule body) {
            this.paymentScheduleKey = paymentScheduleKey;
            this.body = body;
        }

        public CancelPaymentScheduleApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public CancelPaymentScheduleApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public CancelPaymentScheduleApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public CancelPaymentScheduleApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public CancelPaymentScheduleApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public CancelPaymentScheduleApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return PaymentSchedulesApi.this.cancelPaymentScheduleCall(this.paymentScheduleKey, this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, _callback);
        }

        public PaymentScheduleResponse execute() throws ApiException {
            ApiResponse localVarResp = PaymentSchedulesApi.this.cancelPaymentScheduleWithHttpInfo(this.paymentScheduleKey, this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion);
            return (PaymentScheduleResponse)localVarResp.getData();
        }

        private ApiResponse<PaymentScheduleResponse> executeWithHttpInfo() throws ApiException {
            return PaymentSchedulesApi.this.cancelPaymentScheduleWithHttpInfo(this.paymentScheduleKey, this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion);
        }

        public Call executeAsync(ApiCallback<PaymentScheduleResponse> _callback) throws ApiException {
            return PaymentSchedulesApi.this.cancelPaymentScheduleAsync(this.paymentScheduleKey, this.body, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, _callback);
        }
    }

    public class AddItemsToCustomPaymentScheduleApi {
        private final String paymentScheduleKey;
        private final CreatePaymentScheduleItemsRequest body;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;

        private AddItemsToCustomPaymentScheduleApi(String paymentScheduleKey, CreatePaymentScheduleItemsRequest body) {
            this.paymentScheduleKey = paymentScheduleKey;
            this.body = body;
        }

        public AddItemsToCustomPaymentScheduleApi idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public AddItemsToCustomPaymentScheduleApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public AddItemsToCustomPaymentScheduleApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public AddItemsToCustomPaymentScheduleApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public AddItemsToCustomPaymentScheduleApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public AddItemsToCustomPaymentScheduleApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public AddItemsToCustomPaymentScheduleApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return PaymentSchedulesApi.this.addItemsToCustomPaymentScheduleCall(this.paymentScheduleKey, this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, _callback);
        }

        public PaymentScheduleResponse execute() throws ApiException {
            ApiResponse localVarResp = PaymentSchedulesApi.this.addItemsToCustomPaymentScheduleWithHttpInfo(this.paymentScheduleKey, this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion);
            return (PaymentScheduleResponse)localVarResp.getData();
        }

        private ApiResponse<PaymentScheduleResponse> executeWithHttpInfo() throws ApiException {
            return PaymentSchedulesApi.this.addItemsToCustomPaymentScheduleWithHttpInfo(this.paymentScheduleKey, this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion);
        }

        public Call executeAsync(ApiCallback<PaymentScheduleResponse> _callback) throws ApiException {
            return PaymentSchedulesApi.this.addItemsToCustomPaymentScheduleAsync(this.paymentScheduleKey, this.body, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, _callback);
        }
    }
}

