/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.api;

import com.google.gson.reflect.TypeToken;
import com.zuora.ApiCallback;
import com.zuora.ApiClient;
import com.zuora.ApiException;
import com.zuora.ApiResponse;
import com.zuora.Configuration;
import com.zuora.Pair;
import com.zuora.model.CancelAuthorizationRequest;
import com.zuora.model.CancelAuthorizationResponse;
import com.zuora.model.CreateAuthorizationRequest;
import com.zuora.model.CreateAuthorizationResponse;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class PaymentAuthorizationApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public PaymentAuthorizationApi() {
        this(Configuration.getDefaultApiClient());
    }

    public PaymentAuthorizationApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call cancelAuthorizationCall(String paymentMethodId, CancelAuthorizationRequest request, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CancelAuthorizationRequest localVarPostBody = request;
        String localVarPath = "/v1/payment-methods/{payment-method-id}/voidAuthorize".replace("{payment-method-id}", this.localVarApiClient.escapeString(paymentMethodId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (idempotencyKey != null) {
            localVarHeaderParams.put("Idempotency-Key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call cancelAuthorizationValidateBeforeCall(String paymentMethodId, CancelAuthorizationRequest request, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback _callback) throws ApiException {
        if (paymentMethodId == null) {
            throw new ApiException("Missing the required parameter 'paymentMethodId' when calling cancelAuthorization(Async)");
        }
        if (request == null) {
            throw new ApiException("Missing the required parameter 'request' when calling cancelAuthorization(Async)");
        }
        return this.cancelAuthorizationCall(paymentMethodId, request, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, _callback);
    }

    public CancelAuthorizationResponse cancelAuthorization(String paymentMethodId, CancelAuthorizationRequest request, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion) throws ApiException {
        ApiResponse<CancelAuthorizationResponse> localVarResp = this.cancelAuthorizationWithHttpInfo(paymentMethodId, request, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion);
        return localVarResp.getData();
    }

    private ApiResponse<CancelAuthorizationResponse> cancelAuthorizationWithHttpInfo(String paymentMethodId, CancelAuthorizationRequest request, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion) throws ApiException {
        Call localVarCall = this.cancelAuthorizationValidateBeforeCall(paymentMethodId, request, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, null);
        Type localVarReturnType = new TypeToken<CancelAuthorizationResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call cancelAuthorizationAsync(String paymentMethodId, CancelAuthorizationRequest request, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback<CancelAuthorizationResponse> _callback) throws ApiException {
        Call localVarCall = this.cancelAuthorizationValidateBeforeCall(paymentMethodId, request, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, _callback);
        Type localVarReturnType = new TypeToken<CancelAuthorizationResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public CancelAuthorizationApi cancelAuthorizationApi(String paymentMethodId, CancelAuthorizationRequest request) {
        return new CancelAuthorizationApi(paymentMethodId, request);
    }

    private Call createAuthorizationCall(String paymentMethodId, CreateAuthorizationRequest request, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CreateAuthorizationRequest localVarPostBody = request;
        String localVarPath = "/v1/payment-methods/{payment-method-id}/authorize".replace("{payment-method-id}", this.localVarApiClient.escapeString(paymentMethodId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (idempotencyKey != null) {
            localVarHeaderParams.put("Idempotency-Key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createAuthorizationValidateBeforeCall(String paymentMethodId, CreateAuthorizationRequest request, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback _callback) throws ApiException {
        if (paymentMethodId == null) {
            throw new ApiException("Missing the required parameter 'paymentMethodId' when calling createAuthorization(Async)");
        }
        if (request == null) {
            throw new ApiException("Missing the required parameter 'request' when calling createAuthorization(Async)");
        }
        return this.createAuthorizationCall(paymentMethodId, request, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, _callback);
    }

    public CreateAuthorizationResponse createAuthorization(String paymentMethodId, CreateAuthorizationRequest request, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion) throws ApiException {
        ApiResponse<CreateAuthorizationResponse> localVarResp = this.createAuthorizationWithHttpInfo(paymentMethodId, request, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion);
        return localVarResp.getData();
    }

    private ApiResponse<CreateAuthorizationResponse> createAuthorizationWithHttpInfo(String paymentMethodId, CreateAuthorizationRequest request, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion) throws ApiException {
        Call localVarCall = this.createAuthorizationValidateBeforeCall(paymentMethodId, request, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, null);
        Type localVarReturnType = new TypeToken<CreateAuthorizationResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call createAuthorizationAsync(String paymentMethodId, CreateAuthorizationRequest request, String idempotencyKey, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback<CreateAuthorizationResponse> _callback) throws ApiException {
        Call localVarCall = this.createAuthorizationValidateBeforeCall(paymentMethodId, request, idempotencyKey, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, _callback);
        Type localVarReturnType = new TypeToken<CreateAuthorizationResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public CreateAuthorizationApi createAuthorizationApi(String paymentMethodId, CreateAuthorizationRequest request) {
        return new CreateAuthorizationApi(paymentMethodId, request);
    }

    public class CreateAuthorizationApi {
        private final String paymentMethodId;
        private final CreateAuthorizationRequest request;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;

        private CreateAuthorizationApi(String paymentMethodId, CreateAuthorizationRequest request) {
            this.paymentMethodId = paymentMethodId;
            this.request = request;
        }

        public CreateAuthorizationApi idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public CreateAuthorizationApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public CreateAuthorizationApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public CreateAuthorizationApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public CreateAuthorizationApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public CreateAuthorizationApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public CreateAuthorizationApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return PaymentAuthorizationApi.this.createAuthorizationCall(this.paymentMethodId, this.request, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, _callback);
        }

        public CreateAuthorizationResponse execute() throws ApiException {
            ApiResponse localVarResp = PaymentAuthorizationApi.this.createAuthorizationWithHttpInfo(this.paymentMethodId, this.request, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion);
            return (CreateAuthorizationResponse)localVarResp.getData();
        }

        private ApiResponse<CreateAuthorizationResponse> executeWithHttpInfo() throws ApiException {
            return PaymentAuthorizationApi.this.createAuthorizationWithHttpInfo(this.paymentMethodId, this.request, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion);
        }

        public Call executeAsync(ApiCallback<CreateAuthorizationResponse> _callback) throws ApiException {
            return PaymentAuthorizationApi.this.createAuthorizationAsync(this.paymentMethodId, this.request, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, _callback);
        }
    }

    public class CancelAuthorizationApi {
        private final String paymentMethodId;
        private final CancelAuthorizationRequest request;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;

        private CancelAuthorizationApi(String paymentMethodId, CancelAuthorizationRequest request) {
            this.paymentMethodId = paymentMethodId;
            this.request = request;
        }

        public CancelAuthorizationApi idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public CancelAuthorizationApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public CancelAuthorizationApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public CancelAuthorizationApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public CancelAuthorizationApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public CancelAuthorizationApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public CancelAuthorizationApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return PaymentAuthorizationApi.this.cancelAuthorizationCall(this.paymentMethodId, this.request, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, _callback);
        }

        public CancelAuthorizationResponse execute() throws ApiException {
            ApiResponse localVarResp = PaymentAuthorizationApi.this.cancelAuthorizationWithHttpInfo(this.paymentMethodId, this.request, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion);
            return (CancelAuthorizationResponse)localVarResp.getData();
        }

        private ApiResponse<CancelAuthorizationResponse> executeWithHttpInfo() throws ApiException {
            return PaymentAuthorizationApi.this.cancelAuthorizationWithHttpInfo(this.paymentMethodId, this.request, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion);
        }

        public Call executeAsync(ApiCallback<CancelAuthorizationResponse> _callback) throws ApiException {
            return PaymentAuthorizationApi.this.cancelAuthorizationAsync(this.paymentMethodId, this.request, this.idempotencyKey, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, _callback);
        }
    }
}

