/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Objects;
import javax.annotation.Nullable;

public class PrepaidBalanceTransaction {
    public static final String SERIALIZED_NAME_TRANSACTION_DATE = "transaction_date";
    @SerializedName(value="transaction_date")
    private String transactionDate;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private TypeEnum type;
    public static final String SERIALIZED_NAME_QUANTITY = "quantity";
    @SerializedName(value="quantity")
    private BigDecimal quantity;

    public PrepaidBalanceTransaction transactionDate(String transactionDate) {
        this.transactionDate = transactionDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Date on which the transaction occurs.")
    public String getTransactionDate() {
        return this.transactionDate;
    }

    public void setTransactionDate(String transactionDate) {
        this.transactionDate = transactionDate;
    }

    public PrepaidBalanceTransaction type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An action that increases or decreases its associated prepaid balance. ")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public PrepaidBalanceTransaction quantity(BigDecimal quantity) {
        this.quantity = quantity;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Quantity of the prepaid balance transaction.")
    public BigDecimal getQuantity() {
        return this.quantity;
    }

    public void setQuantity(BigDecimal quantity) {
        this.quantity = quantity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PrepaidBalanceTransaction prepaidBalanceTransaction = (PrepaidBalanceTransaction)o;
        return Objects.equals(this.transactionDate, prepaidBalanceTransaction.transactionDate) && Objects.equals((Object)this.type, (Object)prepaidBalanceTransaction.type) && Objects.equals(this.quantity, prepaidBalanceTransaction.quantity);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.transactionDate, this.type, this.quantity});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PrepaidBalanceTransaction {\n");
        sb.append("    transactionDate: ").append(this.toIndentedString(this.transactionDate)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    quantity: ").append(this.toIndentedString(this.quantity)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        PREPAYMENT("prepayment"),
        DRAWDOWN("drawdown"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(value);
            }
        }
    }
}

