/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.client.JSON;
import org.openapitools.client.model.AccountCreateRequest;
import org.openapitools.client.model.LineItemCreateRequest;
import org.openapitools.client.model.OrdersProcessingOption;
import org.openapitools.client.model.PostSubscriptionOrderRequest;
import org.openapitools.jackson.nullable.JsonNullable;
import org.threeten.bp.LocalDate;

public class OrderCreateRequest {
    public static final String SERIALIZED_NAME_CATEGORY = "category";
    @SerializedName(value="category")
    private CategoryEnum category;
    public static final String SERIALIZED_NAME_CUSTOM_OBJECTS = "custom_objects";
    @SerializedName(value="custom_objects")
    private Map<String, Object> customObjects = null;
    public static final String SERIALIZED_NAME_CUSTOM_FIELDS = "custom_fields";
    @SerializedName(value="custom_fields")
    @JsonAdapter(value=JSON.CustomFieldAdapter.class)
    private Map<String, String> customFields = null;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_ACCOUNT_NUMBER = "account_number";
    @SerializedName(value="account_number")
    private String accountNumber;
    public static final String SERIALIZED_NAME_ACCOUNT_ID = "account_id";
    @SerializedName(value="account_id")
    private String accountId;
    public static final String SERIALIZED_NAME_ACCOUNT_DATA = "account_data";
    @SerializedName(value="account_data")
    private AccountCreateRequest accountData;
    public static final String SERIALIZED_NAME_ORDER_DATE = "order_date";
    @SerializedName(value="order_date")
    private LocalDate orderDate;
    public static final String SERIALIZED_NAME_ORDER_NUMBER = "order_number";
    @SerializedName(value="order_number")
    private String orderNumber;
    public static final String SERIALIZED_NAME_LINE_ITEMS = "line_items";
    @SerializedName(value="line_items")
    private List<LineItemCreateRequest> lineItems = null;
    public static final String SERIALIZED_NAME_PROCESSING_OPTIONS = "processing_options";
    @SerializedName(value="processing_options")
    private OrdersProcessingOption processingOptions;
    public static final String SERIALIZED_NAME_SUBSCRIPTIONS = "subscriptions";
    @SerializedName(value="subscriptions")
    private List<PostSubscriptionOrderRequest> subscriptions = null;
    public static final String SERIALIZED_NAME_STATE = "state";
    @SerializedName(value="state")
    private StateEnum state;

    public OrderCreateRequest() {
    }

    public OrderCreateRequest(Map<String, Object> customObjects) {
        this();
        this.customObjects = customObjects;
    }

    public OrderCreateRequest category(CategoryEnum category) {
        this.category = category;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Category of the order to indicate a product sale or return. Default value is `sale`.")
    public CategoryEnum getCategory() {
        return this.category;
    }

    public void setCategory(CategoryEnum category) {
        this.category = category;
    }

    @Nullable
    @ApiModelProperty(value="The custom objects associated with a Zuora standard object.")
    public Map<String, Object> getCustomObjects() {
        return this.customObjects;
    }

    public OrderCreateRequest customFields(Map<String, String> customFields) {
        this.customFields = customFields;
        return this;
    }

    public OrderCreateRequest putCustomFieldsItem(String key, String customFieldsItem) {
        if (this.customFields == null) {
            this.customFields = new HashMap<String, String>();
        }
        this.customFields.put(key, customFieldsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Set of user-defined fields associated with this object. Useful for storing additional information about the object in a structured format.")
    public Map<String, String> getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(Map<String, String> customFields) {
        this.customFields = customFields;
    }

    public OrderCreateRequest description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="description of test account", value="An arbitrary string attached to the object. Often useful for displaying to users.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public OrderCreateRequest accountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="A-100001", value="Human-readable identifier of the account. It can be user-supplied.")
    public String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public OrderCreateRequest accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2c92c0f86a8dd422016a9e7a70116b0d", value="Identifier of the account.")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public OrderCreateRequest accountData(AccountCreateRequest accountData) {
        this.accountData = accountData;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The information of the new account that owns the subscription. The subscription owner account can be different from the invoice owner account. If you specify this field, do not specify `account_id`.")
    public AccountCreateRequest getAccountData() {
        return this.accountData;
    }

    public void setAccountData(AccountCreateRequest accountData) {
        this.accountData = accountData;
    }

    public OrderCreateRequest orderDate(LocalDate orderDate) {
        this.orderDate = orderDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Sat Jan 01 00:00:00 GMT 2022", value="The date when the order is signed. All the order actions under this order will use this order date as the contract effective date if the contract effective date field is skipped or its value is left as null.")
    public LocalDate getOrderDate() {
        return this.orderDate;
    }

    public void setOrderDate(LocalDate orderDate) {
        this.orderDate = orderDate;
    }

    public OrderCreateRequest orderNumber(String orderNumber) {
        this.orderNumber = orderNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The order number of the new order. If not provided, system will auto-generate a number for this order.     Note: Ensure that the order number does not contain a slash.")
    public String getOrderNumber() {
        return this.orderNumber;
    }

    public void setOrderNumber(String orderNumber) {
        this.orderNumber = orderNumber;
    }

    public OrderCreateRequest lineItems(List<LineItemCreateRequest> lineItems) {
        this.lineItems = lineItems;
        return this;
    }

    public OrderCreateRequest addLineItemsItem(LineItemCreateRequest lineItemsItem) {
        if (this.lineItems == null) {
            this.lineItems = new ArrayList<LineItemCreateRequest>();
        }
        this.lineItems.add(lineItemsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Order line items are non-subscription-based items created by an order, representing transactional charges such as one-time fees, physical goods, or professional service charges that are not sold as subscription services.    By specifying this field, you can launch non-subscription and unified monetization business models in Zuora, in addition to subscription business models.")
    public List<LineItemCreateRequest> getLineItems() {
        return this.lineItems;
    }

    public void setLineItems(List<LineItemCreateRequest> lineItems) {
        this.lineItems = lineItems;
    }

    public OrderCreateRequest processingOptions(OrdersProcessingOption processingOptions) {
        this.processingOptions = processingOptions;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public OrdersProcessingOption getProcessingOptions() {
        return this.processingOptions;
    }

    public void setProcessingOptions(OrdersProcessingOption processingOptions) {
        this.processingOptions = processingOptions;
    }

    public OrderCreateRequest subscriptions(List<PostSubscriptionOrderRequest> subscriptions) {
        this.subscriptions = subscriptions;
        return this;
    }

    public OrderCreateRequest addSubscriptionsItem(PostSubscriptionOrderRequest subscriptionsItem) {
        if (this.subscriptions == null) {
            this.subscriptions = new ArrayList<PostSubscriptionOrderRequest>();
        }
        this.subscriptions.add(subscriptionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Based on the intended order action, each item should include specific fields.     For example, to create a new subscription for a new account, you must specify the `account_data` and `subscription_plans` fields at a minimum.")
    public List<PostSubscriptionOrderRequest> getSubscriptions() {
        return this.subscriptions;
    }

    public void setSubscriptions(List<PostSubscriptionOrderRequest> subscriptions) {
        this.subscriptions = subscriptions;
    }

    public OrderCreateRequest state(StateEnum state) {
        this.state = state;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The status of the order.")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderCreateRequest orderCreateRequest = (OrderCreateRequest)o;
        return Objects.equals((Object)this.category, (Object)orderCreateRequest.category) && Objects.equals(this.customObjects, orderCreateRequest.customObjects) && Objects.equals(this.customFields, orderCreateRequest.customFields) && Objects.equals(this.description, orderCreateRequest.description) && Objects.equals(this.accountNumber, orderCreateRequest.accountNumber) && Objects.equals(this.accountId, orderCreateRequest.accountId) && Objects.equals(this.accountData, orderCreateRequest.accountData) && Objects.equals(this.orderDate, orderCreateRequest.orderDate) && Objects.equals(this.orderNumber, orderCreateRequest.orderNumber) && Objects.equals(this.lineItems, orderCreateRequest.lineItems) && Objects.equals(this.processingOptions, orderCreateRequest.processingOptions) && Objects.equals(this.subscriptions, orderCreateRequest.subscriptions) && Objects.equals((Object)this.state, (Object)orderCreateRequest.state);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.category, this.customObjects, this.customFields, this.description, this.accountNumber, this.accountId, this.accountData, this.orderDate, this.orderNumber, this.lineItems, this.processingOptions, this.subscriptions, this.state});
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrderCreateRequest {\n");
        sb.append("    category: ").append(this.toIndentedString((Object)this.category)).append("\n");
        sb.append("    customObjects: ").append(this.toIndentedString(this.customObjects)).append("\n");
        sb.append("    customFields: ").append(this.toIndentedString(this.customFields)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    accountNumber: ").append(this.toIndentedString(this.accountNumber)).append("\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    accountData: ").append(this.toIndentedString(this.accountData)).append("\n");
        sb.append("    orderDate: ").append(this.toIndentedString(this.orderDate)).append("\n");
        sb.append("    orderNumber: ").append(this.toIndentedString(this.orderNumber)).append("\n");
        sb.append("    lineItems: ").append(this.toIndentedString(this.lineItems)).append("\n");
        sb.append("    processingOptions: ").append(this.toIndentedString(this.processingOptions)).append("\n");
        sb.append("    subscriptions: ").append(this.toIndentedString(this.subscriptions)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StateEnum {
        PENDING("pending"),
        COMPLETE("complete"),
        DRAFT("draft"),
        CANCELED("canceled"),
        SCHEDULED("scheduled"),
        EXECUTING("executing"),
        FAILED("failed"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StateEnum fromValue(String value) {
            for (StateEnum b : StateEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<StateEnum> {
            public void write(JsonWriter jsonWriter, StateEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StateEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StateEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum CategoryEnum {
        SALE("sale"),
        RETURN("return"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private CategoryEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static CategoryEnum fromValue(String value) {
            for (CategoryEnum b : CategoryEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<CategoryEnum> {
            public void write(JsonWriter jsonWriter, CategoryEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public CategoryEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return CategoryEnum.fromValue(value);
            }
        }
    }
}

