/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;
import org.openapitools.client.ApiCallback;
import org.openapitools.client.ApiClient;
import org.openapitools.client.ApiException;
import org.openapitools.client.ApiResponse;
import org.openapitools.client.Configuration;
import org.openapitools.client.Pair;
import org.openapitools.client.model.CreditMemo;
import org.openapitools.client.model.ErrorResponse;
import org.openapitools.client.model.GetByIdQueryParams;
import org.openapitools.client.model.Headers;
import org.openapitools.client.model.Invoice;
import org.openapitools.client.model.InvoiceCreateRequest;
import org.openapitools.client.model.InvoiceItemListResponse;
import org.openapitools.client.model.InvoiceListResponse;
import org.openapitools.client.model.InvoicePatchRequest;
import org.openapitools.client.model.InvoiceReverseRequest;
import org.openapitools.client.model.ListQueryParams;
import org.openapitools.client.model.PayInvoiceRequest;
import org.openapitools.client.model.WriteOffRequest;

public class InvoicesApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public InvoicesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public InvoicesApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call cancelInvoiceCall(String invoiceId, List<String> fields, List<String> invoiceFields, List<String> invoiceItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> lineItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/invoices/{invoice_id}/cancel".replace("{invoice_id}", this.localVarApiClient.escapeString(invoiceId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (invoiceFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "invoice.fields[]", invoiceFields));
        }
        if (invoiceItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "invoice_items.fields[]", invoiceItemsFields));
        }
        if (taxationItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "taxation_items.fields[]", taxationItemsFields));
        }
        if (accountFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "account.fields[]", accountFields));
        }
        if (billToFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "bill_to.fields[]", billToFields));
        }
        if (lineItemFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "line_item.fields[]", lineItemFields));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call cancelInvoiceValidateBeforeCall(String invoiceId, List<String> fields, List<String> invoiceFields, List<String> invoiceItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> lineItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (invoiceId == null) {
            throw new ApiException("Missing the required parameter 'invoiceId' when calling cancelInvoice(Async)");
        }
        return this.cancelInvoiceCall(invoiceId, fields, invoiceFields, invoiceItemsFields, taxationItemsFields, accountFields, billToFields, lineItemFields, expand, filter, pageSize, zuoraTrackId, async, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<Invoice> cancelInvoiceWithHttpInfo(String invoiceId, List<String> fields, List<String> invoiceFields, List<String> invoiceItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> lineItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.cancelInvoiceValidateBeforeCall(invoiceId, fields, invoiceFields, invoiceItemsFields, taxationItemsFields, accountFields, billToFields, lineItemFields, expand, filter, pageSize, zuoraTrackId, async, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<Invoice>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call cancelInvoiceAsync(String invoiceId, List<String> fields, List<String> invoiceFields, List<String> invoiceItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> lineItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<Invoice> _callback) throws ApiException {
        Call localVarCall = this.cancelInvoiceValidateBeforeCall(invoiceId, fields, invoiceFields, invoiceItemsFields, taxationItemsFields, accountFields, billToFields, lineItemFields, expand, filter, pageSize, zuoraTrackId, async, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<Invoice>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public CancelInvoiceParams cancelInvoiceParams(String invoiceId) {
        return new CancelInvoiceParams(invoiceId);
    }

    public Invoice cancelInvoice(String invoiceId) throws ApiException {
        CancelInvoiceParams params = new CancelInvoiceParams(invoiceId);
        return this.executeCancelInvoiceAPICall(params).getData();
    }

    public Invoice cancelInvoice(String invoiceId, List<String> expand) throws ApiException {
        CancelInvoiceParams params = new CancelInvoiceParams(invoiceId);
        params.expand(expand);
        return this.executeCancelInvoiceAPICall(params).getData();
    }

    public Invoice cancelInvoice(String invoiceId, List<String> expand, Headers headers) throws ApiException {
        CancelInvoiceParams params = new CancelInvoiceParams(invoiceId).expand(expand).headers(headers);
        return this.executeCancelInvoiceAPICall(params).getData();
    }

    public Invoice cancel(CancelInvoiceParams params) throws ApiException {
        return this.executeCancelInvoiceAPICall(params).getData();
    }

    public ApiResponse<Invoice> cancelWithHttpInfo(CancelInvoiceParams params) throws ApiException {
        return this.executeCancelInvoiceAPICall(params);
    }

    ApiResponse<Invoice> executeCancelInvoiceAPICall(CancelInvoiceParams params) throws ApiException {
        return this.cancelInvoiceWithHttpInfo(params.invoiceId, params.fields, params.invoiceFields, params.invoiceItemsFields, params.taxationItemsFields, params.accountFields, params.billToFields, params.lineItemFields, params.expand, params.filter, params.pageSize, params.zuoraTrackId, params.async, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    private Call createInvoiceCall(InvoiceCreateRequest invoiceCreateRequest, List<String> fields, List<String> invoiceFields, List<String> invoiceItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> lineItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        InvoiceCreateRequest localVarPostBody = invoiceCreateRequest;
        String localVarPath = "/invoices";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (invoiceFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "invoice.fields[]", invoiceFields));
        }
        if (invoiceItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "invoice_items.fields[]", invoiceItemsFields));
        }
        if (taxationItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "taxation_items.fields[]", taxationItemsFields));
        }
        if (accountFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "account.fields[]", accountFields));
        }
        if (billToFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "bill_to.fields[]", billToFields));
        }
        if (lineItemFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "line_item.fields[]", lineItemFields));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createInvoiceValidateBeforeCall(InvoiceCreateRequest invoiceCreateRequest, List<String> fields, List<String> invoiceFields, List<String> invoiceItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> lineItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (invoiceCreateRequest == null) {
            throw new ApiException("Missing the required parameter 'invoiceCreateRequest' when calling createInvoice(Async)");
        }
        return this.createInvoiceCall(invoiceCreateRequest, fields, invoiceFields, invoiceItemsFields, taxationItemsFields, accountFields, billToFields, lineItemFields, expand, filter, pageSize, zuoraTrackId, async, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<Invoice> createInvoiceWithHttpInfo(InvoiceCreateRequest invoiceCreateRequest, List<String> fields, List<String> invoiceFields, List<String> invoiceItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> lineItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.createInvoiceValidateBeforeCall(invoiceCreateRequest, fields, invoiceFields, invoiceItemsFields, taxationItemsFields, accountFields, billToFields, lineItemFields, expand, filter, pageSize, zuoraTrackId, async, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<Invoice>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call createInvoiceAsync(InvoiceCreateRequest invoiceCreateRequest, List<String> fields, List<String> invoiceFields, List<String> invoiceItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> lineItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<Invoice> _callback) throws ApiException {
        Call localVarCall = this.createInvoiceValidateBeforeCall(invoiceCreateRequest, fields, invoiceFields, invoiceItemsFields, taxationItemsFields, accountFields, billToFields, lineItemFields, expand, filter, pageSize, zuoraTrackId, async, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<Invoice>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public CreateInvoiceParams createInvoiceParams(InvoiceCreateRequest invoiceCreateRequest) {
        return new CreateInvoiceParams(invoiceCreateRequest);
    }

    public Invoice createInvoice(InvoiceCreateRequest invoiceCreateRequest) throws ApiException {
        CreateInvoiceParams params = new CreateInvoiceParams(invoiceCreateRequest);
        return this.executeCreateInvoiceAPICall(params).getData();
    }

    public Invoice createInvoice(InvoiceCreateRequest invoiceCreateRequest, List<String> expand) throws ApiException {
        CreateInvoiceParams params = new CreateInvoiceParams(invoiceCreateRequest);
        params.expand(expand);
        return this.executeCreateInvoiceAPICall(params).getData();
    }

    public Invoice createInvoice(InvoiceCreateRequest invoiceCreateRequest, List<String> expand, Headers headers) throws ApiException {
        CreateInvoiceParams params = new CreateInvoiceParams(invoiceCreateRequest).expand(expand).headers(headers);
        return this.executeCreateInvoiceAPICall(params).getData();
    }

    public Invoice create(CreateInvoiceParams params) throws ApiException {
        return this.executeCreateInvoiceAPICall(params).getData();
    }

    public ApiResponse<Invoice> createWithHttpInfo(CreateInvoiceParams params) throws ApiException {
        return this.executeCreateInvoiceAPICall(params);
    }

    ApiResponse<Invoice> executeCreateInvoiceAPICall(CreateInvoiceParams params) throws ApiException {
        return this.createInvoiceWithHttpInfo(params.invoiceCreateRequest, params.fields, params.invoiceFields, params.invoiceItemsFields, params.taxationItemsFields, params.accountFields, params.billToFields, params.lineItemFields, params.expand, params.filter, params.pageSize, params.zuoraTrackId, params.async, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    private Call deleteInvoiceCall(String invoiceId, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/invoices/{invoice_id}".replace("{invoice_id}", this.localVarApiClient.escapeString(invoiceId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteInvoiceValidateBeforeCall(String invoiceId, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (invoiceId == null) {
            throw new ApiException("Missing the required parameter 'invoiceId' when calling deleteInvoice(Async)");
        }
        return this.deleteInvoiceCall(invoiceId, zuoraTrackId, async, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<Void> deleteInvoiceWithHttpInfo(String invoiceId, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.deleteInvoiceValidateBeforeCall(invoiceId, zuoraTrackId, async, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call deleteInvoiceAsync(String invoiceId, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteInvoiceValidateBeforeCall(invoiceId, zuoraTrackId, async, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public DeleteInvoiceParams deleteInvoiceParams(String invoiceId) {
        return new DeleteInvoiceParams(invoiceId);
    }

    public void deleteInvoice(String invoiceId) throws ApiException {
        DeleteInvoiceParams params = new DeleteInvoiceParams(invoiceId);
        this.executeDeleteInvoiceAPICall(params);
    }

    public void deleteInvoice(String invoiceId, Headers headers) throws ApiException {
        DeleteInvoiceParams params = new DeleteInvoiceParams(invoiceId).headers(headers);
        this.executeDeleteInvoiceAPICall(params);
    }

    public void delete(DeleteInvoiceParams params) throws ApiException {
        this.executeDeleteInvoiceAPICall(params).getData();
    }

    public ApiResponse<Void> deleteWithHttpInfo(DeleteInvoiceParams params) throws ApiException {
        return this.executeDeleteInvoiceAPICall(params);
    }

    ApiResponse<Void> executeDeleteInvoiceAPICall(DeleteInvoiceParams params) throws ApiException {
        return this.deleteInvoiceWithHttpInfo(params.invoiceId, params.zuoraTrackId, params.async, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    private Call emailInvoiceCall(String invoiceId, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/invoices/{invoice_id}/email".replace("{invoice_id}", this.localVarApiClient.escapeString(invoiceId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call emailInvoiceValidateBeforeCall(String invoiceId, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (invoiceId == null) {
            throw new ApiException("Missing the required parameter 'invoiceId' when calling emailInvoice(Async)");
        }
        return this.emailInvoiceCall(invoiceId, zuoraTrackId, async, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<Void> emailInvoiceWithHttpInfo(String invoiceId, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.emailInvoiceValidateBeforeCall(invoiceId, zuoraTrackId, async, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call emailInvoiceAsync(String invoiceId, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.emailInvoiceValidateBeforeCall(invoiceId, zuoraTrackId, async, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public EmailInvoiceParams emailInvoiceParams(String invoiceId) {
        return new EmailInvoiceParams(invoiceId);
    }

    public void emailInvoice(String invoiceId) throws ApiException {
        EmailInvoiceParams params = new EmailInvoiceParams(invoiceId);
        this.executeEmailInvoiceAPICall(params);
    }

    public void emailInvoice(String invoiceId, Headers headers) throws ApiException {
        EmailInvoiceParams params = new EmailInvoiceParams(invoiceId).headers(headers);
        this.executeEmailInvoiceAPICall(params);
    }

    public void emailInvoice(EmailInvoiceParams params) throws ApiException {
        this.executeEmailInvoiceAPICall(params).getData();
    }

    public ApiResponse<Void> emailInvoiceWithHttpInfo(EmailInvoiceParams params) throws ApiException {
        return this.executeEmailInvoiceAPICall(params);
    }

    ApiResponse<Void> executeEmailInvoiceAPICall(EmailInvoiceParams params) throws ApiException {
        return this.emailInvoiceWithHttpInfo(params.invoiceId, params.zuoraTrackId, params.async, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    private Call getInvoiceCall(String invoiceId, List<String> fields, List<String> invoiceFields, List<String> invoiceItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> lineItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/invoices/{invoice_id}".replace("{invoice_id}", this.localVarApiClient.escapeString(invoiceId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (invoiceFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "invoice.fields[]", invoiceFields));
        }
        if (invoiceItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "invoice_items.fields[]", invoiceItemsFields));
        }
        if (taxationItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "taxation_items.fields[]", taxationItemsFields));
        }
        if (accountFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "account.fields[]", accountFields));
        }
        if (billToFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "bill_to.fields[]", billToFields));
        }
        if (lineItemFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "line_item.fields[]", lineItemFields));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getInvoiceValidateBeforeCall(String invoiceId, List<String> fields, List<String> invoiceFields, List<String> invoiceItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> lineItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (invoiceId == null) {
            throw new ApiException("Missing the required parameter 'invoiceId' when calling getInvoice(Async)");
        }
        return this.getInvoiceCall(invoiceId, fields, invoiceFields, invoiceItemsFields, taxationItemsFields, accountFields, billToFields, lineItemFields, expand, filter, pageSize, zuoraTrackId, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<Invoice> getInvoiceWithHttpInfo(String invoiceId, List<String> fields, List<String> invoiceFields, List<String> invoiceItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> lineItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.getInvoiceValidateBeforeCall(invoiceId, fields, invoiceFields, invoiceItemsFields, taxationItemsFields, accountFields, billToFields, lineItemFields, expand, filter, pageSize, zuoraTrackId, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<Invoice>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call getInvoiceAsync(String invoiceId, List<String> fields, List<String> invoiceFields, List<String> invoiceItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> lineItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<Invoice> _callback) throws ApiException {
        Call localVarCall = this.getInvoiceValidateBeforeCall(invoiceId, fields, invoiceFields, invoiceItemsFields, taxationItemsFields, accountFields, billToFields, lineItemFields, expand, filter, pageSize, zuoraTrackId, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<Invoice>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetInvoiceParams getInvoiceParams(String invoiceId) {
        return new GetInvoiceParams(invoiceId);
    }

    public Invoice getInvoice(String invoiceId) throws ApiException {
        GetInvoiceParams params = new GetInvoiceParams(invoiceId);
        return this.executeGetInvoiceAPICall(params).getData();
    }

    public Invoice getInvoice(String invoiceId, List<String> expand) throws ApiException {
        GetInvoiceParams params = new GetInvoiceParams(invoiceId);
        params.expand(expand);
        return this.executeGetInvoiceAPICall(params).getData();
    }

    public Invoice getInvoice(String invoiceId, List<String> expand, Headers headers) throws ApiException {
        GetInvoiceParams params = new GetInvoiceParams(invoiceId).expand(expand).headers(headers);
        return this.executeGetInvoiceAPICall(params).getData();
    }

    public Invoice get(GetInvoiceParams params) throws ApiException {
        return this.executeGetInvoiceAPICall(params).getData();
    }

    public ApiResponse<Invoice> getWithHttpInfo(GetInvoiceParams params) throws ApiException {
        return this.executeGetInvoiceAPICall(params);
    }

    ApiResponse<Invoice> executeGetInvoiceAPICall(GetInvoiceParams params) throws ApiException {
        return this.getInvoiceWithHttpInfo(params.invoiceId, params.fields, params.invoiceFields, params.invoiceItemsFields, params.taxationItemsFields, params.accountFields, params.billToFields, params.lineItemFields, params.expand, params.filter, params.pageSize, params.zuoraTrackId, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    private Call getInvoiceItemsCall(String cursor, List<String> expand, List<String> filter, List<String> sort, Integer pageSize, List<String> fields, List<String> invoiceItemFields, List<String> taxationItemsFields, List<String> lineItemFields, List<String> invoiceFields, String zuoraTrackId, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/invoice_items";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (cursor != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("cursor", cursor));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (sort != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "sort[]", sort));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (invoiceItemFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "invoice_item.fields[]", invoiceItemFields));
        }
        if (taxationItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "taxation_items.fields[]", taxationItemsFields));
        }
        if (lineItemFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "line_item.fields[]", lineItemFields));
        }
        if (invoiceFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "invoice.fields[]", invoiceFields));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getInvoiceItemsValidateBeforeCall(String cursor, List<String> expand, List<String> filter, List<String> sort, Integer pageSize, List<String> fields, List<String> invoiceItemFields, List<String> taxationItemsFields, List<String> lineItemFields, List<String> invoiceFields, String zuoraTrackId, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        return this.getInvoiceItemsCall(cursor, expand, filter, sort, pageSize, fields, invoiceItemFields, taxationItemsFields, lineItemFields, invoiceFields, zuoraTrackId, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<InvoiceItemListResponse> getInvoiceItemsWithHttpInfo(String cursor, List<String> expand, List<String> filter, List<String> sort, Integer pageSize, List<String> fields, List<String> invoiceItemFields, List<String> taxationItemsFields, List<String> lineItemFields, List<String> invoiceFields, String zuoraTrackId, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.getInvoiceItemsValidateBeforeCall(cursor, expand, filter, sort, pageSize, fields, invoiceItemFields, taxationItemsFields, lineItemFields, invoiceFields, zuoraTrackId, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<InvoiceItemListResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call getInvoiceItemsAsync(String cursor, List<String> expand, List<String> filter, List<String> sort, Integer pageSize, List<String> fields, List<String> invoiceItemFields, List<String> taxationItemsFields, List<String> lineItemFields, List<String> invoiceFields, String zuoraTrackId, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<InvoiceItemListResponse> _callback) throws ApiException {
        Call localVarCall = this.getInvoiceItemsValidateBeforeCall(cursor, expand, filter, sort, pageSize, fields, invoiceItemFields, taxationItemsFields, lineItemFields, invoiceFields, zuoraTrackId, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<InvoiceItemListResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetInvoiceItemsParams getInvoiceItemsParams() {
        return new GetInvoiceItemsParams();
    }

    public InvoiceItemListResponse getInvoiceItems() throws ApiException {
        GetInvoiceItemsParams params = new GetInvoiceItemsParams();
        return this.executeGetInvoiceItemsAPICall(params).getData();
    }

    public InvoiceItemListResponse getInvoiceItems(String cursor, List<String> expand, List<String> filter) throws ApiException {
        GetInvoiceItemsParams params = new GetInvoiceItemsParams();
        params.cursor(cursor);
        params.expand(expand);
        params.filter(filter);
        return this.executeGetInvoiceItemsAPICall(params).getData();
    }

    public InvoiceItemListResponse getInvoiceItems(String cursor, List<String> expand, List<String> filter, Headers headers) throws ApiException {
        GetInvoiceItemsParams params = new GetInvoiceItemsParams().cursor(cursor).expand(expand).filter(filter).headers(headers);
        return this.executeGetInvoiceItemsAPICall(params).getData();
    }

    public InvoiceItemListResponse list(GetInvoiceItemsParams params) throws ApiException {
        return this.executeGetInvoiceItemsAPICall(params).getData();
    }

    public ApiResponse<InvoiceItemListResponse> listWithHttpInfo(GetInvoiceItemsParams params) throws ApiException {
        return this.executeGetInvoiceItemsAPICall(params);
    }

    ApiResponse<InvoiceItemListResponse> executeGetInvoiceItemsAPICall(GetInvoiceItemsParams params) throws ApiException {
        return this.getInvoiceItemsWithHttpInfo(params.cursor, params.expand, params.filter, params.sort, params.pageSize, params.fields, params.invoiceItemFields, params.taxationItemsFields, params.lineItemFields, params.invoiceFields, params.zuoraTrackId, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    private Call getInvoicesCall(String cursor, List<String> expand, List<String> filter, List<String> sort, Integer pageSize, List<String> fields, List<String> invoiceFields, List<String> invoiceItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> lineItemFields, String zuoraTrackId, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/invoices";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (cursor != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("cursor", cursor));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (sort != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "sort[]", sort));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (invoiceFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "invoice.fields[]", invoiceFields));
        }
        if (invoiceItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "invoice_items.fields[]", invoiceItemsFields));
        }
        if (taxationItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "taxation_items.fields[]", taxationItemsFields));
        }
        if (accountFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "account.fields[]", accountFields));
        }
        if (billToFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "bill_to.fields[]", billToFields));
        }
        if (lineItemFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "line_item.fields[]", lineItemFields));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getInvoicesValidateBeforeCall(String cursor, List<String> expand, List<String> filter, List<String> sort, Integer pageSize, List<String> fields, List<String> invoiceFields, List<String> invoiceItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> lineItemFields, String zuoraTrackId, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        return this.getInvoicesCall(cursor, expand, filter, sort, pageSize, fields, invoiceFields, invoiceItemsFields, taxationItemsFields, accountFields, billToFields, lineItemFields, zuoraTrackId, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<InvoiceListResponse> getInvoicesWithHttpInfo(String cursor, List<String> expand, List<String> filter, List<String> sort, Integer pageSize, List<String> fields, List<String> invoiceFields, List<String> invoiceItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> lineItemFields, String zuoraTrackId, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.getInvoicesValidateBeforeCall(cursor, expand, filter, sort, pageSize, fields, invoiceFields, invoiceItemsFields, taxationItemsFields, accountFields, billToFields, lineItemFields, zuoraTrackId, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<InvoiceListResponse>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call getInvoicesAsync(String cursor, List<String> expand, List<String> filter, List<String> sort, Integer pageSize, List<String> fields, List<String> invoiceFields, List<String> invoiceItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> lineItemFields, String zuoraTrackId, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<InvoiceListResponse> _callback) throws ApiException {
        Call localVarCall = this.getInvoicesValidateBeforeCall(cursor, expand, filter, sort, pageSize, fields, invoiceFields, invoiceItemsFields, taxationItemsFields, accountFields, billToFields, lineItemFields, zuoraTrackId, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<InvoiceListResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetInvoicesParams getInvoicesParams() {
        return new GetInvoicesParams();
    }

    public InvoiceListResponse getInvoices() throws ApiException {
        GetInvoicesParams params = new GetInvoicesParams();
        return this.executeGetInvoicesAPICall(params).getData();
    }

    public InvoiceListResponse getInvoices(String cursor, List<String> expand, List<String> filter) throws ApiException {
        GetInvoicesParams params = new GetInvoicesParams();
        params.cursor(cursor);
        params.expand(expand);
        params.filter(filter);
        return this.executeGetInvoicesAPICall(params).getData();
    }

    public InvoiceListResponse getInvoices(String cursor, List<String> expand, List<String> filter, Headers headers) throws ApiException {
        GetInvoicesParams params = new GetInvoicesParams().cursor(cursor).expand(expand).filter(filter).headers(headers);
        return this.executeGetInvoicesAPICall(params).getData();
    }

    public InvoiceListResponse list(GetInvoicesParams params) throws ApiException {
        return this.executeGetInvoicesAPICall(params).getData();
    }

    public ApiResponse<InvoiceListResponse> listWithHttpInfo(GetInvoicesParams params) throws ApiException {
        return this.executeGetInvoicesAPICall(params);
    }

    ApiResponse<InvoiceListResponse> executeGetInvoicesAPICall(GetInvoicesParams params) throws ApiException {
        return this.getInvoicesWithHttpInfo(params.cursor, params.expand, params.filter, params.sort, params.pageSize, params.fields, params.invoiceFields, params.invoiceItemsFields, params.taxationItemsFields, params.accountFields, params.billToFields, params.lineItemFields, params.zuoraTrackId, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    private Call patchInvoiceCall(String invoiceId, InvoicePatchRequest invoicePatchRequest, List<String> fields, List<String> invoiceFields, List<String> invoiceItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> lineItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        InvoicePatchRequest localVarPostBody = invoicePatchRequest;
        String localVarPath = "/invoices/{invoice_id}".replace("{invoice_id}", this.localVarApiClient.escapeString(invoiceId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (invoiceFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "invoice.fields[]", invoiceFields));
        }
        if (invoiceItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "invoice_items.fields[]", invoiceItemsFields));
        }
        if (taxationItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "taxation_items.fields[]", taxationItemsFields));
        }
        if (accountFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "account.fields[]", accountFields));
        }
        if (billToFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "bill_to.fields[]", billToFields));
        }
        if (lineItemFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "line_item.fields[]", lineItemFields));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchInvoiceValidateBeforeCall(String invoiceId, InvoicePatchRequest invoicePatchRequest, List<String> fields, List<String> invoiceFields, List<String> invoiceItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> lineItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (invoiceId == null) {
            throw new ApiException("Missing the required parameter 'invoiceId' when calling patchInvoice(Async)");
        }
        if (invoicePatchRequest == null) {
            throw new ApiException("Missing the required parameter 'invoicePatchRequest' when calling patchInvoice(Async)");
        }
        return this.patchInvoiceCall(invoiceId, invoicePatchRequest, fields, invoiceFields, invoiceItemsFields, taxationItemsFields, accountFields, billToFields, lineItemFields, expand, filter, pageSize, zuoraTrackId, async, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<Invoice> patchInvoiceWithHttpInfo(String invoiceId, InvoicePatchRequest invoicePatchRequest, List<String> fields, List<String> invoiceFields, List<String> invoiceItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> lineItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.patchInvoiceValidateBeforeCall(invoiceId, invoicePatchRequest, fields, invoiceFields, invoiceItemsFields, taxationItemsFields, accountFields, billToFields, lineItemFields, expand, filter, pageSize, zuoraTrackId, async, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<Invoice>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call patchInvoiceAsync(String invoiceId, InvoicePatchRequest invoicePatchRequest, List<String> fields, List<String> invoiceFields, List<String> invoiceItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> lineItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<Invoice> _callback) throws ApiException {
        Call localVarCall = this.patchInvoiceValidateBeforeCall(invoiceId, invoicePatchRequest, fields, invoiceFields, invoiceItemsFields, taxationItemsFields, accountFields, billToFields, lineItemFields, expand, filter, pageSize, zuoraTrackId, async, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<Invoice>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public PatchInvoiceParams patchInvoiceParams(String invoiceId, InvoicePatchRequest invoicePatchRequest) {
        return new PatchInvoiceParams(invoiceId, invoicePatchRequest);
    }

    public Invoice patchInvoice(String invoiceId, InvoicePatchRequest invoicePatchRequest) throws ApiException {
        PatchInvoiceParams params = new PatchInvoiceParams(invoiceId, invoicePatchRequest);
        return this.executePatchInvoiceAPICall(params).getData();
    }

    public Invoice patchInvoice(String invoiceId, InvoicePatchRequest invoicePatchRequest, List<String> expand) throws ApiException {
        PatchInvoiceParams params = new PatchInvoiceParams(invoiceId, invoicePatchRequest);
        params.expand(expand);
        return this.executePatchInvoiceAPICall(params).getData();
    }

    public Invoice patchInvoice(String invoiceId, InvoicePatchRequest invoicePatchRequest, List<String> expand, Headers headers) throws ApiException {
        PatchInvoiceParams params = new PatchInvoiceParams(invoiceId, invoicePatchRequest).expand(expand).headers(headers);
        return this.executePatchInvoiceAPICall(params).getData();
    }

    public Invoice update(PatchInvoiceParams params) throws ApiException {
        return this.executePatchInvoiceAPICall(params).getData();
    }

    public ApiResponse<Invoice> updateWithHttpInfo(PatchInvoiceParams params) throws ApiException {
        return this.executePatchInvoiceAPICall(params);
    }

    ApiResponse<Invoice> executePatchInvoiceAPICall(PatchInvoiceParams params) throws ApiException {
        return this.patchInvoiceWithHttpInfo(params.invoiceId, params.invoicePatchRequest, params.fields, params.invoiceFields, params.invoiceItemsFields, params.taxationItemsFields, params.accountFields, params.billToFields, params.lineItemFields, params.expand, params.filter, params.pageSize, params.zuoraTrackId, params.async, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    private Call payInvoiceCall(String invoiceId, PayInvoiceRequest payInvoiceRequest, List<String> fields, List<String> invoiceFields, List<String> invoiceItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> lineItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        PayInvoiceRequest localVarPostBody = payInvoiceRequest;
        String localVarPath = "/invoices/{invoice_id}/pay".replace("{invoice_id}", this.localVarApiClient.escapeString(invoiceId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (invoiceFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "invoice.fields[]", invoiceFields));
        }
        if (invoiceItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "invoice_items.fields[]", invoiceItemsFields));
        }
        if (taxationItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "taxation_items.fields[]", taxationItemsFields));
        }
        if (accountFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "account.fields[]", accountFields));
        }
        if (billToFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "bill_to.fields[]", billToFields));
        }
        if (lineItemFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "line_item.fields[]", lineItemFields));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call payInvoiceValidateBeforeCall(String invoiceId, PayInvoiceRequest payInvoiceRequest, List<String> fields, List<String> invoiceFields, List<String> invoiceItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> lineItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (invoiceId == null) {
            throw new ApiException("Missing the required parameter 'invoiceId' when calling payInvoice(Async)");
        }
        if (payInvoiceRequest == null) {
            throw new ApiException("Missing the required parameter 'payInvoiceRequest' when calling payInvoice(Async)");
        }
        return this.payInvoiceCall(invoiceId, payInvoiceRequest, fields, invoiceFields, invoiceItemsFields, taxationItemsFields, accountFields, billToFields, lineItemFields, expand, filter, pageSize, zuoraTrackId, async, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<Invoice> payInvoiceWithHttpInfo(String invoiceId, PayInvoiceRequest payInvoiceRequest, List<String> fields, List<String> invoiceFields, List<String> invoiceItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> lineItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.payInvoiceValidateBeforeCall(invoiceId, payInvoiceRequest, fields, invoiceFields, invoiceItemsFields, taxationItemsFields, accountFields, billToFields, lineItemFields, expand, filter, pageSize, zuoraTrackId, async, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<Invoice>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call payInvoiceAsync(String invoiceId, PayInvoiceRequest payInvoiceRequest, List<String> fields, List<String> invoiceFields, List<String> invoiceItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> lineItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<Invoice> _callback) throws ApiException {
        Call localVarCall = this.payInvoiceValidateBeforeCall(invoiceId, payInvoiceRequest, fields, invoiceFields, invoiceItemsFields, taxationItemsFields, accountFields, billToFields, lineItemFields, expand, filter, pageSize, zuoraTrackId, async, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<Invoice>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public PayInvoiceParams payInvoiceParams(String invoiceId, PayInvoiceRequest payInvoiceRequest) {
        return new PayInvoiceParams(invoiceId, payInvoiceRequest);
    }

    public Invoice payInvoice(String invoiceId, PayInvoiceRequest payInvoiceRequest) throws ApiException {
        PayInvoiceParams params = new PayInvoiceParams(invoiceId, payInvoiceRequest);
        return this.executePayInvoiceAPICall(params).getData();
    }

    public Invoice payInvoice(String invoiceId, PayInvoiceRequest payInvoiceRequest, List<String> expand) throws ApiException {
        PayInvoiceParams params = new PayInvoiceParams(invoiceId, payInvoiceRequest);
        params.expand(expand);
        return this.executePayInvoiceAPICall(params).getData();
    }

    public Invoice payInvoice(String invoiceId, PayInvoiceRequest payInvoiceRequest, List<String> expand, Headers headers) throws ApiException {
        PayInvoiceParams params = new PayInvoiceParams(invoiceId, payInvoiceRequest).expand(expand).headers(headers);
        return this.executePayInvoiceAPICall(params).getData();
    }

    public Invoice pay(PayInvoiceParams params) throws ApiException {
        return this.executePayInvoiceAPICall(params).getData();
    }

    public ApiResponse<Invoice> payWithHttpInfo(PayInvoiceParams params) throws ApiException {
        return this.executePayInvoiceAPICall(params);
    }

    ApiResponse<Invoice> executePayInvoiceAPICall(PayInvoiceParams params) throws ApiException {
        return this.payInvoiceWithHttpInfo(params.invoiceId, params.payInvoiceRequest, params.fields, params.invoiceFields, params.invoiceItemsFields, params.taxationItemsFields, params.accountFields, params.billToFields, params.lineItemFields, params.expand, params.filter, params.pageSize, params.zuoraTrackId, params.async, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    private Call postInvoiceCall(String invoiceId, List<String> fields, List<String> invoiceFields, List<String> invoiceItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> lineItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/invoices/{invoice_id}/post".replace("{invoice_id}", this.localVarApiClient.escapeString(invoiceId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (invoiceFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "invoice.fields[]", invoiceFields));
        }
        if (invoiceItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "invoice_items.fields[]", invoiceItemsFields));
        }
        if (taxationItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "taxation_items.fields[]", taxationItemsFields));
        }
        if (accountFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "account.fields[]", accountFields));
        }
        if (billToFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "bill_to.fields[]", billToFields));
        }
        if (lineItemFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "line_item.fields[]", lineItemFields));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call postInvoiceValidateBeforeCall(String invoiceId, List<String> fields, List<String> invoiceFields, List<String> invoiceItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> lineItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (invoiceId == null) {
            throw new ApiException("Missing the required parameter 'invoiceId' when calling postInvoice(Async)");
        }
        return this.postInvoiceCall(invoiceId, fields, invoiceFields, invoiceItemsFields, taxationItemsFields, accountFields, billToFields, lineItemFields, expand, filter, pageSize, zuoraTrackId, async, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<Invoice> postInvoiceWithHttpInfo(String invoiceId, List<String> fields, List<String> invoiceFields, List<String> invoiceItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> lineItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.postInvoiceValidateBeforeCall(invoiceId, fields, invoiceFields, invoiceItemsFields, taxationItemsFields, accountFields, billToFields, lineItemFields, expand, filter, pageSize, zuoraTrackId, async, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<Invoice>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call postInvoiceAsync(String invoiceId, List<String> fields, List<String> invoiceFields, List<String> invoiceItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> lineItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<Invoice> _callback) throws ApiException {
        Call localVarCall = this.postInvoiceValidateBeforeCall(invoiceId, fields, invoiceFields, invoiceItemsFields, taxationItemsFields, accountFields, billToFields, lineItemFields, expand, filter, pageSize, zuoraTrackId, async, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<Invoice>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public PostInvoiceParams postInvoiceParams(String invoiceId) {
        return new PostInvoiceParams(invoiceId);
    }

    public Invoice postInvoice(String invoiceId) throws ApiException {
        PostInvoiceParams params = new PostInvoiceParams(invoiceId);
        return this.executePostInvoiceAPICall(params).getData();
    }

    public Invoice postInvoice(String invoiceId, List<String> expand) throws ApiException {
        PostInvoiceParams params = new PostInvoiceParams(invoiceId);
        params.expand(expand);
        return this.executePostInvoiceAPICall(params).getData();
    }

    public Invoice postInvoice(String invoiceId, List<String> expand, Headers headers) throws ApiException {
        PostInvoiceParams params = new PostInvoiceParams(invoiceId).expand(expand).headers(headers);
        return this.executePostInvoiceAPICall(params).getData();
    }

    public Invoice post(PostInvoiceParams params) throws ApiException {
        return this.executePostInvoiceAPICall(params).getData();
    }

    public ApiResponse<Invoice> postWithHttpInfo(PostInvoiceParams params) throws ApiException {
        return this.executePostInvoiceAPICall(params);
    }

    ApiResponse<Invoice> executePostInvoiceAPICall(PostInvoiceParams params) throws ApiException {
        return this.postInvoiceWithHttpInfo(params.invoiceId, params.fields, params.invoiceFields, params.invoiceItemsFields, params.taxationItemsFields, params.accountFields, params.billToFields, params.lineItemFields, params.expand, params.filter, params.pageSize, params.zuoraTrackId, params.async, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    private Call reverseInvoiceCall(String invoiceId, InvoiceReverseRequest invoiceReverseRequest, List<String> fields, List<String> invoiceFields, List<String> invoiceItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> lineItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        InvoiceReverseRequest localVarPostBody = invoiceReverseRequest;
        String localVarPath = "/invoices/{invoice_id}/reverse".replace("{invoice_id}", this.localVarApiClient.escapeString(invoiceId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (invoiceFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "invoice.fields[]", invoiceFields));
        }
        if (invoiceItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "invoice_items.fields[]", invoiceItemsFields));
        }
        if (taxationItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "taxation_items.fields[]", taxationItemsFields));
        }
        if (accountFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "account.fields[]", accountFields));
        }
        if (billToFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "bill_to.fields[]", billToFields));
        }
        if (lineItemFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "line_item.fields[]", lineItemFields));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call reverseInvoiceValidateBeforeCall(String invoiceId, InvoiceReverseRequest invoiceReverseRequest, List<String> fields, List<String> invoiceFields, List<String> invoiceItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> lineItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (invoiceId == null) {
            throw new ApiException("Missing the required parameter 'invoiceId' when calling reverseInvoice(Async)");
        }
        if (invoiceReverseRequest == null) {
            throw new ApiException("Missing the required parameter 'invoiceReverseRequest' when calling reverseInvoice(Async)");
        }
        return this.reverseInvoiceCall(invoiceId, invoiceReverseRequest, fields, invoiceFields, invoiceItemsFields, taxationItemsFields, accountFields, billToFields, lineItemFields, expand, filter, pageSize, zuoraTrackId, async, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<Invoice> reverseInvoiceWithHttpInfo(String invoiceId, InvoiceReverseRequest invoiceReverseRequest, List<String> fields, List<String> invoiceFields, List<String> invoiceItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> lineItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.reverseInvoiceValidateBeforeCall(invoiceId, invoiceReverseRequest, fields, invoiceFields, invoiceItemsFields, taxationItemsFields, accountFields, billToFields, lineItemFields, expand, filter, pageSize, zuoraTrackId, async, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<Invoice>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call reverseInvoiceAsync(String invoiceId, InvoiceReverseRequest invoiceReverseRequest, List<String> fields, List<String> invoiceFields, List<String> invoiceItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> lineItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<Invoice> _callback) throws ApiException {
        Call localVarCall = this.reverseInvoiceValidateBeforeCall(invoiceId, invoiceReverseRequest, fields, invoiceFields, invoiceItemsFields, taxationItemsFields, accountFields, billToFields, lineItemFields, expand, filter, pageSize, zuoraTrackId, async, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<Invoice>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public ReverseInvoiceParams reverseInvoiceParams(String invoiceId, InvoiceReverseRequest invoiceReverseRequest) {
        return new ReverseInvoiceParams(invoiceId, invoiceReverseRequest);
    }

    public Invoice reverseInvoice(String invoiceId, InvoiceReverseRequest invoiceReverseRequest) throws ApiException {
        ReverseInvoiceParams params = new ReverseInvoiceParams(invoiceId, invoiceReverseRequest);
        return this.executeReverseInvoiceAPICall(params).getData();
    }

    public Invoice reverseInvoice(String invoiceId, InvoiceReverseRequest invoiceReverseRequest, List<String> expand) throws ApiException {
        ReverseInvoiceParams params = new ReverseInvoiceParams(invoiceId, invoiceReverseRequest);
        params.expand(expand);
        return this.executeReverseInvoiceAPICall(params).getData();
    }

    public Invoice reverseInvoice(String invoiceId, InvoiceReverseRequest invoiceReverseRequest, List<String> expand, Headers headers) throws ApiException {
        ReverseInvoiceParams params = new ReverseInvoiceParams(invoiceId, invoiceReverseRequest).expand(expand).headers(headers);
        return this.executeReverseInvoiceAPICall(params).getData();
    }

    public Invoice reverse(ReverseInvoiceParams params) throws ApiException {
        return this.executeReverseInvoiceAPICall(params).getData();
    }

    public ApiResponse<Invoice> reverseWithHttpInfo(ReverseInvoiceParams params) throws ApiException {
        return this.executeReverseInvoiceAPICall(params);
    }

    ApiResponse<Invoice> executeReverseInvoiceAPICall(ReverseInvoiceParams params) throws ApiException {
        return this.reverseInvoiceWithHttpInfo(params.invoiceId, params.invoiceReverseRequest, params.fields, params.invoiceFields, params.invoiceItemsFields, params.taxationItemsFields, params.accountFields, params.billToFields, params.lineItemFields, params.expand, params.filter, params.pageSize, params.zuoraTrackId, params.async, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    private Call unpostInvoiceCall(String invoiceId, List<String> fields, List<String> invoiceFields, List<String> invoiceItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> lineItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/invoices/{invoice_id}/unpost".replace("{invoice_id}", this.localVarApiClient.escapeString(invoiceId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (invoiceFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "invoice.fields[]", invoiceFields));
        }
        if (invoiceItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "invoice_items.fields[]", invoiceItemsFields));
        }
        if (taxationItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "taxation_items.fields[]", taxationItemsFields));
        }
        if (accountFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "account.fields[]", accountFields));
        }
        if (billToFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "bill_to.fields[]", billToFields));
        }
        if (lineItemFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "line_item.fields[]", lineItemFields));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call unpostInvoiceValidateBeforeCall(String invoiceId, List<String> fields, List<String> invoiceFields, List<String> invoiceItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> lineItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (invoiceId == null) {
            throw new ApiException("Missing the required parameter 'invoiceId' when calling unpostInvoice(Async)");
        }
        return this.unpostInvoiceCall(invoiceId, fields, invoiceFields, invoiceItemsFields, taxationItemsFields, accountFields, billToFields, lineItemFields, expand, filter, pageSize, zuoraTrackId, async, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<Invoice> unpostInvoiceWithHttpInfo(String invoiceId, List<String> fields, List<String> invoiceFields, List<String> invoiceItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> lineItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.unpostInvoiceValidateBeforeCall(invoiceId, fields, invoiceFields, invoiceItemsFields, taxationItemsFields, accountFields, billToFields, lineItemFields, expand, filter, pageSize, zuoraTrackId, async, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<Invoice>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call unpostInvoiceAsync(String invoiceId, List<String> fields, List<String> invoiceFields, List<String> invoiceItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> lineItemFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<Invoice> _callback) throws ApiException {
        Call localVarCall = this.unpostInvoiceValidateBeforeCall(invoiceId, fields, invoiceFields, invoiceItemsFields, taxationItemsFields, accountFields, billToFields, lineItemFields, expand, filter, pageSize, zuoraTrackId, async, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<Invoice>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public UnpostInvoiceParams unpostInvoiceParams(String invoiceId) {
        return new UnpostInvoiceParams(invoiceId);
    }

    public Invoice unpostInvoice(String invoiceId) throws ApiException {
        UnpostInvoiceParams params = new UnpostInvoiceParams(invoiceId);
        return this.executeUnpostInvoiceAPICall(params).getData();
    }

    public Invoice unpostInvoice(String invoiceId, List<String> expand) throws ApiException {
        UnpostInvoiceParams params = new UnpostInvoiceParams(invoiceId);
        params.expand(expand);
        return this.executeUnpostInvoiceAPICall(params).getData();
    }

    public Invoice unpostInvoice(String invoiceId, List<String> expand, Headers headers) throws ApiException {
        UnpostInvoiceParams params = new UnpostInvoiceParams(invoiceId).expand(expand).headers(headers);
        return this.executeUnpostInvoiceAPICall(params).getData();
    }

    public Invoice unpost(UnpostInvoiceParams params) throws ApiException {
        return this.executeUnpostInvoiceAPICall(params).getData();
    }

    public ApiResponse<Invoice> unpostWithHttpInfo(UnpostInvoiceParams params) throws ApiException {
        return this.executeUnpostInvoiceAPICall(params);
    }

    ApiResponse<Invoice> executeUnpostInvoiceAPICall(UnpostInvoiceParams params) throws ApiException {
        return this.unpostInvoiceWithHttpInfo(params.invoiceId, params.fields, params.invoiceFields, params.invoiceItemsFields, params.taxationItemsFields, params.accountFields, params.billToFields, params.lineItemFields, params.expand, params.filter, params.pageSize, params.zuoraTrackId, params.async, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    private Call writeOffInvoiceCall(String invoiceId, WriteOffRequest writeOffRequest, List<String> fields, List<String> creditMemoFields, List<String> appliedToFields, List<String> creditMemoItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        WriteOffRequest localVarPostBody = writeOffRequest;
        String localVarPath = "/invoices/{invoice_id}/write-off".replace("{invoice_id}", this.localVarApiClient.escapeString(invoiceId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (creditMemoFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "credit_memo.fields[]", creditMemoFields));
        }
        if (appliedToFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "applied_to.fields[]", appliedToFields));
        }
        if (creditMemoItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "credit_memo_items.fields[]", creditMemoItemsFields));
        }
        if (taxationItemsFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "taxation_items.fields[]", taxationItemsFields));
        }
        if (accountFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "account.fields[]", accountFields));
        }
        if (billToFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "bill_to.fields[]", billToFields));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraWorkingOrg != null) {
            localVarHeaderParams.put("zuora-working-org", this.localVarApiClient.parameterToString(zuoraWorkingOrg));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call writeOffInvoiceValidateBeforeCall(String invoiceId, WriteOffRequest writeOffRequest, List<String> fields, List<String> creditMemoFields, List<String> appliedToFields, List<String> creditMemoItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (invoiceId == null) {
            throw new ApiException("Missing the required parameter 'invoiceId' when calling writeOffInvoice(Async)");
        }
        if (writeOffRequest == null) {
            throw new ApiException("Missing the required parameter 'writeOffRequest' when calling writeOffInvoice(Async)");
        }
        return this.writeOffInvoiceCall(invoiceId, writeOffRequest, fields, creditMemoFields, appliedToFields, creditMemoItemsFields, taxationItemsFields, accountFields, billToFields, expand, filter, pageSize, zuoraTrackId, async, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
    }

    private ApiResponse<CreditMemo> writeOffInvoiceWithHttpInfo(String invoiceId, WriteOffRequest writeOffRequest, List<String> fields, List<String> creditMemoFields, List<String> appliedToFields, List<String> creditMemoItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.writeOffInvoiceValidateBeforeCall(invoiceId, writeOffRequest, fields, creditMemoFields, appliedToFields, creditMemoItemsFields, taxationItemsFields, accountFields, billToFields, expand, filter, pageSize, zuoraTrackId, async, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<CreditMemo>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call writeOffInvoiceAsync(String invoiceId, WriteOffRequest writeOffRequest, List<String> fields, List<String> creditMemoFields, List<String> appliedToFields, List<String> creditMemoItemsFields, List<String> taxationItemsFields, List<String> accountFields, List<String> billToFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraWorkingOrg, String zuoraOrgIds, ApiCallback<CreditMemo> _callback) throws ApiException {
        Call localVarCall = this.writeOffInvoiceValidateBeforeCall(invoiceId, writeOffRequest, fields, creditMemoFields, appliedToFields, creditMemoItemsFields, taxationItemsFields, accountFields, billToFields, expand, filter, pageSize, zuoraTrackId, async, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraWorkingOrg, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<CreditMemo>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public WriteOffInvoiceParams writeOffInvoiceParams(String invoiceId, WriteOffRequest writeOffRequest) {
        return new WriteOffInvoiceParams(invoiceId, writeOffRequest);
    }

    public CreditMemo writeOffInvoice(String invoiceId, WriteOffRequest writeOffRequest) throws ApiException {
        WriteOffInvoiceParams params = new WriteOffInvoiceParams(invoiceId, writeOffRequest);
        return this.executeWriteOffInvoiceAPICall(params).getData();
    }

    public CreditMemo writeOffInvoice(String invoiceId, WriteOffRequest writeOffRequest, List<String> expand) throws ApiException {
        WriteOffInvoiceParams params = new WriteOffInvoiceParams(invoiceId, writeOffRequest);
        params.expand(expand);
        return this.executeWriteOffInvoiceAPICall(params).getData();
    }

    public CreditMemo writeOffInvoice(String invoiceId, WriteOffRequest writeOffRequest, List<String> expand, Headers headers) throws ApiException {
        WriteOffInvoiceParams params = new WriteOffInvoiceParams(invoiceId, writeOffRequest).expand(expand).headers(headers);
        return this.executeWriteOffInvoiceAPICall(params).getData();
    }

    public CreditMemo writeOffInvoice(WriteOffInvoiceParams params) throws ApiException {
        return this.executeWriteOffInvoiceAPICall(params).getData();
    }

    public ApiResponse<CreditMemo> writeOffInvoiceWithHttpInfo(WriteOffInvoiceParams params) throws ApiException {
        return this.executeWriteOffInvoiceAPICall(params);
    }

    ApiResponse<CreditMemo> executeWriteOffInvoiceAPICall(WriteOffInvoiceParams params) throws ApiException {
        return this.writeOffInvoiceWithHttpInfo(params.invoiceId, params.writeOffRequest, params.fields, params.creditMemoFields, params.appliedToFields, params.creditMemoItemsFields, params.taxationItemsFields, params.accountFields, params.billToFields, params.expand, params.filter, params.pageSize, params.zuoraTrackId, params.async, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraWorkingOrg, params.zuoraOrgIds);
    }

    public static class WriteOffInvoiceParams {
        private final String invoiceId;
        private final WriteOffRequest writeOffRequest;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private List<String> fields;
        private List<String> creditMemoFields;
        private List<String> appliedToFields;
        private List<String> creditMemoItemsFields;
        private List<String> taxationItemsFields;
        private List<String> accountFields;
        private List<String> billToFields;
        private List<String> expand;
        private List<String> filter;
        private Integer pageSize;
        private String zuoraTrackId;
        private Boolean async;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public WriteOffInvoiceParams(String invoiceId, WriteOffRequest writeOffRequest) {
            this.invoiceId = invoiceId;
            this.writeOffRequest = writeOffRequest;
        }

        public WriteOffInvoiceParams getByIdQueryParams(GetByIdQueryParams getByIdQueryParams) {
            this.getByIdQueryParams = getByIdQueryParams;
            if (this.expand != null) {
                this.expand = getByIdQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = getByIdQueryParams.getFilter();
            }
            if (this.pageSize != null) {
                this.pageSize = getByIdQueryParams.getPageSize();
            }
            return this;
        }

        public WriteOffInvoiceParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public WriteOffInvoiceParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public WriteOffInvoiceParams creditMemoFields(List<String> creditMemoFields) {
            this.creditMemoFields = creditMemoFields;
            return this;
        }

        public WriteOffInvoiceParams appliedToFields(List<String> appliedToFields) {
            this.appliedToFields = appliedToFields;
            return this;
        }

        public WriteOffInvoiceParams creditMemoItemsFields(List<String> creditMemoItemsFields) {
            this.creditMemoItemsFields = creditMemoItemsFields;
            return this;
        }

        public WriteOffInvoiceParams taxationItemsFields(List<String> taxationItemsFields) {
            this.taxationItemsFields = taxationItemsFields;
            return this;
        }

        public WriteOffInvoiceParams accountFields(List<String> accountFields) {
            this.accountFields = accountFields;
            return this;
        }

        public WriteOffInvoiceParams billToFields(List<String> billToFields) {
            this.billToFields = billToFields;
            return this;
        }

        public WriteOffInvoiceParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public WriteOffInvoiceParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public WriteOffInvoiceParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }
    }

    public static class UnpostInvoiceParams {
        private final String invoiceId;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private List<String> fields;
        private List<String> invoiceFields;
        private List<String> invoiceItemsFields;
        private List<String> taxationItemsFields;
        private List<String> accountFields;
        private List<String> billToFields;
        private List<String> lineItemFields;
        private List<String> expand;
        private List<String> filter;
        private Integer pageSize;
        private String zuoraTrackId;
        private Boolean async;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public UnpostInvoiceParams(String invoiceId) {
            this.invoiceId = invoiceId;
        }

        public UnpostInvoiceParams getByIdQueryParams(GetByIdQueryParams getByIdQueryParams) {
            this.getByIdQueryParams = getByIdQueryParams;
            if (this.expand != null) {
                this.expand = getByIdQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = getByIdQueryParams.getFilter();
            }
            if (this.pageSize != null) {
                this.pageSize = getByIdQueryParams.getPageSize();
            }
            return this;
        }

        public UnpostInvoiceParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public UnpostInvoiceParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public UnpostInvoiceParams invoiceFields(List<String> invoiceFields) {
            this.invoiceFields = invoiceFields;
            return this;
        }

        public UnpostInvoiceParams invoiceItemsFields(List<String> invoiceItemsFields) {
            this.invoiceItemsFields = invoiceItemsFields;
            return this;
        }

        public UnpostInvoiceParams taxationItemsFields(List<String> taxationItemsFields) {
            this.taxationItemsFields = taxationItemsFields;
            return this;
        }

        public UnpostInvoiceParams accountFields(List<String> accountFields) {
            this.accountFields = accountFields;
            return this;
        }

        public UnpostInvoiceParams billToFields(List<String> billToFields) {
            this.billToFields = billToFields;
            return this;
        }

        public UnpostInvoiceParams lineItemFields(List<String> lineItemFields) {
            this.lineItemFields = lineItemFields;
            return this;
        }

        public UnpostInvoiceParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public UnpostInvoiceParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public UnpostInvoiceParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }
    }

    public static class ReverseInvoiceParams {
        private final String invoiceId;
        private final InvoiceReverseRequest invoiceReverseRequest;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private List<String> fields;
        private List<String> invoiceFields;
        private List<String> invoiceItemsFields;
        private List<String> taxationItemsFields;
        private List<String> accountFields;
        private List<String> billToFields;
        private List<String> lineItemFields;
        private List<String> expand;
        private List<String> filter;
        private Integer pageSize;
        private String zuoraTrackId;
        private Boolean async;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public ReverseInvoiceParams(String invoiceId, InvoiceReverseRequest invoiceReverseRequest) {
            this.invoiceId = invoiceId;
            this.invoiceReverseRequest = invoiceReverseRequest;
        }

        public ReverseInvoiceParams getByIdQueryParams(GetByIdQueryParams getByIdQueryParams) {
            this.getByIdQueryParams = getByIdQueryParams;
            if (this.expand != null) {
                this.expand = getByIdQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = getByIdQueryParams.getFilter();
            }
            if (this.pageSize != null) {
                this.pageSize = getByIdQueryParams.getPageSize();
            }
            return this;
        }

        public ReverseInvoiceParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public ReverseInvoiceParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public ReverseInvoiceParams invoiceFields(List<String> invoiceFields) {
            this.invoiceFields = invoiceFields;
            return this;
        }

        public ReverseInvoiceParams invoiceItemsFields(List<String> invoiceItemsFields) {
            this.invoiceItemsFields = invoiceItemsFields;
            return this;
        }

        public ReverseInvoiceParams taxationItemsFields(List<String> taxationItemsFields) {
            this.taxationItemsFields = taxationItemsFields;
            return this;
        }

        public ReverseInvoiceParams accountFields(List<String> accountFields) {
            this.accountFields = accountFields;
            return this;
        }

        public ReverseInvoiceParams billToFields(List<String> billToFields) {
            this.billToFields = billToFields;
            return this;
        }

        public ReverseInvoiceParams lineItemFields(List<String> lineItemFields) {
            this.lineItemFields = lineItemFields;
            return this;
        }

        public ReverseInvoiceParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public ReverseInvoiceParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public ReverseInvoiceParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }
    }

    public static class PostInvoiceParams {
        private final String invoiceId;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private List<String> fields;
        private List<String> invoiceFields;
        private List<String> invoiceItemsFields;
        private List<String> taxationItemsFields;
        private List<String> accountFields;
        private List<String> billToFields;
        private List<String> lineItemFields;
        private List<String> expand;
        private List<String> filter;
        private Integer pageSize;
        private String zuoraTrackId;
        private Boolean async;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public PostInvoiceParams(String invoiceId) {
            this.invoiceId = invoiceId;
        }

        public PostInvoiceParams getByIdQueryParams(GetByIdQueryParams getByIdQueryParams) {
            this.getByIdQueryParams = getByIdQueryParams;
            if (this.expand != null) {
                this.expand = getByIdQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = getByIdQueryParams.getFilter();
            }
            if (this.pageSize != null) {
                this.pageSize = getByIdQueryParams.getPageSize();
            }
            return this;
        }

        public PostInvoiceParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public PostInvoiceParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public PostInvoiceParams invoiceFields(List<String> invoiceFields) {
            this.invoiceFields = invoiceFields;
            return this;
        }

        public PostInvoiceParams invoiceItemsFields(List<String> invoiceItemsFields) {
            this.invoiceItemsFields = invoiceItemsFields;
            return this;
        }

        public PostInvoiceParams taxationItemsFields(List<String> taxationItemsFields) {
            this.taxationItemsFields = taxationItemsFields;
            return this;
        }

        public PostInvoiceParams accountFields(List<String> accountFields) {
            this.accountFields = accountFields;
            return this;
        }

        public PostInvoiceParams billToFields(List<String> billToFields) {
            this.billToFields = billToFields;
            return this;
        }

        public PostInvoiceParams lineItemFields(List<String> lineItemFields) {
            this.lineItemFields = lineItemFields;
            return this;
        }

        public PostInvoiceParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public PostInvoiceParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public PostInvoiceParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }
    }

    public static class PayInvoiceParams {
        private final String invoiceId;
        private final PayInvoiceRequest payInvoiceRequest;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private List<String> fields;
        private List<String> invoiceFields;
        private List<String> invoiceItemsFields;
        private List<String> taxationItemsFields;
        private List<String> accountFields;
        private List<String> billToFields;
        private List<String> lineItemFields;
        private List<String> expand;
        private List<String> filter;
        private Integer pageSize;
        private String zuoraTrackId;
        private Boolean async;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public PayInvoiceParams(String invoiceId, PayInvoiceRequest payInvoiceRequest) {
            this.invoiceId = invoiceId;
            this.payInvoiceRequest = payInvoiceRequest;
        }

        public PayInvoiceParams getByIdQueryParams(GetByIdQueryParams getByIdQueryParams) {
            this.getByIdQueryParams = getByIdQueryParams;
            if (this.expand != null) {
                this.expand = getByIdQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = getByIdQueryParams.getFilter();
            }
            if (this.pageSize != null) {
                this.pageSize = getByIdQueryParams.getPageSize();
            }
            return this;
        }

        public PayInvoiceParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public PayInvoiceParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public PayInvoiceParams invoiceFields(List<String> invoiceFields) {
            this.invoiceFields = invoiceFields;
            return this;
        }

        public PayInvoiceParams invoiceItemsFields(List<String> invoiceItemsFields) {
            this.invoiceItemsFields = invoiceItemsFields;
            return this;
        }

        public PayInvoiceParams taxationItemsFields(List<String> taxationItemsFields) {
            this.taxationItemsFields = taxationItemsFields;
            return this;
        }

        public PayInvoiceParams accountFields(List<String> accountFields) {
            this.accountFields = accountFields;
            return this;
        }

        public PayInvoiceParams billToFields(List<String> billToFields) {
            this.billToFields = billToFields;
            return this;
        }

        public PayInvoiceParams lineItemFields(List<String> lineItemFields) {
            this.lineItemFields = lineItemFields;
            return this;
        }

        public PayInvoiceParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public PayInvoiceParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public PayInvoiceParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }
    }

    public static class PatchInvoiceParams {
        private final String invoiceId;
        private final InvoicePatchRequest invoicePatchRequest;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private List<String> fields;
        private List<String> invoiceFields;
        private List<String> invoiceItemsFields;
        private List<String> taxationItemsFields;
        private List<String> accountFields;
        private List<String> billToFields;
        private List<String> lineItemFields;
        private List<String> expand;
        private List<String> filter;
        private Integer pageSize;
        private String zuoraTrackId;
        private Boolean async;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public PatchInvoiceParams(String invoiceId, InvoicePatchRequest invoicePatchRequest) {
            this.invoiceId = invoiceId;
            this.invoicePatchRequest = invoicePatchRequest;
        }

        public PatchInvoiceParams getByIdQueryParams(GetByIdQueryParams getByIdQueryParams) {
            this.getByIdQueryParams = getByIdQueryParams;
            if (this.expand != null) {
                this.expand = getByIdQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = getByIdQueryParams.getFilter();
            }
            if (this.pageSize != null) {
                this.pageSize = getByIdQueryParams.getPageSize();
            }
            return this;
        }

        public PatchInvoiceParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public PatchInvoiceParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public PatchInvoiceParams invoiceFields(List<String> invoiceFields) {
            this.invoiceFields = invoiceFields;
            return this;
        }

        public PatchInvoiceParams invoiceItemsFields(List<String> invoiceItemsFields) {
            this.invoiceItemsFields = invoiceItemsFields;
            return this;
        }

        public PatchInvoiceParams taxationItemsFields(List<String> taxationItemsFields) {
            this.taxationItemsFields = taxationItemsFields;
            return this;
        }

        public PatchInvoiceParams accountFields(List<String> accountFields) {
            this.accountFields = accountFields;
            return this;
        }

        public PatchInvoiceParams billToFields(List<String> billToFields) {
            this.billToFields = billToFields;
            return this;
        }

        public PatchInvoiceParams lineItemFields(List<String> lineItemFields) {
            this.lineItemFields = lineItemFields;
            return this;
        }

        public PatchInvoiceParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public PatchInvoiceParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public PatchInvoiceParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }
    }

    public static class GetInvoicesParams {
        private Headers headers;
        private ListQueryParams listQueryParams;
        private String cursor;
        private List<String> expand;
        private List<String> filter;
        private List<String> sort;
        private Integer pageSize;
        private List<String> fields;
        private List<String> invoiceFields;
        private List<String> invoiceItemsFields;
        private List<String> taxationItemsFields;
        private List<String> accountFields;
        private List<String> billToFields;
        private List<String> lineItemFields;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public GetInvoicesParams listQueryParams(ListQueryParams listQueryParams) {
            this.listQueryParams = listQueryParams;
            if (this.cursor != null) {
                this.cursor = listQueryParams.getCursor();
            }
            if (this.expand != null) {
                this.expand = listQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = listQueryParams.getFilter();
            }
            if (this.sort != null) {
                this.sort = listQueryParams.getSort();
            }
            if (this.pageSize != null) {
                this.pageSize = listQueryParams.getPageSize();
            }
            return this;
        }

        public GetInvoicesParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public GetInvoicesParams cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public GetInvoicesParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public GetInvoicesParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public GetInvoicesParams sort(List<String> sort) {
            this.sort = sort;
            return this;
        }

        public GetInvoicesParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public GetInvoicesParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public GetInvoicesParams invoiceFields(List<String> invoiceFields) {
            this.invoiceFields = invoiceFields;
            return this;
        }

        public GetInvoicesParams invoiceItemsFields(List<String> invoiceItemsFields) {
            this.invoiceItemsFields = invoiceItemsFields;
            return this;
        }

        public GetInvoicesParams taxationItemsFields(List<String> taxationItemsFields) {
            this.taxationItemsFields = taxationItemsFields;
            return this;
        }

        public GetInvoicesParams accountFields(List<String> accountFields) {
            this.accountFields = accountFields;
            return this;
        }

        public GetInvoicesParams billToFields(List<String> billToFields) {
            this.billToFields = billToFields;
            return this;
        }

        public GetInvoicesParams lineItemFields(List<String> lineItemFields) {
            this.lineItemFields = lineItemFields;
            return this;
        }
    }

    public static class GetInvoiceItemsParams {
        private Headers headers;
        private ListQueryParams listQueryParams;
        private String cursor;
        private List<String> expand;
        private List<String> filter;
        private List<String> sort;
        private Integer pageSize;
        private List<String> fields;
        private List<String> invoiceItemFields;
        private List<String> taxationItemsFields;
        private List<String> lineItemFields;
        private List<String> invoiceFields;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public GetInvoiceItemsParams listQueryParams(ListQueryParams listQueryParams) {
            this.listQueryParams = listQueryParams;
            if (this.cursor != null) {
                this.cursor = listQueryParams.getCursor();
            }
            if (this.expand != null) {
                this.expand = listQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = listQueryParams.getFilter();
            }
            if (this.sort != null) {
                this.sort = listQueryParams.getSort();
            }
            if (this.pageSize != null) {
                this.pageSize = listQueryParams.getPageSize();
            }
            return this;
        }

        public GetInvoiceItemsParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public GetInvoiceItemsParams cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public GetInvoiceItemsParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public GetInvoiceItemsParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public GetInvoiceItemsParams sort(List<String> sort) {
            this.sort = sort;
            return this;
        }

        public GetInvoiceItemsParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public GetInvoiceItemsParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public GetInvoiceItemsParams invoiceItemFields(List<String> invoiceItemFields) {
            this.invoiceItemFields = invoiceItemFields;
            return this;
        }

        public GetInvoiceItemsParams taxationItemsFields(List<String> taxationItemsFields) {
            this.taxationItemsFields = taxationItemsFields;
            return this;
        }

        public GetInvoiceItemsParams lineItemFields(List<String> lineItemFields) {
            this.lineItemFields = lineItemFields;
            return this;
        }

        public GetInvoiceItemsParams invoiceFields(List<String> invoiceFields) {
            this.invoiceFields = invoiceFields;
            return this;
        }
    }

    public static class GetInvoiceParams {
        private final String invoiceId;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private List<String> fields;
        private List<String> invoiceFields;
        private List<String> invoiceItemsFields;
        private List<String> taxationItemsFields;
        private List<String> accountFields;
        private List<String> billToFields;
        private List<String> lineItemFields;
        private List<String> expand;
        private List<String> filter;
        private Integer pageSize;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public GetInvoiceParams(String invoiceId) {
            this.invoiceId = invoiceId;
        }

        public GetInvoiceParams getByIdQueryParams(GetByIdQueryParams getByIdQueryParams) {
            this.getByIdQueryParams = getByIdQueryParams;
            if (this.expand != null) {
                this.expand = getByIdQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = getByIdQueryParams.getFilter();
            }
            if (this.pageSize != null) {
                this.pageSize = getByIdQueryParams.getPageSize();
            }
            return this;
        }

        public GetInvoiceParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public GetInvoiceParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public GetInvoiceParams invoiceFields(List<String> invoiceFields) {
            this.invoiceFields = invoiceFields;
            return this;
        }

        public GetInvoiceParams invoiceItemsFields(List<String> invoiceItemsFields) {
            this.invoiceItemsFields = invoiceItemsFields;
            return this;
        }

        public GetInvoiceParams taxationItemsFields(List<String> taxationItemsFields) {
            this.taxationItemsFields = taxationItemsFields;
            return this;
        }

        public GetInvoiceParams accountFields(List<String> accountFields) {
            this.accountFields = accountFields;
            return this;
        }

        public GetInvoiceParams billToFields(List<String> billToFields) {
            this.billToFields = billToFields;
            return this;
        }

        public GetInvoiceParams lineItemFields(List<String> lineItemFields) {
            this.lineItemFields = lineItemFields;
            return this;
        }

        public GetInvoiceParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public GetInvoiceParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public GetInvoiceParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }
    }

    public static class EmailInvoiceParams {
        private final String invoiceId;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private String zuoraTrackId;
        private Boolean async;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public EmailInvoiceParams(String invoiceId) {
            this.invoiceId = invoiceId;
        }

        public EmailInvoiceParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }
    }

    public static class DeleteInvoiceParams {
        private final String invoiceId;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private String zuoraTrackId;
        private Boolean async;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public DeleteInvoiceParams(String invoiceId) {
            this.invoiceId = invoiceId;
        }

        public DeleteInvoiceParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }
    }

    public static class CreateInvoiceParams {
        private final InvoiceCreateRequest invoiceCreateRequest;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private List<String> fields;
        private List<String> invoiceFields;
        private List<String> invoiceItemsFields;
        private List<String> taxationItemsFields;
        private List<String> accountFields;
        private List<String> billToFields;
        private List<String> lineItemFields;
        private List<String> expand;
        private List<String> filter;
        private Integer pageSize;
        private String zuoraTrackId;
        private Boolean async;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public CreateInvoiceParams(InvoiceCreateRequest invoiceCreateRequest) {
            this.invoiceCreateRequest = invoiceCreateRequest;
        }

        public CreateInvoiceParams getByIdQueryParams(GetByIdQueryParams getByIdQueryParams) {
            this.getByIdQueryParams = getByIdQueryParams;
            if (this.expand != null) {
                this.expand = getByIdQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = getByIdQueryParams.getFilter();
            }
            if (this.pageSize != null) {
                this.pageSize = getByIdQueryParams.getPageSize();
            }
            return this;
        }

        public CreateInvoiceParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public CreateInvoiceParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public CreateInvoiceParams invoiceFields(List<String> invoiceFields) {
            this.invoiceFields = invoiceFields;
            return this;
        }

        public CreateInvoiceParams invoiceItemsFields(List<String> invoiceItemsFields) {
            this.invoiceItemsFields = invoiceItemsFields;
            return this;
        }

        public CreateInvoiceParams taxationItemsFields(List<String> taxationItemsFields) {
            this.taxationItemsFields = taxationItemsFields;
            return this;
        }

        public CreateInvoiceParams accountFields(List<String> accountFields) {
            this.accountFields = accountFields;
            return this;
        }

        public CreateInvoiceParams billToFields(List<String> billToFields) {
            this.billToFields = billToFields;
            return this;
        }

        public CreateInvoiceParams lineItemFields(List<String> lineItemFields) {
            this.lineItemFields = lineItemFields;
            return this;
        }

        public CreateInvoiceParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public CreateInvoiceParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public CreateInvoiceParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }
    }

    public static class CancelInvoiceParams {
        private final String invoiceId;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private List<String> fields;
        private List<String> invoiceFields;
        private List<String> invoiceItemsFields;
        private List<String> taxationItemsFields;
        private List<String> accountFields;
        private List<String> billToFields;
        private List<String> lineItemFields;
        private List<String> expand;
        private List<String> filter;
        private Integer pageSize;
        private String zuoraTrackId;
        private Boolean async;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraWorkingOrg;
        private String zuoraOrgIds;

        public CancelInvoiceParams(String invoiceId) {
            this.invoiceId = invoiceId;
        }

        public CancelInvoiceParams getByIdQueryParams(GetByIdQueryParams getByIdQueryParams) {
            this.getByIdQueryParams = getByIdQueryParams;
            if (this.expand != null) {
                this.expand = getByIdQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = getByIdQueryParams.getFilter();
            }
            if (this.pageSize != null) {
                this.pageSize = getByIdQueryParams.getPageSize();
            }
            return this;
        }

        public CancelInvoiceParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraWorkingOrg() != null) {
                this.zuoraWorkingOrg = headers.getZuoraWorkingOrg();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public CancelInvoiceParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public CancelInvoiceParams invoiceFields(List<String> invoiceFields) {
            this.invoiceFields = invoiceFields;
            return this;
        }

        public CancelInvoiceParams invoiceItemsFields(List<String> invoiceItemsFields) {
            this.invoiceItemsFields = invoiceItemsFields;
            return this;
        }

        public CancelInvoiceParams taxationItemsFields(List<String> taxationItemsFields) {
            this.taxationItemsFields = taxationItemsFields;
            return this;
        }

        public CancelInvoiceParams accountFields(List<String> accountFields) {
            this.accountFields = accountFields;
            return this;
        }

        public CancelInvoiceParams billToFields(List<String> billToFields) {
            this.billToFields = billToFields;
            return this;
        }

        public CancelInvoiceParams lineItemFields(List<String> lineItemFields) {
            this.lineItemFields = lineItemFields;
            return this;
        }

        public CancelInvoiceParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public CancelInvoiceParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public CancelInvoiceParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }
    }
}

