/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.api;

import com.google.gson.reflect.TypeToken;
import com.zuora.ApiCallback;
import com.zuora.ApiClient;
import com.zuora.ApiException;
import com.zuora.ApiResponse;
import com.zuora.Configuration;
import com.zuora.Pair;
import com.zuora.model.GetCustomExchangeRatesType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class CustomExchangeRatesApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public CustomExchangeRatesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public CustomExchangeRatesApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call getCustomExchangeRatesCall(String currency, String startDate, String endDate, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/custom-exchange-rates/{currency}".replace("{currency}", this.localVarApiClient.escapeString(currency.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (startDate != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("startDate", startDate));
        }
        if (endDate != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("endDate", endDate));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (authorization != null) {
            localVarHeaderParams.put("Authorization", this.localVarApiClient.parameterToString(authorization));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("Zuora-Track-Id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("Zuora-Entity-Ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (zuoraVersion != null) {
            localVarHeaderParams.put("Zuora-Version", this.localVarApiClient.parameterToString(zuoraVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCustomExchangeRatesValidateBeforeCall(String currency, String startDate, String endDate, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback _callback) throws ApiException {
        if (currency == null) {
            throw new ApiException("Missing the required parameter 'currency' when calling getCustomExchangeRates(Async)");
        }
        if (startDate == null) {
            throw new ApiException("Missing the required parameter 'startDate' when calling getCustomExchangeRates(Async)");
        }
        if (endDate == null) {
            throw new ApiException("Missing the required parameter 'endDate' when calling getCustomExchangeRates(Async)");
        }
        return this.getCustomExchangeRatesCall(currency, startDate, endDate, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, _callback);
    }

    protected GetCustomExchangeRatesType getCustomExchangeRates(String currency, String startDate, String endDate, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion) throws ApiException {
        ApiResponse<GetCustomExchangeRatesType> localVarResp = this.getCustomExchangeRatesWithHttpInfo(currency, startDate, endDate, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion);
        return localVarResp.getData();
    }

    private ApiResponse<GetCustomExchangeRatesType> getCustomExchangeRatesWithHttpInfo(String currency, String startDate, String endDate, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion) throws ApiException {
        Call localVarCall = this.getCustomExchangeRatesValidateBeforeCall(currency, startDate, endDate, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, null);
        Type localVarReturnType = new TypeToken<GetCustomExchangeRatesType>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getCustomExchangeRatesAsync(String currency, String startDate, String endDate, String acceptEncoding, String contentEncoding, String authorization, String zuoraTrackId, String zuoraEntityIds, String zuoraVersion, ApiCallback<GetCustomExchangeRatesType> _callback) throws ApiException {
        Call localVarCall = this.getCustomExchangeRatesValidateBeforeCall(currency, startDate, endDate, acceptEncoding, contentEncoding, authorization, zuoraTrackId, zuoraEntityIds, zuoraVersion, _callback);
        Type localVarReturnType = new TypeToken<GetCustomExchangeRatesType>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetCustomExchangeRatesApi getCustomExchangeRatesApi(String currency, String startDate, String endDate) {
        return new GetCustomExchangeRatesApi(currency, startDate, endDate);
    }

    public class GetCustomExchangeRatesApi {
        private final String currency;
        private final String startDate;
        private final String endDate;
        private String acceptEncoding;
        private String contentEncoding;
        private String authorization;
        private String zuoraTrackId;
        private String zuoraEntityIds;
        private String zuoraVersion;

        private GetCustomExchangeRatesApi(String currency, String startDate, String endDate) {
            this.currency = currency;
            this.startDate = startDate;
            this.endDate = endDate;
        }

        public GetCustomExchangeRatesApi acceptEncoding(String acceptEncoding) {
            this.acceptEncoding = acceptEncoding;
            return this;
        }

        public GetCustomExchangeRatesApi contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public GetCustomExchangeRatesApi authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public GetCustomExchangeRatesApi zuoraTrackId(String zuoraTrackId) {
            this.zuoraTrackId = zuoraTrackId;
            return this;
        }

        public GetCustomExchangeRatesApi zuoraEntityIds(String zuoraEntityIds) {
            this.zuoraEntityIds = zuoraEntityIds;
            return this;
        }

        public GetCustomExchangeRatesApi zuoraVersion(String zuoraVersion) {
            this.zuoraVersion = zuoraVersion;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return CustomExchangeRatesApi.this.getCustomExchangeRatesCall(this.currency, this.startDate, this.endDate, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, _callback);
        }

        public GetCustomExchangeRatesType execute() throws ApiException {
            ApiResponse localVarResp = CustomExchangeRatesApi.this.getCustomExchangeRatesWithHttpInfo(this.currency, this.startDate, this.endDate, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion);
            return (GetCustomExchangeRatesType)localVarResp.getData();
        }

        private ApiResponse<GetCustomExchangeRatesType> executeWithHttpInfo() throws ApiException {
            return CustomExchangeRatesApi.this.getCustomExchangeRatesWithHttpInfo(this.currency, this.startDate, this.endDate, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion);
        }

        public Call executeAsync(ApiCallback<GetCustomExchangeRatesType> _callback) throws ApiException {
            return CustomExchangeRatesApi.this.getCustomExchangeRatesAsync(this.currency, this.startDate, this.endDate, this.acceptEncoding, this.contentEncoding, this.authorization, this.zuoraTrackId, this.zuoraEntityIds, this.zuoraVersion, _callback);
        }
    }
}

