/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.sdk.internal.pricing;

import com.zuora.sdk.PriceCreateRequest;
import com.zuora.sdk.PriceEnum;
import com.zuora.sdk.PriceTier;
import com.zuora.sdk.internal.RatePlansBySubscriptionIdQuery;
import com.zuora.sdk.internal.apis.data.ProxyCreateOrModifyProductRatePlanChargeTierDataProductRatePlanChargeTier;
import com.zuora.sdk.internal.models.enums.ChargeType;
import java.util.ArrayList;
import java.util.Currency;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public abstract class ChargeModelRule {
    abstract PriceEnum.ChargeModel getChargeModel();

    abstract EnumSet<ChargeType> getChargeTypes();

    abstract List<ProxyCreateOrModifyProductRatePlanChargeTierDataProductRatePlanChargeTier> getZTiers(PriceCreateRequest var1);

    abstract Double getAmountFromRatePlanCharge(RatePlansBySubscriptionIdQuery.Node2 var1);

    abstract boolean check(PriceCreateRequest var1);

    boolean isDiscount(PriceCreateRequest priceCreateRequest) {
        return priceCreateRequest.getDiscountLevel() != null && priceCreateRequest.getApplyDiscountTo() != null;
    }

    boolean hasTiers(PriceCreateRequest priceCreateRequest) {
        return priceCreateRequest.getTiers() != null && !priceCreateRequest.getTiers().isEmpty();
    }

    boolean hasOverage(PriceCreateRequest priceCreateRequest) {
        return priceCreateRequest.getOverage() != null || PriceEnum.TiersMode.GRADUATED_WITH_OVERAGE.equals((Object)priceCreateRequest.getTiersMode());
    }

    protected RatePlansBySubscriptionIdQuery.Node2 getNodeFromEdge2(List<RatePlansBySubscriptionIdQuery.Edge2> zTiers) {
        if (zTiers == null) {
            return null;
        }
        Optional<RatePlansBySubscriptionIdQuery.Node2> node2 = zTiers.stream().map(RatePlansBySubscriptionIdQuery.Edge2::getNode).filter(Objects::nonNull).findFirst();
        return node2.orElse(null);
    }

    List<ProxyCreateOrModifyProductRatePlanChargeTierDataProductRatePlanChargeTier> getZTierFromAmount(Map<Currency, Double> amountsMap, boolean isOverage) {
        return amountsMap.entrySet().stream().map(amount -> new ProxyCreateOrModifyProductRatePlanChargeTierDataProductRatePlanChargeTier().currency(((Currency)amount.getKey()).getCurrencyCode()).isOveragePrice(Boolean.valueOf(isOverage)).price((Double)amount.getValue())).collect(Collectors.toList());
    }

    List<ProxyCreateOrModifyProductRatePlanChargeTierDataProductRatePlanChargeTier> getZTierFromTiers(List<PriceTier> tiers, boolean clearEndingUnit) {
        ArrayList<ProxyCreateOrModifyProductRatePlanChargeTierDataProductRatePlanChargeTier> zTiers = new ArrayList<ProxyCreateOrModifyProductRatePlanChargeTierDataProductRatePlanChargeTier>();
        if (tiers == null || tiers.isEmpty()) {
            return zTiers;
        }
        PriceTier lastTier = clearEndingUnit ? tiers.get(tiers.size() - 1) : null;
        for (PriceTier tier : tiers) {
            Double startingUnit = tier.getStartingUnit();
            Double endingUnit = tier.getUpTo();
            zTiers.addAll(tier.getAmounts().entrySet().stream().map(aTier -> {
                ProxyCreateOrModifyProductRatePlanChargeTierDataProductRatePlanChargeTier zTier = new ProxyCreateOrModifyProductRatePlanChargeTierDataProductRatePlanChargeTier().startingUnit(startingUnit).endingUnit(tier == lastTier ? null : endingUnit).price((Double)aTier.getValue()).currency(((Currency)aTier.getKey()).getCurrencyCode()).priceFormat("Flat Fee");
                return zTier;
            }).collect(Collectors.toList()));
            zTiers.addAll(tier.getUnitAmounts().entrySet().stream().map(aTier -> {
                ProxyCreateOrModifyProductRatePlanChargeTierDataProductRatePlanChargeTier zTier = new ProxyCreateOrModifyProductRatePlanChargeTierDataProductRatePlanChargeTier().startingUnit(startingUnit).endingUnit(tier == lastTier ? null : endingUnit).price((Double)aTier.getValue()).currency(((Currency)aTier.getKey()).getCurrencyCode()).priceFormat("Per Unit");
                return zTier;
            }).collect(Collectors.toList()));
        }
        return zTiers;
    }
}

