/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.sdk;

import com.zuora.sdk.EnumMapper;
import com.zuora.sdk.Overage;
import com.zuora.sdk.PriceEnum;
import com.zuora.sdk.PriceMapper;
import com.zuora.sdk.Recurring;
import com.zuora.sdk.SubscriptionPlanItem;
import com.zuora.sdk.SubscriptionPlanItemMapper;
import com.zuora.sdk.TierMapper;
import com.zuora.sdk.internal.RatePlansBySubscriptionIdQuery;
import com.zuora.sdk.internal.models.enums.BillCycleType;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import org.mapstruct.factory.Mappers;

class SubscriptionPlanItemMapperImpl
extends SubscriptionPlanItemMapper {
    private final TierMapper tierMapper = new TierMapper();
    private final PriceMapper priceMapper = (PriceMapper)Mappers.getMapper(PriceMapper.class);
    private final EnumMapper enumMapper = (EnumMapper)Mappers.getMapper(EnumMapper.class);

    SubscriptionPlanItemMapperImpl() {
    }

    @Override
    SubscriptionPlanItem.SubscriptionPlanItemBuilder fromApi(RatePlansBySubscriptionIdQuery.Node1 ratePlanCharge) {
        if (ratePlanCharge == null) {
            return null;
        }
        SubscriptionPlanItem.SubscriptionPlanItemBuilder subscriptionPlanItemBuilder = new SubscriptionPlanItem.SubscriptionPlanItemBuilder();
        subscriptionPlanItemBuilder.recurring(this.node1ToRecurring(ratePlanCharge));
        subscriptionPlanItemBuilder.startEvent(this.enumMapper.mapTriggerEvent(ratePlanCharge.getTriggerEvent()));
        subscriptionPlanItemBuilder.number(ratePlanCharge.getChargeNumber());
        subscriptionPlanItemBuilder.unitOfMeasure(ratePlanCharge.getUOM());
        subscriptionPlanItemBuilder.tiers(this.tierMapper.mapRatePlanChargeToTiers(ratePlanCharge));
        if (ratePlanCharge.getQuantity() != null) {
            subscriptionPlanItemBuilder.quantity(ratePlanCharge.getQuantity());
        }
        subscriptionPlanItemBuilder.subscriptionPlan(ratePlanCharge.getRatePlanId());
        subscriptionPlanItemBuilder.price(ratePlanCharge.getProductRatePlanChargeId());
        subscriptionPlanItemBuilder.overage(this.fromApiToOverage(ratePlanCharge));
        subscriptionPlanItemBuilder.priceBaseInterval(this.enumMapper.mapListPriceBase(ratePlanCharge.getListPriceBase()));
        if (ratePlanCharge.getCreatedDate() != null) {
            subscriptionPlanItemBuilder.createTime(ZonedDateTime.parse(ratePlanCharge.getCreatedDate()));
        }
        if (ratePlanCharge.getUpdatedDate() != null) {
            subscriptionPlanItemBuilder.updateTime(ZonedDateTime.parse(ratePlanCharge.getUpdatedDate()));
        }
        subscriptionPlanItemBuilder.createdBy(ratePlanCharge.getCreatedById());
        subscriptionPlanItemBuilder.updatedBy(ratePlanCharge.getUpdatedById());
        if (ratePlanCharge.getChargedThroughDate() != null) {
            subscriptionPlanItemBuilder.invoicedThroughDate(LocalDate.parse(ratePlanCharge.getChargedThroughDate()));
        }
        subscriptionPlanItemBuilder.id(ratePlanCharge.getId());
        subscriptionPlanItemBuilder.name(ratePlanCharge.getName());
        subscriptionPlanItemBuilder.description(ratePlanCharge.getDescription());
        if (ratePlanCharge.getProcessedThroughDate() != null) {
            subscriptionPlanItemBuilder.processedThroughDate(LocalDate.parse(ratePlanCharge.getProcessedThroughDate()));
        }
        subscriptionPlanItemBuilder.segment(this.priceMapper.map(ratePlanCharge.getSegment()));
        subscriptionPlanItemBuilder.version(this.priceMapper.map(ratePlanCharge.getVersion()));
        subscriptionPlanItemBuilder.applyDiscountTo(this.enumMapper.fromApi(ratePlanCharge.getApplyDiscountTo()));
        subscriptionPlanItemBuilder.discountLevel(this.enumMapper.fromDiscountLevel(ratePlanCharge.getDiscountLevel()));
        subscriptionPlanItemBuilder.chargeModel(this.enumMapper.fromChargeModel(ratePlanCharge.getChargeModel()));
        subscriptionPlanItemBuilder.chargeType(this.enumMapper.fromChargeType(ratePlanCharge.getChargeType()));
        this.setAmounts(subscriptionPlanItemBuilder, ratePlanCharge);
        return subscriptionPlanItemBuilder;
    }

    @Override
    Overage fromNodeToOverage(RatePlansBySubscriptionIdQuery.Node1 ratePlanCharge) {
        if (ratePlanCharge == null) {
            return null;
        }
        Overage.OverageBuilder overage = Overage.builder();
        overage.intervalCount(this.priceMapper.map(ratePlanCharge.getNumberOfPeriods()));
        if (ratePlanCharge.getOverageCalculationOption() != null) {
            overage.applyAtEndOfSmoothingPeriod(Boolean.parseBoolean(ratePlanCharge.getOverageCalculationOption()));
        }
        if (ratePlanCharge.getOverageUnusedUnitsCreditOption() != null) {
            overage.creditUnusedUnits(Boolean.parseBoolean(ratePlanCharge.getOverageUnusedUnitsCreditOption()));
        }
        return overage.build();
    }

    @Override
    PriceEnum.RecurringOn mapFrom(BillCycleType billCycleType) {
        PriceEnum.RecurringOn recurringOn;
        if (billCycleType == null) {
            return null;
        }
        switch (billCycleType) {
            case DEFAULT_FROM_CUSTOMER: {
                recurringOn = PriceEnum.RecurringOn.ACCOUNT_CYCLE_DATE;
                break;
            }
            case SUBSCRIPTION_STAR_TDAY: {
                recurringOn = PriceEnum.RecurringOn.SUBSCRIPTION_START_DAY;
                break;
            }
            case CHARGE_TRIGGER_DAY: {
                recurringOn = PriceEnum.RecurringOn.SUBSCRIPTION_PLAN_ITEM_DAY;
                break;
            }
            default: {
                recurringOn = null;
            }
        }
        return recurringOn;
    }

    protected Recurring node1ToRecurring(RatePlansBySubscriptionIdQuery.Node1 node1) {
        if (node1 == null) {
            return null;
        }
        Recurring.RecurringBuilder recurring = Recurring.builder();
        recurring.alignment(this.enumMapper.mapAlignment(node1.getBillingPeriodAlignment()));
        recurring.durationIntervalCount(this.priceMapper.map(node1.getUpToPeriods()));
        recurring.durationInterval(this.enumMapper.map(node1.getUpToPeriodsType()));
        recurring.ratingGroup(this.enumMapper.fromRatingGroup(node1.getRatingGroup()));
        recurring.interval(this.enumMapper.mapBillingPeriodType(node1.getBillingPeriod()));
        recurring.intervalCount(this.priceMapper.map(node1.getSpecificBillingPeriod()));
        recurring.on(this.toRecurringOn(node1));
        recurring.timing(this.enumMapper.mapBillingTiming(node1.getBillingTiming()));
        return recurring.build();
    }
}

