/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.sdk;

import com.zuora.sdk.EnumMapper;
import com.zuora.sdk.Overage;
import com.zuora.sdk.PriceEnum;
import com.zuora.sdk.PriceMapper;
import com.zuora.sdk.SubscriptionPlanItem;
import com.zuora.sdk.TierMapper;
import com.zuora.sdk.internal.RatePlansBySubscriptionIdQuery;
import com.zuora.sdk.internal.models.enums.BillCycleType;
import com.zuora.sdk.internal.models.enums.ChargeType;
import com.zuora.sdk.internal.pricing.RuleProcessor;
import java.util.EnumSet;
import java.util.List;
import org.mapstruct.AfterMapping;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.MappingTarget;
import org.mapstruct.Mappings;
import org.mapstruct.Named;
import org.mapstruct.ReportingPolicy;
import org.mapstruct.ValueMapping;
import org.mapstruct.ValueMappings;
import org.mapstruct.factory.Mappers;

@Mapper(unmappedTargetPolicy=ReportingPolicy.IGNORE, uses={TierMapper.class, PriceMapper.class, EnumMapper.class})
abstract class SubscriptionPlanItemMapper {
    SubscriptionPlanItemMapper() {
    }

    @Mappings(value={@Mapping(target="startEvent", source="triggerEvent"), @Mapping(target="number", source="chargeNumber"), @Mapping(target="unitOfMeasure", source="UOM"), @Mapping(target="tiers", source="ratePlanCharge"), @Mapping(target="quantity", source="quantity"), @Mapping(target="subscriptionPlan", source="ratePlanId"), @Mapping(target="price", source="productRatePlanChargeId"), @Mapping(target="overage", source="."), @Mapping(target="recurring.alignment", source="billingPeriodAlignment"), @Mapping(target="recurring.durationIntervalCount", source="upToPeriods", resultType=Integer.class), @Mapping(target="recurring.durationInterval", source="upToPeriodsType"), @Mapping(target="recurring.ratingGroup", source="ratingGroup"), @Mapping(target="recurring.interval", source="billingPeriod"), @Mapping(target="recurring.intervalCount", source="specificBillingPeriod"), @Mapping(target="recurring.on", source="."), @Mapping(target="recurring.timing", source="billingTiming"), @Mapping(target="priceBaseInterval", source="listPriceBase"), @Mapping(source="createdDate", target="createTime"), @Mapping(source="updatedDate", target="updateTime"), @Mapping(source="createdById", target="createdBy"), @Mapping(source="updatedById", target="updatedBy"), @Mapping(source="chargedThroughDate", target="invoicedThroughDate")})
    abstract SubscriptionPlanItem.SubscriptionPlanItemBuilder fromApi(RatePlansBySubscriptionIdQuery.Node1 var1);

    @Named(value="defaultOverage")
    @Mappings(value={@Mapping(target="intervalCount", source="numberOfPeriods"), @Mapping(target="applyAtEndOfSmoothingPeriod", source="overageCalculationOption"), @Mapping(target="creditUnusedUnits", source="overageUnusedUnitsCreditOption")})
    abstract Overage fromNodeToOverage(RatePlansBySubscriptionIdQuery.Node1 var1);

    Overage fromApiToOverage(RatePlansBySubscriptionIdQuery.Node1 ratePlanCharge) {
        PriceEnum.ChargeModel chargeModel = ((EnumMapper)Mappers.getMapper(EnumMapper.class)).fromChargeModel(ratePlanCharge.getChargeModel());
        if (chargeModel != null && !chargeModel.equals((Object)PriceEnum.ChargeModel.OVERAGE)) {
            return null;
        }
        return this.fromNodeToOverage(ratePlanCharge);
    }

    @AfterMapping
    protected void setAmounts(@MappingTarget SubscriptionPlanItem.SubscriptionPlanItemBuilder result, RatePlansBySubscriptionIdQuery.Node1 ratePlanCharge) {
        PriceEnum.ChargeModel chargeModel;
        ChargeType chargeType = ChargeType.getByLabel((String)ratePlanCharge.getChargeType());
        if (chargeType != null && chargeType.equals((Object)ChargeType.ONE_TIME)) {
            result.recurring(null);
        }
        if ((chargeModel = ((EnumMapper)Mappers.getMapper(EnumMapper.class)).fromChargeModel(ratePlanCharge.getChargeModel())) == null) {
            return;
        }
        if (PriceEnum.ChargeModel.getTieredModels().contains((Object)chargeModel) && !chargeModel.equals((Object)PriceEnum.ChargeModel.TIERED_WITH_OVERAGE)) {
            return;
        }
        if (ratePlanCharge.getRateplanchargetiers() != null) {
            List<RatePlansBySubscriptionIdQuery.Edge2> tiers = ratePlanCharge.getRateplanchargetiers().getEdges();
            Double priceAmount = RuleProcessor.getAmounts(chargeModel, tiers);
            if (EnumSet.of(PriceEnum.ChargeModel.FLAT_FEE, PriceEnum.ChargeModel.DISCOUNT_FIXED_AMOUNT).contains((Object)chargeModel)) {
                result.amount(priceAmount);
                return;
            }
            if (chargeModel.equals((Object)PriceEnum.ChargeModel.DISCOUNT_PERCENTAGE)) {
                result.percentAmount(priceAmount);
                return;
            }
            if (EnumSet.of(PriceEnum.ChargeModel.PER_UNIT, PriceEnum.ChargeModel.OVERAGE, PriceEnum.ChargeModel.TIERED_WITH_OVERAGE).contains((Object)chargeModel)) {
                result.unitAmount(priceAmount);
            }
        }
    }

    @ValueMappings(value={@ValueMapping(source="DEFAULT_FROM_CUSTOMER", target="ACCOUNT_CYCLE_DATE"), @ValueMapping(source="SUBSCRIPTION_STAR_TDAY", target="SUBSCRIPTION_START_DAY"), @ValueMapping(source="CHARGE_TRIGGER_DAY", target="SUBSCRIPTION_PLAN_ITEM_DAY"), @ValueMapping(source="<ANY_REMAINING>", target="<NULL>")})
    abstract PriceEnum.RecurringOn mapFrom(BillCycleType var1);

    PriceEnum.RecurringOn toRecurringOn(RatePlansBySubscriptionIdQuery.Node1 ratePlanCharge) {
        if (ratePlanCharge.getChargeType().equals(ChargeType.ONE_TIME.getApiValue())) {
            return null;
        }
        return ((EnumMapper)Mappers.getMapper(EnumMapper.class)).map(ratePlanCharge.getBillCycleType(), ratePlanCharge.getWeeklyBillCycleDay(), ratePlanCharge.getBillCycleDay());
    }
}

