/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.sdk;

import com.zuora.sdk.EnumMapper;
import com.zuora.sdk.Plan;
import com.zuora.sdk.Price;
import com.zuora.sdk.PriceEnum;
import com.zuora.sdk.ProcessingOption;
import com.zuora.sdk.Recurring;
import com.zuora.sdk.StartOn;
import com.zuora.sdk.SubscriptionAPI;
import com.zuora.sdk.SubscriptionPlanItem;
import com.zuora.sdk.Term;
import com.zuora.sdk.Tier;
import com.zuora.sdk.internal.apis.data.BillingOptions;
import com.zuora.sdk.internal.apis.data.CancelSubscription;
import com.zuora.sdk.internal.apis.data.ChargeTier;
import com.zuora.sdk.internal.apis.data.CreateOrderChargeOverride;
import com.zuora.sdk.internal.apis.data.CreateOrderChargeOverrideBilling;
import com.zuora.sdk.internal.apis.data.CreateOrderChargeOverridePricing;
import com.zuora.sdk.internal.apis.data.CreateOrderChargeUpdate;
import com.zuora.sdk.internal.apis.data.CreateOrderCreateSubscription;
import com.zuora.sdk.internal.apis.data.CreateOrderOrderAction;
import com.zuora.sdk.internal.apis.data.CreateOrderPricingUpdate;
import com.zuora.sdk.internal.apis.data.CreateOrderRatePlanOverride;
import com.zuora.sdk.internal.apis.data.CreateOrderRatePlanUpdate;
import com.zuora.sdk.internal.apis.data.CreateOrderTermsAndConditions;
import com.zuora.sdk.internal.apis.data.CreateOrderTriggerParams;
import com.zuora.sdk.internal.apis.data.DiscountPricingOverride;
import com.zuora.sdk.internal.apis.data.DiscountPricingUpdate;
import com.zuora.sdk.internal.apis.data.LastTerm;
import com.zuora.sdk.internal.apis.data.OneTimeFlatFeePricingOverride;
import com.zuora.sdk.internal.apis.data.OneTimePerUnitPricingOverride;
import com.zuora.sdk.internal.apis.data.OneTimeTieredPricingOverride;
import com.zuora.sdk.internal.apis.data.OneTimeVolumePricingOverride;
import com.zuora.sdk.internal.apis.data.OwnerTransfer;
import com.zuora.sdk.internal.apis.data.ProcessingOptions;
import com.zuora.sdk.internal.apis.data.ProcessingOptionsElectronicPaymentOptions;
import com.zuora.sdk.internal.apis.data.RecurringFlatFeePricingOverride;
import com.zuora.sdk.internal.apis.data.RecurringFlatFeePricingUpdate;
import com.zuora.sdk.internal.apis.data.RecurringPerUnitPricingOverride;
import com.zuora.sdk.internal.apis.data.RecurringPerUnitPricingUpdate;
import com.zuora.sdk.internal.apis.data.RecurringTieredPricingOverride;
import com.zuora.sdk.internal.apis.data.RecurringTieredPricingUpdate;
import com.zuora.sdk.internal.apis.data.RecurringVolumePricingOverride;
import com.zuora.sdk.internal.apis.data.RecurringVolumePricingUpdate;
import com.zuora.sdk.internal.apis.data.RemoveProduct;
import com.zuora.sdk.internal.apis.data.RenewalTerm;
import com.zuora.sdk.internal.apis.data.TriggerDate;
import com.zuora.sdk.internal.exceptions.ZuoraSdkException;
import com.zuora.sdk.internal.models.enums.ChargeType;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Currency;
import java.util.List;
import java.util.stream.Collectors;
import org.mapstruct.factory.Mappers;

class SubscriptionAPIHelper {
    private static final EnumMapper enumMapper = (EnumMapper)Mappers.getMapper(EnumMapper.class);

    SubscriptionAPIHelper() {
    }

    static CreateOrderChargeUpdate getCreateOrderChargeUpdate(SubscriptionPlanItem subscriptionPlanItem, Currency currency) {
        return new CreateOrderChargeUpdate().chargeNumber(subscriptionPlanItem.getNumber()).pricing(SubscriptionAPIHelper.getChargeUpdatePricing(subscriptionPlanItem, currency));
    }

    static CreateOrderRatePlanOverride getCreateOrderRatePlanOverride(Plan plan, Currency currency) {
        return new CreateOrderRatePlanOverride().productRatePlanId(plan.getId()).chargeOverrides(SubscriptionAPIHelper.getChargeOverride(plan, currency));
    }

    static List<CreateOrderChargeOverride> getChargeOverride(Plan plan, Currency currency) {
        List<Price> items = plan.getItems();
        return items.stream().map(item -> new CreateOrderChargeOverride().pricing(SubscriptionAPIHelper.getChargeOverridePricing(item, currency)).productRatePlanChargeId(item.getId()).billing(SubscriptionAPIHelper.getChargeOverrideBilling(item)).startDate(new CreateOrderTriggerParams().triggerEvent(enumMapper.map(item.getStartEvent()))).description(item.getDescription())).collect(Collectors.toList());
    }

    static CreateOrderChargeOverrideBilling getChargeOverrideBilling(Price item) {
        CreateOrderChargeOverrideBilling chargeOverrideBilling = new CreateOrderChargeOverrideBilling();
        if (item.getRecurring() == null) {
            return chargeOverrideBilling;
        }
        Recurring recurring = item.getRecurring();
        if (recurring.getAlignment() != null) {
            chargeOverrideBilling.billingPeriodAlignment(enumMapper.map(recurring.getAlignment()).getApiValue());
        }
        if (recurring.getTiming() != null) {
            chargeOverrideBilling.billingTiming(recurring.getTiming().name());
        }
        return chargeOverrideBilling;
    }

    static CreateOrderChargeOverridePricing getChargeOverridePricing(Price item, Currency currency) {
        CreateOrderChargeOverridePricing chargeOverridePricing = new CreateOrderChargeOverridePricing();
        ChargeType chargeType = item.getChargeType();
        PriceEnum.ChargeModel chargeModel = item.getChargeModel();
        if (chargeType.equals((Object)ChargeType.RECURRING)) {
            if (chargeModel.equals((Object)PriceEnum.ChargeModel.FLAT_FEE)) {
                return chargeOverridePricing.recurringFlatFee(new RecurringFlatFeePricingOverride().listPrice(item.getAmounts().get(currency)).listPriceBase(enumMapper.mapSubscriptionListPriceBase(item.getPriceBaseInterval())));
            }
            if (chargeModel.equals((Object)PriceEnum.ChargeModel.PER_UNIT)) {
                return chargeOverridePricing.recurringPerUnit(new RecurringPerUnitPricingOverride().listPrice(item.getUnitAmounts().get(currency)).listPriceBase(enumMapper.mapSubscriptionListPriceBase(item.getPriceBaseInterval())).quantity(Double.valueOf(item.getQuantity())));
            }
            if (chargeModel.equals((Object)PriceEnum.ChargeModel.TIERED)) {
                return chargeOverridePricing.recurringTiered(new RecurringTieredPricingOverride().quantity(Double.valueOf(item.getQuantity())).tiers(SubscriptionAPIHelper.getChargeTiers(item.getTiers(), currency)));
            }
            if (chargeModel.equals((Object)PriceEnum.ChargeModel.VOLUME)) {
                return chargeOverridePricing.recurringVolume(new RecurringVolumePricingOverride().quantity(Double.valueOf(item.getQuantity())).tiers(SubscriptionAPIHelper.getChargeTiers(item.getTiers(), currency)));
            }
            if (chargeModel.equals((Object)PriceEnum.ChargeModel.DISCOUNT_FIXED_AMOUNT)) {
                return chargeOverridePricing.discount(new DiscountPricingOverride().applyDiscountTo(enumMapper.toApi(item.getApplyDiscountTo()).getApiValue()).discountAmount(item.getAmounts().get(currency)).discountLevel(enumMapper.map(item.getDiscountLevel()).getApiValue()));
            }
            if (chargeModel.equals((Object)PriceEnum.ChargeModel.DISCOUNT_PERCENTAGE)) {
                return chargeOverridePricing.discount(new DiscountPricingOverride().applyDiscountTo(enumMapper.toApi(item.getApplyDiscountTo()).getApiValue()).discountPercentage(item.getPercentAmount()).discountLevel(enumMapper.map(item.getDiscountLevel()).getApiValue()));
            }
        } else if (chargeType.equals((Object)ChargeType.ONE_TIME)) {
            if (chargeModel.equals((Object)PriceEnum.ChargeModel.FLAT_FEE)) {
                return chargeOverridePricing.oneTimeFlatFee(new OneTimeFlatFeePricingOverride().listPrice(item.getAmounts().get(currency)));
            }
            if (chargeModel.equals((Object)PriceEnum.ChargeModel.PER_UNIT)) {
                return chargeOverridePricing.oneTimePerUnit(new OneTimePerUnitPricingOverride().listPrice(item.getUnitAmounts().get(currency)).quantity(Double.valueOf(item.getQuantity())));
            }
            if (chargeModel.equals((Object)PriceEnum.ChargeModel.TIERED)) {
                return chargeOverridePricing.oneTimeTiered(new OneTimeTieredPricingOverride().quantity(Double.valueOf(item.getQuantity())).tiers(SubscriptionAPIHelper.getChargeTiers(item.getTiers(), currency)));
            }
            if (chargeModel.equals((Object)PriceEnum.ChargeModel.VOLUME)) {
                return chargeOverridePricing.oneTimeVolume(new OneTimeVolumePricingOverride().quantity(Double.valueOf(item.getQuantity())).tiers(SubscriptionAPIHelper.getChargeTiers(item.getTiers(), currency)));
            }
        }
        return chargeOverridePricing;
    }

    static CreateOrderPricingUpdate getChargeUpdatePricing(SubscriptionPlanItem item, Currency currency) {
        CreateOrderPricingUpdate chargeUpdatePricing = new CreateOrderPricingUpdate();
        PriceEnum.ChargeModel chargeModel = item.getChargeModel();
        ChargeType chargeType = item.getChargeType();
        if (chargeType.equals((Object)ChargeType.RECURRING)) {
            if (chargeModel.equals((Object)PriceEnum.ChargeModel.FLAT_FEE)) {
                return chargeUpdatePricing.recurringFlatFee(new RecurringFlatFeePricingUpdate().listPrice(item.getAmounts().get(currency)));
            }
            if (chargeModel.equals((Object)PriceEnum.ChargeModel.PER_UNIT)) {
                return chargeUpdatePricing.recurringPerUnit(new RecurringPerUnitPricingUpdate().listPrice(item.getUnitAmounts().get(currency)).quantity(Double.valueOf(item.getQuantity())));
            }
            if (chargeModel.equals((Object)PriceEnum.ChargeModel.TIERED)) {
                return chargeUpdatePricing.recurringTiered(new RecurringTieredPricingUpdate().quantity(Double.valueOf(item.getQuantity())).tiers(SubscriptionAPIHelper.getChargeTiers(item.getTiers(), currency)));
            }
            if (chargeModel.equals((Object)PriceEnum.ChargeModel.VOLUME)) {
                return chargeUpdatePricing.recurringVolume(new RecurringVolumePricingUpdate().quantity(Double.valueOf(item.getQuantity())).tiers(SubscriptionAPIHelper.getChargeTiers(item.getTiers(), currency)));
            }
            if (chargeModel.equals((Object)PriceEnum.ChargeModel.DISCOUNT_FIXED_AMOUNT)) {
                return chargeUpdatePricing.discount(new DiscountPricingUpdate().applyDiscountTo(enumMapper.toApi(item.getApplyDiscountTo()).getApiValue()).discountLevel(enumMapper.map(item.getDiscountLevel()).getApiValue()));
            }
            if (chargeModel.equals((Object)PriceEnum.ChargeModel.DISCOUNT_PERCENTAGE)) {
                return chargeUpdatePricing.discount(new DiscountPricingUpdate().applyDiscountTo(enumMapper.map(item.getDiscountLevel()).getApiValue()).discountPercentage(item.getPercentAmount()).discountLevel(enumMapper.map(item.getDiscountLevel()).getApiValue()));
            }
        } else if (chargeType.equals((Object)ChargeType.ONE_TIME)) {
            throw ZuoraSdkException.builder().operationName("update subscription plan").message("Updating one time pricing is not supported").build();
        }
        return chargeUpdatePricing;
    }

    static List<ChargeTier> getChargeTiers(List<Tier> tiers, Currency currency) {
        return tiers.stream().map(aTier -> {
            ChargeTier chargeTier = new ChargeTier().tier(aTier.getTier());
            if (aTier.getAmounts() != null & !aTier.getAmounts().isEmpty()) {
                return chargeTier.price(aTier.getAmounts().get(currency)).priceFormat(ChargeTier.EnumpriceFormat.EpriceFormat1.label).startingUnit(aTier.getStartingUnit()).endingUnit(aTier.getUpTo());
            }
            if (aTier.getUnitAmounts() != null & !aTier.getUnitAmounts().isEmpty()) {
                return chargeTier.price(aTier.getUnitAmounts().get(currency)).priceFormat(ChargeTier.EnumpriceFormat.EpriceFormat2.label).startingUnit(aTier.getStartingUnit()).endingUnit(aTier.getUpTo());
            }
            throw ZuoraSdkException.builder().message("No pricing on tier").build();
        }).collect(Collectors.toList());
    }

    static CreateOrderOrderAction getCreateSubscriptionOrderAction(CreateOrderCreateSubscription createSub, StartOn startOn) {
        return new CreateOrderOrderAction().triggerDates(SubscriptionAPIHelper.getTriggerDates(startOn)).type(SubscriptionAPI.OrderType.CREATE_SUBSCRIPTION.getApiValue()).createSubscription(createSub);
    }

    static CreateOrderOrderAction getAddProductOrderAction(Plan plan, Currency currency, StartOn startOn) {
        return new CreateOrderOrderAction().type(SubscriptionAPI.OrderType.ADD_PRODUCT.getApiValue()).triggerDates(SubscriptionAPIHelper.getTriggerDates(startOn)).addProduct(SubscriptionAPIHelper.getCreateOrderRatePlanOverride(plan, currency));
    }

    static CreateOrderOrderAction getUpdateProductOrderAction(String subscriptionPlanId, List<SubscriptionPlanItem> subscriptionPlanItems, Currency currency, StartOn startOn) {
        CreateOrderRatePlanUpdate ratePlanUpdate = new CreateOrderRatePlanUpdate().ratePlanId(subscriptionPlanId).chargeUpdates(subscriptionPlanItems.stream().map(subPlanItem -> SubscriptionAPIHelper.getCreateOrderChargeUpdate(subPlanItem, currency)).collect(Collectors.toList()));
        return new CreateOrderOrderAction().type(SubscriptionAPI.OrderType.UPDATE_PRODUCT.getApiValue()).triggerDates(SubscriptionAPIHelper.getTriggerDates(startOn)).updateProduct(ratePlanUpdate);
    }

    static CreateOrderOrderAction getCancelOrderAction(LocalDate cancellationDate, SubscriptionAPI.CancellationPolicy cancellationPolicy, StartOn startOn) {
        return new CreateOrderOrderAction().type(SubscriptionAPI.OrderType.CANCEL_SUBSCRIPTION.getApiValue()).cancelSubscription(new CancelSubscription().cancellationEffectiveDate(cancellationDate.toString()).cancellationPolicy(cancellationPolicy.getApiValue())).triggerDates(SubscriptionAPIHelper.getTriggerDates(startOn));
    }

    static CreateOrderOrderAction getOwnerTransferOrderAction(String accountKey, String invoiceAccountKey, StartOn startOn) {
        return new CreateOrderOrderAction().type(SubscriptionAPI.OrderType.OWNER_TRANSFER.getApiValue()).ownerTransfer(new OwnerTransfer().destinationAccountNumber(accountKey).destinationInvoiceAccountNumber(invoiceAccountKey)).triggerDates(SubscriptionAPIHelper.getTriggerDates(startOn));
    }

    static CreateOrderOrderAction getRenewOrderAction(StartOn startOn) {
        return new CreateOrderOrderAction().type(SubscriptionAPI.OrderType.RENEW_SUBSCRIPTION.getApiValue()).triggerDates(SubscriptionAPIHelper.getTriggerDates(startOn));
    }

    static CreateOrderOrderAction getRemoveProductOrderAction(StartOn startOn, String ratePlanId) {
        return new CreateOrderOrderAction().type(SubscriptionAPI.OrderType.REMOVE_PRODUCT.getApiValue()).removeProduct(new RemoveProduct().ratePlanId(ratePlanId)).triggerDates(SubscriptionAPIHelper.getTriggerDates(startOn));
    }

    static CreateOrderOrderAction getTermsAndConditionsOrderAction(StartOn startOn, Term currentTerm, Term renewalTerm, boolean autoRenew) {
        List<RenewalTerm> renewalTerms = SubscriptionAPIHelper.getRenewalTerms(renewalTerm);
        CreateOrderTermsAndConditions createOrderTermsAndConditions = new CreateOrderTermsAndConditions().autoRenew(Boolean.valueOf(autoRenew)).renewalSetting(renewalTerms.isEmpty() ? "RENEW_TO_EVERGREEN" : "RENEW_WITH_SPECIFIC_TERM").renewalTerms(renewalTerms).lastTerm(SubscriptionAPIHelper.getLastTerm(currentTerm));
        return new CreateOrderOrderAction().type(SubscriptionAPI.OrderType.TERMS_AND_CONDITIONS.getApiValue()).triggerDates(SubscriptionAPIHelper.getTriggerDates(startOn)).termsAndConditions(createOrderTermsAndConditions);
    }

    static LastTerm getLastTerm(Term currentTerm) {
        return new LastTerm().period(currentTerm.getIntervalCount()).periodType(currentTerm.getLastTermInterval()).termType(currentTerm.getType().name());
    }

    static List<TriggerDate> getTriggerDates(StartOn startOn) {
        if (startOn == null) {
            throw ZuoraSdkException.builder().operationName("TriggerDates").message("Trigger Dates required for updating subscriptions").build();
        }
        return SubscriptionAPIHelper.getTriggerDates(startOn.getContractEffective(), startOn.getServiceActivation(), startOn.getCustomerAcceptance());
    }

    static List<TriggerDate> getTriggerDates(LocalDate contractEffective, LocalDate serviceActivation, LocalDate customerAcceptance) {
        ArrayList<TriggerDate> triggerDates = new ArrayList<TriggerDate>();
        if (contractEffective != null) {
            triggerDates.add(new TriggerDate().name(SubscriptionAPI.TriggerDateEnum.CONTRACT_EFFECTIVE.getApiValue()).triggerDate(contractEffective.toString()));
        }
        if (serviceActivation != null) {
            triggerDates.add(new TriggerDate().name(SubscriptionAPI.TriggerDateEnum.SERVICE_ACTIVATION.getApiValue()).triggerDate(serviceActivation.toString()));
        }
        if (customerAcceptance != null) {
            triggerDates.add(new TriggerDate().name(SubscriptionAPI.TriggerDateEnum.CUSTOMER_ACCEPTANCE.getApiValue()).triggerDate(customerAcceptance.toString()));
        }
        return triggerDates;
    }

    static ProcessingOptions getProcessingOptions(ProcessingOption subProcessingOption) {
        ProcessingOptions processingOptions = new ProcessingOptions();
        if (subProcessingOption != null) {
            processingOptions.runBilling(Boolean.valueOf(true)).billingOptions(new BillingOptions().documentDate(subProcessingOption.getDocumentDate()).targetDate(subProcessingOption.getDocumentDate()));
            if (subProcessingOption.getCollectionMethod().equals((Object)ProcessingOption.CollectionMethod.COLLECT_PAYMENT)) {
                if (subProcessingOption.getPaymentMethod() != null) {
                    processingOptions.electronicPaymentOptions(new ProcessingOptionsElectronicPaymentOptions().paymentMethodId(subProcessingOption.getPaymentMethod())).collectPayment(Boolean.valueOf(true));
                } else {
                    throw ZuoraSdkException.builder().operationName("ProcessingOptions").message("Payment Method ID must be set to collect payment").build();
                }
            }
        }
        return processingOptions;
    }

    static List<RenewalTerm> getRenewalTerms(Term renewalTerm) {
        if (renewalTerm.getType() == Term.TermType.EVERGREEN) {
            return new ArrayList<RenewalTerm>();
        }
        return Collections.singletonList(new RenewalTerm().period(renewalTerm.getIntervalCount()).periodType(renewalTerm.getLastTermInterval()));
    }
}

