/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.sdk.utils;

import com.zuora.sdk.internal.exceptions.ZuoraSdkException;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class PaginatedStreamHelper {
    public <T> Stream run(Function<String, Page<T>> list) {
        PagingIterator iterator = new PagingIterator(cursor -> cursor == null ? list.apply(null) : list.apply((String)cursor));
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 1296), false).flatMap(page -> page.content().stream());
    }

    static class PagingIterator<T>
    implements Iterator<Page<T>> {
        private final Function<String, Page<T>> pager;
        private Page<T> page;

        public PagingIterator(Function<String, Page<T>> pager) {
            this.pager = pager;
        }

        @Override
        public boolean hasNext() {
            return this.page == null || this.page.cursor() != null;
        }

        @Override
        public Page<T> next() {
            try {
                this.page = this.page == null ? this.pager.apply(null) : this.pager.apply(this.page.cursor());
                return this.page;
            }
            catch (Exception e) {
                throw ZuoraSdkException.builder().cause((Throwable)e).message(e.getMessage()).build();
            }
        }
    }

    public static class Page<T> {
        private final List<T> content;
        private final String cursor;

        public Page(List<T> content, String cursor) {
            this.content = content;
            this.cursor = cursor;
        }

        public List<T> content() {
            return this.content;
        }

        public String cursor() {
            return this.cursor;
        }
    }
}

