/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.sdk;

import com.apollographql.apollo.ApolloClient;
import com.apollographql.apollo.api.Input;
import com.apollographql.apollo.api.Query;
import com.apollographql.apollo.api.Response;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import com.zuora.sdk.ApiMapper;
import com.zuora.sdk.BaseFacade;
import com.zuora.sdk.Plan;
import com.zuora.sdk.PlanCreateRequest;
import com.zuora.sdk.Price;
import com.zuora.sdk.PriceCreateRequest;
import com.zuora.sdk.PriceMapper;
import com.zuora.sdk.Product;
import com.zuora.sdk.ProductCreateRequest;
import com.zuora.sdk.ZuoraClient;
import com.zuora.sdk.internal.APIContext;
import com.zuora.sdk.internal.ApolloClientUtil;
import com.zuora.sdk.internal.HawkClient;
import com.zuora.sdk.internal.ProductBySkuQuery;
import com.zuora.sdk.internal.ProductRatePlanChargesQuery;
import com.zuora.sdk.internal.ProductsQuery;
import com.zuora.sdk.internal.apis.ProductRatePlansAPI;
import com.zuora.sdk.internal.apis.data.ProxyGetProductRatePlan;
import com.zuora.sdk.internal.exceptions.ZuoraSdkException;
import com.zuora.sdk.internal.models.ZProduct;
import com.zuora.sdk.internal.models.ZProductRatePlan;
import com.zuora.sdk.internal.type.ProductFilterKey;
import com.zuora.sdk.internal.type.ProductrateplanchargeFilterKey;
import com.zuora.sdk.utils.PaginatedStreamHelper;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mapstruct.factory.Mappers;

public class ProductAPI {
    private static final Integer BATCH_SIZE = 10;
    private final HawkClient hawkClient;
    private final ApolloClient gqlClient;
    private final ZuoraClient client;
    private APIContext context;
    private PriceMapper priceMapper = (PriceMapper)Mappers.getMapper(PriceMapper.class);

    ProductAPI(ZuoraClient client) {
        this.client = client;
        this.context = client.getContext();
        this.hawkClient = client.getHawkClient();
        this.gqlClient = this.hawkClient.getGqlClient();
    }

    /*
     * WARNING - void declaration
     */
    public Product create(ProductCreateRequest productCreateRequest) throws ZuoraSdkException {
        long l = System.currentTimeMillis();
        Object object = this;
        ProductCreateRequest productCreateRequest2 = productCreateRequest;
        try {
            void zProduct;
            void product;
            ZProduct zProduct2 = ApiMapper.Mapper.toApi(productCreateRequest2).build();
            String string = zProduct2.create(product.context);
            product.client.customObjects().saveAssociations((BaseFacade)zProduct, string);
            zProduct.getPlans().forEach(productPlan -> {
                productPlan.setProduct(string);
                Plan plan = this.createPlan((PlanCreateRequest)productPlan);
                this.client.customObjects().saveAssociations((BaseFacade)productPlan, plan.getId());
                productPlan.getPrices().forEach(planItem -> {
                    planItem.setPlan(plan.getId());
                    this.client.prices().create((PriceCreateRequest)planItem);
                });
            });
            object = product.get(string);
            return object;
        }
        finally {
            productCreateRequest2 = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void delete(Product product) throws ZuoraSdkException {
        Meter meter;
        String string;
        long l = System.currentTimeMillis();
        ProductAPI productAPI = this;
        Product product2 = product;
        try {
            void product3;
            ZProduct.delete((APIContext)product3.context, (String)product2.getId());
            productAPI = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        product2 = SharedMetricRegistries.getOrCreate((String)"zuora");
        String string2 = "com.zuora.sdk.ProductAPI".substring("com.zuora.sdk.ProductAPI".lastIndexOf(".") + 1);
        if (null != productAPI) {
            string = MetricRegistry.name((String)"sdk.invocations.error", (String[])new String[]{productAPI.getClass().getSimpleName(), string2, "delete"});
            meter = product2.meter(string);
            meter.mark();
        } else {
            string = MetricRegistry.name((String)"sdk.invocations.success", (String[])new String[]{string2, "delete"});
            meter = product2.meter(string);
            meter.mark();
        }
        string = MetricRegistry.name((String)"sdk.invocations.duration", (String[])new String[]{string2, "delete"});
        meter = product2.histogram(string);
        long l2 = System.currentTimeMillis() - l;
        meter.update(l2);
        if (productAPI != null) {
            throw productAPI;
        }
    }

    public Product get(String productId) throws ZuoraSdkException {
        try {
            CompletableFuture response = ApolloClientUtil.toCompletableFuture(this.gqlClient.query((Query)new ProductBySkuQuery(ProductFilterKey.ID, productId)));
            if (response.get().getData() == null || ((ProductBySkuQuery.Data)response.get().getData()).getProducts().getEdges().isEmpty()) {
                return null;
            }
            Product product = this.mapNestedProduct(((ProductBySkuQuery.Data)response.get().getData()).getProducts().getEdges().get(0).getNode());
            ZProduct zProduct = ZProduct.get((APIContext)this.context, (String)productId);
            product = product.toBuilder().customFields(zProduct.productObjectCustomFields()).build();
            return product;
        }
        catch (Exception e) {
            throw ZuoraSdkException.builder().cause((Throwable)e).message(e.getMessage()).build();
        }
    }

    public Stream<Product> stream() throws ZuoraSdkException {
        long l = System.currentTimeMillis();
        Object object = this;
        try {
            object = new PaginatedStreamHelper().run(cursor -> {
                CompletableFuture response = ApolloClientUtil.toCompletableFuture(this.gqlClient.query((Query)new ProductsQuery((Input<String>)Input.optional((Object)cursor))));
                ProductsQuery.Products data = ((ProductsQuery.Data)response.join().getData()).getProducts();
                List products2 = data.getEdges().stream().map(edge -> this.mapNestedProduct(edge.getNode())).collect(Collectors.toList());
                return new PaginatedStreamHelper.Page(products2, data.getPageInfo().getEndCursor());
            });
            return object;
        }
        finally {
            Object object2 = null;
        }
    }

    private Product mapNestedProduct(ProductsQuery.Node productResp) {
        LocalDate now = LocalDate.now(this.context.getEntityProfileInfo().tenantZoneId());
        LocalDate startDate = LocalDate.parse(productResp.getEffectiveStartDate());
        LocalDate endDate = LocalDate.parse(productResp.getEffectiveEndDate());
        ZonedDateTime createTime = ZonedDateTime.parse(productResp.getCreatedDate());
        ZonedDateTime updateTime = ZonedDateTime.parse(productResp.getUpdatedDate());
        boolean active = !(!now.isEqual(startDate) && !now.isAfter(startDate) || !now.isEqual(endDate) && !now.isBefore(endDate));
        Product product = Product.builder().id(productResp.getId()).name(productResp.getName()).sku(productResp.getSKU()).startDate(startDate).endDate(endDate).description(productResp.getDescription()).createdBy(productResp.getCreatedById()).createTime(createTime).updatedBy(productResp.getUpdatedById()).updateTime(updateTime).active(active).build();
        if (productResp.getProductrateplans() != null) {
            product.toBuilder().plans(productResp.getProductrateplans().getEdges().stream().map(ratePlan -> {
                LocalDate planStartDate = LocalDate.parse(ratePlan.getNode().getEffectiveStartDate());
                LocalDate planEndDate = LocalDate.parse(ratePlan.getNode().getEffectiveEndDate());
                boolean planActive = now.isEqual(planStartDate) || now.isAfter(planStartDate) && (now.isEqual(planEndDate) || now.isBefore(planEndDate));
                String planId = ratePlan.getNode().getId();
                Plan plan = Plan.builder().id(planId).name(ratePlan.getNode().getName()).startDate(LocalDate.parse(ratePlan.getNode().getEffectiveStartDate())).endDate(LocalDate.parse(ratePlan.getNode().getEffectiveEndDate())).product(product.getId()).createdBy(ratePlan.getNode().getCreatedById()).createTime(ZonedDateTime.parse(ratePlan.getNode().getCreatedDate())).updatedBy(ratePlan.getNode().getUpdatedById()).updateTime(ZonedDateTime.parse(ratePlan.getNode().getUpdatedDate())).description(ratePlan.getNode().getDescription()).active(planActive).build();
                ZProductRatePlan productRatePlan = ZProductRatePlan.get((APIContext)this.context, (String)planId);
                plan = plan.toBuilder().activeCurrencies(productRatePlan.activeCurrencies()).customFields(productRatePlan.productRatePlanObjectCustomFields()).build();
                product.addPlan(plan);
                return plan;
            }).collect(Collectors.toList()));
        }
        return product;
    }

    private Product mapNestedProduct(ProductBySkuQuery.Node productResp) {
        LocalDate now = LocalDate.now(this.context.getEntityProfileInfo().tenantZoneId());
        LocalDate startDate = LocalDate.parse(productResp.getEffectiveStartDate());
        LocalDate endDate = LocalDate.parse(productResp.getEffectiveEndDate());
        ZonedDateTime createTime = ZonedDateTime.parse(productResp.getCreatedDate());
        ZonedDateTime updateTime = ZonedDateTime.parse(productResp.getUpdatedDate());
        boolean active = !(!now.isEqual(startDate) && !now.isAfter(startDate) || !now.isEqual(endDate) && !now.isBefore(endDate));
        Product product = Product.builder().id(productResp.getId()).name(productResp.getName()).sku(productResp.getSKU()).startDate(startDate).endDate(endDate).description(productResp.getDescription()).createdBy(productResp.getCreatedById()).createTime(createTime).updatedBy(productResp.getUpdatedById()).updateTime(updateTime).active(active).build();
        if (productResp.getProductrateplans() != null) {
            product.toBuilder().plans(productResp.getProductrateplans().getEdges().stream().map(ratePlan -> {
                Plan plan = this.getPlan(ratePlan.getNode().getId());
                product.addPlan(plan);
                return plan;
            }).collect(Collectors.toList()));
        }
        return product;
    }

    /*
     * WARNING - void declaration
     */
    public Product findBySku(String string) throws ZuoraSdkException {
        Meter meter;
        String string2;
        Product product;
        Object object;
        long l = System.currentTimeMillis();
        ProductAPI productAPI = this;
        String string3 = string;
        try {
            try {
                void sku;
                object = ApolloClientUtil.toCompletableFuture(sku.gqlClient.query((Query)new ProductBySkuQuery(ProductFilterKey.SKU, string3)));
                product = ((Response)((CompletableFuture)object).get()).getData() == null || ((ProductBySkuQuery.Data)((Response)((CompletableFuture)object).get()).getData()).getProducts().getEdges().isEmpty() ? null : super.mapNestedProduct(((ProductBySkuQuery.Data)((Response)((CompletableFuture)object).get()).getData()).getProducts().getEdges().get(0).getNode());
            }
            catch (Exception exception) {
                throw ZuoraSdkException.builder().cause(exception.getCause()).message(exception.toString()).build();
            }
        }
        catch (Throwable throwable) {
            productAPI = null;
        }
        productAPI = product;
        string3 = null;
        object = SharedMetricRegistries.getOrCreate((String)"zuora");
        String string4 = "com.zuora.sdk.ProductAPI".substring("com.zuora.sdk.ProductAPI".lastIndexOf(".") + 1);
        if (null != string3) {
            string2 = MetricRegistry.name((String)"sdk.invocations.error", (String[])new String[]{string3.getClass().getSimpleName(), string4, "findBySku"});
            meter = object.meter(string2);
            meter.mark();
        } else {
            string2 = MetricRegistry.name((String)"sdk.invocations.success", (String[])new String[]{string4, "findBySku"});
            meter = object.meter(string2);
            meter.mark();
        }
        string2 = MetricRegistry.name((String)"sdk.invocations.duration", (String[])new String[]{string4, "findBySku"});
        meter = object.histogram(string2);
        long l2 = System.currentTimeMillis() - l;
        meter.update(l2);
        if (string3 != null) {
            throw string3;
        }
        return productAPI;
    }

    public Plan getPlan(String id) throws ZuoraSdkException {
        try {
            ProxyGetProductRatePlan proxyGetProductRatePlan = ProductRatePlansAPI.objectRetrieve((APIContext)this.context, (String)id);
            LocalDate today = this.client.today();
            LocalDate planStartDate = LocalDate.parse(proxyGetProductRatePlan.effectiveStartDate());
            LocalDate planEndDate = LocalDate.parse(proxyGetProductRatePlan.effectiveEndDate());
            ZonedDateTime createTime = ZonedDateTime.parse(proxyGetProductRatePlan.createdDate());
            ZonedDateTime updateTime = ZonedDateTime.parse(proxyGetProductRatePlan.updatedDate());
            boolean planActive = today.isEqual(planStartDate) || today.isAfter(planStartDate) && (today.isEqual(planEndDate) || today.isBefore(planEndDate));
            Plan plan = Plan.builder().id(proxyGetProductRatePlan.id()).active(planActive).name(proxyGetProductRatePlan.name()).updatedBy(proxyGetProductRatePlan.updatedById()).updateTime(updateTime).createdBy(proxyGetProductRatePlan.createdById()).createTime(createTime).startDate(planStartDate).endDate(planEndDate).activeCurrencies(proxyGetProductRatePlan.activeCurrencies()).customFields(proxyGetProductRatePlan.productRatePlanObjectCustomFields()).description(proxyGetProductRatePlan.description()).build();
            Response response = ApolloClientUtil.toCompletableFuture(this.gqlClient.query((Query)new ProductRatePlanChargesQuery(ProductrateplanchargeFilterKey.PRODUCTRATEPLANID, id))).join();
            if (response.getData() != null && ((ProductRatePlanChargesQuery.Data)response.getData()).getProductrateplancharges() != null) {
                List<ProductRatePlanChargesQuery.Edge> ratePlanChargeEdges = ((ProductRatePlanChargesQuery.Data)response.getData()).getProductrateplancharges().getEdges();
                List<Price> planItems = plan.getItems();
                if (ratePlanChargeEdges != null) {
                    ratePlanChargeEdges.stream().filter(ratePlanCharge -> ratePlanCharge.getNode() != null).forEach(ratePlanCharge -> planItems.add(this.priceMapper.fromApi(ratePlanCharge.getNode()).setPlan(id).setId(ratePlanCharge.getNode().getId())));
                }
            }
            return plan;
        }
        catch (Exception e) {
            throw ZuoraSdkException.builder().cause((Throwable)e).build();
        }
    }

    public List<Plan> getPlans(Product product) throws ZuoraSdkException {
        Product aProduct = this.findBySku(product.getSku());
        return aProduct.getPlans();
    }

    /*
     * WARNING - void declaration
     */
    public Plan createPlan(PlanCreateRequest planCreateRequest) throws ZuoraSdkException {
        long l = System.currentTimeMillis();
        Object object = this;
        PlanCreateRequest planCreateRequest2 = planCreateRequest;
        try {
            void plan;
            Object object2 = ApiMapper.Mapper.toApi(planCreateRequest2).build().create(plan.context);
            object = plan.getPlan((String)object2);
            return object;
        }
        finally {
            planCreateRequest2 = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Plan updatePlan(Plan plan) throws ZuoraSdkException {
        long l = System.currentTimeMillis();
        Object object = this;
        Plan plan2 = plan;
        try {
            void plan3;
            ApiMapper.Mapper.toApi(plan2).build().update(plan3.context);
            object = plan2;
            return object;
        }
        finally {
            plan2 = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Plan removePlan(Plan plan) throws ZuoraSdkException {
        long l = System.currentTimeMillis();
        Object object = this;
        Plan plan2 = plan;
        try {
            void plan3;
            ApiMapper.Mapper.toApi(plan2).build();
            ZProductRatePlan.delete((APIContext)plan3.context, (String)plan2.getId());
            object = plan2;
            return object;
        }
        finally {
            plan2 = null;
        }
    }
}

