/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.sdk.internal.pricing;

import com.zuora.sdk.PriceCreateRequest;
import com.zuora.sdk.PriceEnum;
import com.zuora.sdk.internal.models.enums.ChargeType;
import com.zuora.sdk.internal.pricing.ChargeModelRule;
import java.util.EnumSet;

public class Tiered
extends ChargeModelRule {
    private static final PriceEnum.ChargeModel chargeModel = PriceEnum.ChargeModel.TIERED;
    private static final EnumSet<ChargeType> chargeTypes = EnumSet.of(ChargeType.RECURRING, ChargeType.ONE_TIME, ChargeType.USAGE);

    @Override
    PriceEnum.ChargeModel getChargeModel() {
        return chargeModel;
    }

    @Override
    EnumSet<ChargeType> getChargeTypes() {
        return chargeTypes;
    }

    @Override
    public boolean check(PriceCreateRequest priceCreateRequest) {
        if (!this.hasTiers(priceCreateRequest)) {
            return false;
        }
        return !this.hasOverage(priceCreateRequest) && (priceCreateRequest.getTiersMode() == null || priceCreateRequest.getTiersMode().equals((Object)PriceEnum.TiersMode.GRADUATED));
    }
}

