/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.sdk;

import com.zuora.sdk.EnumMapper;
import com.zuora.sdk.Overage;
import com.zuora.sdk.PriceEnum;
import com.zuora.sdk.PriceMapper;
import com.zuora.sdk.SubscriptionPlanItem;
import com.zuora.sdk.TierMapper;
import com.zuora.sdk.internal.RatePlansBySubscriptionIdQuery;
import com.zuora.sdk.internal.models.enums.BillCycleType;
import com.zuora.sdk.internal.models.enums.ChargeModel;
import com.zuora.sdk.internal.models.enums.ChargeType;
import java.util.List;
import org.mapstruct.AfterMapping;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.MappingTarget;
import org.mapstruct.Mappings;
import org.mapstruct.ReportingPolicy;
import org.mapstruct.ValueMapping;
import org.mapstruct.ValueMappings;
import org.mapstruct.factory.Mappers;

@Mapper(unmappedTargetPolicy=ReportingPolicy.IGNORE, uses={TierMapper.class, PriceMapper.class, EnumMapper.class})
abstract class SubscriptionPlanItemMapper {
    SubscriptionPlanItemMapper() {
    }

    @Mappings(value={@Mapping(target="startEvent", source="triggerEvent"), @Mapping(target="number", source="chargeNumber"), @Mapping(target="unitOfMeasure", source="UOM"), @Mapping(target="tiers", source="ratePlanCharge"), @Mapping(target="quantity", source="quantity"), @Mapping(target="subscriptionPlan", source="ratePlanId"), @Mapping(target="price", source="productRatePlanChargeId"), @Mapping(target="overage", source="."), @Mapping(target="recurring.alignment", source="billingPeriodAlignment"), @Mapping(target="recurring.durationIntervalCount", source="upToPeriods", resultType=Integer.class), @Mapping(target="recurring.durationInterval", source="upToPeriodsType"), @Mapping(target="recurring.ratingGroup", source="ratingGroup"), @Mapping(target="recurring.interval", source="billingPeriod"), @Mapping(target="recurring.intervalCount", source="specificBillingPeriod"), @Mapping(target="recurring.on", source="."), @Mapping(target="recurring.timing", source="billingTiming"), @Mapping(target="priceBaseInterval", source="listPriceBase"), @Mapping(source="createdDate", target="createTime"), @Mapping(source="updatedDate", target="updateTime"), @Mapping(source="createdById", target="createdBy"), @Mapping(source="updatedById", target="updatedBy")})
    abstract SubscriptionPlanItem.SubscriptionPlanItemBuilder fromApi(RatePlansBySubscriptionIdQuery.Node1 var1);

    @Mappings(value={@Mapping(target="intervalCount", source="numberOfPeriods"), @Mapping(target="applyAtEndOfSmoothingPeriod", source="overageCalculationOption"), @Mapping(target="creditUnusedUnits", source="overageUnusedUnitsCreditOption")})
    abstract Overage fromApiToOverage(RatePlansBySubscriptionIdQuery.Node1 var1);

    @AfterMapping
    protected void setAmounts(@MappingTarget SubscriptionPlanItem.SubscriptionPlanItemBuilder result, RatePlansBySubscriptionIdQuery.Node1 ratePlanCharge) {
        ChargeType chargeType = ChargeType.getByLabel((String)ratePlanCharge.getChargeType());
        if (chargeType.equals((Object)ChargeType.ONE_TIME)) {
            result.recurring(null);
        }
        ChargeModel chargeModel = ChargeModel.getByLabel((String)ratePlanCharge.getChargeModel());
        if (ratePlanCharge.getRateplanchargetiers() != null && chargeModel != null) {
            TierMapper tierMapper = new TierMapper();
            List<RatePlansBySubscriptionIdQuery.Edge2> tiers = ratePlanCharge.getRateplanchargetiers().getEdges();
            if (chargeModel.equals((Object)ChargeModel.FLAT_FEE)) {
                result.amounts(tierMapper.toAmountsFromRatePlan(tiers));
            } else if (chargeModel.equals((Object)ChargeModel.DISCOUNT_FIXED_AMOUNT)) {
                result.amounts(tierMapper.toDiscountAmountsFromRatePlan(tiers));
            } else if (chargeModel.equals((Object)ChargeModel.DISCOUNT_PERCENTAGE)) {
                result.percentAmount(tierMapper.toDiscountPercentFromRatePlan(tiers));
            } else if (chargeModel.equals((Object)ChargeModel.PER_UNIT)) {
                result.unitAmounts(tierMapper.toAmountsFromRatePlan(tiers));
            } else if (chargeModel.equals((Object)ChargeModel.OVERAGE) || chargeModel.equals((Object)ChargeModel.TIERED_WITH_OVERAGE)) {
                result.unitAmounts(tierMapper.toOverageAmountsFromRatePlan(tiers));
            }
        }
    }

    @ValueMappings(value={@ValueMapping(source="DEFAULT_FROM_CUSTOMER", target="ACCOUNT_CYCLE_DATE"), @ValueMapping(source="SUBSCRIPTION_STAR_TDAY", target="SUBSCRIPTION_START_DAY"), @ValueMapping(source="CHARGE_TRIGGER_DAY", target="SUBSCRIPTION_PLAN_ITEM_DAY"), @ValueMapping(source="<ANY_REMAINING>", target="<NULL>")})
    abstract PriceEnum.RecurringOn mapFrom(BillCycleType var1);

    PriceEnum.RecurringOn toRecurringOn(RatePlansBySubscriptionIdQuery.Node1 ratePlanCharge) {
        if (ratePlanCharge.getChargeType().equals(ChargeType.ONE_TIME.getApiValue())) {
            return null;
        }
        return ((EnumMapper)Mappers.getMapper(EnumMapper.class)).map(ratePlanCharge.getBillCycleType(), ratePlanCharge.getWeeklyBillCycleDay(), ratePlanCharge.getBillCycleDay());
    }
}

