/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.sdk;

import com.zuora.sdk.BaseFacade;
import com.zuora.sdk.PaymentCreateRequest;
import com.zuora.sdk.internal.APIContext;
import com.zuora.sdk.internal.apis.PaymentsAPI;
import com.zuora.sdk.internal.apis.data.PaymentCreateRequestFinanceInformation;
import com.zuora.sdk.internal.models.enums.PaymentType;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;

public final class BillingDocumentPayRequest
extends BaseFacade {
    private final Map<String, Object> customFields;
    @NonNull
    private Double amount;
    @NonNull
    private String authorisationCode;
    private String description;
    @NonNull
    private String currency;
    private LocalDate date;
    private Map<String, String> gatewayOptions;
    private PaymentCreateRequest.PaymentCreateRequestFinanceInformation financeInformation;
    private String gateway;
    private String paymentMethod;
    private String gatewayOrderId;
    private String reference;
    private String statementDescriptor;
    private String softDescriptorPhone;
    @NonNull
    private Boolean external;

    public PaymentsAPI.PaymentCreateRequest createAPIRequest(APIContext context) {
        PaymentsAPI.PaymentCreateRequest paymentCreateRequest = PaymentsAPI.create((APIContext)context).currency(this.getCurrency()).type(this.getExternal() != false ? PaymentType.EXTERNAL.getApiValue() : PaymentType.ELECTRONIC.getApiValue()).amount(this.getAmount()).authTransactionId(this.getAuthorisationCode()).comment(this.getDescription()).paymentMethodId(this.getPaymentMethod()).gatewayId(this.getGateway()).gatewayOrderId(this.getGatewayOrderId()).referenceId(this.getReference()).softDescriptorPhone(this.getSoftDescriptorPhone()).softDescriptor(this.getStatementDescriptor());
        if (this.date != null) {
            paymentCreateRequest.effectiveDate(DateTimeFormatter.ISO_LOCAL_DATE.format(this.date));
        }
        if (this.financeInformation != null) {
            paymentCreateRequest.financeInformation(new PaymentCreateRequestFinanceInformation().bankAccountAccountingCode(this.financeInformation.getBankAccountAccountingCode()).transferredToAccounting(this.financeInformation.getTransferredToAccounting().getApiValue()).unappliedPaymentAccountingCode(this.financeInformation.getUnappliedPaymentAccountingCode()));
        }
        if (this.customFields != null) {
            paymentCreateRequest.paymentObjectCustomFields(new HashMap<String, Object>(this.customFields));
        }
        if (this.gatewayOptions != null) {
            paymentCreateRequest.gatewayOptions(new HashMap<String, String>(this.gatewayOptions));
        }
        return paymentCreateRequest;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static Map<String, Object> $default$customFields() {
        return new HashMap<String, Object>();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    BillingDocumentPayRequest(Map<String, Object> customFields, @NonNull Double amount, @NonNull String authorisationCode, String description, @NonNull String currency, LocalDate date, Map<String, String> gatewayOptions, PaymentCreateRequest.PaymentCreateRequestFinanceInformation financeInformation, String gateway, String paymentMethod, String gatewayOrderId, String reference, String statementDescriptor, String softDescriptorPhone, @NonNull Boolean external) {
        if (amount == null) {
            throw new NullPointerException("amount is marked non-null but is null");
        }
        if (authorisationCode == null) {
            throw new NullPointerException("authorisationCode is marked non-null but is null");
        }
        if (currency == null) {
            throw new NullPointerException("currency is marked non-null but is null");
        }
        if (external == null) {
            throw new NullPointerException("external is marked non-null but is null");
        }
        this.customFields = customFields;
        this.amount = amount;
        this.authorisationCode = authorisationCode;
        this.description = description;
        this.currency = currency;
        this.date = date;
        this.gatewayOptions = gatewayOptions;
        this.financeInformation = financeInformation;
        this.gateway = gateway;
        this.paymentMethod = paymentMethod;
        this.gatewayOrderId = gatewayOrderId;
        this.reference = reference;
        this.statementDescriptor = statementDescriptor;
        this.softDescriptorPhone = softDescriptorPhone;
        this.external = external;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static BillingDocumentPayRequestBuilder builder() {
        return new BillingDocumentPayRequestBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public BillingDocumentPayRequestBuilder toBuilder() {
        return new BillingDocumentPayRequestBuilder().customFields(this.customFields).amount(this.amount).authorisationCode(this.authorisationCode).description(this.description).currency(this.currency).date(this.date).gatewayOptions(this.gatewayOptions).financeInformation(this.financeInformation).gateway(this.gateway).paymentMethod(this.paymentMethod).gatewayOrderId(this.gatewayOrderId).reference(this.reference).statementDescriptor(this.statementDescriptor).softDescriptorPhone(this.softDescriptorPhone).external(this.external);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Map<String, Object> getCustomFields() {
        return this.customFields;
    }

    @NonNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Double getAmount() {
        return this.amount;
    }

    @NonNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getAuthorisationCode() {
        return this.authorisationCode;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public LocalDate getDate() {
        return this.date;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Map<String, String> getGatewayOptions() {
        return this.gatewayOptions;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public PaymentCreateRequest.PaymentCreateRequestFinanceInformation getFinanceInformation() {
        return this.financeInformation;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getGateway() {
        return this.gateway;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getPaymentMethod() {
        return this.paymentMethod;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getGatewayOrderId() {
        return this.gatewayOrderId;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getReference() {
        return this.reference;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getStatementDescriptor() {
        return this.statementDescriptor;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getSoftDescriptorPhone() {
        return this.softDescriptorPhone;
    }

    @NonNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Boolean getExternal() {
        return this.external;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setAmount(@NonNull Double amount) {
        if (amount == null) {
            throw new NullPointerException("amount is marked non-null but is null");
        }
        this.amount = amount;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setAuthorisationCode(@NonNull String authorisationCode) {
        if (authorisationCode == null) {
            throw new NullPointerException("authorisationCode is marked non-null but is null");
        }
        this.authorisationCode = authorisationCode;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setCurrency(@NonNull String currency) {
        if (currency == null) {
            throw new NullPointerException("currency is marked non-null but is null");
        }
        this.currency = currency;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setDate(LocalDate date) {
        this.date = date;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setGatewayOptions(Map<String, String> gatewayOptions) {
        this.gatewayOptions = gatewayOptions;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setFinanceInformation(PaymentCreateRequest.PaymentCreateRequestFinanceInformation financeInformation) {
        this.financeInformation = financeInformation;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setGateway(String gateway) {
        this.gateway = gateway;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setPaymentMethod(String paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setGatewayOrderId(String gatewayOrderId) {
        this.gatewayOrderId = gatewayOrderId;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setReference(String reference) {
        this.reference = reference;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setStatementDescriptor(String statementDescriptor) {
        this.statementDescriptor = statementDescriptor;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setSoftDescriptorPhone(String softDescriptorPhone) {
        this.softDescriptorPhone = softDescriptorPhone;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setExternal(@NonNull Boolean external) {
        if (external == null) {
            throw new NullPointerException("external is marked non-null but is null");
        }
        this.external = external;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BillingDocumentPayRequest)) {
            return false;
        }
        BillingDocumentPayRequest other = (BillingDocumentPayRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Double this$amount = this.getAmount();
        Double other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        Boolean this$external = this.getExternal();
        Boolean other$external = other.getExternal();
        if (this$external == null ? other$external != null : !((Object)this$external).equals(other$external)) {
            return false;
        }
        Map<String, Object> this$customFields = this.getCustomFields();
        Map<String, Object> other$customFields = other.getCustomFields();
        if (this$customFields == null ? other$customFields != null : !((Object)this$customFields).equals(other$customFields)) {
            return false;
        }
        String this$authorisationCode = this.getAuthorisationCode();
        String other$authorisationCode = other.getAuthorisationCode();
        if (this$authorisationCode == null ? other$authorisationCode != null : !this$authorisationCode.equals(other$authorisationCode)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        LocalDate this$date = this.getDate();
        LocalDate other$date = other.getDate();
        if (this$date == null ? other$date != null : !((Object)this$date).equals(other$date)) {
            return false;
        }
        Map<String, String> this$gatewayOptions = this.getGatewayOptions();
        Map<String, String> other$gatewayOptions = other.getGatewayOptions();
        if (this$gatewayOptions == null ? other$gatewayOptions != null : !((Object)this$gatewayOptions).equals(other$gatewayOptions)) {
            return false;
        }
        PaymentCreateRequest.PaymentCreateRequestFinanceInformation this$financeInformation = this.getFinanceInformation();
        PaymentCreateRequest.PaymentCreateRequestFinanceInformation other$financeInformation = other.getFinanceInformation();
        if (this$financeInformation == null ? other$financeInformation != null : !((Object)this$financeInformation).equals(other$financeInformation)) {
            return false;
        }
        String this$gateway = this.getGateway();
        String other$gateway = other.getGateway();
        if (this$gateway == null ? other$gateway != null : !this$gateway.equals(other$gateway)) {
            return false;
        }
        String this$paymentMethod = this.getPaymentMethod();
        String other$paymentMethod = other.getPaymentMethod();
        if (this$paymentMethod == null ? other$paymentMethod != null : !this$paymentMethod.equals(other$paymentMethod)) {
            return false;
        }
        String this$gatewayOrderId = this.getGatewayOrderId();
        String other$gatewayOrderId = other.getGatewayOrderId();
        if (this$gatewayOrderId == null ? other$gatewayOrderId != null : !this$gatewayOrderId.equals(other$gatewayOrderId)) {
            return false;
        }
        String this$reference = this.getReference();
        String other$reference = other.getReference();
        if (this$reference == null ? other$reference != null : !this$reference.equals(other$reference)) {
            return false;
        }
        String this$statementDescriptor = this.getStatementDescriptor();
        String other$statementDescriptor = other.getStatementDescriptor();
        if (this$statementDescriptor == null ? other$statementDescriptor != null : !this$statementDescriptor.equals(other$statementDescriptor)) {
            return false;
        }
        String this$softDescriptorPhone = this.getSoftDescriptorPhone();
        String other$softDescriptorPhone = other.getSoftDescriptorPhone();
        return !(this$softDescriptorPhone == null ? other$softDescriptorPhone != null : !this$softDescriptorPhone.equals(other$softDescriptorPhone));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BillingDocumentPayRequest;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Double $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        Boolean $external = this.getExternal();
        result = result * 59 + ($external == null ? 43 : ((Object)$external).hashCode());
        Map<String, Object> $customFields = this.getCustomFields();
        result = result * 59 + ($customFields == null ? 43 : ((Object)$customFields).hashCode());
        String $authorisationCode = this.getAuthorisationCode();
        result = result * 59 + ($authorisationCode == null ? 43 : $authorisationCode.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        LocalDate $date = this.getDate();
        result = result * 59 + ($date == null ? 43 : ((Object)$date).hashCode());
        Map<String, String> $gatewayOptions = this.getGatewayOptions();
        result = result * 59 + ($gatewayOptions == null ? 43 : ((Object)$gatewayOptions).hashCode());
        PaymentCreateRequest.PaymentCreateRequestFinanceInformation $financeInformation = this.getFinanceInformation();
        result = result * 59 + ($financeInformation == null ? 43 : ((Object)$financeInformation).hashCode());
        String $gateway = this.getGateway();
        result = result * 59 + ($gateway == null ? 43 : $gateway.hashCode());
        String $paymentMethod = this.getPaymentMethod();
        result = result * 59 + ($paymentMethod == null ? 43 : $paymentMethod.hashCode());
        String $gatewayOrderId = this.getGatewayOrderId();
        result = result * 59 + ($gatewayOrderId == null ? 43 : $gatewayOrderId.hashCode());
        String $reference = this.getReference();
        result = result * 59 + ($reference == null ? 43 : $reference.hashCode());
        String $statementDescriptor = this.getStatementDescriptor();
        result = result * 59 + ($statementDescriptor == null ? 43 : $statementDescriptor.hashCode());
        String $softDescriptorPhone = this.getSoftDescriptorPhone();
        result = result * 59 + ($softDescriptorPhone == null ? 43 : $softDescriptorPhone.hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "BillingDocumentPayRequest(customFields=" + this.getCustomFields() + ", amount=" + this.getAmount() + ", authorisationCode=" + this.getAuthorisationCode() + ", description=" + this.getDescription() + ", currency=" + this.getCurrency() + ", date=" + this.getDate() + ", gatewayOptions=" + this.getGatewayOptions() + ", financeInformation=" + this.getFinanceInformation() + ", gateway=" + this.getGateway() + ", paymentMethod=" + this.getPaymentMethod() + ", gatewayOrderId=" + this.getGatewayOrderId() + ", reference=" + this.getReference() + ", statementDescriptor=" + this.getStatementDescriptor() + ", softDescriptorPhone=" + this.getSoftDescriptorPhone() + ", external=" + this.getExternal() + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static class BillingDocumentPayRequestBuilder {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean customFields$set;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Map<String, Object> customFields$value;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Double amount;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String authorisationCode;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String description;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String currency;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private LocalDate date;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Map<String, String> gatewayOptions;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private PaymentCreateRequest.PaymentCreateRequestFinanceInformation financeInformation;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String gateway;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String paymentMethod;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String gatewayOrderId;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String reference;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String statementDescriptor;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String softDescriptorPhone;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Boolean external;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        BillingDocumentPayRequestBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public BillingDocumentPayRequestBuilder customFields(Map<String, Object> customFields) {
            this.customFields$value = customFields;
            this.customFields$set = true;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public BillingDocumentPayRequestBuilder amount(@NonNull Double amount) {
            if (amount == null) {
                throw new NullPointerException("amount is marked non-null but is null");
            }
            this.amount = amount;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public BillingDocumentPayRequestBuilder authorisationCode(@NonNull String authorisationCode) {
            if (authorisationCode == null) {
                throw new NullPointerException("authorisationCode is marked non-null but is null");
            }
            this.authorisationCode = authorisationCode;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public BillingDocumentPayRequestBuilder description(String description) {
            this.description = description;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public BillingDocumentPayRequestBuilder currency(@NonNull String currency) {
            if (currency == null) {
                throw new NullPointerException("currency is marked non-null but is null");
            }
            this.currency = currency;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public BillingDocumentPayRequestBuilder date(LocalDate date) {
            this.date = date;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public BillingDocumentPayRequestBuilder gatewayOptions(Map<String, String> gatewayOptions) {
            this.gatewayOptions = gatewayOptions;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public BillingDocumentPayRequestBuilder financeInformation(PaymentCreateRequest.PaymentCreateRequestFinanceInformation financeInformation) {
            this.financeInformation = financeInformation;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public BillingDocumentPayRequestBuilder gateway(String gateway) {
            this.gateway = gateway;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public BillingDocumentPayRequestBuilder paymentMethod(String paymentMethod) {
            this.paymentMethod = paymentMethod;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public BillingDocumentPayRequestBuilder gatewayOrderId(String gatewayOrderId) {
            this.gatewayOrderId = gatewayOrderId;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public BillingDocumentPayRequestBuilder reference(String reference) {
            this.reference = reference;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public BillingDocumentPayRequestBuilder statementDescriptor(String statementDescriptor) {
            this.statementDescriptor = statementDescriptor;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public BillingDocumentPayRequestBuilder softDescriptorPhone(String softDescriptorPhone) {
            this.softDescriptorPhone = softDescriptorPhone;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public BillingDocumentPayRequestBuilder external(@NonNull Boolean external) {
            if (external == null) {
                throw new NullPointerException("external is marked non-null but is null");
            }
            this.external = external;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public BillingDocumentPayRequest build() {
            Map customFields$value = this.customFields$value;
            if (!this.customFields$set) {
                customFields$value = BillingDocumentPayRequest.$default$customFields();
            }
            return new BillingDocumentPayRequest(customFields$value, this.amount, this.authorisationCode, this.description, this.currency, this.date, this.gatewayOptions, this.financeInformation, this.gateway, this.paymentMethod, this.gatewayOrderId, this.reference, this.statementDescriptor, this.softDescriptorPhone, this.external);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "BillingDocumentPayRequest.BillingDocumentPayRequestBuilder(customFields$value=" + this.customFields$value + ", amount=" + this.amount + ", authorisationCode=" + this.authorisationCode + ", description=" + this.description + ", currency=" + this.currency + ", date=" + this.date + ", gatewayOptions=" + this.gatewayOptions + ", financeInformation=" + this.financeInformation + ", gateway=" + this.gateway + ", paymentMethod=" + this.paymentMethod + ", gatewayOrderId=" + this.gatewayOrderId + ", reference=" + this.reference + ", statementDescriptor=" + this.statementDescriptor + ", softDescriptorPhone=" + this.softDescriptorPhone + ", external=" + this.external + ")";
        }
    }
}

