/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.sdk;

import com.zuora.sdk.TaxationItem;
import com.zuora.sdk.ZuoraClient;
import com.zuora.sdk.core.APIContext;
import com.zuora.sdk.core.apis.TaxationItemsAPI;
import com.zuora.sdk.core.apis.data.GETTaxationItemType;
import com.zuora.sdk.core.exceptions.ZuoraSdkException;
import com.zuora.sdk.core.internal.Tools;
import com.zuora.sdk.core.internal.TransformHelper;
import com.zuora.sdk.enums.TaxRateType;
import java.time.ZoneId;
import java.util.Collections;
import java.util.List;

public class TaxationItemAPI {
    private final ZuoraClient client;

    TaxationItemAPI(ZuoraClient client) {
        this.client = client;
    }

    TaxationItem get(String id) throws ZuoraSdkException {
        ZoneId tenantZoneId = this.client.getContext().getEntityProfileInfo().tenantZoneId();
        GETTaxationItemType ret = TaxationItemsAPI.retrieve((APIContext)this.client.getContext(), (String)id);
        TaxationItem item = new TaxationItem();
        item.setCreatedBy(ret.createdById());
        item.setCreateTime(Tools.toZonedDateTime((ZoneId)tenantZoneId, (String)ret.createdDate()));
        item.setUpdatedBy(ret.updatedById());
        item.setUpdateTime(Tools.toZonedDateTime((ZoneId)tenantZoneId, (String)ret.updatedDate()));
        item.setAmount(ret.taxAmount());
        item.setType(TaxRateType.getByLabel(ret.taxRateType()));
        item.setSourceTaxItem(ret.sourceTaxItemId());
        item.setMemoItem(ret.memoItemId());
        TransformHelper.transform((List)Collections.EMPTY_LIST, (Object)ret, (Object)item);
        return item;
    }
}

