/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.sdk.utils;

import com.apollographql.apollo.ApolloCall;
import com.apollographql.apollo.api.Response;
import com.apollographql.apollo.exception.ApolloException;
import java.util.concurrent.CompletableFuture;
import lombok.NonNull;

public class ApolloClientUtil {
    public static <T> CompletableFuture<Response<T>> toCompletableFuture(@NonNull ApolloCall<T> apolloCall) {
        if (apolloCall == null) {
            throw new NullPointerException("apolloCall is marked non-null but is null");
        }
        final CompletableFuture completableFuture = new CompletableFuture();
        completableFuture.whenComplete((tResponse, throwable) -> {
            if (completableFuture.isCancelled()) {
                completableFuture.cancel(true);
            }
        });
        apolloCall.enqueue(new ApolloCall.Callback<T>(){

            public void onResponse(@NonNull Response<T> response) {
                if (response == null) {
                    throw new NullPointerException("response is marked non-null but is null");
                }
                completableFuture.complete(response);
            }

            public void onFailure(@NonNull ApolloException e) {
                if (e == null) {
                    throw new NullPointerException("e is marked non-null but is null");
                }
                completableFuture.completeExceptionally((Throwable)e);
            }
        });
        return completableFuture;
    }
}

