/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.sdk.planitems;

import com.zuora.sdk.chargemodels.ChargeModelInterface;
import com.zuora.sdk.core.exceptions.ZuoraSdkException;
import com.zuora.sdk.core.models.enums.BillingTiming;
import com.zuora.sdk.planitems.PlanItemCreateRequest;
import com.zuora.sdk.planitems.PlanItemEnum;
import com.zuora.sdk.planitems.PlanItemType;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.EnumSet;
import lombok.Generated;

public final class OneTimePlanItemCreateRequest
extends PlanItemCreateRequest
implements PlanItemType {
    public OneTimePlanItemCreateRequest(String accountingCode, PlanItemEnum.Event startEvent, ChargeModelInterface chargeModel, String name, PlanItemType.ItemType planItemType, String plan, String description, String taxCode, boolean taxInclusive, BillingTiming timing) {
        super(accountingCode, startEvent, chargeModel, name, PlanItemType.ItemType.ONE_TIME, timing, plan, description, taxCode, taxInclusive);
    }

    public static OneTimePlanItemCreateRequestBuilder oneTimeBuilder() {
        return new OneTimePlanItemCreateRequestBuilder();
    }

    @Override
    public PlanItemType.ItemType getType() {
        return PlanItemType.ItemType.ONE_TIME;
    }

    public OneTimePlanItemCreateRequestBuilder toBuilder() {
        return new OneTimePlanItemCreateRequestBuilder().accountingCode(this.accountingCode).startEvent(this.startEvent).chargeModel(this.chargeModel).name(this.name).planItemType(this.planItemType).plan(this.plan).description(this.description).taxCode(this.taxCode).taxInclusive(this.taxInclusive).timing(this.timing);
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "OneTimePlanItemCreateRequest(super=" + super.toString() + ")";
    }

    public static class OneTimePlanItemCreateRequestBuilder {
        private final EnumSet<ChargeModelInterface.Type> chargeModels = EnumSet.of(ChargeModelInterface.Type.FLAT_FEE, ChargeModelInterface.Type.PER_UNIT, ChargeModelInterface.Type.TIERED, ChargeModelInterface.Type.VOLUME);
        private String accountingCode;
        private PlanItemEnum.Event startEvent;
        private ChargeModelInterface chargeModel;
        private String name;
        private PlanItemType.ItemType planItemType;
        private String plan;
        private String description;
        private String taxCode;
        private boolean taxInclusive;
        private BillingTiming timing;

        public OneTimePlanItemCreateRequestBuilder chargeModel(ChargeModelInterface chargeModel) {
            if (chargeModel != null && !this.chargeModels.contains((Object)chargeModel.getType())) {
                throw ZuoraSdkException.builder().message("Invalid Charge Model").build();
            }
            this.chargeModel = chargeModel;
            return this;
        }

        public OneTimePlanItemCreateRequestBuilder accountingCode(String accountingCode) {
            this.accountingCode = accountingCode;
            return this;
        }

        public OneTimePlanItemCreateRequestBuilder startEvent(PlanItemEnum.Event startEvent) {
            this.startEvent = startEvent;
            return this;
        }

        public OneTimePlanItemCreateRequestBuilder name(String name) {
            this.name = name;
            return this;
        }

        public OneTimePlanItemCreateRequestBuilder planItemType(PlanItemType.ItemType planItemType) {
            this.planItemType = planItemType;
            return this;
        }

        public OneTimePlanItemCreateRequestBuilder plan(String plan) {
            this.plan = plan;
            return this;
        }

        public OneTimePlanItemCreateRequestBuilder description(String description) {
            this.description = description;
            return this;
        }

        public OneTimePlanItemCreateRequestBuilder taxCode(String taxCode) {
            this.taxCode = taxCode;
            return this;
        }

        public OneTimePlanItemCreateRequestBuilder taxInclusive(boolean taxInclusive) {
            this.taxInclusive = taxInclusive;
            return this;
        }

        public OneTimePlanItemCreateRequestBuilder timing(BillingTiming timing) {
            this.timing = timing;
            return this;
        }

        public OneTimePlanItemCreateRequest build() {
            return new OneTimePlanItemCreateRequest(this.accountingCode, this.startEvent, this.chargeModel, this.name, this.planItemType, this.plan, this.description, this.taxCode, this.taxInclusive, this.timing);
        }

        public String toString() {
            return "OneTimePlanItemCreateRequest.OneTimePlanItemCreateRequestBuilder(chargeModels=" + this.chargeModels + ", accountingCode=" + this.accountingCode + ", startEvent=" + (Object)((Object)this.startEvent) + ", chargeModel=" + this.chargeModel + ", name=" + this.name + ", planItemType=" + (Object)((Object)this.planItemType) + ", plan=" + this.plan + ", description=" + this.description + ", taxCode=" + this.taxCode + ", taxInclusive=" + this.taxInclusive + ", timing=" + this.timing + ")";
        }
    }
}

