/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.sdk;

import com.zuora.sdk.ZuoraObject;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class ZuoraMetadata {
    List<Map> metaData;

    ZuoraMetadata(List metaData) {
        this.metaData = metaData;
    }

    ZuoraMetadataDefinition getDefinition(Class<?> clazz) {
        ZuoraObject annotation = clazz.getAnnotation(ZuoraObject.class);
        if (annotation == null) {
            return null;
        }
        String objectType = annotation.name();
        String namespace = annotation.namespace();
        if (objectType == null || objectType.isEmpty()) {
            return null;
        }
        String type = namespace.equals("default") ? "default__" + objectType : objectType;
        return this.getDefinition(type);
    }

    private ZuoraMetadataDefinition getDefinition(String objectType) {
        Map definition = this.metaData.stream().filter(d -> d.get("type").equals(objectType.toLowerCase())).findFirst().orElse(null);
        if (definition == null) {
            return null;
        }
        return new ZuoraMetadataDefinition(definition);
    }

    class ZuoraMetadataDefinition {
        private String objectType;
        private String namespace;
        private Map properties;
        private List<Map> relationships;

        ZuoraMetadataDefinition(Map definition) {
            this.objectType = (String)definition.get("type");
            this.namespace = (String)definition.get("namespace");
            this.properties = (Map)definition.get("properties");
            this.relationships = (List)definition.get("relationships");
        }

        Map getRelationship(ZuoraMetadataDefinition targetDef) {
            return this.relationships.stream().filter(r -> r.get("object").equals(targetDef.objectType) && r.get("cardinality").equals("oneToMany")).findFirst().orElse(null);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getObjectType() {
            return this.objectType;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getNamespace() {
            return this.namespace;
        }
    }
}

