/*
 * Decompiled with CFR 0.152.
 */
package com.zuora.sdk.chargemodels;

import com.google.common.base.Strings;
import com.zuora.sdk.chargemodels.Tiered;
import com.zuora.sdk.core.models.enums.ApplyType;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.EnumSet;
import java.util.List;
import lombok.Generated;

public interface ChargeModelInterface {
    public Type getType();

    public String getUnitOfMeasure();

    public Double getQuantity();

    public List<Tiered.Tier> getTiers();

    public static enum ApplyDiscountTo {
        ONETIME,
        RECURRING,
        USAGE;


        public static ApplyType getApiValueBySet(EnumSet<ApplyDiscountTo> setValues) {
            String newValue = "";
            if (setValues.contains((Object)ONETIME)) {
                newValue = newValue.concat(ONETIME.name());
            }
            if (setValues.contains((Object)RECURRING)) {
                newValue = newValue.concat(RECURRING.name());
            }
            if (setValues.contains((Object)USAGE)) {
                newValue = newValue.concat(USAGE.name());
            }
            return ApplyType.getByLabel((String)newValue);
        }

        public static EnumSet<ApplyDiscountTo> getSetValueByApiValue(ApplyType type) {
            EnumSet<ApplyDiscountTo> applyDiscountToEnumSet = EnumSet.noneOf(ApplyDiscountTo.class);
            String apiLabel = type.getApiValue();
            if (apiLabel.contains(ONETIME.name())) {
                applyDiscountToEnumSet.add(ONETIME);
            }
            if (apiLabel.contains(USAGE.name())) {
                applyDiscountToEnumSet.add(USAGE);
            }
            if (apiLabel.contains(RECURRING.name())) {
                applyDiscountToEnumSet.add(RECURRING);
            }
            return applyDiscountToEnumSet;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "ChargeModelInterface.ApplyDiscountTo." + this.name();
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ApplyDiscountTo() {
        }
    }

    public static enum Type {
        FLAT_FEE("FlatFee"),
        PER_UNIT("PerUnit"),
        OVERAGE("Overage"),
        VOLUME("Volume"),
        TIERED("Tiered"),
        TIERED_WITH_OVERAGE("TieredWithOverage"),
        DISCOUNT_AMOUNT("DiscountFixedAmount"),
        DISCOUNT_PERCENTAGE("DiscountPercentage");

        private final String apiValue;

        public static Type getByLabel(String label) {
            if (Strings.isNullOrEmpty((String)label)) {
                return null;
            }
            for (Type type : Type.values()) {
                if (!type.getApiValue().equals(label)) continue;
                return type;
            }
            return null;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "ChargeModelInterface.Type." + this.name() + "(apiValue=" + this.getApiValue() + ")";
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Type(String apiValue) {
            this.apiValue = apiValue;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getApiValue() {
            return this.apiValue;
        }
    }
}

